/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#include <stdio.h>

#include "../../../service/gsmmisc.h"
#include "../../../device/gsmdev.h"
#include "../../gsmphone.h"
#include "../ndct34.h"
#include "ndct3.h"

class GSM_Protocol;
class GSM_Protocol_Message;

class GSM_Phone_N7110:virtual public GSM_Phone
{
public:
	GSM_Phone_N7110(DebugInfo **Deb, GSM_Device **Dev, GSM_AllProtocols **Prot, GSM_AllPhones **Pho):GSM_Phone(Deb,Dev,Prot,Pho) {
		Info.push_back(GSM_Phone_Info("6210", "NPE-3",  "Nokia 6210" ,"fbus|irdaphonet", "-cal62-"));
		Info.push_back(GSM_Phone_Info("6250", "NHM-3",  "Nokia 6250" ,"fbus|irdaphonet", "-cal62-"));
		Info.push_back(GSM_Phone_Info("7110", "NSE-5",  "Nokia 7110" ,"fbus|irdaphonet", "-cal62-"));

		DCT34 = new GSM_Phone_NDCT34((*Phones)->GetID(),Deb,&(*Phones));
		DCT3  = new GSM_Phone_NDCT3((*Phones)->GetID(),Deb,&((*Phones)->Current),&((*Protocols)->Current));

		ModuleName      = "dct3/n7110";
		ModulesUsed     = "";
		ModulesRequired = "";
	}
	~GSM_Phone_N7110() {
		delete DCT34;
		delete DCT3;
	}

	GSM_Error	Open		   	(char *FrameID);
	GSM_Error	Dispatch	       	(GSM_Protocol_Message *msg, void *Struct, int RequestID);

	GSM_Error	GetManufacturer		(unsigned char *Manufacturer);
	GSM_Error	GetIMEI			(unsigned char *IMEI);
	GSM_Error	GetCodeNameModel       	(unsigned char *Model);
	GSM_Error	GetFirmwareVersion     	(unsigned char *Firm);
	GSM_Error	GetFirmwareDate		(unsigned char *Dat);
	GSM_Error	GetDateTime	    	(GSM_DateTime *DT);
	GSM_Error	GetPBKStatus	   	(GSM_PBKStatus *Status);
	GSM_Error	GetPBK		 	(GSM_PBKEntry *Entry);
	GSM_Error	SetPBK		 	(GSM_PBKEntry *Entry);
	GSM_Error	DeletePBK	      	(GSM_PBKEntry *Entry);
	GSM_Error	GetNextCalendar		(GSM_CalendarEntry *Entry, BOOLEAN start, int *Current, int *Max);
	GSM_Error	DeleteCalendar	 	(GSM_CalendarEntry *Entry);
	GSM_Error	AddCalendar	    	(GSM_CalendarEntry *Entry);
	GSM_Error	GetSMSStatus	   	(GSM_SMSStatus *Status);
	GSM_Error	GetSMSC			(GSM_SMSC *SMSC);
//      GSM_Error	AddSMS		 	(GSM_SMSList *List);
	GSM_Error	SetSMS		 	(GSM_SMSList *List);
	GSM_Error	SendSMS			(GSM_SMSEntry *SMS);
	GSM_Error	DeleteSMS	      	(GSM_SMSList *List);
private:
	GSM_Phone_NDCT34 *DCT34;
	GSM_Phone_NDCT3  *DCT3;

	GSM_SMS_Loc      SMSLocations;
	int	      	SMSFoldersNum;
	unsigned char    SMSFolderID;
	int	      	SMSLocation;

	GSM_Error	GetSMSFolderStatus     	(GSM_SMS_Loc *SMSLocations);
	GSM_Error	GetSMS		 	(GSM_SMSList *List, wchart SMS_ID);

	GSM_Error	ReplyGetIMEI	   	(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *IMEI);
	GSM_Error	ReplyGetPBKStatus      	(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
	GSM_Error	ReplyGetPBK	    	(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
	GSM_Error	ReplySetPBK	    	(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
	GSM_Error	ReplyGetSMSStatus      	(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
	GSM_Error	ReplyGetSMS	    	(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
	GSM_Error	ReplyGetSMSC	   	(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
	GSM_Error	ReplyGetSMSFolders     	(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
	GSM_Error	ReplyGetSMSFolderStatus	(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
	GSM_Error	ReplySetSMS	    	(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
	GSM_Error	ReplyDeleteSMS	 	(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
};
