/* (C) 2003 - 2007 by Marcin Wiacek www.mwiacek.com */

#include <list>

#include "../misc/misc.h"
#include "../misc/coding/coding.h"
#include "../service/gsmmisc.h"
#include "../service/gsmpbk.h"
#include "../service/gsmcal.h"
#include "../service/gsmfiles.h"
#include "../service/gsmdata.h"
#include "../service/sms/gsmsms.h"
#include "../service/sms/smsmulti.h"

using namespace std;

#ifndef gsmphone_h
#define gsmphone_h

const int ID_None                = 1;
const int ID_IncomingFrame       = 2;
const int ID_GetIMEI             = 3;
const int ID_GetPBKStatus        = 4;
const int ID_GetPBK              = 5;
const int ID_SetPBK              = 6;
const int ID_DelPBK              = 7;
const int ID_GetCalendar         = 8;
const int ID_GetDateTime         = 9;
const int ID_AddCalendar         = 10;
const int ID_GetFirstCalendarPos = 11;
const int ID_DelCalendar         = 12;
const int ID_GetSMSStatus        = 13;
const int ID_GetSMS              = 14;
const int ID_GetSMSC             = 15;
const int ID_GetSMSFolders       = 16;
const int ID_GetSMSFolderStatus  = 17;
const int ID_SetSMS              = 18;
const int ID_SetSMSName          = 19;
const int ID_DelSMS              = 20;
const int ID_GetFileFolderInfo   = 21;
const int ID_GetFilePart         = 22;
const int ID_OpenFile            = 23;
const int ID_CloseFile           = 24;
const int ID_DeleteFile          = 25;
const int ID_GetFileCheckSum     = 26;
const int ID_AddFilePart         = 27;
const int ID_DeleteFolder        = 28;
const int ID_AddFolder           = 29;
const int ID_GetFolderList       = 30;
const int ID_SetFileDate         = 31;
const int ID_GetNote             = 32;
const int ID_AddNote             = 33;
const int ID_DelNote             = 34;
const int ID_GetToDo             = 35;
const int ID_GetProductCode      = 36;
const int ID_AddToDo             = 37;
const int ID_SetDateTime	 = 38;

const int ID_Start               = 38; //set it to last value above

class GSM_Device;
class GSM_AllDevices;
class GSM_AllProtocols;
class GSM_Protocol_Message;
class GSM_AllPhones;

class GSM_Phone_Info {
public:
        char                    *Protocol;
        char                    *Model;
        char                    *CodeNameModel;
        char                    *DeviceModel;
        char                    *Features;

        GSM_Phone_Info          (char *Mod, char *Code, char *Device, char *Prot, char *Feat);
        ~GSM_Phone_Info         ();

        bool                    CompareProtocol(char *Pro);
};

typedef struct {
        int     RequestID;
        bool    FrameFound;
} AnsStruct;

/**
 * class for phone modules
 */
class GSM_Phone
{
        friend class            GSM_AllPhones;
public:
        list <GSM_Phone_Info>   Info;
        char                    *ModuleName,*ModulesRequired,*ModulesUsed;
	GSM_FileFolderInfoLists FoldersCache;
	GSM_FileFolderInfoListsSubEntry *FoldersCacheSubEntry;

        GSM_Phone               (DebugInfo **Deb, GSM_Device **Dev, GSM_AllProtocols **Prot, GSM_AllPhones **Pho);
        virtual                 ~GSM_Phone();

        int                     GetID();
        GSM_Error               Read(int RequestID, void *Struct);
        GSM_Error               ReadOnce(int RequestID, void *Struct);
        GSM_Error               Write(unsigned char *buffer, int length, unsigned char type, int time, int request, void *Struct);
        virtual GSM_Error       Dispatch(GSM_Protocol_Message *msg, void *Struct, int RequestID) = 0;
        void                    SetUserReply(GSM_Error(*UsrReply)(int MsgLength, unsigned char MsgType, unsigned char *MsgBuffer, void *Struct, int RequestID));
        void                    SetSMSSendReply(void(*SMSSndReply)(int TPMR));
	GSM_Error 		ReadFolderToCache(wchar_t *ID, GSM_FileFolderInfoList **List);

        virtual GSM_Error       Open(char *ID);
        virtual GSM_Error       Close();

        //phone info
        virtual GSM_Error       GetIMEI(unsigned char *IMEI);
        virtual GSM_Error       GetModel(unsigned char *Model);
        virtual GSM_Error       GetManufacturer(unsigned char *Manufacturer);
        virtual GSM_Error       GetFirmwareVersion(unsigned char *Firm);
        virtual GSM_Error       GetFirmwareDate(unsigned char *Date);
        virtual GSM_Error       GetCodeNameModel(unsigned char *CodeNameModel); 
	virtual GSM_Error	GetProductCode(unsigned char *ProductCode);
        //date time
        virtual GSM_Error       GetDateTime(GSM_DateTime *DT);
        virtual GSM_Error       SetDateTime(GSM_DateTime *DT);
        //phonebook memories
        virtual GSM_Error       GetPBKStatus(GSM_PBKStatus *Status);
        virtual GSM_Error       GetPBK(GSM_PBKEntry *Entry);
        virtual GSM_Error       SetPBK(GSM_PBKEntry *Entry);
        virtual GSM_Error       DeletePBK(GSM_PBKEntry *Entry);
        //calendar
        virtual GSM_Error       GetNextCalendar(GSM_CalendarEntry *Entry, BOOLEAN start, int *Current, int *Max);
        virtual GSM_Error       AddCalendar(GSM_CalendarEntry *Entry);
        virtual GSM_Error       DeleteCalendar(GSM_CalendarEntry *Entry);
        //notes
        virtual GSM_Error       GetNextNote(GSM_NoteEntry *Entry, BOOLEAN start, int *Current, int *Max);
        virtual GSM_Error       AddNote(GSM_NoteEntry *Entry);
        virtual GSM_Error       DeleteNote(GSM_NoteEntry *Entry);
        //ToDo
        virtual GSM_Error       GetNextToDo(GSM_ToDoEntry *Entry, BOOLEAN start, int *Current, int *Max);
        virtual GSM_Error       AddToDo(GSM_ToDoEntry *Entry);
        virtual GSM_Error       DeleteToDo(GSM_ToDoEntry *Entry);
        //sms
        virtual GSM_Error       GetSMSStatus(GSM_SMSStatus *Status);
        virtual GSM_Error       DeleteSMS(GSM_SMSList *List);
        virtual GSM_Error       SetSMS(GSM_SMSList *List);
        virtual GSM_Error       AddSMS(GSM_SMSList *List);
        virtual GSM_Error       SendSMS(GSM_SMSEntry *SMS);
        virtual GSM_Error       GetSMSC(GSM_SMSC *SMSC);
        virtual GSM_Error       SetSMSC(GSM_SMSC *SMSC);
        //sms & mms
	virtual GSM_Error 	GetSMSMMSFolders(GSM_SMSMMSFolders *Folders);
	virtual GSM_Error       GetNextSMSMMSIDFromFolder(BOOLEAN start, GSM_SMSMMSFoldersSubEntry *SMSFolder, GSM_SMSList *SMS, GSM_MMSFile *MMS, int *Current, int *MaxInFolder);
        //filesystem
        virtual GSM_Error       GetFileFolderInfo(FileFolderInfo *FInfo);
        virtual GSM_Error       GetNextRootFolderID(wchar_t *ID, GSM_MemoryType *MemType);
        virtual GSM_Error       GetJavaGamesFolderID(wchart *ID, BOOLEAN *NeedSubFolder, BOOLEAN Start);
        virtual GSM_Error       GetJavaAppsFolderID(wchart *ID, BOOLEAN *NeedSubFolder, BOOLEAN Start);
        virtual GSM_Error       GetFolderInfoList(GSM_FileFolderInfoList *FInfo, BOOLEAN Start);
        virtual GSM_Error       AddFolder(FileFolderInfo *FInfo);
        virtual GSM_Error       DeleteFolder(wchar_t *FolderID);        
        virtual GSM_Error       AddFilePart(GSM_File *File, int *Pos);
        virtual GSM_Error       GetFilePart(GSM_File *File);
        virtual GSM_Error       GetMMSFilePart(GSM_File *File);
        virtual GSM_Error       DeleteFile(wchar_t *FileID);
protected:
        int                     ID;
        GSM_Phone               *Next;

        GSM_Device              **Device;
        GSM_AllProtocols        **Protocols;
        GSM_AllPhones           **Phones;
        DebugInfo               **Debug;
        bool                    Opened;
        GSM_Error               (*UserReply)(int MsgLength, unsigned char MsgType, unsigned char *MsgBuffer, void *Struct, int RequestID);
        void                    (*SMSSendReply)(int TPMR);
        GSM_Error               GetSMSLocation(wchart ID, unsigned char *folderid, int *location);
        GSM_Error               GetSMSLocations(GSM_SMSList *sms, unsigned char *folderid, int *location);
        void                    SetSMSLocation(wchart *SMSID, unsigned char folderid, int location);
        void                    SetSMSLocations(GSM_SMSList *sms, unsigned char folderid, int location);

        bool                    Ans(char *MsgTyp, int SubTypeChar, unsigned char SubType, int Request, AnsStruct *AS);
};

/**
 * collection of phone modules
 */
class GSM_AllPhones
{
        friend class            GSM_Phone;
public:
        GSM_Phone               *Current;
        char                    CFGCompatibility[200];

        GSM_AllPhones           (DebugInfo **Deb);
        ~GSM_AllPhones          ();

        void                    Add                (GSM_Phone *Phone);
        GSM_Error               Switch             (char *Pho, char *Pro, char *Comp);
        GSM_Error               SwitchToDeviceName (char *Pho, char *Pro, char *Comp);
        BOOLEAN                 Feature            (char *Name);
        BOOLEAN                CompatibilityFeature(char *Name);
        int                     GetNext            (GSM_Phone **Pho);
        int                     GetID              ();
private:
        int                     ID;

        GSM_Phone               *AllPhones;
        DebugInfo               **Debug;

        char                    *Features;
        char                    *Model;
        char                    *CodeNameModel;

        unsigned char           ReceivedBuffer[5000];
        int                     ReceivedLen, ReceivedPos;

        int                     ReplyNum;
};

#endif
