/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef WIN32
#  include <windows.h>
#endif

#include "../../cfg/config.h" //msvc2005
#include "../protocol/gsmprot.h"
#include "../device/gsmdev.h"
#include "../service/gsmmisc.h"
#include "gsmphone.h"

BOOLEAN GSM_AllPhones::Feature(char *Name)
{
	char Buff[50];

	sprintf(Buff,"-%s-",Name);
	if (strstr(Features,Buff)!=NULL) return TRUE;
	return FALSE;
}

BOOLEAN GSM_AllPhones::CompatibilityFeature(char *Name)
{
	char Buff[50];

	sprintf(Buff,"-%s-",Name);
	if (strstr(CFGCompatibility,Buff)!=NULL) return TRUE;
	return FALSE;
}

int GSM_AllPhones::GetID()
{
	ID+=100;
	if (ID > 20000) (*Debug)->Deb("[STATE     : ERROR WITH ID]\n");
	return ID-100;
}

GSM_AllPhones::GSM_AllPhones(DebugInfo **Deb)
{
	ID	      = 0;
	ReceivedLen     = 0;
	ReceivedPos     = 0;
	ReplyNum	= 3;
	Current	 = NULL;
	AllPhones       = NULL;
	Debug	   = Deb;
}

GSM_AllPhones::~GSM_AllPhones()
{
	GSM_Phone *pho,*pho2;

	pho=AllPhones;
	while(1) {
		if (pho == NULL) break;
		pho2 = pho->Next;
		delete(pho);
		pho = pho2;
	}
}

void GSM_AllPhones::Add(GSM_Phone *Phone)
{
	GSM_Phone *Pho;

	if (AllPhones == NULL) {
		AllPhones = Phone;
	} else {
		Pho = AllPhones;
		while (Pho->Next != NULL) Pho = Pho->Next;
		Pho->Next = Phone;
	}
}

GSM_Error GSM_AllPhones::Switch(char *Pho, char *Pro, char *Comp)
{
	GSM_Phone		       *pho;
	bool			    	PhoneFound = false, found;
	list<GSM_Phone_Info>::iterator  phoinfo;
	int			     	i;
	char			    	buf[20];

	(*Debug)->Deb("[STATE     : switching to phone]\n");

	sprintf(CFGCompatibility,"%s",Comp);

	/* Do we have phone model in phone modules ? If yes, switch */
	pho=AllPhones;
	while(1) {
		for (phoinfo=pho->Info.begin(); phoinfo!=pho->Info.end(); ++phoinfo) {
			if (strcmp((*phoinfo).Model,Pho)) {
				continue;
			} else {
				PhoneFound=true;
			}
			if ((*phoinfo).CompareProtocol(Pro)) {
				found = true;

				i = 0;
				while(pho->ModulesUsed[i]!=0) {
					memset(buf,0,sizeof(buf));
					while(pho->ModulesUsed[i]!=0) {
						buf[strlen(buf)] = pho->ModulesUsed[i];
						i++;
						if (pho->ModulesUsed[i]=='|') {
							i++;
							break;
						}
					}
//				      (*Debug)->Deb("Checking \"%s\" used\n",buf);
				}

				i = 0;
				while(pho->ModulesRequired[i]!=0) {
					memset(buf,0,sizeof(buf));
					while(pho->ModulesRequired[i]!=0) {
						buf[strlen(buf)] = pho->ModulesRequired[i];
						i++;
						if (pho->ModulesRequired[i]=='|') {
							i++;
							break;
						}
					}
//				      (*Debug)->Deb("Checking \"%s\" required\n",buf);
				}

				if (found) {
					if (Current != NULL) {
						//disable old
					}
					Current	 = pho;
					Features	= (*phoinfo).Features;
					Model	   = (*phoinfo).Model;
					CodeNameModel   = (*phoinfo).CodeNameModel;
					return GSM_Return_Error(GSM_ERR_NONE);
				}
			}
		}
		if (pho->Next == NULL) break;
		pho = pho->Next;
	}

	/* We had phone, but with other protocol */
	if (PhoneFound) return GSM_Return_Error(GSM_ERR_OTHER_PROTOCOL);

	/* Unknown phone model */
	return GSM_Return_Error(GSM_ERR_PHONE_STRING_UNKNOWN);
}

GSM_Error GSM_AllPhones::SwitchToDeviceName(char *Pho, char *Pro, char *Comp)
{
	GSM_Phone		        *pho;
	list<GSM_Phone_Info>::iterator  phoinfo;
	bool			    	PhoneFound = false;

	(*Debug)->Deb("[STATE     : switching to phone with device name]\n");

	sprintf(CFGCompatibility,"%s",Comp);

	/* Do we have phone model in phone modules ? If yes, switch */
	pho=AllPhones;
	while(1) {
		for (phoinfo=pho->Info.begin(); phoinfo!=pho->Info.end(); ++phoinfo) {
			if (strcmp((*phoinfo).DeviceModel,Pho)) continue; else PhoneFound=true;
			if ((*phoinfo).CompareProtocol(Pro)) {
				if (Current != NULL) {
					//disable old
				}
				Current	 	= pho;
				Features	= (*phoinfo).Features;
				Model	   	= (*phoinfo).Model;
				CodeNameModel   = (*phoinfo).CodeNameModel;
				return GSM_Return_Error(GSM_ERR_NONE);
			}
		}
		if (pho->Next == NULL) break;
		pho = pho->Next;
	}

	/* We had phone, but with other protocol */
	if (PhoneFound) return GSM_Return_Error(GSM_ERR_OTHER_PROTOCOL);

	/* Unknown phone model */
	return GSM_Return_Error(GSM_ERR_PHONE_STRING_UNKNOWN);
}

int GSM_AllPhones::GetNext(GSM_Phone **Pho)
{
	if ((*Pho) == NULL) {
		(*Pho) = AllPhones;
	} else {
		if ((*Pho)->Next == NULL) return 0;
		(*Pho) = ((*Pho)->Next);
	}
	return 1;
}

/* ------------------------------------------------------------------------- */

GSM_Phone_Info::GSM_Phone_Info(char *Mod, char *Code, char *Device, char *Prot, char *Feat)
{
	Model		   = Mod;
	Protocol	   = Prot;
	CodeNameModel	   = Code;
	DeviceModel	   = Device;
	Features	   = Feat;
}

GSM_Phone_Info::~GSM_Phone_Info()
{
}

bool GSM_Phone_Info::CompareProtocol(char *Pro)
{
	char	    	Prot[50];
	int	     	i;
	bool	    	PhoneFound = false;

	Prot[0] = 0;
	for (i=0;i<(int)strlen(this->Protocol)+1;i++) {
		if (i == strlen(this->Protocol) || this->Protocol[i] == '|') {
			if (!strcmp(Prot,Pro)) return true;
			Prot[0] = 0;
		} else {
			Prot[strlen(Prot)+1] = 0;
			Prot[strlen(Prot)]   = this->Protocol[i];
		}
	}
	return false;
}

/* ------------------------------------------------------------------------- */

GSM_Phone::GSM_Phone(DebugInfo **Deb, GSM_Device **Dev, GSM_AllProtocols **Prot, GSM_AllPhones **Pho)
{
	UserReply       	= NULL;
	SMSSendReply    	= NULL;
	Next	    		= NULL;
	Protocols       	= Prot;
	Device	  		= Dev;
	Phones	  		= Pho;
	Debug	   		= Deb;
	Opened	  		= false;
	ID	      		= (*Phones)->GetID();
	FoldersCacheSubEntry 	= NULL;
}

GSM_Phone::~GSM_Phone()
{
	if (FoldersCacheSubEntry!=NULL) delete(FoldersCacheSubEntry);
}

int GSM_Phone::GetID()
{
	return ID;
}

GSM_Error GSM_Phone::Read(int RequestID, void *Struct)
{
	GSM_Error error, error2;

	if ((*Phones)->ReceivedLen == (*Phones)->ReceivedPos) {
		(*Phones)->ReceivedPos = 0;
		(*Phones)->ReceivedLen = 5000;
		error = (*Device)->Read((*Phones)->ReceivedBuffer,&(*Phones)->ReceivedLen);
		if (error.Code != GSM_ERR_NONE) {
//		      (*Phones)->ReceivedLen = 0;
			return error;
		}
		if ((*Phones)->ReceivedLen == 0) return GSM_Return_Error(GSM_ERR_TIMEOUT);
	}

	error = (*Protocols)->Current->Dispatch((*Phones)->ReceivedBuffer,(*Phones)->ReceivedLen,&(*Phones)->ReceivedPos);
	switch (error.Code) {
	case GSM_ERR_NEWMESSAGE:
		(*Debug)->Deb    ("RECEIVED frame type 0x%02X/length %i\n",(*Protocols)->Current->MsgReceived.Type,(*Protocols)->Current->MsgReceived.Length);
		(*Debug)->DumpDeb((*Protocols)->Current->MsgReceived.Buffer.data(), (*Protocols)->Current->MsgReceived.Length);

		if (UserReply != NULL) {
			error2 = UserReply((*Protocols)->Current->MsgReceived.Length,
					  (*Protocols)->Current->MsgReceived.Type,
					  (unsigned char *)(*Protocols)->Current->MsgReceived.Buffer.data(),
					  Struct, RequestID);
			if (error2.Code == GSM_ERR_FRAME_TYPE_UNKNOWN) {
				error2 = Dispatch(&(*Protocols)->Current->MsgReceived, Struct, RequestID);
			}
		} else {
			error2 = Dispatch(&(*Protocols)->Current->MsgReceived, Struct, RequestID);
		}

		switch (error2.Code) {
		case GSM_ERR_FRAME_NOT_REQUESTED:
			(*Debug)->Deb    ("\nFrame not requested. Please report\n");
			break;
		case GSM_ERR_FRAME_TYPE_UNKNOWN:
			(*Debug)->Deb    ("\nFrame type unknown. Please report\n");
			break;
		case GSM_ERR_FRAME_CONTENT_UNKNOWN:
			(*Debug)->Deb    ("\nFrame content unknown. Please report\n");
			break;
		default:
			return error2;
		}
		(*Debug)->Deb    ("\nSENT frame type 0x%02X/length %i\n",(*Protocols)->Current->MsgSent.Type,(*Protocols)->Current->MsgSent.Length);
		(*Debug)->DumpDeb((*Protocols)->Current->MsgSent.Buffer.data(), (*Protocols)->Current->MsgSent.Length);
		(*Debug)->Deb    ("\nRECEIVED frame type 0x%02X/length %i\n",(*Protocols)->Current->MsgReceived.Type,(*Protocols)->Current->MsgReceived.Length);
		(*Debug)->DumpDeb((*Protocols)->Current->MsgReceived.Buffer.data(), (*Protocols)->Current->MsgReceived.Length);
		(*Debug)->Deb    ("\n");
		return error2;
	case GSM_ERR_NONE:
		return GSM_Return_Error(GSM_ERR_TIMEOUT);
	default:
		return error;
	}
}

GSM_Error GSM_Phone::ReadOnce(int RequestID, void *Struct)
{
	GSM_DateTime    Date,Date2;
	GSM_Error       error;

	GSM_GetCurrentDateTime(&Date);
#ifdef WIN32
	Sleep(1);
#else
	usleep(100);
#endif
	while (1) {
		error = Read(RequestID, Struct);
		if (error.Code != GSM_ERR_TIMEOUT) return error;
		GSM_GetCurrentDateTime(&Date2);
		if (Date2.Second!=Date.Second) break;
#ifdef WIN32
		Sleep(1);
#else
		usleep(100);
#endif
	}
	while (1) {
		error = Read(RequestID, Struct);
		if (error.Code != GSM_ERR_TIMEOUT) return error;
		GSM_GetCurrentDateTime(&Date);
		if (Date2.Second!=Date.Second) break;
#ifdef WIN32
		Sleep(1);
#else
		usleep(100);
#endif
	}
	return GSM_Return_Error(GSM_ERR_TIMEOUT);
}

GSM_Error GSM_Phone::Write(unsigned char *buffer,int length, unsigned char type, int time, int request, void *Struct)
{      
	int	     i, j;
	GSM_Error    error;

	for (i=0;i<(*Phones)->ReplyNum;i++) {
		if (i!=0) (*Debug)->Deb("RETRYING sending frame %i/%i time\n", i+1, (*Phones)->ReplyNum);

		error = (*Protocols)->Current->Write(buffer, length, type);
		if (error.Code!=GSM_ERR_NONE) return error;

		for (j=0;j<time;j++) {
			error = ReadOnce(request, Struct);
			if (error.Code != GSM_ERR_TIMEOUT) return error;
		}
	}

	return GSM_Return_Error(GSM_ERR_TIMEOUT);
}

bool GSM_Phone::Ans(char *MsgTyp, int SubTypeChar, unsigned char SubType, int Request, AnsStruct *AS)
{
	unsigned char *MsgType = (unsigned char *)MsgTyp;

	/* AT commands */
	if (strlen((const char *)MsgType) > 2) {
	}

	/* ------------ Nokia and other binary stuff ------------------ */

	if ((*Protocols)->Current->MsgReceived.Type != MsgType[0]) return false;

	if (SubTypeChar != 0 && SubTypeChar < (*Protocols)->Current->MsgReceived.Length) {
		if ((*Protocols)->Current->MsgReceived.Buffer[SubTypeChar] != SubType) return false;
	}

	(AS->FrameFound) = true;

	if (Request != ID_IncomingFrame && Request != AS->RequestID) return false;
	return true;
}

GSM_Error GSM_Phone::Open(char *ID)
{
	(*Debug)->Deb("[STATE     : opening phone %s]\n",ModuleName);
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone::Close()
{
	return GSM_Return_Error(GSM_ERR_NONE);
}

void GSM_Phone::SetUserReply(GSM_Error(*UsrReply)(int MsgLength, unsigned char MsgType, unsigned char *MsgBuffer, void *Struct, int RequestID))
{
	UserReply = UsrReply;
}

void GSM_Phone::SetSMSSendReply(void(*SMSSndReply)(int TPMR))
{
	SMSSendReply = SMSSndReply;
}

GSM_Error GSM_Phone::ReadFolderToCache(wchar_t *ID, GSM_FileFolderInfoList **List)
{
	GSM_FileFolderInfoListsSubEntry 	*En = NULL;
	BOOLEAN					Start = TRUE;
	GSM_Error 				error;

	En = NULL;
	while (FoldersCache.GetNext(&En)) {
		if (!wcscmp(En->Info.Info.ID.data(),ID)) {
			*List = &En->Info;
			return GSM_Return_Error(GSM_ERR_NONE);
		}
	}

	En = new GSM_FileFolderInfoListsSubEntry;
	En->Info.Info.SetID(ID);
	while (1) {
		error = GetFolderInfoList(&En->Info,Start);
		Start = FALSE;
		if (error.Code == GSM_ERR_FOLDER_MORE) continue;
		if (error.Code != GSM_ERR_NONE && error.Code != GSM_ERR_FOLDER_PART) {
			delete En;
			return error;
		}
		break;
	}

	FoldersCache.AddSubEntry(En);
	*List = &En->Info;

	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone::GetModel(unsigned char *Model)
{
	unsigned char		   	Mod[50];
	list<GSM_Phone_Info>::iterator  phoinfo;
	GSM_Error		        error;

	error = GetCodeNameModel(Mod);
	if (error.Code != GSM_ERR_NONE) return error;

	for (phoinfo=Info.begin(); phoinfo!=Info.end(); ++phoinfo) {
		if (strcmp((*phoinfo).CodeNameModel,(const char *)Mod)) continue;
		strcpy((char *)Model,(*phoinfo).Model);
		return GSM_Return_Error(GSM_ERR_NONE);
	}

	return GSM_Return_Error(GSM_ERR_UNKNOWN);
}

GSM_Error GSM_Phone::GetManufacturer(unsigned char *Manufacturer)
{
	Manufacturer[0] = 0;
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::GetSMSLocation(wchart ID, unsigned char *folderid, int *location)
{
	int		     	i,j;
	wchar_t		 	buffer[20],chr;
	GSM_SMSListSubEntry     *SubEntry = NULL;
	BOOLEAN		 	First = TRUE;

	if (ID.length()>19) return GSM_Return_Error(GSM_ERR_UNKNOWN);
	memset(buffer,0,20);
	for (i=0;i<18;i++) {
		chr=ID.data()[i];
		if (chr=='\\') break;
		if (chr==0x00) return GSM_Return_Error(GSM_ERR_UNKNOWN);
		buffer[i] = chr;
	}
	*folderid = atoi(UnicodeToStringReturn(buffer));

	memset(buffer,0,20);
	for (j=0;j<18;j++) {
		chr=ID.data()[i+1+j];
		if (chr==0) break;
		buffer[j] = chr;
	}
	*location = atoi(UnicodeToStringReturn(buffer));

	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone::GetSMSLocations(GSM_SMSList *sms, unsigned char *folderid, int *location)
{
	GSM_SMSListSubEntry     *SubEntry = NULL;
	BOOLEAN		 	First = TRUE;
	GSM_SMSEntry	    	*SMS;
	unsigned char 		folderid2;
	int 			location2;
	GSM_Error	       	error;

	while (sms->GetNext(&SubEntry) == TRUE) {
		SMS = SubEntry->GetSMS();

		if (First) {
			error = GetSMSLocation(SMS->ID, folderid, location);
		} else {
			error = GetSMSLocation(SMS->ID, &folderid2, &location2);
		}
		if (error.Code != GSM_ERR_NONE) return error;
		if (First) {
			First = FALSE;
		} else {
			if (folderid2 != *folderid || location2 != *location) return GSM_Return_Error(GSM_ERR_UNKNOWN);		 
		}
		(*Debug)->Deb("SMS folder %i & location %i\n",*folderid,*location);
	}

	return GSM_Return_Error(GSM_ERR_NONE);
}

void GSM_Phone::SetSMSLocation(wchart *SMSID, unsigned char folderid, int location)
{
	char buffer[10];

	sprintf(buffer,"%i\\%i",folderid,location);

	SMSID->clear();
	SMSID->append((const wchar_t *)StringToUnicodeReturn(buffer),strlen(buffer));
}

void GSM_Phone::SetSMSLocations(GSM_SMSList *sms, unsigned char folderid, int location)
{
	GSM_SMSListSubEntry *SubEntry = NULL;

	while (sms->GetNext(&SubEntry) == TRUE) {
		SetSMSLocation(&SubEntry->GetSMS()->ID, folderid, location);
	}
}

GSM_Error GSM_Phone::GetIMEI(unsigned char *IMEI)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::GetCodeNameModel(unsigned char *CodeNameModel)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::GetFirmwareVersion(unsigned char *Firm)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::GetFirmwareDate(unsigned char *Date)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::GetProductCode(unsigned char *ProductCode)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::GetPBKStatus(GSM_PBKStatus *Status)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::GetPBK(GSM_PBKEntry *Entry)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::SetPBK(GSM_PBKEntry *Entry)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::DeletePBK(GSM_PBKEntry *Entry)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::GetNextCalendar(GSM_CalendarEntry *Entry, BOOLEAN start, int *Current, int *Max)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::AddCalendar(GSM_CalendarEntry *Entry)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::DeleteCalendar(GSM_CalendarEntry *Entry)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::GetNextNote(GSM_NoteEntry *Entry, BOOLEAN start, int *Current, int *Max)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::AddNote(GSM_NoteEntry *Entry)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::DeleteNote(GSM_NoteEntry *Entry)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::GetNextToDo(GSM_ToDoEntry *Entry, BOOLEAN start, int *Current, int *Max)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::AddToDo(GSM_ToDoEntry *Entry)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::DeleteToDo(GSM_ToDoEntry *Entry)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::GetDateTime(GSM_DateTime *DT)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::SetDateTime(GSM_DateTime *DT)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::SetSMS(GSM_SMSList *List)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::AddSMS(GSM_SMSList *List)
{
	GSM_SMSListSubEntry *SubEntry;

	SubEntry = NULL;
	while (List->GetNext(&SubEntry) == TRUE) {
		SubEntry->GetSMS()->ID.clear();
	}

	return SetSMS(List);
}

GSM_Error GSM_Phone::SendSMS(GSM_SMSEntry *SMS)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::DeleteSMS(GSM_SMSList *List)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::GetSMSStatus(GSM_SMSStatus *Status)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::GetSMSMMSFolders(GSM_SMSMMSFolders *Folders)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::GetNextSMSMMSIDFromFolder(BOOLEAN start, GSM_SMSMMSFoldersSubEntry *SMSFolder, GSM_SMSList *SMS, GSM_MMSFile *MMS, int *Current, int *MaxInFolder)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::GetSMSC(GSM_SMSC *SMSC)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::SetSMSC(GSM_SMSC *SMSC)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::GetFileFolderInfo(FileFolderInfo *FInfo)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::GetFolderInfoList(GSM_FileFolderInfoList *FInfo, BOOLEAN Start)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::GetNextRootFolderID(wchar_t *ID, GSM_MemoryType *MemType)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::GetJavaGamesFolderID(wchart *ID, BOOLEAN *NeedSubFolder, BOOLEAN Start)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::GetJavaAppsFolderID(wchart *ID, BOOLEAN *NeedSubFolder, BOOLEAN Start)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::GetFilePart(GSM_File *File)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::GetMMSFilePart(GSM_File *File)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::AddFilePart(GSM_File *File, int *Pos)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::DeleteFile(wchar_t *FileID)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::DeleteFolder(wchar_t *FolderID)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

GSM_Error GSM_Phone::AddFolder(FileFolderInfo *FInfo)
{
	return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
}

