
#include "../cfg/config.h"
#include "../common/service/gsmdata.h"
#include "../common/service/gsmmisc.h"
#include "../common/service/backup/gsmback.h"
#include "../common/gsmstate.h"

#include <wx/msgdlg.h>
#include <wx/listctrl.h>
#include <wx/combobox.h>
#include <wx/mediactrl.h>
#include <wx/textctrl.h>
#include <wx/sizer.h>
#include <wx/image.h>
#include <wx/button.h>
#include <wx/filedlg.h>


BOOLEAN PrintError (GSM_Error error)
{
    unsigned char buffer[2000];

    if (error.Code == GSM_ERR_NONE) return FALSE;
    sprintf((char *)buffer,"%s",GSM_GetErrorInfo(error));
    wxMessageBox(buffer,
            wxT("Error"),
            wxICON_WARNING | wxOK);
    return TRUE;
}

char *DayOfWeekStr(int Year, int Month, int Day)
{
    switch (DayOfWeek(Year,Month,Day)) {
        case 1: return "Mon";
        case 2: return "Tue";
        case 3: return "Wed";
        case 4: return "Thu";
        case 5: return "Fri";
        case 6: return "Sat";
        case 7: return "Sun";
        default:return "";
    }
}

void PrintDT(GSM_DateTime *DT, char *Buffer)
{
    GSM_DateTime    DT2;
    time_t          One,Two;
    int             Days;

    GSM_GetCurrentDateTime(&DT2);
    DT2.Hour = 23;
    DT2.Minute = 59;
    DT2.Second = 59;
    One=GSMDateTime2TimeT(DT);
    Two=GSMDateTime2TimeT(&DT2);
    Days = (Two - One) / (60*60*24);

    if (Days==0) {
        sprintf(Buffer, "today %02i:%02i:%02i",
            DT->Hour,
            DT->Minute,
            DT->Second);
    } else if (Days==1) {
        sprintf(Buffer, "yesterday %02i:%02i:%02i",
            DT->Hour,
            DT->Minute,
            DT->Second);
    } else if (Days>0) {    
        sprintf(Buffer, "%s %02i-%02i-%04i %02i:%02i:%02i (%i days ago)",
            DayOfWeekStr(
                    DT->Year,
                    DT->Month,
                    DT->Day),
            DT->Day,
            DT->Month,
            DT->Year,
            DT->Hour,
            DT->Minute,
            DT->Second,
            Days);
    } else {
        sprintf(Buffer, "%s %02i-%02i-%04i %02i:%02i:%02i",
            DayOfWeekStr(
                    DT->Year,
                    DT->Month,
                    DT->Day),
            DT->Day,
            DT->Month,
            DT->Year,
            DT->Hour,
            DT->Minute,
            DT->Second);
    }
}

int ViewMMSFile(GSM_File *File, GSM_MMSDecodedFile *Decoded, wxListCtrl *List, wxComboBox *FilesList)
{
	GSM_MMSDecodedFileSubEntry  *SubDecoded;
	GSM_Error                   error;
    long                        tmp,EntryNum=0;
    wchar_t                     Buffer[200];
	char                        buff[200];
    BOOLEAN                     Found;
    wchart                      Name;
    int                         FileNum=-1,FileNum2=1;
    char                        X[1000];

    List->DeleteAllItems();
    FilesList->Clear();

    if (UnicodeLength(File->Info.ID.data())!=0) {
        tmp = List->InsertItem(EntryNum++, "ID", 0);
        List->SetItem(tmp, 1, File->Info.ID.data());
    }

    SubDecoded = NULL;
    while (Decoded->GetNext(&SubDecoded)) {
        Found = false;
        switch (SubDecoded->Type) {
        case MMS_Address_Phone_Source:
            tmp = List->InsertItem(EntryNum++, "From (phone)", 0); Found = true;
            break;
    	case MMS_Address_Unknown_Source:
            tmp = List->InsertItem(EntryNum++, "From", 0); Found = true;
            break;
        case MMS_Address_Phone_Destination:
            tmp = List->InsertItem(EntryNum++, "To (phone)", 0); Found = true;
            break;
        case MMS_Address_Unknown_Destination:
            tmp = List->InsertItem(EntryNum++, "To", 0); Found = true;
            break;
        case MMS_Address_Phone_CC:
            tmp = List->InsertItem(EntryNum++, "CC (phone)", 0); Found = true;
            break;
        case MMS_Address_Unknown_CC:
            tmp = List->InsertItem(EntryNum++, "CC", 0); Found = true;
            break;
        case MMS_Address_Phone_BCC:
            tmp = List->InsertItem(EntryNum++, "BCC (phone)", 0); Found = true;
            break;
        case MMS_Address_Unknown_BCC:
            tmp = List->InsertItem(EntryNum++, "BCC", 0); Found = true;
            break;
        case MMS_Unknown:
            tmp = List->InsertItem(EntryNum++, "<Unknown content>", 0); Found = true;
            break;
        }
        if (Found) {
            memcpy(Buffer,SubDecoded->Text.data(),(SubDecoded->Text.length()+1)*sizeof(wchar_t));
//            FindSMSNumber(Buffer);
            List->SetItem(tmp, 1, Buffer);
            continue;
        }
        switch (SubDecoded->Type) {
        case MMS_Text_TransactionID:
            tmp = List->InsertItem(EntryNum++, "Transaction ID", 0); Found = TRUE;
            break;
        case MMS_Text_Subject:
            tmp = List->InsertItem(EntryNum++, "Subject", 0); Found = TRUE;
            break;
        case MMS_Text_ContentLocation:
            tmp = List->InsertItem(EntryNum++, "Content location", 0); Found = TRUE;
            break;
        case MMS_Text_ContentType:
            tmp = List->InsertItem(EntryNum++, "Content type", 0); Found = TRUE;
            break;
        case MMS_Text_MessageType:
            tmp = List->InsertItem(EntryNum++, "Message type", 0); Found = TRUE;
            break;
        case MMS_Text_MessageID:
            tmp = List->InsertItem(EntryNum++, "Message ID", 0); Found = TRUE;
            break;
        case MMS_Text_MessageClass:
            tmp = List->InsertItem(EntryNum++, "Message class", 0); Found = TRUE;
            break;
        case MMS_Text_Priority:
            tmp = List->InsertItem(EntryNum++, "Priority", 0); Found = TRUE;
            break;
        case MMS_Text_Version:
            tmp = List->InsertItem(EntryNum++, "MMS version", 0); Found = TRUE;
            break;
        case MMS_Text_Response_Status:
            tmp = List->InsertItem(EntryNum++, "Response status", 0); Found = TRUE;
            break;
        case MMS_Text_Status:
            tmp = List->InsertItem(EntryNum++, "Status", 0); Found = TRUE;
            break;
        }
        if (Found) {
            List->SetItem(tmp, 1, SubDecoded->Text.data());
            continue;
        }
        switch (SubDecoded->Type) {
        case MMS_Bool_Report:
            tmp = List->InsertItem(EntryNum++, "Delivery report", 0); Found = TRUE;
            break;
        case MMS_Bool_Read_Reply:
            tmp = List->InsertItem(EntryNum++, "Read reply", 0); Found = TRUE;
            break;
        case MMS_Bool_Report_Allowed:
            tmp = List->InsertItem(EntryNum++, "Report allowed", 0); Found = TRUE;
            break;
        }
        if (Found) {
            if (SubDecoded->Bool) {
                List->SetItem(tmp, 1, "yes");
            } else {
                List->SetItem(tmp, 1, "no");
            }
            continue;
        }
        switch (SubDecoded->Type) {
        case MMS_DT_DateTime:
            tmp = List->InsertItem(EntryNum++, "Sent", 0);
            PrintDT(&SubDecoded->DT, buff);
            List->SetItem(tmp, 1, buff);
            break;
    	case MMS_DT_Expiry:
            tmp = List->InsertItem(EntryNum++, "Expiry", 0);
            List->SetItem(tmp, 1, SubDecoded->Text.data());
            break;
        case MMS_File:
            tmp = List->InsertItem(EntryNum++, "File", 0);
            tmp = List->InsertItem(EntryNum++, "  Content type", 0);
            sprintf(X,"%s",UnicodeToStringReturn(SubDecoded->Text.data()));
            sprintf(X+strlen(X),"%s",UnicodeToStringReturn(SubDecoded->Text2.data()));
            List->SetItem(tmp, 1, X);            

            if (SubDecoded->Header.length()!=0) {
                tmp = List->InsertItem(EntryNum++, "  Header", 0);
                List->SetItem(tmp, 1, SubDecoded->Header.data());
            }
            tmp = List->InsertItem(EntryNum++, "  Size", 0);
            sprintf(buff,"%i bytes",SubDecoded->File.Info.Size);
            List->SetItem(tmp, 1, buff);
            
            Name.clear();
            Name.append(SubDecoded->File.Info.Name.data(),UnicodeLength(SubDecoded->File.Info.Name.data()));
            Name.push_back(' ');
            Name.push_back('(');
            Name.append(SubDecoded->Text.data(),UnicodeLength((wchar_t *)SubDecoded->Text.data()));
            Name.push_back(')');
            FilesList->Append(Name.data());

            if (!wcscmp(SubDecoded->Text.data(),StringToUnicodeReturn("text/plain"))) {
                if (FileNum==-1) FileNum=FileNum2;
            }
            FileNum2++;
            break;
        }
    }
    return FileNum;
}

void MMSSelect(int Num, GSM_MMSDecodedFile *Decoded, wxMediaCtrl *MediaCtrl1, wxTextCtrl *Memo1, wxBoxSizer *BoxSizer3, wxButton *Button) 
{
    boolean                     wrong;
    int                         num5=0;
    int                         Num2;
    GSM_SMSMMSFoldersSubEntry   *SubFolder;
    GSM_Error                   error,preverror;
    GSM_MMSFile                 Entry2;
    boolean                     wasmore = false;
	GSM_MMSDecodedFileSubEntry  *SubDecoded;
	boolean                     found;
	wxImage                     newImage ;
	wxBitmap                    *newBitmap;
	long                        item,item2=0;
	wchart                      UTF8Text;

    Button->Enable(true);

    SubDecoded = NULL;
    while (Decoded->GetNext(&SubDecoded)) {
        if (SubDecoded->Type !=  MMS_File) continue;
        num5++;
        if (num5-1!=Num) continue;

        if (!wcscmp(SubDecoded->Text.data(),StringToUnicodeReturn("text/plain")) ||
            !wcscmp(SubDecoded->Text.data(),StringToUnicodeReturn("text/x-vCard")) ||
            !wcscmp(SubDecoded->Text.data(),StringToUnicodeReturn("text/x-vCalendar")) ||
            !wcscmp(SubDecoded->Text.data(),StringToUnicodeReturn("application/smil"))) {

//            Freeze();
            MediaCtrl1->Show(false);
            Memo1->Show(true);
            BoxSizer3->Layout();
//            Thaw();

            Memo1->Clear();
            if (UnicodeCaseStr(SubDecoded->Text2.data(),StringToUnicodeReturn("charset=utf8"))!=NULL) {
                UTF8ToUnicode(SubDecoded->File.Buffer.data(), &UTF8Text, SubDecoded->File.Buffer.size());
                Memo1->AppendText(UTF8Text.data());
            } else {
                Memo1->AppendText(SubDecoded->File.Buffer.data());
            }
            break;
        }
        if (!wcscmp(SubDecoded->Text.data(),StringToUnicodeReturn("image/jpeg")) ||
             !wcscmp(SubDecoded->Text.data(),StringToUnicodeReturn("audio/amr")) ||
            !wcscmp(SubDecoded->Text.data(),StringToUnicodeReturn("image/gif"))) {
//            Freeze();
            MediaCtrl1->Show(true);
            Memo1->Show(false);
            BoxSizer3->Layout();
//            Thaw();

            if (!wcscmp(SubDecoded->Text.data(),StringToUnicodeReturn("audio/amr"))) {
                SubDecoded->File.SaveToDisk("tmpbitmap.amr");
                MediaCtrl1->Load("tmpbitmap.amr");
                MediaCtrl1->ShowPlayerControls(wxMEDIACTRLPLAYERCONTROLS_DEFAULT);
            }
            if (!wcscmp(SubDecoded->Text.data(),StringToUnicodeReturn("image/jpeg"))) {
                SubDecoded->File.SaveToDisk("tmpbitmap.jpg");
                MediaCtrl1->Load("tmpbitmap.jpg");
                MediaCtrl1->ShowPlayerControls(wxMEDIACTRLPLAYERCONTROLS_NONE);
            }
            if (!wcscmp(SubDecoded->Text.data(),StringToUnicodeReturn("image/gif"))) {
                SubDecoded->File.SaveToDisk("tmpbitmap.gif");
                MediaCtrl1->Load("tmpbitmap.gif");
                MediaCtrl1->ShowPlayerControls(wxMEDIACTRLPLAYERCONTROLS_NONE);
            }

//                wxInitAllImageHandlers();
//                SubDecoded->File.SaveToDisk("tmpbitmap");
//            if (!wcscmp(SubDecoded->Text.data(),StringToUnicodeReturn("image/jpeg"))) {
//                newImage.LoadFile("tmpbitmap",wxBITMAP_TYPE_JPEG);
//            }
//            if (!wcscmp(SubDecoded->Text.data(),StringToUnicodeReturn("image/gif"))) {
//                newImage.LoadFile("tmpbitmap",wxBITMAP_TYPE_GIF);
//            }
//                newBitmap = new wxBitmap(newImage);
//                WxBitmapButton1->SetBitmapLabel(*newBitmap);
//                delete(newBitmap);


            break;
        }
//            Freeze();
            MediaCtrl1->Show(false);
            Memo1->Show(false);
            BoxSizer3->Layout();
//            Thaw();
    }
}

void SaveMMSFile(GSM_MMSDecodedFile *Decoded, wxFileDialog *WxSaveFileDialog1, int Num)
{
    int                         num5=0;
	GSM_MMSDecodedFileSubEntry  *SubDecoded;

    SubDecoded = NULL;
    while (Decoded->GetNext(&SubDecoded)) {
        if (SubDecoded->Type !=  MMS_File) continue;
        num5++;
        if (num5-1!=Num) continue;

        WxSaveFileDialog1->SetFilename(SubDecoded->File.Info.Name.data());
        if (WxSaveFileDialog1->ShowModal()!=wxID_OK) return;

//        if (!wcscmp(SubDecoded->Text.data(),StringToUnicodeReturn("text/plain")) ||
//            !wcscmp(SubDecoded->Text.data(),StringToUnicodeReturn("text/x-vCard")) ||
//            !wcscmp(SubDecoded->Text.data(),StringToUnicodeReturn("text/x-vCalendar")) ||
//            !wcscmp(SubDecoded->Text.data(),StringToUnicodeReturn("application/smil"))) {
//            if (UnicodeCaseStr(SubDecoded->Text2.data(),StringToUnicodeReturn("charset=utf8"))!=NULL) {
//                if (wxMessageBox("Do you want to save decoded file content ?",
//                        wxT("Question"),
//                        wxICON_QUESTION | wxYES_NO) == wxYES) {
//                    UTF8ToUnicode(SubDecoded->File.Buffer.data(), &UTF8Text, SubDecoded->File.Buffer.size());
//                    SubDecoded->File.SaveToDisk((char *)WxSaveFileDialog1->GetPath().c_str());
//                }
//            }
//        }

        SubDecoded->File.SaveToDisk((char *)WxSaveFileDialog1->GetPath().c_str());
        break;
    }
}
