//---------------------------------------------------------------------------
//
// Name:        BackupDlg.cpp
// Author:      Marcinello
// Created:     2007-02-17 22:20:42
// Description: BackupDlg class implementation
//
//---------------------------------------------------------------------------

#include "BackupDlg.h"

//Do not add custom headers
//wxDev-C++ designer will remove them
////Header Include Start
////Header Include End

//----------------------------------------------------------------------------
// BackupDlg
//----------------------------------------------------------------------------
//Add Custom Events only in the appropriate block.
//Code added in other places will be removed by wxDev-C++
////Event Table Start
BEGIN_EVENT_TABLE(BackupDlg,wxDialog)
	////Manual Code Start
	////Manual Code End
	
	EVT_CLOSE(BackupDlg::OnClose)
	EVT_CHECKBOX(ID_WXCHECKBOX7,BackupDlg::WxCheckBox7Click)
	EVT_BUTTON(ID_WXBUTTON4,BackupDlg::WxButton4Click)
	EVT_BUTTON(ID_WXBUTTON3,BackupDlg::WxButton3Click)
	EVT_BUTTON(ID_WXBUTTON2,BackupDlg::WxButton2Click)
	EVT_CHECKBOX(ID_WXCHECKBOX3,BackupDlg::WxCheckBox3Click)
	EVT_CHECKBOX(ID_WXCHECKBOX2,BackupDlg::WxCheckBox2Click)
	EVT_COMBOBOX(ID_WXCOMBOBOX1,BackupDlg::WxComboBox1Selected)
	EVT_BUTTON(ID_WXBUTTON1,BackupDlg::WxButton1Click)
	EVT_CHECKBOX(ID_WXCHECKBOX1,BackupDlg::WxCheckBox1Click)
END_EVENT_TABLE()
////Event Table End

BackupDlg::BackupDlg(GSM_Backup_FileFormatFunctions *Func2, wxWindow *parent, wxWindowID id, const wxString &title, const wxPoint &position, const wxSize& size, long style)
: wxDialog(parent, id, title, position, size, style)
{
    Func = Func2;
	CreateGUIControls();
	
	SetTitle(title);
    
    WxComboBox1->Select(0);
    WxButton3->Enable(FALSE);
    
    WxCheckBox1->Enable(Func->PhonePBK);    
    WxCheckBox2->Enable(Func->SIMPBK);
    WxCheckBox3->Enable(Func->Calendar);
    WxCheckBox4->Enable(Func->Notes);
    WxCheckBox5->Enable(Func->ToDo);
    WxCheckBox7->Enable(Func->PhonePBKPointers);    
}

BackupDlg::~BackupDlg()
{
} 

void BackupDlg::CreateGUIControls()
{
	//Do not add custom code between
        //GUI Items Creation Start and GUI Items Creation End.
	//wxDev-C++ designer will remove them.
	//Add the custom code before or after the blocks
	////GUI Items Creation Start

	SetTitle(wxT("Untitled1"));
	SetIcon(wxNullIcon);
	SetSize(8,8,422,401);
	Center();
	

	WxStaticText3 = new wxStaticText(this, ID_WXSTATICTEXT3, wxT("(can be required for restoring calendar and other)"), wxPoint(33,315), wxDefaultSize, 0, wxT("WxStaticText3"));

	WxListCtrl1 = new wxListCtrl(this, ID_WXLISTCTRL1, wxPoint(14,44), wxSize(385,96), wxLC_REPORT | wxLC_NO_HEADER);
	WxListCtrl1->InsertColumn(0,wxT("Value"),wxLIST_FORMAT_LEFT,300 );
	WxListCtrl1->InsertColumn(0,wxT("Name"),wxLIST_FORMAT_LEFT,80 );

	WxStaticText2 = new wxStaticText(this, ID_WXSTATICTEXT2, wxT("ringtones, logos and other not included inside file)"), wxPoint(52,228), wxDefaultSize, 0, wxT("WxStaticText2"));

	WxCheckBox7 = new wxCheckBox(this, ID_WXCHECKBOX7, wxT("pointers (info about objects like sms lists,"), wxPoint(34,215), wxSize(250,14), 0, wxDefaultValidator, wxT("WxCheckBox7"));

	WxCheckBox6 = new wxCheckBox(this, ID_WXCHECKBOX6, wxT("Set date and time in phone before restore"), wxPoint(15,301), wxSize(285,16), 0, wxDefaultValidator, wxT("WxCheckBox6"));

	WxButton4 = new wxButton(this, ID_WXBUTTON4, wxT("Cancel"), wxPoint(312,345), wxSize(92,25), 0, wxDefaultValidator, wxT("WxButton4"));

	WxButton3 = new wxButton(this, ID_WXBUTTON3, wxT("OK"), wxPoint(7,345), wxSize(92,24), 0, wxDefaultValidator, wxT("WxButton3"));

	WxStaticText1 = new wxStaticText(this, ID_WXSTATICTEXT1, wxT("Format"), wxPoint(16,24), wxDefaultSize, 0, wxT("WxStaticText1"));

	WxButton2 = new wxButton(this, ID_WXBUTTON2, wxT("Unselect all"), wxPoint(333,194), wxSize(64,20), 0, wxDefaultValidator, wxT("WxButton2"));

	WxCheckBox5 = new wxCheckBox(this, ID_WXCHECKBOX5, wxT("ToDo"), wxPoint(15,274), wxSize(58,16), 0, wxDefaultValidator, wxT("WxCheckBox5"));

	WxCheckBox4 = new wxCheckBox(this, ID_WXCHECKBOX4, wxT("Notes"), wxPoint(15,257), wxSize(64,17), 0, wxDefaultValidator, wxT("WxCheckBox4"));

	WxCheckBox3 = new wxCheckBox(this, ID_WXCHECKBOX3, wxT("Calendar"), wxPoint(15,241), wxSize(69,17), 0, wxDefaultValidator, wxT("WxCheckBox3"));

	WxCheckBox2 = new wxCheckBox(this, ID_WXCHECKBOX2, wxT("SIM phonebook"), wxPoint(15,174), wxSize(100,17), 0, wxDefaultValidator, wxT("WxCheckBox2"));

	wxArrayString arrayStringFor_WxComboBox1;
	arrayStringFor_WxComboBox1.Add(wxT("Gammu format"));
	WxComboBox1 = new wxComboBox(this, ID_WXCOMBOBOX1, wxT("WxComboBox1"), wxPoint(71,22), wxSize(227,21), arrayStringFor_WxComboBox1, wxCB_DROPDOWN | wxCB_READONLY, wxDefaultValidator, wxT("WxComboBox1"));

	WxButton1 = new wxButton(this, ID_WXBUTTON1, wxT("Select all"), wxPoint(333,172), wxSize(64,20), 0, wxDefaultValidator, wxT("WxButton1"));

	WxCheckBox1 = new wxCheckBox(this, ID_WXCHECKBOX1, wxT("Phone phonebook"), wxPoint(15,192), wxSize(137,18), 0, wxDefaultValidator, wxT("WxCheckBox1"));

	WxStaticBox1 = new wxStaticBox(this, ID_WXSTATICBOX1, wxT("Features"), wxPoint(7,151), wxSize(399,147));

	WxStaticBox2 = new wxStaticBox(this, ID_WXSTATICBOX2, wxT("File"), wxPoint(6,3), wxSize(401,144));
	////GUI Items Creation End
}

void BackupDlg::OnClose(wxCloseEvent& /*event*/)
{
	Destroy();
}

/*
 * WxButton3Click
 */
void BackupDlg::WxButton3Click(wxCommandEvent& event)
{
	EndModal(wxID_OK);
}

/*
 * WxButton4Click
 */
void BackupDlg::WxButton4Click(wxCommandEvent& event)
{
	EndModal(wxID_CANCEL);
}

/*
 * WxComboBox1Selected
 */
void BackupDlg::WxComboBox1Selected(wxCommandEvent& event )
{
	GSM_Backup                     Backup;
	GSM_Backup_FileFormatFunctions Func;
	
	Backup.GetFileFunctions(Backup_Gammu, &Func);
	
	WxCheckBox1->Enable(Func.PhonePBK);
	WxCheckBox2->Enable(Func.SIMPBK);
	WxCheckBox3->Enable(Func.Calendar);	
	WxCheckBox4->Enable(Func.Notes);
	WxCheckBox5->Enable(Func.ToDo);
	WxCheckBox7->Enable(Func.PhonePBKPointers);
	Check();	
}

/*
 * WxButton1Click
 */
void BackupDlg::WxButton1Click(wxCommandEvent& event)
{
	if (WxCheckBox1->IsEnabled()) WxCheckBox1->SetValue(TRUE);
	if (WxCheckBox2->IsEnabled()) WxCheckBox2->SetValue(TRUE);
	if (WxCheckBox3->IsEnabled()) WxCheckBox3->SetValue(TRUE);
	if (WxCheckBox4->IsEnabled()) WxCheckBox4->SetValue(TRUE);
	if (WxCheckBox5->IsEnabled()) WxCheckBox5->SetValue(TRUE);
	if (WxCheckBox7->IsEnabled()) WxCheckBox7->SetValue(TRUE);
	Check();
}

/*
 * WxButton2Click
 */
void BackupDlg::WxButton2Click(wxCommandEvent& event)
{
	WxCheckBox1->SetValue(FALSE);
	WxCheckBox2->SetValue(FALSE);
	WxCheckBox3->SetValue(FALSE);
	WxCheckBox4->SetValue(FALSE);
	WxCheckBox5->SetValue(FALSE);
	WxCheckBox7->SetValue(FALSE);
	Check();
}

void BackupDlg::Check()
{
	Func->PhonePBK = WxCheckBox1->GetValue();
    Func->SIMPBK = WxCheckBox2->GetValue();
    Func->Calendar = WxCheckBox3->GetValue();
	Func->Notes = WxCheckBox4->GetValue();
	Func->ToDo = WxCheckBox5->GetValue();
	Func->PhonePBKPointers = WxCheckBox7->GetValue();
    WxButton3->Enable(TRUE);
    if (!WxCheckBox1->GetValue() &&
	    !WxCheckBox2->GetValue() &&
    	!WxCheckBox3->GetValue() &&
        !WxCheckBox4->GetValue() &&
        !WxCheckBox5->GetValue()) {
            //fixme
    	WxButton3->Enable(FALSE);
    }    
}

/*
 * WxCheckBox1Click
 */
void BackupDlg::WxCheckBox1Click(wxCommandEvent& event)
{
	Check();
}

/*
 * WxCheckBox2Click
 */
void BackupDlg::WxCheckBox2Click(wxCommandEvent& event)
{
	Check();
}

/*
 * WxCheckBox3Click
 */
void BackupDlg::WxCheckBox3Click(wxCommandEvent& event)
{
	Check();
}

/*
 * WxCheckBox7Click
 */
void BackupDlg::WxCheckBox7Click(wxCommandEvent& event)
{
	Check();
}
