//---------------------------------------------------------------------------
//
// Name:        CfgDlg.cpp
// Author:      Marcinello
// Created:     2007-01-25 22:01:44
// Description: CfgDlg class implementation
//
//---------------------------------------------------------------------------

#include "CfgDlg.h"

//Do not add custom headers
//wxDev-C++ designer will remove them
////Header Include Start
////Header Include End

//----------------------------------------------------------------------------
// CfgDlg
//----------------------------------------------------------------------------
//Add Custom Events only in the appropriate block.
//Code added in other places will be removed by wxDev-C++
////Event Table Start
BEGIN_EVENT_TABLE(CfgDlg,wxDialog)
	////Manual Code Start
	////Manual Code End
	
	EVT_CLOSE(CfgDlg::OnClose)
	EVT_COMBOBOX(ID_WXCOMBOBOX1,CfgDlg::WxComboBox1Selected)
	EVT_COMBOBOX(ID_WXCOMBOBOX2,CfgDlg::WxComboBox2Selected)
	EVT_BUTTON(ID_WXBUTTON2,CfgDlg::WxButton2Click)
	EVT_BUTTON(ID_WXBUTTON3,CfgDlg::WxButton3Click)
END_EVENT_TABLE()
////Event Table End

CfgDlg::CfgDlg(wxWindow *parent, wxWindowID id, const wxString &title, const wxPoint &position, const wxSize& size, long style)
: wxDialog(parent, id, title, position, size, style)
{
	CreateGUIControls();
}

CfgDlg::~CfgDlg()
{
} 

void CfgDlg::CreateGUIControls()
{
	//Do not add custom code between
        //GUI Items Creation Start and GUI Items Creation End.
	//wxDev-C++ designer will remove them.
	//Add the custom code before or after the blocks
	////GUI Items Creation Start

	SetTitle(wxT("Configuration for phone connection"));
	SetIcon(wxNullIcon);
	SetSize(8,8,446,226);
	Center();
	

	WxCheckBox3 = new wxCheckBox(this, ID_WXCHECKBOX3, wxT("check online info on startup (send codename and product code)"), wxPoint(14,119), wxSize(357,18), 0, wxDefaultValidator, wxT("WxCheckBox3"));

	WxCheckBox2 = new wxCheckBox(this, ID_WXCHECKBOX2, wxT("log communication for debug"), wxPoint(14,143), wxSize(240,18), 0, wxDefaultValidator, wxT("WxCheckBox2"));

	wxArrayString arrayStringFor_WxComboBox1;
	WxComboBox1 = new wxComboBox(this, ID_WXCOMBOBOX1, wxT("WxComboBox1"), wxPoint(93,24), wxSize(336,21), arrayStringFor_WxComboBox1, wxCB_DROPDOWN | wxCB_READONLY | wxCB_SORT, wxDefaultValidator, wxT("WxComboBox1"));

	WxEdit1 = new wxTextCtrl(this, ID_WXEDIT1, wxT("WxEdit1"), wxPoint(93,50), wxSize(335,21), 0, wxDefaultValidator, wxT("WxEdit1"));

	wxArrayString arrayStringFor_WxComboBox2;
	WxComboBox2 = new wxComboBox(this, ID_WXCOMBOBOX2, wxT("WxComboBox2"), wxPoint(93,76), wxSize(335,21), arrayStringFor_WxComboBox2, wxCB_DROPDOWN | wxCB_READONLY | wxCB_SORT, wxDefaultValidator, wxT("WxComboBox2"));

	WxCheckBox1 = new wxCheckBox(this, ID_WXCHECKBOX1, wxT("set phone clock from your computer"), wxPoint(14,103), wxSize(296,18), 0, wxDefaultValidator, wxT("WxCheckBox1"));

	WxButton2 = new wxButton(this, ID_WXBUTTON2, wxT("&OK"), wxPoint(40,170), wxSize(82,23), 0, wxDefaultValidator, wxT("WxButton2"));

	WxButton3 = new wxButton(this, ID_WXBUTTON3, wxT("&Cancel"), wxPoint(312,171), wxSize(81,23), 0, wxDefaultValidator, wxT("WxButton3"));

	WxStaticText3 = new wxStaticText(this, ID_WXSTATICTEXT3, wxT("Phone model"), wxPoint(14,78), wxDefaultSize, 0, wxT("WxStaticText3"));

	WxStaticText2 = new wxStaticText(this, ID_WXSTATICTEXT2, wxT("Device"), wxPoint(14,52), wxDefaultSize, 0, wxT("WxStaticText2"));

	WxStaticText1 = new wxStaticText(this, ID_WXSTATICTEXT1, wxT("Type"), wxPoint(15,25), wxDefaultSize, 0, wxT("WxStaticText1"));

	WxStaticBox1 = new wxStaticBox(this, ID_WXSTATICBOX1, wxT("Parameters"), wxPoint(3,6), wxSize(432,160));
	////GUI Items Creation End
}

void CfgDlg::OnClose(wxCloseEvent& /*event*/)
{
	Destroy();
}

void CfgDlg::SetConfig(GSM_GPlusConfig *CFG2, GSM_StateMachine *s2)
{
	list<GSM_Protocol_Info>::iterator 	proinfo;
	list<GSM_Phone_Info>::iterator 		phoinfo;
    GSM_Protocol            		    *pro;
        GSM_Phone               		*pho;
    int                                 Num=0;
    char                                buff[200];
    
    s=s2;
    CFG = CFG2;
    
    if (strcmp(CFG->LogLevel,"nothing")) WxCheckBox2->SetValue(true);
    if (!strcmp(CFG->SyncTime,"yes")) WxCheckBox1->SetValue(true);
    if (!strcmp(CFG->GetOnlineInfo,"yes")) WxCheckBox3->SetValue(true);
            
    //device
    WxEdit1->SetValue(StringToUnicodeReturn(CFG->Device));
    
    //phone model
    WxComboBox2->Clear();
    WxComboBox2->Append("(selected automatic)");
    WxComboBox2->SetSelection(0);
    Num=0;
    pho = NULL;
    while(1) {
        if (!s->Phones->GetNext(&pho)) break;
    	for (phoinfo=pho->Info.begin(); phoinfo!=pho->Info.end(); ++phoinfo) {
            if ((*phoinfo).Model[0]==0) continue;
            sprintf(buff,"%s (%s)",(*phoinfo).Model,(*phoinfo).CodeNameModel);
            WxComboBox2->Append(buff);
            Num++;
            if (!strcmp(CFG->Phone,(*phoinfo).Model)) WxComboBox2->SetSelection(Num);            
        }
    }    
    
    //connection
    SelectChoice2();
}

typedef struct {
 	char		*Connection;
	char		*Description;
	char        *Device;
} X;

    X   X2[] = {
    	"bluerfphonet", "Nokia - bluetooth for old models (with Microsoft stack)", "Phone address",
    	"bluephonet", "Nokia - bluetooth for new models (with Microsoft stack)", "Phone address",
    	"phonetblue", "Nokia - bluetooth over 'Nokia PC Suite' service (with any stack)", "Serial port",
    	"irdaphonet", "Nokia - infrared", "Device",
    	"dku2", "Nokia - DKU2 USB cable for PopPort (with Nokia driver)", "Device",
    	"fbus", "Nokia - FBUS cable","Serial port",
    	"","",""};

void CfgDlg::SelectChoice1()
{
    char                                buff[200];
	list<GSM_Protocol_Info>::iterator 	proinfo;
	list<GSM_Phone_Info>::iterator 		phoinfo;
    GSM_Protocol            		    *pro;
        GSM_Phone               		*pho;
	int Num,i;

    i = 0;
    while (X2[i].Connection[0] != 0) {
        if (strcmp(WxComboBox1->GetStringSelection(),X2[i].Description)) {
            i++;
            continue;
        }
        pro = NULL;
        while(1) {
            if (!s->Protocols->GetNext(&pro)) break;
            for (proinfo=pro->Info.begin(); proinfo!=pro->Info.end(); ++proinfo) {
                if (!strcmp((*proinfo).Protocol,X2[i].Connection)) {
                    sprintf(CFG->Protocol,"%s",X2[i].Connection);
                    WxEdit1->Enable((*proinfo).NeedPort);
                    WxStaticText2->Enable((*proinfo).NeedPort);
                    WxStaticText2->SetLabel(X2[i].Device);
                }
            }
        }
        break;
    }
}

void CfgDlg::SelectChoice2()
{
    char                                buff[200];
	list<GSM_Protocol_Info>::iterator 	proinfo;
	list<GSM_Phone_Info>::iterator 		phoinfo;
    GSM_Protocol            		    *pro;
        GSM_Phone               		*pho;
	int i,j;

    WxComboBox1->Clear();
    if (WxComboBox2->GetValue()=="(selected automatic)") {
        sprintf(CFG->Phone,"");
        pro = NULL;
        while(1) {
            if (!s->Protocols->GetNext(&pro)) break;
            for (proinfo=pro->Info.begin(); proinfo!=pro->Info.end(); ++proinfo) {
                i = 0;
                while (X2[i].Connection[0] != 0) {
                    if (!strcmp((*proinfo).Protocol,X2[i].Connection)) {
                        WxComboBox1->Append(X2[i].Description);
                    }
                    i++;
                }
            }
        }
    } else {
        pho = NULL;
        while(1) {
            if (!s->Phones->GetNext(&pho)) break;
        	for (phoinfo=pho->Info.begin(); phoinfo!=pho->Info.end(); ++phoinfo) {
                if ((*phoinfo).Model[0]==0) continue;
                sprintf(buff,"%s (%s)",(*phoinfo).Model,(*phoinfo).CodeNameModel);
                if (strcmp(buff,WxComboBox2->GetStringSelection())) continue;
                sprintf(CFG->Phone,"%s",(*phoinfo).Model);

                pro = NULL;
                while(1) {
                    if (!s->Protocols->GetNext(&pro)) break;
                    for (proinfo=pro->Info.begin(); proinfo!=pro->Info.end(); ++proinfo) {
                        i = 0;
                        while (X2[i].Connection[0] != 0) {
                            if (!strcmp((*proinfo).Protocol,X2[i].Connection) &&
                                strstr((*phoinfo).Protocol,X2[i].Connection)!=NULL) {
                                WxComboBox1->Append(X2[i].Description);
                            }
                            i++;
                        }
                    }
                }
            }
        }
    }
    
    for (i=0;i<WxComboBox1->GetCount();i++) {
        if (i==0) WxComboBox1->SetSelection(0);
        j = 0;
        while (X2[j].Connection[0] != 0) {
            if (!strcmp(WxComboBox1->GetString(i),X2[j].Description)) {
                if (!strcmp(CFG->Protocol,X2[j].Connection)) {
                    WxComboBox1->SetSelection(i);
                }                
            }
            j++;
        }
    }
    SelectChoice1();
}


/*
 * WxButton2Click
 */
void CfgDlg::WxButton2Click(wxCommandEvent& event)
{
    sprintf(CFG->Device,"%s",UnicodeToStringReturn((wchar_t *)((const wchar_t *)WxEdit1->GetValue().wc_str(wxConvLibc))));

    if (WxCheckBox1->GetValue()) {
        sprintf(CFG->SyncTime,"yes");
    } else {
        sprintf(CFG->SyncTime,"no");
    }
    
    if (WxCheckBox2->GetValue()) {
        sprintf(CFG->LogLevel,"textall");
        sprintf(CFG->LogFile,"log");
    } else {
        sprintf(CFG->LogLevel,"nothing");
    }
    if (WxCheckBox3->GetValue()) {
        sprintf(CFG->GetOnlineInfo,"yes");
    } else {
        sprintf(CFG->GetOnlineInfo,"no");
    }
    
    EndModal(wxID_OK);
}

/*
 * WxButton3Click
 */
void CfgDlg::WxButton3Click(wxCommandEvent& event)
{
    EndModal(wxID_CANCEL);
}

/*
 * WxComboBox1Selected
 */
void CfgDlg::WxComboBox1Selected(wxCommandEvent& event )
{
	SelectChoice1();
}

/*
 * WxComboBox2Selected
 */
void CfgDlg::WxComboBox2Selected(wxCommandEvent& event )
{
	SelectChoice2();
}
