/* (C) 2003 - 2006 by Marcin Wiacek www.mwiacek.com */

void GetFileFolderInfo(GSM_StateMachine *s, BOOLEAN DetailsAvail, FileFolderInfo *FInfo, int Level, GSM_MemoryType Mem, int *PhoneSize, int *CardSize)
{
	int 				i,j=0;
	GSM_FileFolderInfoList		List;
	GSM_FileFolderInfoListSubEntry  *SubEntry;
	GSM_Error			error;
	BOOLEAN				Start = TRUE;

	if (DetailsAvail == FALSE) {
		error = s->Phones->Current->GetFileFolderInfo(FInfo);
		PrintError(error);
	}

	if (FInfo->ID.data()[0] == 'c' || FInfo->ID.data()[0] == 'C') {
		printf("(%s)",UnicodeToStringReturn(FInfo->ID.data()));
		for (i=UnicodeLength(FInfo->ID.data());i<6;i++) printf(" ");
	}

	if (FInfo->Folder == TRUE) {
		List.Info.SetID((wchar_t *)FInfo->ID.data());

		while (1) {
			error = s->Phones->Current->GetFolderInfoList(&List,Start);
			Start = FALSE;
			if (error.Code == GSM_ERR_FOLDER_MORE) {
				j++;
				PrintStdErr("Reading filesystem folder content: %i",j);
				continue;
			}
			if (error.Code == GSM_ERR_FOLDER_PART || 
			    error.Code == GSM_ERR_EMPTY || 
			    error.Code == GSM_ERR_MEMORY) {
				break;
			}
			PrintError(error);
			break;
		}
		PrintStdErr("");
	}

	if (FInfo->DRMForwardLock) {
		printf("P");
	} else {
		printf(" ");
	}
	if (FInfo->ReadOnly) {
		printf("R");
	} else {
		printf(" ");
	}
	if (FInfo->Hidden) {
		printf("H");
	} else {
		printf(" ");
	}
	if (FInfo->System) {
		printf("S");
	} else {
		printf(" ");
	}

	for (i=0;i<Level-1;i++) printf("|   ");
	if (Level!=0) printf("|---");

	if (FInfo->Folder == FALSE) {
		printf("%s\n",UnicodeToStringReturn(FInfo->Name.data()));
		if (Mem == MEM_MEMORY_CARD) *CardSize += FInfo->Size;
		if (Mem == MEM_PHONE) *PhoneSize += FInfo->Size;
		return;
	}

	if (error.Code == GSM_ERR_FOLDER_PART) printf("part of ");
	if (Level!=0) {
		printf("folder");
	} else {
		printf("drive");
	}
	printf(" %s",UnicodeToStringReturn(FInfo->Name.data()));

	if (Level==0) {
		if (Mem == MEM_MEMORY_CARD) printf(" (memory card)");
		if (Mem == MEM_PHONE) printf(" (phone)");
	}
	printf("\n");
	if (error.Code == GSM_ERR_EMPTY) return;
	if (error.Code == GSM_ERR_MEMORY) {
		printf("(currently unavailable)\n");
		return;
	}

	SubEntry = NULL;
	while (List.GetNext(&SubEntry) == TRUE) {
	       	GetFileFolderInfo(s,List.SubEntryFullData,&SubEntry->Info,Level+1,Mem,PhoneSize,CardSize);
	}
}

void GetFileSystem(GSM_StateMachine *s, GSM_GPlusConfig *CFG, int argc, char *argv[])
{
	FileFolderInfo	Info;
	GSM_Error		error;
	BOOLEAN			Start = TRUE;
	wchar_t			name[20];
	GSM_MemoryType		Mem;
	int			PhoneSize = 0, CardSize = 0;

	error = s->Open(CFG);
	PrintError(error);

	name[0] = 0;
	while (true) {
		error = s->Phones->Current->GetNextRootFolderID(name,&Mem);
		if (error.Code == GSM_ERR_EMPTY) break;
		if (error.Code != GSM_ERR_MEMORY) PrintError(error);

		Info.Folder = TRUE;
		Info.SetID(name);
		Info.SetName(name);
		GetFileFolderInfo(s,TRUE,&Info,0,Mem,&PhoneSize,&CardSize);
	}

	printf("\n\n%i bytes used in phone memory",PhoneSize);
	if (CardSize != 0) printf(", %i bytes used in memory card",CardSize);
	printf("\n");
}

void GetOneFile(GSM_StateMachine *s, GSM_File *File)
{
	GSM_Error error;

	GSM_GetCurrentDateTime(&DTStart);
	
	while(true) {
		error = s->Phones->Current->GetFilePart(File);
		if (error.Code!=GSM_ERR_NONE) {
			printf("\n  ");
			PrintError(error);
		}

		PrintTimeLeft("  Done: ", File->Buffer.size(),File->Info.Size);

		if (File->Info.Size == File->Buffer.size()) break;
	}	
	PrintStdErr("");
}

void GetFile(GSM_StateMachine *s, GSM_GPlusConfig *CFG, int argc, char *argv[])
{
	GSM_File		File;
	GSM_Error		error;
	wchar_t 		Buffer[500];

	error = s->Open(CFG);
	PrintError(error);

	UTF8QuotedPrintableToUnicode((unsigned char *)argv[0], Buffer, strlen(argv[0]));
	File.Info.SetID(Buffer);

	printf("Reading file %s\n",argv[0]);

	GetOneFile(s, &File);

	printf("\n  Saving to %s",UnicodeToStringReturn(File.Info.Name.data()));
	File.SaveToDisk(UnicodeToStringReturn(File.Info.Name.data()));
	//PrintError(error);
}

void AddOneFile(GSM_StateMachine *s, GSM_File *File)
{
	int 			Pos = 0;
	GSM_Error		error;
	unsignedstring		Buffer2;

	while(1) {
		error = s->Phones->Current->AddFilePart(File,&Pos);
		if (error.Code == GSM_ERR_EMPTY) break;
		PrintError(error);

		PrintTimeLeft("  Done: ", Pos,File->Info.Size);
	}	
	PrintStdErr("");

	UnicodeToUTF8QuotedPrintable((wchar_t *)File->Info.ID.data(), &Buffer2);
	printf("%cFile ID is %s         \n",13,Buffer2.data());
}

void AddFile(GSM_StateMachine *s, GSM_GPlusConfig *CFG, int argc, char *argv[])
{
	GSM_File		File;
	GSM_Error		error;
	wchar_t 		Buffer[500];

	if (!File.ReadFromDisk(StringToUnicodeReturn(argv[1]))) return;
	//PrintError(error);

	error = s->Open(CFG);
	PrintError(error);

	UTF8QuotedPrintableToUnicode((unsigned char *)argv[0], Buffer, strlen(argv[0]));
	File.Info.SetID(Buffer);

	File.Info.SetName(StringToUnicodeReturn(argv[1]));

	File.Info.DRMForwardLock = FALSE;
	File.Info.ReadOnly	 = FALSE;
	File.Info.Hidden	 = FALSE;
	File.Info.System	 = FALSE;

	AddOneFile(s, &File);	
}

void AddFolder(GSM_StateMachine *s, GSM_GPlusConfig *CFG, int argc, char *argv[])
{
	GSM_File		File;
	GSM_Error		error;
	wchar_t 		Buffer[500];
	FileFolderInfo 	FInfo;

	error = s->Open(CFG);
	PrintError(error);

	UTF8QuotedPrintableToUnicode((unsigned char *)argv[0], Buffer, strlen(argv[0]));
	FInfo.SetID(Buffer);

	FInfo.SetName(StringToUnicodeReturn(argv[1]));

	error = s->Phones->Current->AddFolder(&FInfo);
	PrintError(error);
}

void DeleteFolder(GSM_StateMachine *s, GSM_GPlusConfig *CFG, int argc, char *argv[])
{
	GSM_File		File;
	GSM_Error		error;
	wchar_t 		Buffer[500];
	FileFolderInfo 	FInfo;

	error = s->Open(CFG);
	PrintError(error);

	UTF8QuotedPrintableToUnicode((unsigned char *)argv[0], Buffer, strlen(argv[0]));

	error = s->Phones->Current->DeleteFolder(Buffer);
	PrintError(error);
}

void DeleteFile(GSM_StateMachine *s, GSM_GPlusConfig *CFG, int argc, char *argv[])
{
	GSM_File		File;
	GSM_Error		error;
	wchar_t 		Buffer[500];
	FileFolderInfo 	FInfo;

	error = s->Open(CFG);
	PrintError(error);

	UTF8QuotedPrintableToUnicode((unsigned char *)argv[0], Buffer, strlen(argv[0]));

	error = s->Phones->Current->DeleteFile(Buffer);
	PrintError(error);
}

BOOLEAN FindJADFiles(GSM_StateMachine *s, FileFolderInfo *FInfo, BOOLEAN DetailsAvail, unsignedstring Name)
{
	int 				j=0;
	GSM_FileFolderInfoList 		List;
	GSM_FileFolderInfoListSubEntry  *SubEntry;
	BOOLEAN 			Start = TRUE, x;
	GSM_File			File;
	GSM_Error			error;
	unsignedstring 			JAD_Vendor, JAD_Name, JAD_JAR, JAD_Version;
	int 				JAD_JAR_Size;

	if (DetailsAvail == FALSE) {
		error = s->Phones->Current->GetFileFolderInfo(FInfo);
		PrintError(error);
	}
	if (FInfo->Folder == FALSE) {
		if (StringCaseStr(UnicodeToStringReturn(FInfo->Name.data()),".jad")!=NULL) {
			File.Info.SetID((wchar_t *)FInfo->ID.data());
			GetOneFile(s,&File);
			File.JAD_Find_Data(&JAD_Vendor, &JAD_Name, &JAD_JAR, &JAD_Version, &JAD_JAR_Size);
			if (Name.length() != 0) {
				return StringCaseCmp((char *)JAD_Name.data(),(char *)Name.data(),-1);
			} else {
				printf("  \"%s\" (version \"%s\", size about %i bytes) created by \"%s\"\n",JAD_Name.data(),JAD_Version.data(),JAD_JAR_Size+File.Info.Size,JAD_Vendor.data());
			}
		}
		return FALSE;
	}

	List.Info.SetID((wchar_t *)FInfo->ID.data());
	while (1) {
		error = s->Phones->Current->GetFolderInfoList(&List,Start);
		Start = FALSE;
		if (error.Code == GSM_ERR_FOLDER_MORE) {
			j++;
			PrintStdErr("Reading filesystem folder content: %i",j);
			continue;
		}
		if (error.Code == GSM_ERR_FOLDER_PART || 
		    error.Code == GSM_ERR_EMPTY || 
		    error.Code == GSM_ERR_MEMORY) {
			break;
		}
		PrintError(error);
		break;
	}
	PrintStdErr("");

	SubEntry = NULL;
	while (List.GetNext(&SubEntry) == TRUE) {
		x = FindJADFiles(s,&SubEntry->Info,List.SubEntryFullData,Name);
		if (x) return x;
	}

	return FALSE;
}

void DisplayJava(GSM_StateMachine *s, GSM_GPlusConfig *CFG, int argc, char *argv[])
{
	GSM_Error		error;
	wchart			ID;
	unsignedstring		Buffer2,Name;
	BOOLEAN 		NeedSubFolder,Start;
	FileFolderInfo 	FInfo;
	int 			i=1;

	error = s->Open(CFG);
	PrintError(error);

	while (true) {
		Start = TRUE;
		while (true) {
			if (i==1 ) {
				error = s->Phones->Current->GetJavaGamesFolderID(&ID, &NeedSubFolder, Start);
			} else {
				error = s->Phones->Current->GetJavaAppsFolderID(&ID, &NeedSubFolder, Start);
			}
			Start = FALSE;
			if (error.Code == GSM_ERR_FOLDER_MORE) continue;
			PrintError(error);
			break;
		}
		UnicodeToUTF8QuotedPrintable((wchar_t *)ID.data(), &Buffer2);
		if (i==1) {
			printf("Folder for Java games is %s\n",Buffer2.data());
		} else {
			printf("\nFolder for Java applications is %s\n",Buffer2.data());
		}
		FInfo.SetID((wchar_t *)ID.data());
		FindJADFiles(s, &FInfo, FALSE, Name);
		i++;
		if (i==3) break;
		Buffer2.clear();
	}
}

void AddJava(GSM_StateMachine *s, GSM_GPlusConfig *CFG, int argc, char *argv[], BOOLEAN Game)
{
	wchart			ID;
	BOOLEAN 		NeedSubFolder;
	GSM_File		JAD_File, JAR_File;
	GSM_Error		error;
	char			Buffer2[500];
	unsignedstring 		JAD_Vendor, JAD_Name, JAD_JAR, JAD_Version;
	int 			JAD_JAR_Size,pos;
	BOOLEAN			FixSize = FALSE, Start, Found;
	FileFolderInfo 	FInfo;

	sprintf(Buffer2,"%s.jad",argv[0]);
	//error = 
	JAD_File.ReadFromDisk(StringToUnicodeReturn(Buffer2));
	//PrintError(error);

	sprintf(Buffer2,"%s.jar",argv[0]);
	//error = 
		JAR_File.ReadFromDisk(StringToUnicodeReturn(Buffer2));
	//PrintError(error);

	//---------------------- checking JAD content -------------------------

	JAD_File.JAD_Find_Data(&JAD_Vendor, &JAD_Name, &JAD_JAR, &JAD_Version, &JAD_JAR_Size);
	if (JAD_Vendor.size()==0) { printf("No vendor in JAD file\n"); exit(-1); }
	if (JAD_Name.size()==0) { printf("No name in JAD file\n"); exit(-1); }
	if (JAD_JAR.size()==0) { printf("No JAR URL in JAD file\n"); exit(-1); }
	
	if (JAD_JAR_Size!=JAR_File.Buffer.size()) { 
		printf("Wrong JAD file size inside JAR\n");
//		printf("JAD size will be fixed inside file %i %i\n",JAD_JAR_Size,JAR_File.Buffer.size());
	}

	// no http path in JAR name allowed for many phones
	if (strstr((char *)JAD_JAR.data(),"http://") != NULL) {		
		pos = JAD_JAR.length()-1;
		while (JAD_JAR.data()[pos] != '/') pos--;		
		strcpy(Buffer2,(char *)JAD_JAR.data()+pos+1);
		JAD_JAR.clear();
		JAD_JAR.append((unsigned char *)Buffer2,strlen(Buffer2));
	}

	// Changing all #13 or #10 to #13#10 in JAD
	JAD_File.SetWin32EndLines();

	//---------------------------------------------------------------------

	printf("Adding \"%s\" (version \"%s\") created by \"%s\"\n",JAD_Name.data(),JAD_Version.data(),JAD_Vendor.data());

	error = s->Open(CFG);
	PrintError(error);

	Start = TRUE;
	while (true) {
		if (Game) {
			error = s->Phones->Current->GetJavaGamesFolderID(&ID, &NeedSubFolder, Start);
		} else {
			error = s->Phones->Current->GetJavaAppsFolderID(&ID, &NeedSubFolder, Start);
		}
		Start = FALSE;
		if (error.Code == GSM_ERR_FOLDER_MORE) continue;
		PrintError(error);
		break;
	}

	// ----------------------- search for midlet in phone -----------------
	// -------------------- if found, replace old application -------------
	FInfo.SetID((wchar_t *)ID.data());
	Found = FindJADFiles(s, &FInfo, FALSE, JAD_Name);
	if (Found) {
		ID.clear();
		ID.append(FInfo.ID.data(),UnicodeLength(FInfo.ID.data()));
		printf("Replacing old version\n");
	} else {
		if (NeedSubFolder) {
			FInfo.SetID((wchar_t *)ID.data());
			sprintf(Buffer2,"%s",JAD_JAR.data());
			Buffer2[strlen(Buffer2)-4] = 0;
			FInfo.SetName(StringToUnicodeReturn(Buffer2));

			error = s->Phones->Current->AddFolder(&FInfo);
			PrintError(error);

			ID.clear();
			ID.append(FInfo.ID.data(),UnicodeLength(FInfo.ID.data()));
		}
	}

	//------------------------- writing files -----------------------------

	printf("Writing JAD file\n");
	sprintf(Buffer2,"%s",JAD_JAR.data());
	Buffer2[strlen(Buffer2)-1] = 'd';
	JAD_File.Info.SetName(StringToUnicodeReturn(Buffer2));
	JAD_File.Info.SetID((wchar_t *)ID.data());
	JAD_File.Info.DRMForwardLock = FALSE;
	JAD_File.Info.ReadOnly	 = FALSE;
	JAD_File.Info.Hidden	 = FALSE;
	JAD_File.Info.System	 = FALSE;
	PrintTimeLeftReset();
	AddOneFile(s, &JAD_File);	

	printf("Writing JAR file\n");
	sprintf(Buffer2,"%s",JAD_JAR.data());
	JAR_File.Info.SetName(StringToUnicodeReturn(Buffer2));
	JAR_File.Info.SetID((wchar_t *)ID.data());
	JAR_File.Info.DRMForwardLock = FALSE;
	JAR_File.Info.ReadOnly	 = FALSE;
	JAR_File.Info.Hidden	 = FALSE;
	JAR_File.Info.System	 = FALSE;
	PrintTimeLeftReset();
	AddOneFile(s, &JAR_File);
}

void AddJavaGame(GSM_StateMachine *s, GSM_GPlusConfig *CFG, int argc, char *argv[])
{
	AddJava(s,CFG,argc,argv,TRUE);
}

void AddJavaApp(GSM_StateMachine *s, GSM_GPlusConfig *CFG, int argc, char *argv[])
{
	AddJava(s,CFG,argc,argv,FALSE);
}
