/* (C) 2003 - 2007 by Marcin Wiacek www.mwiacek.com */

#ifndef gsm_pbk_h
#define gsm_pbk_h

#ifdef WIN32
#  include <windows.h>
#endif

#include "gsmmisc.h"
#include "../misc/misc.h"

typedef enum {
	PBK_Not_Assigned = 1,

	PBK_Text_Phone_General,
	PBK_Text_Phone_Mobile,
	PBK_Text_Phone_Home,
	PBK_Text_Phone_Work,
	PBK_Text_Phone_Fax,
	PBK_Text_Postal,
	PBK_Text_Postal_Street,
	PBK_Text_Postal_City,
	PBK_Text_Postal_State,
	PBK_Text_Postal_ZIP_Code,
	PBK_Text_Postal_Country,
	PBK_Text_Email,
	PBK_Text_URL,
	PBK_Text_UserID,
	PBK_Text_Note,
	PBK_Text_Name,
	PBK_Text_Name_Last,
	PBK_Text_Name_First,
	PBK_Text_PTT,
	PBK_DateTime_Call_Length,

	//not supported yet
	PBK_ID_SMSList,
	PBK_ID_Picture,
	PBK_ID_VoiceTag,
	PBK_ID_RingtoneFile,
	PBK_ID_Ringtone,
	PBK_ID_SpeedDial
} GSM_PBK_SubEntryType;

class GSM_PBKSubEntry
{
	friend class GSM_PBKEntry;
public:
	GSM_PBKSubEntry();
	~GSM_PBKSubEntry();

	GSM_Error		SetError;

	GSM_PBK_SubEntryType 	GetType();
	GSM_Error 		SetToText(GSM_PBK_SubEntryType Typ, wchar_t *Txt);
	wchar_t			*GetText();
	GSM_Error 		SetToDateTime(GSM_PBK_SubEntryType Typ, GSM_DateTime DT2);
	GSM_DateTime		*GetDateTime();
	long			Length;

	GSM_PBKSubEntry		*GetNext();
private:
	void 			SetNext(GSM_PBKSubEntry *Nxt);

	GSM_DateTime		DT;
	GSM_PBKSubEntry		*Next;
	wchar_t			*Text;
	GSM_PBK_SubEntryType	Type;
};

class GSM_PBKEntry
{
public:
	GSM_PBKEntry();
	~GSM_PBKEntry();

	int 			Location;
	GSM_MemoryType		Memory;

	void 			ClearAll();	
	BOOLEAN 		GetNext(GSM_PBKSubEntry **En);
	GSM_Error	 	AddText(GSM_PBK_SubEntryType Typ, wchar_t *Txt);
	GSM_Error	 	AddDateTime(GSM_PBK_SubEntryType Typ, GSM_DateTime DT2);
private:
	GSM_PBKSubEntry		*Entries;
};

typedef struct {
	int 			Used;
	int 			Free;
	GSM_MemoryType		Memory;
} GSM_PBKStatus;

#endif
