/* (C) 2003 - 2007 by Marcin Wiacek www.mwiacek.com */

#ifdef WIN32
#  include <windows.h>
#endif

#include "../../misc/files.h"
#include "../sms/gsmsms.h"
#include "../../misc/misc.h"
#include "../gsmmisc.h"
#include "../gsmpbk.h"
#include "../gsmcal.h"
#include "../gsmdata.h"

#ifndef gsm_back_h
#define gsm_back_h

typedef struct {
	BOOLEAN PhonePBK;
	BOOLEAN PhonePBKPointers;
	BOOLEAN SIMPBK;
	BOOLEAN Calendar;
	BOOLEAN Notes;
	BOOLEAN ToDo;
} GSM_Backup_FileFormatFunctions;

typedef enum {
	Backup_Gammu = 1
} GSM_Backup_FileFormatNum;

class GSM_Backup_PBKEntry {
        friend class GSM_Backup;
public:
        GSM_Backup_PBKEntry();
        ~GSM_Backup_PBKEntry();

        GSM_Backup_PBKEntry     *GetNext();
        GSM_PBKEntry            *GetEntry();
private:
        void                    SetNext(GSM_Backup_PBKEntry *Nxt);
        void                    SetEntry(GSM_PBKEntry *En);

        GSM_Backup_PBKEntry     *Next;
        GSM_PBKEntry            *Entry;
};

class GSM_Backup_CalEntry {
        friend class GSM_Backup;
public:
        GSM_Backup_CalEntry();
        ~GSM_Backup_CalEntry();

        GSM_Backup_CalEntry     *GetNext();
        GSM_CalendarEntry       *GetEntry();
private:
        void                    SetNext(GSM_Backup_CalEntry *Nxt);
        void                    SetEntry(GSM_CalendarEntry *En);

        GSM_Backup_CalEntry     *Next;
        GSM_CalendarEntry       *Entry;
};

class GSM_Backup_SMSEntry {
        friend class GSM_Backup;
public:
        GSM_Backup_SMSEntry();
        ~GSM_Backup_SMSEntry();

        GSM_Backup_SMSEntry     *GetNext();
        GSM_SMSList             *GetEntry();
private:
        void                    SetNext(GSM_Backup_SMSEntry *Nxt);
        void                    SetEntry(GSM_SMSList *En);

        GSM_Backup_SMSEntry     *Next;
        GSM_SMSList             *Entry;
};

class GSM_Backup_MMSEntry {
        friend class GSM_Backup;
public:
        GSM_Backup_MMSEntry();
        ~GSM_Backup_MMSEntry();

        GSM_Backup_MMSEntry     *GetNext();
	GSM_MMSFile		*GetEntry();
private:
        void                    SetNext(GSM_Backup_MMSEntry *Nxt);
        void                    SetEntry(GSM_MMSFile *En);

        GSM_Backup_MMSEntry     *Next;
        GSM_MMSFile             *Entry;
};

class GSM_Backup_JADEntry {
        friend class GSM_Backup;
public:
        GSM_Backup_JADEntry();
        ~GSM_Backup_JADEntry();

        GSM_Backup_JADEntry     *GetNext();
	GSM_File		*GetEntry();
private:
        void                    SetNext(GSM_Backup_JADEntry *Nxt);
        void                    SetEntry(GSM_File *En);

        GSM_Backup_JADEntry     *Next;
        GSM_File                *Entry;
};

class GSM_Backup_NoteEntry {
        friend class GSM_Backup;
public:
        GSM_Backup_NoteEntry();
        ~GSM_Backup_NoteEntry();

        GSM_Backup_NoteEntry    *GetNext();
	GSM_NoteEntry		*GetEntry();
private:
        void                    SetNext(GSM_Backup_NoteEntry *Nxt);
        void                    SetEntry(GSM_NoteEntry *En);

        GSM_Backup_NoteEntry    *Next;
        GSM_NoteEntry           *Entry;
};

class GSM_Backup_ToDoEntry {
        friend class GSM_Backup;
public:
        GSM_Backup_ToDoEntry();
        ~GSM_Backup_ToDoEntry();

        GSM_Backup_ToDoEntry    *GetNext();
	GSM_ToDoEntry		*GetEntry();
private:
        void                    SetNext(GSM_Backup_ToDoEntry *Nxt);
        void                    SetEntry(GSM_ToDoEntry *En);

        GSM_Backup_ToDoEntry    *Next;
        GSM_ToDoEntry           *Entry;
};

/**
 * class for saving various informations in memory,
 * reading and saving them in files
 */
class GSM_Backup {
public:
        char                    DeviceIMEI[100];
        char                    DeviceModel[100];
        char                    FileCreator[80];
        GSM_DateTime            FileDateTime;
        BOOLEAN                 FileDateTimeAvailable;
        char                    FileMD5Original[100];
        char                    FileMD5Calculated[100];

        GSM_Backup();
        ~GSM_Backup();

	void			GetFileFunctions(GSM_Backup_FileFormatNum Num, GSM_Backup_FileFormatFunctions *Func);
        GSM_Error               ReadFromFile(char *FileName);
	GSM_Error 		SaveToFile(char *FileName);
        BOOLEAN                 GetNext_JAD(GSM_Backup_JADEntry **En);
        BOOLEAN                 GetNext_MMS(GSM_Backup_MMSEntry **En);
        BOOLEAN                 GetNext_SMS(GSM_Backup_SMSEntry **En);
        BOOLEAN                 GetNext_PBK(GSM_Backup_PBKEntry **En);
        BOOLEAN                 GetNext_Cal(GSM_Backup_CalEntry **En);
        BOOLEAN                 GetNext_Note(GSM_Backup_NoteEntry **En);
        BOOLEAN                 GetNext_ToDo(GSM_Backup_ToDoEntry **En);
        void                    Add_PBK(GSM_PBKEntry *En);
        void                    Add_Cal(GSM_CalendarEntry *En);
        void                    Add_SMS(GSM_SMSList *En);
        void                    Add_MMS(GSM_MMSFile *En);
        void                    Add_JAD(GSM_File *En);
        void                    Add_Note(GSM_NoteEntry *En);
        void                    Add_ToDo(GSM_ToDoEntry *En);
        void                    LinkSMS();
        void                    SortSMSByFolderDT();
        void                    Delete_PBK();
        void                    Delete_SMS();
        void                    Delete_Calendar();
        void                    Delete_MMS();
        void                    Delete_JAD();
        void                    Delete_Notes();
        void                    Delete_ToDo();
private:
        GSM_Backup_PBKEntry     *PBK;
        GSM_Backup_CalEntry     *Cal;
        GSM_Backup_SMSEntry     *SMS;
        GSM_Backup_JADEntry     *JAD;
        GSM_Backup_MMSEntry     *MMS;
	GSM_Backup_NoteEntry    *Notes;
	GSM_Backup_ToDoEntry    *ToDo;

        GSM_Error               ReadFromTextFile(char *FileName);
	GSM_Error 		ReadPbkFromTextFile(INI_File *File);
	GSM_Error 		ReadCalendarFromTextFile(INI_File *File);
	GSM_Error 		ReadNoteFromTextFile(INI_File *File);
	GSM_Error 		ReadToDoFromTextFile(INI_File *File);

	GSM_Error 		SaveToTextFile(char *FileName);
	GSM_Error 		SaveCalendarToTextFile(FILE *file);
	GSM_Error 		SavePbkToTextFile(FILE *file);
	GSM_Error 		SaveNoteToTextFile(FILE *file);
	GSM_Error 		SaveToDoToTextFile(FILE *file);
	void 			SaveTextFilePart(wchar_t *Text, FILE *file, BOOLEAN LineEnd);
	void 			ReadTextFilePart(wchar_t *Src, wchart *Dest);
	GSM_Error 		FindTextFileChecksum(INI_File *File, char *checksum);

        void                    Add_SMS0(GSM_Backup_SMSEntry **Start, GSM_SMSList *En);
};

#endif
