/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../../cfg/config.h" //msvc2005
#include "../service/gsmmisc.h"
#include "../phone/gsmphone.h"
#include "gsmprot.h"

GSM_Protocol_Info::GSM_Protocol_Info(char *Dev, char *Prot, bool UseDevName, bool Need)
{
        Device          	= Dev;
        Protocol        	= Prot;
	CanUseDeviceName 	= UseDevName;
	NeedPort		= Need;
}

/* ------------------------------------------------------------------------- */

GSM_Error GSM_Protocol::CheckReadByte(unsigned char Current, unsigned char Expected, int NewState)
{
	if (Current != Expected) {
		State = MSG_Sync;
	} else {
		State = NewState;
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Protocol::Write(unsigned char *buffer, int length, unsigned char type)
{
	MsgSent.Buffer.clear();
	MsgSent.Length = length;
	MsgSent.Type   = type;
	MsgSent.Buffer.append((const unsigned char *)buffer,length);

	(*Debug)->Deb("SENDING frame type 0x%02X/length %i\n",type, length);
        (*Debug)->DumpDeb(buffer,length);
        return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Protocol::GSM_Protocol(GSM_Device **Dev, DebugInfo **Deb)
{
        Next            = NULL;
        Device          = Dev;
        Debug           = Deb;
	State		= MSG_Sync;
	Opened		= false;
}

GSM_Protocol::~GSM_Protocol()
{
}

/* ------------------------------------------------------------------------- */

GSM_Protocol_Message::GSM_Protocol_Message()
{
        Length = 0;
        Type   = 0;
}

GSM_Protocol_Message::~GSM_Protocol_Message()
{
}

/* ------------------------------------------------------------------------- */

GSM_AllProtocols::GSM_AllProtocols(DebugInfo **Deb)
{
        Current         = NULL;
        AllProtocols    = NULL;
        Debug           = Deb;
}

GSM_AllProtocols::~GSM_AllProtocols()
{
        GSM_Protocol *pro,*pro2;

        pro=AllProtocols;
        while(1) {
                if (pro == NULL) break;
                pro2 = pro->Next;
                delete(pro);
                pro = pro2;
        }
}

void GSM_AllProtocols::Add(GSM_Protocol *Protocol)
{
        GSM_Protocol *Pro;

        if (AllProtocols == NULL) {
                AllProtocols = Protocol;
        } else {
                Pro = AllProtocols;
                while (Pro->Next != NULL) Pro = Pro->Next;
                Pro->Next = Protocol;
        }
}

GSM_Error GSM_AllProtocols::Switch(char *Pro, GSM_AllPhones *Pho)
{
        GSM_Protocol            *Prot = NULL;
        GSM_Error               error;

	(*Debug)->Deb("[STATE     : switching to protocol]\n");

        error = Find(Pro, &Prot, Pho);
        if (error.Code != GSM_ERR_NONE) return error;

        if (Current != NULL) {
                //disable old protocol
        }
        Current = Prot;
	strcpy(CurrentName,Pro);
        return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_AllProtocols::Find(char *Pro, GSM_Protocol **Prot, GSM_AllPhones *Pho)
{
        GSM_Phone               		*pho;
	list<GSM_Phone_Info>::iterator 		phoinfo;
	list<GSM_Protocol_Info>::iterator 	proinfo;

        /* Do we have protocol anywhere in protocol list ? */
        *Prot = AllProtocols;
        while(1) {
		for (proinfo=(*Prot)->Info.begin(); proinfo!=(*Prot)->Info.end(); ++proinfo) {
                        if (!strcmp(Pro,(*proinfo).Protocol)) {
                                return GSM_Return_Error(GSM_ERR_NONE);
                        }
	        }
                if ((*Prot)->Next == NULL) break;
                (*Prot) = (*Prot)->Next;
        }

        /* Do we have anywhere protocol in phones modules info. If yes,
         * protocol driver not compiled */
        pho = NULL;
        while(1) {
                if (Pho->GetNext(&pho)) break;
		for (phoinfo=pho->Info.begin(); phoinfo!=pho->Info.end(); ++phoinfo) {
                        if (strstr((*phoinfo).Protocol,Pro)) return GSM_Return_Error(GSM_ERR_SOURCE_NOT_COMPILED);
	        }
        }

        /* Not found anywhere */
        return GSM_Return_Error(GSM_ERR_PROTOCOL_STRING_UNKNOWN);
}

int GSM_AllProtocols::GetNext(GSM_Protocol **Pro)
{
        if ((*Pro) == NULL) {
                (*Pro) = AllProtocols;
        } else {
                if ((*Pro)->Next == NULL) return 0;
                (*Pro) = ((*Pro)->Next);
        }
        return 1;
}
