/* (C) 2003 - 2007 by Marcin Wiacek www.mwiacek.com */

#include <stdio.h>
#include <wctype.h>
#include <string.h>
#include <sys/stat.h>
#include <stdlib.h>
#ifdef WIN32
#  include <sys/types.h>
#  ifndef BORLANDC
#    include <sys/utime.h>
#  endif
#else
#  include <netdb.h>
#  include <netinet/in.h>
#  include <utime.h>
#endif

#include "../../cfg/config.h" //msvc2005
#include "files.h"
#include "coding/coding.h"

INI_File_Entry::INI_File_Entry(wchart Name2, wchart Value2, long Pos2, int Len2)
{
	Next = NULL;
	Pos = Pos2;
	Len = Len2;
	Name.append(Name2.data(),Name2.length());
	Value.append(Value2.data(),Value2.length());
}

INI_File_Entry::~INI_File_Entry()
{
	delete(Next);
}

void INI_File_Entry::SetNext(INI_File_Entry *Nxt)
{
	Next = Nxt;
}

INI_File_Entry *INI_File_Entry::GetNext()
{
	return Next;
}

/* ------------------------------------------------------------------------- */

INI_File_Section::INI_File_Section(wchart Name2, long Pos2, int Len2)
{
	Next 	= NULL;
	Entries = NULL;
	Pos = Pos2;
	Len = Len2;
	Name.append(Name2.data(),Name2.length());
}

INI_File_Section::~INI_File_Section()
{
	delete(Entries);
	delete(Next);
}

void INI_File_Section::AddEntry(wchart Name2, wchart Value2,long Pos2,int Len2)
{
	INI_File_Entry *Entry,*Entry2;

	Entry = new INI_File_Entry(Name2,Value2,Pos2,Len2);

	if (Entries == NULL) {
		Entries = Entry;
	} else {
		Entry2 = Entries;
		while (Entry2->GetNext()!=NULL) Entry2 = Entry2->GetNext();
		Entry2->SetNext(Entry);
	}
}

BOOLEAN INI_File_Section::GetNextEntry(INI_File_Entry **Entry)
{
	if ((*Entry) == NULL) {
		(*Entry) = Entries;
	} else {
		(*Entry) = (*Entry)->GetNext();
	}
	if ((*Entry) == NULL) return FALSE;
	return TRUE;
}

void INI_File_Section::SetNext(INI_File_Section *Nxt)
{
	Next = Nxt;
}

INI_File_Section *INI_File_Section::GetNext()
{
	return Next;
}

/* ------------------------------------------------------------------------- */

INI_File::INI_File()
{
	Sections = NULL;
	Unicode  = 0;
}

INI_File::~INI_File()
{
	delete(Sections);
}

BOOLEAN INI_File::Decode()
{
	long		Start, Pos = 2, pos, pos2;
	wchart		Line,Line2,Line3;
	BOOLEAN		InsideSection = FALSE;
	wchar_t		widechar;

	Unicode = 0;
	if (Buffer.size()>1) {
		if (Buffer.data()[0] == 0xFE && Buffer.data()[1] == 0xFF) Unicode = 1;
		if (Buffer.data()[0] == 0xFF && Buffer.data()[1] == 0xFE) Unicode = 2;
	}
	if (Unicode == 0) Pos = 0;

	while (true) {
		//reading non empty line
		Line.clear();
		while (true) {
			if (Pos == Buffer.size()) {
				if (Line.size()==0) return TRUE;
				break;
			}
			if (Unicode == 0) {
				mbtowc(&widechar, (const char *)Buffer.data()+Pos, MB_CUR_MAX);
			} else {
				if (Buffer.size()-Pos < 2) return FALSE;
				if (Unicode == 1) widechar = 256*Buffer.data()[Pos] + Buffer.data()[Pos+1];
				if (Unicode == 2) widechar = 256*Buffer.data()[Pos+1] + Buffer.data()[Pos];
			}
			if (widechar == 13 || widechar == 10) {
				if (Line.size()!=0) {
					break;
				}
			} else {
				if (Line.size()==0) Start = Pos;
				Line.push_back(widechar);
			}
			Pos++;
			if (Unicode > 0) Pos++;
		}
		if (InsideSection) {
			/* Line with [ and ] means new section */
			if (Line.data()[0] == '[' && strstr(UnicodeToStringReturn(Line.data()),"]") != NULL) {
				InsideSection = false;
			}
		}
		if (InsideSection) {
			/* we ignore line with comment */
			if (Line.data()[0] == ';' || Line.data()[0] == '#') {
				continue;
			}
			/* do we have = ? If yes, it's section value */
			if (strstr(UnicodeToStringReturn(Line.data()),"=") == NULL) {
				continue;
			}
			/* Find = and separate parts before and after */
			pos = 0;
			while(Line[pos] != '=') pos++;
			pos2=pos;
			pos--;
			/* Remove white spaces */
			while(iswspace(Line[pos])) pos--;
			Line2.clear();
			Line2.append(Line.data(),pos+1);

			pos2++;
			/* Remove white spaces */
			while(iswspace(Line[pos2])) pos2++;
			Line3.clear();
			Line3.append(Line.data()+pos2,Line.size()-pos2);

//printf("entry %s",UnicodeToStringReturn(Line2.data()));
//printf(" %s\n",UnicodeToStringReturn(Line3.data()));

			/* Add as section value */
			GetLastSection()->AddEntry(Line2.data(),Line3.data(),Start,Pos-Start);
		}
		/* we need line with [ and ] */
		if (Line.data()[0] != '[' || strstr(UnicodeToStringReturn(Line.data()),"]") == NULL) {
			continue;
		}
		/* we ignore line with comment */
		if (Line.data()[0] == ';' || Line.data()[0] == '#') {
			continue;
		}
		/* yes we have [ ] and it's section name */
		Line2.clear();
		Line2.append(Line.data()+1,Line.size()-2);
		AddSection(Line2,Start,Pos-Start);
//printf("section %s\n",UnicodeToStringReturn(Line2.data()));
		InsideSection = true;
	}
	return TRUE;
}

BOOLEAN INI_File::ReadFile(char *FileName)
{                                          	
	if (!ReadFromDisk(StringToUnicodeReturn(FileName))) return FALSE;

	return Decode();
}

BOOLEAN INI_File::GetNextSection(INI_File_Section **Section)
{
	if ((*Section) == NULL) {
		(*Section) = Sections;
	} else {
		(*Section) = (*Section)->GetNext();
	}
	if ((*Section) == NULL) return FALSE;
	return TRUE;
}

void INI_File::AddSection(wchart Name2, long Pos2,int Len2)
{
	INI_File_Section *Section,*Section2;

	Section = new INI_File_Section(Name2,Pos2,Len2);

	if (Sections == NULL) {
		Sections = Section;
	} else {
		Section2 = Sections;
		while (Section2->GetNext()!=NULL) Section2 = Section2->GetNext();
		Section2->SetNext(Section);
	}
}

INI_File_Section *INI_File::GetLastSection()
{
	INI_File_Section *Section;

	if (Sections == NULL) {
		return NULL;
	} else {
		Section = Sections;
		while (Section->GetNext()!=NULL) Section = Section->GetNext();
		return Section;
	}
}

wchar_t *INI_File::GetValue(wchar_t *Sec, wchar_t *Nam)
{
	INI_File_Section 	*Section;
	INI_File_Entry 		*Entry;

	Section = NULL;
	while (GetNextSection(&Section)==TRUE) {
		if (!UnicodeCaseCmp(Sec,Section->Name.data(),-1)) continue;
		Entry = NULL;
		while (Section->GetNextEntry(&Entry)==TRUE) {
			if (UnicodeCaseCmp(Nam,Entry->Name.data(),-1)) return (wchar_t *)Entry->Value.data();
		}
	}
	return 0x00;
}

void INI_File::SetValue(wchar_t *Sec, wchar_t *Nam, wchar_t *Val)
{
	INI_File_Section 	*Section;
	INI_File_Entry 		*Entry;
	BOOLEAN			SectionFound = FALSE;
	unsignedstring		Buffer2;
	char			Buff[200];

	Section = NULL;
	while (GetNextSection(&Section)==TRUE) {
		if (!UnicodeCaseCmp(Sec,Section->Name.data(),-1)) continue;
		Entry = NULL;
		while (Section->GetNextEntry(&Entry)==TRUE) {
			if (UnicodeCaseCmp(Nam,Entry->Name.data(),-1)) {
				//update existing entry
				Buffer2.append(Buffer.data(),Buffer.size());
				Buffer.clear();
				Buffer.append(Buffer2.data(),Entry->Pos);
				if (Unicode == 0) {
					sprintf(Buff,"%s = ",UnicodeToStringReturn(Nam));
					sprintf(Buff+strlen((char *)Buff),"%s",UnicodeToStringReturn(Val));
					Buffer.append((unsigned char *)Buff,strlen(Buff));
				}
				Buffer.append(Buffer2.data()+Entry->Pos+Entry->Len,Buffer2.size()-Entry->Pos-Entry->Len);
				delete(Sections);
				Sections = NULL;
				Decode();
				return;
			}
		}
		//add into section
		Buffer2.append(Buffer.data(),Buffer.size());
		Buffer.clear();
		Buffer.append(Buffer2.data(),Section->Pos+Section->Len);
		if (Unicode == 0) {
			sprintf(Buff,"\n%s = ",UnicodeToStringReturn(Nam));
			Buffer.append((unsigned char *)Buff,strlen(Buff));
			sprintf(Buff,"%s",UnicodeToStringReturn(Val));
			Buffer.append((unsigned char *)Buff,strlen(Buff));
		}
		Buffer.append(Buffer2.data()+Section->Pos+Section->Len,Buffer2.size()-Section->Pos-Section->Len);
		delete(Sections);
		Sections = NULL;
		Decode();
		return;
	}
	//add new section
	if (Unicode == 0) {
		sprintf(Buff,"\n[%s]\n",UnicodeToStringReturn(Sec));
		Buffer.append((unsigned char *)Buff,strlen(Buff));
		sprintf(Buff,"%s = ",UnicodeToStringReturn(Nam));
		Buffer.append((unsigned char *)Buff,strlen(Buff));
		sprintf(Buff,"%s",UnicodeToStringReturn(Val));
		Buffer.append((unsigned char *)Buff,strlen(Buff));
	}
	delete(Sections);
	Sections = NULL;
	Decode();
}

//-----------------------------------------------------------------------------

FileFolderInfo::FileFolderInfo()
{
}

FileFolderInfo::~FileFolderInfo()
{
}

void FileFolderInfo::SetID(wchar_t *Txt)
{
	ID.clear();
	ID.append(Txt,UnicodeLength(Txt));
}

void FileFolderInfo::SetName(wchar_t *Txt)
{
	Name.clear();
	Name.append(Txt,UnicodeLength(Txt));
}

//-----------------------------------------------------------------------------

Gen_File::Gen_File()
{
}

Gen_File::~Gen_File()
{
}

BOOLEAN Gen_File::ReadFromDisk(wchar_t *FileName)
{
	int 		i = 1000;
	FILE		*file;
	unsigned char	buffer[1000];
	GSM_DateTime	dt;
	struct stat     fileinfo;

	if (FileName[0] == 0x00) return FALSE;
	file = fopen(UnicodeToStringReturn(FileName),"rb");
	if (file == NULL) return FALSE;

	Info.ID.append(FileName,UnicodeLength(FileName));

	Buffer.clear();
	while (i == 1000) {
		i = fread(buffer,1,1000,file);
		Buffer.append((const unsigned char *)buffer,i);		
	}

	fclose(file);
 	Info.Size = Buffer.size();

	Info.ModificationDateTimeAvailable=FALSE;
	if (stat(UnicodeToStringReturn(FileName),&fileinfo) == 0) {
		Info.ModificationDateTimeAvailable=TRUE;
		dt = TimeT2GSMDateTime(&fileinfo.st_mtime);
		memcpy(&Info.ModificationDateTime,&dt,sizeof(GSM_DateTime));
	}
	return TRUE;
}

BOOLEAN Gen_File::SaveToDisk(char *FileName)
{
	FILE		*file;
#ifndef BORLANDC
	struct utimbuf	filedate;
#endif

	if (FileName[0] == 0x00) return FALSE;
	file = fopen(FileName,"wb");
	if (file == NULL) return FALSE;
	fwrite(Buffer.data(),1,Buffer.size(),file);
	fclose(file);
#ifndef BORLANDC
	if (Info.ModificationDateTimeAvailable) {
		/* access time */
		filedate.actime  = GSMDateTime2TimeT(&Info.ModificationDateTime);
		/* modification time */
		filedate.modtime = GSMDateTime2TimeT(&Info.ModificationDateTime);
		utime(FileName,&filedate);
	}
#endif
	return TRUE;
}

BOOLEAN Gen_File::ReadFromHTTPGet(char *server, char *filename)
{
	int			s, len;
	struct sockaddr_in 	address;
	struct hostent 		*address2;
	char 			buff[2000];
#ifdef WIN32
	WSADATA			wsaData;

	if (WSAStartup(MAKEWORD(1, 1), &wsaData) != 0) return FALSE;
#endif

	s = socket(AF_INET,SOCK_STREAM,0);
#ifdef WIN32
	if (s==INVALID_SOCKET) return FALSE;
#else
	if (s==-1) return FALSE;
#endif

	address2 = gethostbyname(server);
	if (address2 == NULL) return FALSE;

	memset((char *) &address, 0, sizeof(address));
	address.sin_family 	= AF_INET;
	address.sin_port 	= htons(80);
	address.sin_addr.s_addr = *(u_long *) *(address2->h_addr_list);

	if (connect(s,(struct sockaddr *)&address,sizeof(address))<0) {
		return FALSE;
	}

	sprintf(buff,"GET http://%s/%s HTTP/1.0\n\n",server,filename);
	if (send(s,buff,strlen(buff),0)<0) return FALSE;

	Buffer.clear();

#ifdef WIN32
	while ((len=recv(s,buff,200,0))>0) {
#else
	while ((len=read(s,buff,200))>0) {
#endif
		Buffer.append((const unsigned char *)buff,len);
	}
#ifdef WIN32
	closesocket(s);
#else
	close(s);
#endif

	if (Buffer.size()==0) return TRUE;
	if (strstr((const char *)Buffer.data(),"HTTP/1.0 200 OK")==NULL &&
	    strstr((const char *)Buffer.data(),"HTTP/1.1 200 OK")==NULL) {
		Buffer.clear();
		return FALSE;
	}

 	Info.Size = Buffer.size();

	return TRUE;
}

BOOLEAN Gen_File::ReadFromHTTPPost(char *server, char *filename, char *content)
{
	int			s, len;
	struct sockaddr_in 	address;
	struct hostent 		*address2;
	char 			buff[20000];
#ifdef WIN32
	WSADATA			wsaData;

	if (WSAStartup(MAKEWORD(1, 1), &wsaData) != 0) return FALSE;
#endif

	s = socket(AF_INET,SOCK_STREAM,0);
#ifdef WIN32
	if (s==INVALID_SOCKET) return FALSE;
#else
	if (s==-1) return FALSE;
#endif

	address2 = gethostbyname(server);
	if (address2 == NULL) return FALSE;

	memset((char *) &address, 0, sizeof(address));
	address.sin_family 	= AF_INET;
	address.sin_port 	= htons(80);
	address.sin_addr.s_addr = *(u_long *) *(address2->h_addr_list);

	if (connect(s,(struct sockaddr *)&address,sizeof(address))<0) {
		return FALSE;
	}

	sprintf(buff,"POST http://%s%s HTTP/1.0\n",server,filename);
	sprintf(buff+strlen(buff),"User-Agent: Mozilla/4.0\n");
	sprintf(buff+strlen(buff),"Host: %s\n",server);
	sprintf(buff+strlen(buff),"Content-Length: %i\n",strlen(content));
	sprintf(buff+strlen(buff),"Content-Type: application/x-www-form-urlencoded\n\n");
	sprintf(buff+strlen(buff),"%s",content);

	if (send(s,buff,strlen(buff),0)<0) return FALSE;

	Buffer.clear();

#ifdef WIN32
	while ((len=recv(s,buff,200,0))>0) {
#else
	while ((len=read(s,buff,200))>0) {
#endif
		Buffer.append((const unsigned char *)buff,len);
	}
#ifdef WIN32
	closesocket(s);
#else
	close(s);
#endif

	if (Buffer.size()==0) return TRUE;
	if (strstr((const char *)Buffer.data(),"HTTP/1.0 200 OK")==NULL &&
	    strstr((const char *)Buffer.data(),"HTTP/1.1 200 OK")==NULL) {
		Buffer.clear();
		return FALSE;
	}

 	Info.Size = Buffer.size();

	return TRUE;
}
