/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#include <windows.h>
#include <string.h>
#include <stdio.h>
#include <io.h>
#include <memory.h>

#ifndef BORLANDC
#  define INITGUID
#  include <initguid.h>
#  include <Setupapi.h>
#  pragma comment(lib, "setupapi.lib")
  DEFINE_GUID(DKU2AT,    0x4F919104, 0x4adf, 0x11d5, 0x88, 0x2d, 0x0, 0xb0, 0xd0, 0x2f, 0xe3, 0x81);
  DEFINE_GUID(DKU2FBUS2, 0x4F919102, 0x4adf, 0x11d5, 0x88, 0x2d, 0x0, 0xb0, 0xd0, 0x2f, 0xe3, 0x81);
  DEFINE_GUID(DKU2OBEX,  0x4F919100, 0x4adf, 0x11d5, 0x88, 0x2d, 0x0, 0xb0, 0xd0, 0x2f, 0xe3, 0x81);
#endif

#include "../../../cfg/config.h" //msvc2005
#include "../../misc/coding/coding.h"
#include "ser_w32.h"

GSM_Error GSM_Device_Serial::Open(char *Dev, char *Prot, char *Pho, char **DeviceModel, GSM_AllPhones *Phones)
{
#ifndef BORLANDC
	UCHAR				 bu[sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA) +(sizeof(TCHAR)*1000)];
	DWORD				 reqsize;
	SP_DEVINFO_DATA		 	 DeviceInfoData;
	SP_DEVICE_INTERFACE_DATA         DeviceInterfaceData;
	PSP_DEVICE_INTERFACE_DETAIL_DATA DeviceInterfaceDetailData = (PSP_DEVICE_INTERFACE_DETAIL_DATA)bu;
	HDEVINFO			 ListHandle;
	unsigned char			 KeyName2[256];
	char				 DeviceName2[200],DeviceName3[200];

        (*Debug)->Deb("[STATE     : opening device serial]\n");

	strcpy(ProtocolName,Prot);
	strcpy(DeviceName2,Dev);

	if (!strcmp(ProtocolName,"dku2phonet") || !strcmp(ProtocolName,"dku2")) {
	        ListHandle = SetupDiGetClassDevs(&DKU2FBUS2, NULL, NULL,  DIGCF_PRESENT | DIGCF_DEVICEINTERFACE);
		if (ListHandle == INVALID_HANDLE_VALUE) {
		        SetupDiDestroyDeviceInfoList(ListHandle);
			return GSM_Return_Error(GSM_ERR_UNKNOWN);
		}
		DeviceInfoData.cbSize = sizeof(DeviceInfoData);
		DeviceInterfaceData.cbSize = sizeof(DeviceInterfaceData);
            	if (SetupDiEnumDeviceInfo(ListHandle, 0, &DeviceInfoData)) {
					SetupDiGetDeviceRegistryProperty(ListHandle, &DeviceInfoData, SPDRP_DEVICEDESC, NULL, KeyName2, 200, &reqsize);
                	if (SetupDiEnumDeviceInterfaces(ListHandle, &DeviceInfoData, &DKU2FBUS2, 0, &DeviceInterfaceData)) {
				DeviceInterfaceDetailData->cbSize = 5;
                    		if (SetupDiGetDeviceInterfaceDetail(ListHandle, &DeviceInterfaceData, DeviceInterfaceDetailData, 200, &reqsize, &DeviceInfoData)) {
					strcpy(DeviceName2,DeviceInterfaceDetailData->DevicePath);
				}
			}
		}
	        SetupDiDestroyDeviceInfoList(ListHandle);
	}

	if (StringCaseCmp(DeviceName2,"com",3) && strlen(DeviceName2)>3) {
		sprintf(DeviceName3,"\\\\.\\COM%i",atoi(DeviceName2+3));
	} else {
		sprintf(DeviceName3,"%s",DeviceName2);
	}

	Device = CreateFile(DeviceName3,GENERIC_READ | GENERIC_WRITE,
                     	    0,NULL,OPEN_EXISTING,0,NULL);
	if (Device == INVALID_HANDLE_VALUE) {
		(*Debug)->Error("CreateFile");
		return GSM_Return_Error(GSM_ERR_DEVICE_OPEN);
	}

	if (strcmp(ProtocolName,"dku2phonet") && strcmp(Prot,"dku2")) {
	        BackupDCB.DCBlength = sizeof(DCB);
		if (!GetCommState(Device, &BackupDCB)) {
			(*Debug)->Error("GetCommState");
			return GSM_Return_Error(GSM_ERR_DEVICE_OPEN);
		}
		memcpy(&CurrentDCB,&BackupDCB,sizeof(DCB));

		if (!SetCommMask(Device, EV_RXCHAR)) {
			(*Debug)->Error("SetCommMask");
			return GSM_Return_Error(GSM_ERR_DEVICE_OPEN);
		}

		if (!SetupComm(Device,5000,5000)) {
			(*Debug)->Error("SetupComm");
			return GSM_Return_Error(GSM_ERR_DEVICE_OPEN);
		}
	}
#endif
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Device_Serial::Close()
{
		return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Device_Serial::Read(unsigned char *buf, int *len)
{
	COMSTAT		Status;
	DWORD		ErrorCode;

	if (strcmp(ProtocolName,"dku2phonet") && strcmp(ProtocolName,"dku2")) {
		if (ClearCommError(Device, &ErrorCode, &Status)==0) {
			(*Debug)->Error("ClearCommError");
		        return GSM_Return_Error(GSM_ERR_DEVICE_READ);
		}
		*len = Status.cbInQue;

		if (*len <= 0) return GSM_Return_Error(GSM_ERR_NONE);
	} else {
		*len = 5;
	}

	if (!ReadFile(Device, buf, *len, (LPDWORD)len, NULL)) {
		(*Debug)->Error("ReadFile");
	        return GSM_Return_Error(GSM_ERR_DEVICE_READ);
	}
        return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Device_Serial::Write(const unsigned char *buf, int len)
{
	int 	SentAll = 0;
	DWORD 	Sent;
	
	while(1) {
		if (!WriteFile(Device,buf+SentAll,len-SentAll,&Sent,NULL)) {
			(*Debug)->Error("WriteFile");
		        return GSM_Return_Error(GSM_ERR_DEVICE_READ);
		}
		SentAll += Sent;
		if (SentAll = len) return GSM_Return_Error(GSM_ERR_NONE);
	}
        return GSM_Return_Error(GSM_ERR_UNKNOWN);
}

GSM_Error GSM_Device_Serial::SetParameters(int speed, int bits, bool parity, int stopbits)
{
	if (strcmp(ProtocolName,"dku2phonet") && strcmp(ProtocolName,"dku2")) {
		CurrentDCB.BaudRate 	  = CBR_115200;//speed;
		CurrentDCB.ByteSize 	  = bits;
		if (parity) {
			CurrentDCB.Parity = ODDPARITY;
		} else {
			CurrentDCB.Parity = NOPARITY; 
		}
		CurrentDCB.StopBits 	  = ONESTOPBIT; //fixme

		/* No Xon/Xof flow control */
		CurrentDCB.fOutX 	  = false;
		CurrentDCB.fInX 	  = false;

		/* No hardware flow control */
		CurrentDCB.fOutxDsrFlow = 0;
		CurrentDCB.fOutxCtsFlow = 0;

		if (!SetCommState(Device, &CurrentDCB)) {
			(*Debug)->Error("SetCommState");
		        return GSM_Return_Error(GSM_ERR_DEVICE_READ); //aaa
		}
	}

        return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Device_Serial::SetLines(bool dtr, bool rts)
{
	if (strcmp(ProtocolName,"dku2phonet") && strcmp(ProtocolName,"dku2")) {
		CurrentDCB.fDtrControl = DTR_CONTROL_DISABLE;
		if (dtr) CurrentDCB.fDtrControl = DTR_CONTROL_ENABLE;

		CurrentDCB.fRtsControl  = RTS_CONTROL_DISABLE;
		if (rts) CurrentDCB.fRtsControl = RTS_CONTROL_ENABLE;
	
		if (!SetCommState(Device, &CurrentDCB)) {
			(*Debug)->Error("SetCommState");
		        return GSM_Return_Error(GSM_ERR_DEVICE_READ); //aaa
		}
	}

        return GSM_Return_Error(GSM_ERR_NONE);
}
