//---------------------------------------------------------------------------
//
// Name:        PhoneFrm.cpp
// Author:      Marcinello
// Created:     2007-01-25 19:28:56
// Description: PhoneFrm class implementation
//
//---------------------------------------------------------------------------

#include <wx/progdlg.h>

#include "../cfg/config.h"
#include "../common/service/gsmdata.h"
#include "../common/service/gsmmisc.h"
#include "../common/service/backup/gsmback.h"
#include "../common/gsmstate.h"

#include "PhoneFrm.h"
#include "BackupDlg.h"
#include "CfgDlg.h"
#include "SMSEditorDlg.h"
#include "LogDlg.h"
#include "shared.h"

//Do not add custom headers between
//Header Include Start and Header Include End
//wxDev-C++ designer will remove them
////Header Include Start
////Header Include End

//----------------------------------------------------------------------------
// PhoneFrm
//----------------------------------------------------------------------------
//Add Custom Events only in the appropriate block.
//Code added in other places will be removed by wxDev-C++
////Event Table Start
BEGIN_EVENT_TABLE(PhoneFrm,wxFrame)
	////Manual Code Start
	////Manual Code End
	
	EVT_CLOSE(PhoneFrm::OnClose)
	EVT_MENU(ID_MNU_FORWARD_1095 , PhoneFrm::Mnuforward1095Click)
	EVT_MENU(ID_MNU_SENDNEWSMSTOSMSNUMBERS_1144 , PhoneFrm::Mnusendnewsmstosmsnumbers1144Click1)
	EVT_MENU(ID_MNU_SAVETOFILE_1104 , PhoneFrm::Mnusavetofile1104Click)
	
	EVT_LIST_ITEM_SELECTED(ID_JAVAUPWXLISTCTRL,PhoneFrm::JavaUpWxListCtrlSelected)
	EVT_BUTTON(ID_APPADDWXBUTTON,PhoneFrm::AppAddWxButtonClick)
	EVT_BUTTON(ID_GAMEADDWXBUTTON,PhoneFrm::GameAddWxButtonClick)
	EVT_BUTTON(ID_JAVAGETWXBUTTON,PhoneFrm::JavaGetWxButtonClick)
	
	EVT_LIST_ITEM_SELECTED(ID_TODOUPWXLISTCTRL,PhoneFrm::ToDoWxListCtrlSelected)
	EVT_BUTTON(ID_TODOGETWXBUTTON,PhoneFrm::ToDoGetWxButtonClick)
	
	EVT_LIST_ITEM_SELECTED(ID_NOTESWXLISTCTRL,PhoneFrm::NotesWxListCtrlSelected)
	EVT_BUTTON(ID_NOTESGETWXBUTTON,PhoneFrm::NotesGetWxButtonClick)
	
	EVT_LIST_ITEM_SELECTED(ID_CALENDARUPWXLISTCTRL2,PhoneFrm::CalendarUPWxListCtrlSelected)
	EVT_CHECKBOX(ID_CALENDARWXCHECKBOX,PhoneFrm::CalendarWxCheckBoxClick)
	
	EVT_CALENDAR_SEL_CHANGED(ID_WXCALENDARCTRL1,PhoneFrm::WxCalendarCtrl1SelChanged)
	EVT_BUTTON(ID_WXBUTTON1,PhoneFrm::WxButton1Click)
	EVT_BUTTON(ID_CALENDARSEARCHWXBUTTON,PhoneFrm::CalendarSearchWxButtonClick)
	EVT_BUTTON(ID_CALENDARGETWXBUTTON,PhoneFrm::CalendarGetWxButtonClick)
	
	EVT_MEDIA_LOADED(ID_MMSFILEWXMEDIACTRL,PhoneFrm::MMSFileWxMediaCtrlMediaLoaded)
	EVT_BUTTON(ID_MMSSAVEWXBUTTON,PhoneFrm::MMSSaveWxButtonClick)
	EVT_COMBOBOX(ID_MMFILESWXCOMBOBOX,PhoneFrm::MMFilesWxComboBoxSelected)
	
	EVT_LIST_ITEM_SELECTED(ID_MMSUPWXLISTCTRL,PhoneFrm::MMSUpWxListCtrlSelected)
	EVT_LIST_ITEM_RIGHT_CLICK(ID_MMSUPWXLISTCTRL,PhoneFrm::MMSUpWxListCtrlRightClick)
	EVT_BUTTON(ID_MMSSEARCHWXBUTTON,PhoneFrm::MMSSearchWxButtonClick)
	EVT_BUTTON(ID_MMSGETWXBUTTON,PhoneFrm::MMSGetWxButtonClick)
	EVT_COMBOBOX(ID_MMSWXCOMBOBOX,PhoneFrm::MMSWxComboBoxSelected)
	
	EVT_LIST_ITEM_SELECTED(ID_SMSUPWXLISTCTRL,PhoneFrm::SMSUpWxListCtrlSelected)
	EVT_LIST_ITEM_RIGHT_CLICK(ID_SMSUPWXLISTCTRL,PhoneFrm::SMSUpWxListCtrlRightClick)
	EVT_BUTTON(ID_SMSSEARCHWXBUTTON,PhoneFrm::SMSSearchWxButtonClick)
	EVT_BUTTON(ID_SMSSENDWXBUTTON,PhoneFrm::SMSSendWxButtonClick)
	EVT_BUTTON(ID_SMSGETWXBUTTON,PhoneFrm::SMSGetWxButtonClick)
	EVT_COMBOBOX(ID_SMSWXCOMBOBOX,PhoneFrm::SMSWxComboBoxSelected)
	
	EVT_LIST_ITEM_SELECTED(ID_PBKUPWXLISTCTRL2,PhoneFrm::PBKUpWxListCtrlSelected)
	EVT_LIST_COL_CLICK(ID_PBKUPWXLISTCTRL2,PhoneFrm::PBKUpWxListCtrlColLeftClick)
	EVT_BUTTON(ID_PBKSEARCHWXBUTTON,PhoneFrm::PbkSearchWxButtonClick)
	EVT_COMBOBOX(ID_PBKWXCOMBOBOX,PhoneFrm::PBKWxComboBoxSelected)
	EVT_BUTTON(ID_PBKGETWXBUTTON,PhoneFrm::PbkGetWxButtonClick)
	
	EVT_LIST_ITEM_ACTIVATED(ID_FILESWXLISTCTRL,PhoneFrm::FilesWxListCtrlItemActivated)
	EVT_BUTTON(ID_ADDFILEWXBUTTON,PhoneFrm::AddFileWxButtonClick)
	EVT_BUTTON(ID_FILESGETWXBUTTON,PhoneFrm::FilesGetWxButtonClick)
	EVT_BUTTON(ID_ONLINEINFOWXBUTTON,PhoneFrm::OnlineInfoWxButtonClick)
	EVT_BUTTON(ID_RESTOREWXBUTTON,PhoneFrm::RestoreWxButtonClick)
	EVT_BUTTON(ID_BACKUPWXBUTTON,PhoneFrm::BackupWxButtonClick)
	
	EVT_NOTEBOOK_PAGE_CHANGED(ID_WXNOTEBOOK1,PhoneFrm::WxNotebook1PageChanged)
END_EVENT_TABLE()
////Event Table End

void FixBuffer(wchar_t *Buffer)
{
    int i;

    for (i=0;i<UnicodeLength(Buffer);i++) {
        if (Buffer[i] == 242) Buffer[i] = ' ';
    }
}

PhoneFrm::PhoneFrm(BOOLEAN Phone2, GSM_Backup *Backup2, MainFrm *parent2, wxWindowID id, const wxString& title, const wxPoint& pos, const wxSize& size, long style, const wxString& name, GSM_StateMachine *s2, unsigned char *Man, unsigned char *Model, unsigned char *Firm)
: wxMDIChildFrame(parent2, id, title, pos, size, style, name)
{        
    long        tmp,num=0;
    char        buff[200];
    GSM_Error   error;
  
    Phone  = Phone2;
    Backup = Backup2;
    parent = parent2;
    s      = s2;
    
    ParentFolderIDNum = 1;
    FileSystemNum = 0;
    FileFolderID[0] = 0;  
    
    PBKMemoryLen = 0; 
    
    FirstSMS = true;
    FirstMMS = true;
    FirstCalendar = true;

	CreateGUIControls();
	SetTitle(title);

    if (!GetPbkMemories()) DeleteP("PhoneBook");
    if (!CheckCalendar()) DeleteP("Calendar");
    if (!CheckToDo()) DeleteP("ToDo");
    if (!CheckNotes()) DeleteP("Notes");
    if (Phone) {
        if (!EnterFolder()) DeleteP("FileSystem");
        if (!ReadSMSMMSFolders(TRUE)) DeleteP("SMS");
        if (!ReadSMSMMSFolders(FALSE)) DeleteP("MMS");
        
        tmp = InfoWxListCtrl->InsertItem(num++, "Device manufacturer", 0);
        InfoWxListCtrl->SetItem(tmp, 1, Man);

        tmp = InfoWxListCtrl->InsertItem(num++, "Device model", 0);
        InfoWxListCtrl->SetItem(tmp, 1, Model);

    	error = s->Phones->Current->GetCodeNameModel((unsigned char *)buff);
        tmp = InfoWxListCtrl->InsertItem(num++, "Device codename", 0);
        InfoWxListCtrl->SetItem(tmp, 1, buff);

        tmp = InfoWxListCtrl->InsertItem(num++, "Device firmware version", 0);
        InfoWxListCtrl->SetItem(tmp, 1, Firm);

        sprintf(Backup->Model,"%s", Man);
        sprintf(Backup->Model+strlen(Backup->Model)," %s",buff);
        sprintf(Backup->Model+strlen(Backup->Model)," (%s)",Model);
        sprintf(Backup->Model+strlen(Backup->Model)," %s",Firm);

    	error = s->Phones->Current->GetFirmwareDate((unsigned char *)buff);
        tmp = InfoWxListCtrl->InsertItem(num++, "Device firmware date", 0);
        InfoWxListCtrl->SetItem(tmp, 1, buff);

    	error = s->Phones->Current->GetProductCode((unsigned char *)buff);
        tmp = InfoWxListCtrl->InsertItem(num++, "Device Product Code", 0);
        InfoWxListCtrl->SetItem(tmp, 1, buff);

    	error = s->Phones->Current->GetIMEI((unsigned char *)Backup->IMEI);                
    } else {
        if (Backup->DateTimeAvailable) {
            tmp = InfoWxListCtrl->InsertItem(num++, "Created", 0);
            PrintDT(&Backup->DateTime, buff);
            InfoWxListCtrl->SetItem(tmp, 1, buff);
        }
        if (Backup->Model[0] != 0) {
            tmp = InfoWxListCtrl->InsertItem(num++, "Source", 0);
            InfoWxListCtrl->SetItem(tmp, 1, Backup->Model);
        }
        if (Backup->Creator[0] != 0) {
            tmp = InfoWxListCtrl->InsertItem(num++, "Creator", 0);
            InfoWxListCtrl->SetItem(tmp, 1, Backup->Creator);
        }
                		
        DeleteP("FileSystem");
        DeleteP("Java");
        DeleteP("SMS");
        DeleteP("MMS");
        
        BackupWxButton->Show(FALSE);
        RestoreWxButton->Show(FALSE);
        OnlineInfoWxButton->Show(FALSE);
//        WxPanel24->Show(FALSE);
//        WxSplitterWindow7->SetSashPosition(WxSplitterWindow7->GetHeight());
    }
    if (Backup->IMEI[0] != 0) {
        tmp = InfoWxListCtrl->InsertItem(num++, "Device IMEI", 0);
        InfoWxListCtrl->SetItem(tmp, 1, Backup->IMEI);
    }
}

PhoneFrm::~PhoneFrm()
{
    delete (Backup);
    delete (s);
}

void PhoneFrm::CreateGUIControls()
{
	//Do not add custom code between
    //GUI Items Creation Start and GUI Items Creation End
	//wxDev-C++ designer will remove them.
	//Add the custom code before or after the blocks
	////GUI Items Creation Start

	WxGridSizer1 = new wxGridSizer(1, 1, 0, 0);
	this->SetSizer(WxGridSizer1);
	this->SetAutoLayout(true);

	WxNotebook1 = new wxNotebook(this, ID_WXNOTEBOOK1, wxPoint(0,0),wxSize(589,296));
	WxGridSizer1->Add(WxNotebook1,1,wxEXPAND | wxALL,0);

	InfoWxNoteBookPage = new wxPanel(WxNotebook1, ID_INFOWXNOTEBOOKPAGE, wxPoint(4,24), wxSize(581,268));
	WxNotebook1->AddPage(InfoWxNoteBookPage, wxT("General"));

	WxBoxSizer12 = new wxBoxSizer(wxVERTICAL);
	InfoWxNoteBookPage->SetSizer(WxBoxSizer12);
	InfoWxNoteBookPage->SetAutoLayout(true);

	WxPanel16 = new wxPanel(InfoWxNoteBookPage, ID_WXPANEL16, wxPoint(5,5), wxSize(565,31));
	WxBoxSizer12->Add(WxPanel16,0,wxALIGN_TOP | wxALL,5);

	BackupWxButton = new wxButton(WxPanel16, ID_BACKUPWXBUTTON, wxT("Backup"), wxPoint(7,5), wxSize(85,23), 0, wxDefaultValidator, wxT("BackupWxButton"));

	RestoreWxButton = new wxButton(WxPanel16, ID_RESTOREWXBUTTON, wxT("Restore"), wxPoint(103,5), wxSize(85,23), 0, wxDefaultValidator, wxT("RestoreWxButton"));

	OnlineInfoWxButton = new wxButton(WxPanel16, ID_ONLINEINFOWXBUTTON, wxT("Get online info"), wxPoint(198,5), wxSize(85,23), 0, wxDefaultValidator, wxT("OnlineInfoWxButton"));

	WxSplitterWindow7 =new wxSplitterWindow(InfoWxNoteBookPage, ID_WXSPLITTERWINDOW7, wxPoint(204,41), wxSize(166,44) , wxSP_3D | wxSP_LIVE_UPDATE);
	WxBoxSizer12->Add(WxSplitterWindow7,1,wxEXPAND | wxALL,0);

	WxPanel22 = new wxPanel(WxSplitterWindow7, ID_WXPANEL22, wxPoint(5,5), wxSize(73,26));

	WxGridSizer2 = new wxGridSizer(1, 1, 0, 0);
	WxPanel22->SetSizer(WxGridSizer2);
	WxPanel22->SetAutoLayout(true);

	InfoWxListCtrl = new wxListCtrl(WxPanel22, ID_INFOWXLISTCTRL, wxPoint(5,5), wxSize(67,62), wxLC_REPORT);
	InfoWxListCtrl->InsertColumn(0,wxT("Value"),wxLIST_FORMAT_LEFT,300 );
	InfoWxListCtrl->InsertColumn(0,wxT("Name"),wxLIST_FORMAT_LEFT,150 );
	WxGridSizer2->Add(InfoWxListCtrl,1,wxEXPAND | wxALL,5);

	WxPanel24 = new wxPanel(WxSplitterWindow7, ID_WXPANEL24, wxPoint(5,41), wxSize(73,34));

	WxBoxSizer17 = new wxBoxSizer(wxHORIZONTAL);
	WxPanel24->SetSizer(WxBoxSizer17);
	WxPanel24->SetAutoLayout(true);

	InfoDownWxListCtrl = new wxListCtrl(WxPanel24, ID_INFODOWNWXLISTCTRL, wxPoint(5,5), wxSize(61,28), wxLC_REPORT);
	InfoDownWxListCtrl->InsertColumn(0,wxT("Value"),wxLIST_FORMAT_LEFT,300 );
	InfoDownWxListCtrl->InsertColumn(0,wxT("Name"),wxLIST_FORMAT_LEFT,150 );
	WxBoxSizer17->Add(InfoDownWxListCtrl,1,wxEXPAND | wxALL,5);

	FilesWxNoteBookPage = new wxPanel(WxNotebook1, ID_FILESWXNOTEBOOKPAGE, wxPoint(4,24), wxSize(581,268));
	WxNotebook1->AddPage(FilesWxNoteBookPage, wxT("FileSystem"));

	WxBoxSizer1 = new wxBoxSizer(wxVERTICAL);
	FilesWxNoteBookPage->SetSizer(WxBoxSizer1);
	FilesWxNoteBookPage->SetAutoLayout(true);

	WxPanel1 = new wxPanel(FilesWxNoteBookPage, ID_WXPANEL1, wxPoint(5,5), wxSize(285,31));
	WxBoxSizer1->Add(WxPanel1,0,wxALIGN_TOP | wxALL,5);

	FilesGetWxButton = new wxButton(WxPanel1, ID_FILESGETWXBUTTON, wxT("Get from phone"), wxPoint(7,5), wxSize(85,23), 0, wxDefaultValidator, wxT("FilesGetWxButton"));

	AddFileWxButton = new wxButton(WxPanel1, ID_ADDFILEWXBUTTON, wxT("Add file"), wxPoint(103,5), wxSize(85,23), 0, wxDefaultValidator, wxT("AddFileWxButton"));
	AddFileWxButton->Enable(false);

	FilesWxListCtrl = new wxListCtrl(FilesWxNoteBookPage, ID_FILESWXLISTCTRL, wxPoint(9,46), wxSize(277,213), wxLC_REPORT);
	FilesWxListCtrl->InsertColumn(0,wxT("Attribs"),wxLIST_FORMAT_LEFT,70 );
	FilesWxListCtrl->InsertColumn(0,wxT("Modified"),wxLIST_FORMAT_LEFT,200 );
	FilesWxListCtrl->InsertColumn(0,wxT("Type"),wxLIST_FORMAT_LEFT,70 );
	FilesWxListCtrl->InsertColumn(0,wxT("Size"),wxLIST_FORMAT_LEFT,80 );
	FilesWxListCtrl->InsertColumn(0,wxT("Name"),wxLIST_FORMAT_LEFT,170 );
	WxBoxSizer1->Add(FilesWxListCtrl,1,wxEXPAND | wxALL,5);

	PhoneBookWxNoteBookPage = new wxPanel(WxNotebook1, ID_PHONEBOOKWXNOTEBOOKPAGE, wxPoint(4,24), wxSize(581,268));
	WxNotebook1->AddPage(PhoneBookWxNoteBookPage, wxT("PhoneBook"));

	WxBoxSizer2 = new wxBoxSizer(wxVERTICAL);
	PhoneBookWxNoteBookPage->SetSizer(WxBoxSizer2);
	PhoneBookWxNoteBookPage->SetAutoLayout(true);

	WxPanel2 = new wxPanel(PhoneBookWxNoteBookPage, ID_WXPANEL2, wxPoint(5,5), wxSize(570,29));
	WxBoxSizer2->Add(WxPanel2,0,wxALIGN_TOP | wxALL,5);

	PbkGetWxButton = new wxButton(WxPanel2, ID_PBKGETWXBUTTON, wxT("Get from phone"), wxPoint(7,5), wxSize(85,23), 0, wxDefaultValidator, wxT("PbkGetWxButton"));

	wxArrayString arrayStringFor_PBKWxComboBox;
	PBKWxComboBox = new wxComboBox(WxPanel2, ID_PBKWXCOMBOBOX, wxT("PBKWxComboBox"), wxPoint(104,5), wxSize(215,21), arrayStringFor_PBKWxComboBox, wxCB_SIMPLE | wxCB_DROPDOWN | wxCB_READONLY | wxCB_SORT, wxDefaultValidator, wxT("PBKWxComboBox"));

	PbkWxEdit = new wxTextCtrl(WxPanel2, ID_PBKWXEDIT, wxT(""), wxPoint(328,5), wxSize(110,22), 0, wxDefaultValidator, wxT("PbkWxEdit"));
	PbkWxEdit->Enable(false);

	PbkSearchWxButton = new wxButton(WxPanel2, ID_PBKSEARCHWXBUTTON, wxT("Search"), wxPoint(448,5), wxSize(71,23), 0, wxDefaultValidator, wxT("PbkSearchWxButton"));
	PbkSearchWxButton->Enable(false);

	WxSplitterWindow1 =new wxSplitterWindow(PhoneBookWxNoteBookPage, ID_WXSPLITTERWINDOW1, wxPoint(130,39), wxSize(320,110) , wxNO_BORDER | wxSP_3D | wxSP_3DBORDER  | wxSP_NOBORDER | wxSP_LIVE_UPDATE);
	WxBoxSizer2->Add(WxSplitterWindow1,1,wxEXPAND | 0,0);

	WxPanel3 = new wxPanel(WxSplitterWindow1, ID_WXPANEL3, wxPoint(55,5), wxSize(100,70));

	WxGridSizer3 = new wxGridSizer(2, 1, 0, 0);
	WxPanel3->SetSizer(WxGridSizer3);
	WxPanel3->SetAutoLayout(true);

	PBKUpWxListCtrl = new wxListCtrl(WxPanel3, ID_PBKUPWXLISTCTRL2, wxPoint(5,5), wxSize(53,50), wxLC_REPORT);
	PBKUpWxListCtrl->InsertColumn(0,wxT("Time"),wxLIST_FORMAT_LEFT,400 );
	PBKUpWxListCtrl->InsertColumn(0,wxT("Default number"),wxLIST_FORMAT_LEFT,140 );
	PBKUpWxListCtrl->InsertColumn(0,wxT("Name"),wxLIST_FORMAT_LEFT,250 );
	PBKUpWxListCtrl->InsertColumn(0,wxT("Location"),wxLIST_FORMAT_LEFT,50 );
	WxGridSizer3->Add(PBKUpWxListCtrl,1,wxEXPAND | wxALL,5);

	WxPanel4 = new wxPanel(WxSplitterWindow1, ID_WXPANEL4, wxPoint(5,85), wxSize(200,100));

	WxGridSizer4 = new wxGridSizer(1, 1, 0, 0);
	WxPanel4->SetSizer(WxGridSizer4);
	WxPanel4->SetAutoLayout(true);

	PBKDownWxListCtrl = new wxListCtrl(WxPanel4, ID_PBKDOWNWXLISTCTRL2, wxPoint(5,5), wxSize(100,93), wxLC_REPORT);
	PBKDownWxListCtrl->InsertColumn(0,wxT("Value"),wxLIST_FORMAT_LEFT,400 );
	PBKDownWxListCtrl->InsertColumn(0,wxT("Type"),wxLIST_FORMAT_LEFT,170 );
	WxGridSizer4->Add(PBKDownWxListCtrl,1,wxEXPAND | wxALL,5);

	SMSWxNoteBookPage = new wxPanel(WxNotebook1, ID_SMSWXNOTEBOOKPAGE, wxPoint(4,24), wxSize(581,268));
	WxNotebook1->AddPage(SMSWxNoteBookPage, wxT("SMS"));

	WxBoxSizer3 = new wxBoxSizer(wxVERTICAL);
	SMSWxNoteBookPage->SetSizer(WxBoxSizer3);
	SMSWxNoteBookPage->SetAutoLayout(true);

	WxPanel5 = new wxPanel(SMSWxNoteBookPage, ID_WXPANEL5, wxPoint(5,5), wxSize(568,31));
	WxBoxSizer3->Add(WxPanel5,0,wxALIGN_TOP | wxALL,5);

	wxArrayString arrayStringFor_SMSWxComboBox;
	SMSWxComboBox = new wxComboBox(WxPanel5, ID_SMSWXCOMBOBOX, wxT("SMSWxComboBox"), wxPoint(104,5), wxSize(215,21), arrayStringFor_SMSWxComboBox, wxTE_READONLY, wxDefaultValidator, wxT("SMSWxComboBox"));

	SMSGetWxButton = new wxButton(WxPanel5, ID_SMSGETWXBUTTON, wxT("Get from phone"), wxPoint(7,5), wxSize(85,23), 0, wxDefaultValidator, wxT("SMSGetWxButton"));

	SMSWxEdit = new wxTextCtrl(WxPanel5, ID_SMSWXEDIT, wxT(""), wxPoint(328,5), wxSize(110,22), 0, wxDefaultValidator, wxT("SMSWxEdit"));
	SMSWxEdit->Enable(false);

	SMSSendWxButton = new wxButton(WxPanel5, ID_SMSSENDWXBUTTON, wxT("Send SMS"), wxPoint(525,5), wxSize(75,23), 0, wxDefaultValidator, wxT("SMSSendWxButton"));

	SMSSearchWxButton = new wxButton(WxPanel5, ID_SMSSEARCHWXBUTTON, wxT("Search"), wxPoint(448,5), wxSize(71,23), 0, wxDefaultValidator, wxT("SMSSearchWxButton"));
	SMSSearchWxButton->Enable(false);

	WxSplitterWindow2 =new wxSplitterWindow(SMSWxNoteBookPage, ID_WXSPLITTERWINDOW2, wxPoint(10,41), wxSize(558,120) , wxSP_3D | wxSP_LIVE_UPDATE);
	WxBoxSizer3->Add(WxSplitterWindow2,1,wxEXPAND | wxALL,0);

	WxPanel6 = new wxPanel(WxSplitterWindow2, ID_WXPANEL6, wxPoint(164,5), wxSize(110,30));

	WxGridSizer5 = new wxGridSizer(1, 1, 0, 0);
	WxPanel6->SetSizer(WxGridSizer5);
	WxPanel6->SetAutoLayout(true);

	SMSUpWxListCtrl = new wxListCtrl(WxPanel6, ID_SMSUPWXLISTCTRL, wxPoint(5,5), wxSize(100,20), wxLC_REPORT);
	SMSUpWxListCtrl->InsertColumn(0,wxT("Parts"),wxLIST_FORMAT_LEFT,20 );
	SMSUpWxListCtrl->InsertColumn(0,wxT("Text"),wxLIST_FORMAT_LEFT,300 );
	SMSUpWxListCtrl->InsertColumn(0,wxT("Sender"),wxLIST_FORMAT_LEFT,200 );
	SMSUpWxListCtrl->InsertColumn(0,wxT("Sent"),wxLIST_FORMAT_LEFT,200 );
	WxGridSizer5->Add(SMSUpWxListCtrl,1,wxEXPAND | wxALL,5);

	WxPanel7 = new wxPanel(WxSplitterWindow2, ID_WXPANEL7, wxPoint(5,45), wxSize(428,110));

	WxGridSizer6 = new wxGridSizer(1, 1, 0, 0);
	WxPanel7->SetSizer(WxGridSizer6);
	WxPanel7->SetAutoLayout(true);

	WxNotebook2 = new wxNotebook(WxPanel7, ID_WXNOTEBOOK2, wxPoint(5,5),wxSize(204,100));
	WxGridSizer6->Add(WxNotebook2,1,wxEXPAND | wxALL,5);

	WxNoteBookPage1 = new wxPanel(WxNotebook2, ID_WXNOTEBOOKPAGE1, wxPoint(4,24), wxSize(196,72));
	WxNotebook2->AddPage(WxNoteBookPage1, wxT("Summary"));

	WxBoxSizer4 = new wxBoxSizer(wxVERTICAL);
	WxNoteBookPage1->SetSizer(WxBoxSizer4);
	WxNoteBookPage1->SetAutoLayout(true);

	wxArrayString arrayStringFor_SMSNumbersWxListBox;
	SMSNumbersWxListBox = new wxListBox(WxNoteBookPage1, ID_SMSNUMBERSWXLISTBOX, wxPoint(0,0), wxSize(182,26), arrayStringFor_SMSNumbersWxListBox, wxLB_SINGLE | wxNO_BORDER | wxLB_SORT);
	SMSNumbersWxListBox->SetBackgroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_BTNFACE));
	WxBoxSizer4->Add(SMSNumbersWxListBox,0,wxALIGN_TOP | 0,0);

	SMSTextWxMemo = new wxTextCtrl(WxNoteBookPage1, ID_SMSTEXTWXMEMO, wxT(""), wxPoint(25,31), wxSize(131,30), wxTE_READONLY | wxTE_MULTILINE, wxDefaultValidator, wxT("SMSTextWxMemo"));
	SMSTextWxMemo->SetMaxLength(0);
	SMSTextWxMemo->SetFocus();
	SMSTextWxMemo->SetInsertionPointEnd();
	WxBoxSizer4->Add(SMSTextWxMemo,1,wxEXPAND | wxALL,5);

	WxNoteBookPage2 = new wxPanel(WxNotebook2, ID_WXNOTEBOOKPAGE2, wxPoint(4,24), wxSize(196,72));
	WxNotebook2->AddPage(WxNoteBookPage2, wxT("Details"));

	WxBoxSizer5 = new wxBoxSizer(wxHORIZONTAL);
	WxNoteBookPage2->SetSizer(WxBoxSizer5);
	WxNoteBookPage2->SetAutoLayout(true);

	SMSDetailsWxListCtrl = new wxListCtrl(WxNoteBookPage2, ID_SMSDETAILSWXLISTCTRL, wxPoint(5,5), wxSize(177,54), wxLC_REPORT);
	SMSDetailsWxListCtrl->InsertColumn(0,wxT("Value"),wxLIST_FORMAT_LEFT,300 );
	SMSDetailsWxListCtrl->InsertColumn(0,wxT("Name"),wxLIST_FORMAT_LEFT,150 );
	WxBoxSizer5->Add(SMSDetailsWxListCtrl,1,wxEXPAND | wxALL,5);

	MMSWxNoteBookPage = new wxPanel(WxNotebook1, ID_MMSWXNOTEBOOKPAGE, wxPoint(4,24), wxSize(581,268));
	WxNotebook1->AddPage(MMSWxNoteBookPage, wxT("MMS"));

	WxBoxSizer6 = new wxBoxSizer(wxVERTICAL);
	MMSWxNoteBookPage->SetSizer(WxBoxSizer6);
	MMSWxNoteBookPage->SetAutoLayout(true);

	WxPanel8 = new wxPanel(MMSWxNoteBookPage, ID_WXPANEL8, wxPoint(5,5), wxSize(566,31));
	WxBoxSizer6->Add(WxPanel8,0,wxALIGN_TOP | wxALL,5);

	wxArrayString arrayStringFor_MMSWxComboBox;
	MMSWxComboBox = new wxComboBox(WxPanel8, ID_MMSWXCOMBOBOX, wxT("MMSWxComboBox"), wxPoint(104,5), wxSize(215,21), arrayStringFor_MMSWxComboBox, wxTE_READONLY, wxDefaultValidator, wxT("MMSWxComboBox"));

	MMSGetWxButton = new wxButton(WxPanel8, ID_MMSGETWXBUTTON, wxT("Get from phone"), wxPoint(7,5), wxSize(85,23), 0, wxDefaultValidator, wxT("MMSGetWxButton"));

	MMSSearchWxEdit = new wxTextCtrl(WxPanel8, ID_MMSSEARCHWXEDIT, wxT(""), wxPoint(328,5), wxSize(110,22), 0, wxDefaultValidator, wxT("MMSSearchWxEdit"));
	MMSSearchWxEdit->Enable(false);

	MMSSearchWxButton = new wxButton(WxPanel8, ID_MMSSEARCHWXBUTTON, wxT("Search"), wxPoint(448,5), wxSize(71,23), 0, wxDefaultValidator, wxT("MMSSearchWxButton"));
	MMSSearchWxButton->Enable(false);

	WxSplitterWindow3 =new wxSplitterWindow(MMSWxNoteBookPage, ID_WXSPLITTERWINDOW3, wxPoint(100,41), wxSize(375,110) , wxSP_3D | wxSP_LIVE_UPDATE);
	WxBoxSizer6->Add(WxSplitterWindow3,1,wxEXPAND | wxALL,0);

	WxPanel9 = new wxPanel(WxSplitterWindow3, ID_WXPANEL9, wxPoint(29,5), wxSize(153,20));

	WxGridSizer7 = new wxGridSizer(1, 1, 0, 0);
	WxPanel9->SetSizer(WxGridSizer7);
	WxPanel9->SetAutoLayout(true);

	MMSUpWxListCtrl = new wxListCtrl(WxPanel9, ID_MMSUPWXLISTCTRL, wxPoint(5,5), wxSize(47,10), wxLC_REPORT);
	MMSUpWxListCtrl->InsertColumn(0,wxT("Size"),wxLIST_FORMAT_LEFT,70 );
	MMSUpWxListCtrl->InsertColumn(0,wxT("Files"),wxLIST_FORMAT_LEFT,20 );
	MMSUpWxListCtrl->InsertColumn(0,wxT("Text"),wxLIST_FORMAT_LEFT,300 );
	MMSUpWxListCtrl->InsertColumn(0,wxT("Sender"),wxLIST_FORMAT_LEFT,200 );
	MMSUpWxListCtrl->InsertColumn(0,wxT("Sent"),wxLIST_FORMAT_LEFT,200 );
	WxGridSizer7->Add(MMSUpWxListCtrl,1,wxEXPAND | wxALL,5);

	WxPanel10 = new wxPanel(WxSplitterWindow3, ID_WXPANEL10, wxPoint(5,35), wxSize(202,100));

	WxGridSizer8 = new wxGridSizer(1, 1, 0, 0);
	WxPanel10->SetSizer(WxGridSizer8);
	WxPanel10->SetAutoLayout(true);

	WxNotebook3 = new wxNotebook(WxPanel10, ID_WXNOTEBOOK3, wxPoint(5,5),wxSize(187,94));
	WxGridSizer8->Add(WxNotebook3,1,wxEXPAND | wxALL,5);

	WxNoteBookPage3 = new wxPanel(WxNotebook3, ID_WXNOTEBOOKPAGE3, wxPoint(4,24), wxSize(179,66));
	WxNotebook3->AddPage(WxNoteBookPage3, wxT("Summary"));

	WxBoxSizer9 = new wxBoxSizer(wxVERTICAL);
	WxNoteBookPage3->SetSizer(WxBoxSizer9);
	WxNoteBookPage3->SetAutoLayout(true);

	WxPanel11 = new wxPanel(WxNoteBookPage3, ID_WXPANEL11, wxPoint(5,5), wxSize(168,25));
	WxBoxSizer9->Add(WxPanel11,0,wxALIGN_TOP | wxALL,5);

	wxArrayString arrayStringFor_MMFilesWxComboBox;
	MMFilesWxComboBox = new wxComboBox(WxPanel11, ID_MMFILESWXCOMBOBOX, wxT(""), wxPoint(0,1), wxSize(224,21), arrayStringFor_MMFilesWxComboBox, wxCB_DROPDOWN | wxCB_READONLY, wxDefaultValidator, wxT("MMFilesWxComboBox"));

	MMSSaveWxButton = new wxButton(WxPanel11, ID_MMSSAVEWXBUTTON, wxT("Save to file"), wxPoint(230,1), wxSize(84,22), 0, wxDefaultValidator, wxT("MMSSaveWxButton"));
	MMSSaveWxButton->Enable(false);

	WxBoxSizer10 = new wxBoxSizer(wxHORIZONTAL);
	WxBoxSizer9->Add(WxBoxSizer10, 1, wxEXPAND | wxALL, 5);

	MMSFileWxMemo = new wxTextCtrl(WxNoteBookPage3, ID_MMSFILEWXMEMO, wxT(""), wxPoint(5,5), wxSize(10,10), wxTE_READONLY | wxTE_MULTILINE, wxDefaultValidator, wxT("MMSFileWxMemo"));
	MMSFileWxMemo->SetMaxLength(0);
	MMSFileWxMemo->Show(false);
	MMSFileWxMemo->AppendText(wxT("W"));
	MMSFileWxMemo->AppendText(wxT("x"));
	MMSFileWxMemo->AppendText(wxT("M"));
	MMSFileWxMemo->AppendText(wxT("e"));
	MMSFileWxMemo->AppendText(wxT("m"));
	MMSFileWxMemo->AppendText(wxT("o"));
	MMSFileWxMemo->AppendText(wxT("1"));
	MMSFileWxMemo->SetFocus();
	MMSFileWxMemo->SetInsertionPointEnd();
	WxBoxSizer10->Add(MMSFileWxMemo,1,wxEXPAND | wxALL,5);

	MMSFileWxMediaCtrl = new wxMediaCtrl(WxNoteBookPage3, ID_MMSFILEWXMEDIACTRL,wxT(""), wxPoint(25,5), wxSize(10,10) );
	MMSFileWxMediaCtrl->Enable(false);
	MMSFileWxMediaCtrl->ShowPlayerControls(wxMEDIACTRLPLAYERCONTROLS_NONE);
	WxBoxSizer10->Add(MMSFileWxMediaCtrl,1,wxEXPAND | wxALL,5);

	WxNoteBookPage4 = new wxPanel(WxNotebook3, ID_WXNOTEBOOKPAGE4, wxPoint(4,24), wxSize(179,66));
	WxNotebook3->AddPage(WxNoteBookPage4, wxT("Details"));

	WxBoxSizer7 = new wxBoxSizer(wxHORIZONTAL);
	WxNoteBookPage4->SetSizer(WxBoxSizer7);
	WxNoteBookPage4->SetAutoLayout(true);

	MMSDetailsWxListCtrl = new wxListCtrl(WxNoteBookPage4, ID_MMSDOWNWXLISTCTRL, wxPoint(5,5), wxSize(174,32), wxLC_REPORT);
	MMSDetailsWxListCtrl->InsertColumn(0,wxT("Value"),wxLIST_FORMAT_LEFT,300 );
	MMSDetailsWxListCtrl->InsertColumn(0,wxT("Name"),wxLIST_FORMAT_LEFT,200 );
	WxBoxSizer7->Add(MMSDetailsWxListCtrl,1,wxEXPAND | wxALL,5);

	CalendarWxNoteBookPage = new wxPanel(WxNotebook1, ID_CALENDARWXNOTEBOOKPAGE, wxPoint(4,24), wxSize(581,268));
	WxNotebook1->AddPage(CalendarWxNoteBookPage, wxT("Calendar"));

	WxBoxSizer8 = new wxBoxSizer(wxVERTICAL);
	CalendarWxNoteBookPage->SetSizer(WxBoxSizer8);
	CalendarWxNoteBookPage->SetAutoLayout(true);

	WxPanel12 = new wxPanel(CalendarWxNoteBookPage, ID_WXPANEL12, wxPoint(5,5), wxSize(535,30));
	WxBoxSizer8->Add(WxPanel12,0,wxALIGN_TOP | wxALL,5);

	CalendarGetWxButton = new wxButton(WxPanel12, ID_CALENDARGETWXBUTTON, wxT("Get from phone"), wxPoint(7,5), wxSize(85,23), 0, wxDefaultValidator, wxT("CalendarGetWxButton"));

	CalendarSearchWxEdit = new wxTextCtrl(WxPanel12, ID_CALENDARSEARCHWXEDIT, wxT(""), wxPoint(102,4), wxSize(110,21), 0, wxDefaultValidator, wxT("CalendarSearchWxEdit"));
	CalendarSearchWxEdit->Enable(false);

	CalendarSearchWxButton = new wxButton(WxPanel12, ID_CALENDARSEARCHWXBUTTON, wxT("Search"), wxPoint(231,5), wxSize(78,20), 0, wxDefaultValidator, wxT("CalendarSearchWxButton"));
	CalendarSearchWxButton->Enable(false);

	WxBoxSizer11 = new wxBoxSizer(wxHORIZONTAL);
	WxBoxSizer8->Add(WxBoxSizer11, 1, wxEXPAND | wxALL, 5);

	WxPanel13 = new wxPanel(CalendarWxNoteBookPage, ID_WXPANEL13, wxPoint(5,5), wxSize(185,194));
	WxBoxSizer11->Add(WxPanel13,0,wxALIGN_TOP | wxALL,5);

	WxButton1 = new wxButton(WxPanel13, ID_WXBUTTON1, wxT("<<"), wxPoint(7,8), wxSize(69,23), 0, wxDefaultValidator, wxT("WxButton1"));

	WxButton2 = new wxButton(WxPanel13, ID_WXBUTTON2, wxT(">>"), wxPoint(100,7), wxSize(68,25), 0, wxDefaultValidator, wxT("WxButton2"));

	WxCalendarCtrl1 = new wxCalendarCtrl(WxPanel13, ID_WXCALENDARCTRL1, wxDateTime(10,(wxDateTime::Month)2,2007),wxPoint(6,41), wxSize(168,101), wxCAL_SUNDAY_FIRST | wxCAL_SHOW_HOLIDAYS | wxCAL_NO_MONTH_CHANGE | wxCAL_SHOW_SURROUNDING_WEEKS | wxCAL_SEQUENTIAL_MONTH_SELECTION);

	CalendarWxCheckBox = new wxCheckBox(WxPanel13, ID_CALENDARWXCHECKBOX, wxT("Show events from all days"), wxPoint(9,158), wxSize(167,19), 0, wxDefaultValidator, wxT("CalendarWxCheckBox"));
	CalendarWxCheckBox->SetValue(true);

	WxSplitterWindow4 =new wxSplitterWindow(CalendarWxNoteBookPage, ID_WXSPLITTERWINDOW4, wxPoint(195,87), wxSize(68,30) , wxSP_3D | wxSP_LIVE_UPDATE);
	WxBoxSizer11->Add(WxSplitterWindow4,1,wxEXPAND | wxALL,0);

	WxPanel14 = new wxPanel(WxSplitterWindow4, ID_WXPANEL14, wxPoint(5,5), wxSize(25,20));

	WxGridSizer9 = new wxGridSizer(2, 1, 0, 0);
	WxPanel14->SetSizer(WxGridSizer9);
	WxPanel14->SetAutoLayout(true);

	CalendarUpWxListCtrl = new wxListCtrl(WxPanel14, ID_CALENDARUPWXLISTCTRL2, wxPoint(5,5), wxSize(15,13), wxLC_REPORT);
	CalendarUpWxListCtrl->InsertColumn(0,wxT("Text"),wxLIST_FORMAT_LEFT,150 );
	CalendarUpWxListCtrl->InsertColumn(0,wxT("Type"),wxLIST_FORMAT_LEFT,100 );
	CalendarUpWxListCtrl->InsertColumn(0,wxT("Date"),wxLIST_FORMAT_LEFT,140 );
	WxGridSizer9->Add(CalendarUpWxListCtrl,1,wxEXPAND | wxALL,5);

	WxPanel15 = new wxPanel(WxSplitterWindow4, ID_WXPANEL15, wxPoint(6,35), wxSize(23,20));

	WxGridSizer10 = new wxGridSizer(1, 1, 0, 0);
	WxPanel15->SetSizer(WxGridSizer10);
	WxPanel15->SetAutoLayout(true);

	CalendarDownWxListCtrl = new wxListCtrl(WxPanel15, ID_CALENDARDOWNWXLISTCTRL, wxPoint(5,5), wxSize(22,23), wxLC_REPORT);
	CalendarDownWxListCtrl->InsertColumn(0,wxT("Value"),wxLIST_FORMAT_LEFT,250 );
	CalendarDownWxListCtrl->InsertColumn(0,wxT("Name"),wxLIST_FORMAT_LEFT,150 );
	WxGridSizer10->Add(CalendarDownWxListCtrl,1,wxEXPAND | wxALL,5);

	NotesWxNoteBookPage = new wxPanel(WxNotebook1, ID_NOTESWXNOTEBOOKPAGE, wxPoint(4,24), wxSize(581,268));
	WxNotebook1->AddPage(NotesWxNoteBookPage, wxT("Notes"));

	WxBoxSizer13 = new wxBoxSizer(wxVERTICAL);
	NotesWxNoteBookPage->SetSizer(WxBoxSizer13);
	NotesWxNoteBookPage->SetAutoLayout(true);

	WxPanel17 = new wxPanel(NotesWxNoteBookPage, ID_WXPANEL17, wxPoint(5,5), wxSize(528,30));
	WxBoxSizer13->Add(WxPanel17,0,wxALIGN_TOP | wxALL,5);

	NotesGetWxButton = new wxButton(WxPanel17, ID_NOTESGETWXBUTTON, wxT("Get from phone"), wxPoint(7,5), wxSize(85,23), 0, wxDefaultValidator, wxT("NotesGetWxButton"));

	WxBoxSizer14 = new wxBoxSizer(wxHORIZONTAL);
	WxBoxSizer13->Add(WxBoxSizer14, 1, wxEXPAND | wxALL, 5);

	WxSplitterWindow5 =new wxSplitterWindow(NotesWxNoteBookPage, ID_WXSPLITTERWINDOW5, wxPoint(0,0), wxSize(59,35) , wxSP_3D | wxSP_3DBORDER  | wxSP_LIVE_UPDATE);
	WxBoxSizer14->Add(WxSplitterWindow5,1,wxEXPAND | wxALL,0);

	WxPanel18 = new wxPanel(WxSplitterWindow5, ID_WXPANEL18, wxPoint(6,5), wxSize(18,13));

	WxGridSizer11 = new wxGridSizer(1, 1, 0, 0);
	WxPanel18->SetSizer(WxGridSizer11);
	WxPanel18->SetAutoLayout(true);

	NotesWxListCtrl = new wxListCtrl(WxPanel18, ID_NOTESWXLISTCTRL, wxPoint(5,5), wxSize(200,200), wxLC_REPORT);
	NotesWxListCtrl->InsertColumn(0,wxT("Text"),wxLIST_FORMAT_LEFT,300 );
	WxGridSizer11->Add(NotesWxListCtrl,1,wxEXPAND | wxALL,5);

	WxPanel19 = new wxPanel(WxSplitterWindow5, ID_WXPANEL19, wxPoint(5,28), wxSize(21,25));

	WxGridSizer12 = new wxGridSizer(1, 1, 0, 0);
	WxPanel19->SetSizer(WxGridSizer12);
	WxPanel19->SetAutoLayout(true);

	NotesWxMemo = new wxTextCtrl(WxPanel19, ID_NOTESWXMEMO, wxT(""), wxPoint(5,5), wxSize(100,100), wxTE_READONLY | wxTE_MULTILINE, wxDefaultValidator, wxT("NotesWxMemo"));
	NotesWxMemo->SetMaxLength(0);
	NotesWxMemo->SetFocus();
	NotesWxMemo->SetInsertionPointEnd();
	WxGridSizer12->Add(NotesWxMemo,1,wxEXPAND | wxALL,5);

	ToDoWxNoteBookPage = new wxPanel(WxNotebook1, ID_TODOWXNOTEBOOKPAGE, wxPoint(4,24), wxSize(581,268));
	WxNotebook1->AddPage(ToDoWxNoteBookPage, wxT("ToDo"));

	WxBoxSizer15 = new wxBoxSizer(wxVERTICAL);
	ToDoWxNoteBookPage->SetSizer(WxBoxSizer15);
	ToDoWxNoteBookPage->SetAutoLayout(true);

	WxPanel20 = new wxPanel(ToDoWxNoteBookPage, ID_WXPANEL20, wxPoint(5,5), wxSize(563,30));
	WxBoxSizer15->Add(WxPanel20,0,wxALIGN_TOP | wxALL,5);

	ToDoGetWxButton = new wxButton(WxPanel20, ID_TODOGETWXBUTTON, wxT("Get from phone"), wxPoint(7,5), wxSize(85,23), 0, wxDefaultValidator, wxT("ToDoGetWxButton"));

	WxBoxSizer16 = new wxBoxSizer(wxVERTICAL);
	WxBoxSizer15->Add(WxBoxSizer16, 1, wxEXPAND | wxALL, 5);

	WxSplitterWindow6 =new wxSplitterWindow(ToDoWxNoteBookPage, ID_WXSPLITTERWINDOW6, wxPoint(0,0), wxSize(211,143) , wxSP_3D | wxSP_LIVE_UPDATE);
	WxBoxSizer16->Add(WxSplitterWindow6,1,wxEXPAND | wxALL,0);

	WxPanel21 = new wxPanel(WxSplitterWindow6, ID_WXPANEL21, wxPoint(30,5), wxSize(70,15));

	WxGridSizer13 = new wxGridSizer(1, 1, 0, 0);
	WxPanel21->SetSizer(WxGridSizer13);
	WxPanel21->SetAutoLayout(true);

	ToDoUpWxListCtrl = new wxListCtrl(WxPanel21, ID_TODOUPWXLISTCTRL, wxPoint(5,5), wxSize(40,7), wxLC_REPORT);
	ToDoUpWxListCtrl->InsertColumn(0,wxT("Text"),wxLIST_FORMAT_LEFT,200 );
	ToDoUpWxListCtrl->InsertColumn(0,wxT("Status"),wxLIST_FORMAT_LEFT,80 );
	ToDoUpWxListCtrl->InsertColumn(0,wxT("End"),wxLIST_FORMAT_LEFT,200 );
	WxGridSizer13->Add(ToDoUpWxListCtrl,1,wxEXPAND | wxALL,5);

	WxPanel23 = new wxPanel(WxSplitterWindow6, ID_WXPANEL23, wxPoint(5,30), wxSize(121,133));

	WxGridSizer14 = new wxGridSizer(1, 1, 0, 0);
	WxPanel23->SetSizer(WxGridSizer14);
	WxPanel23->SetAutoLayout(true);

	ToDoDownWxListCtrl = new wxListCtrl(WxPanel23, ID_TODODOWNWXLISTCTRL, wxPoint(5,5), wxSize(96,97), wxLC_REPORT);
	ToDoDownWxListCtrl->InsertColumn(0,wxT("Value"),wxLIST_FORMAT_LEFT,200 );
	ToDoDownWxListCtrl->InsertColumn(0,wxT("Name"),wxLIST_FORMAT_LEFT,150 );
	WxGridSizer14->Add(ToDoDownWxListCtrl,1,wxEXPAND | wxALL,5);

	JavaWxNoteBookPage = new wxPanel(WxNotebook1, ID_JAVAWXNOTEBOOKPAGE, wxPoint(4,24), wxSize(581,268));
	WxNotebook1->AddPage(JavaWxNoteBookPage, wxT("Java"));

	WxBoxSizer18 = new wxBoxSizer(wxVERTICAL);
	JavaWxNoteBookPage->SetSizer(WxBoxSizer18);
	JavaWxNoteBookPage->SetAutoLayout(true);

	WxPanel25 = new wxPanel(JavaWxNoteBookPage, ID_WXPANEL25, wxPoint(5,5), wxSize(553,31));
	WxBoxSizer18->Add(WxPanel25,0,wxALIGN_TOP | wxALL,5);

	JavaGetWxButton = new wxButton(WxPanel25, ID_JAVAGETWXBUTTON, wxT("Get from phone"), wxPoint(7,5), wxSize(85,23), 0, wxDefaultValidator, wxT("JavaGetWxButton"));

	GameAddWxButton = new wxButton(WxPanel25, ID_GAMEADDWXBUTTON, wxT("Add game"), wxPoint(103,5), wxSize(85,23), 0, wxDefaultValidator, wxT("GameAddWxButton"));

	AppAddWxButton = new wxButton(WxPanel25, ID_APPADDWXBUTTON, wxT("Add application"), wxPoint(198,5), wxSize(85,23), 0, wxDefaultValidator, wxT("AppAddWxButton"));

	WxBoxSizer19 = new wxBoxSizer(wxHORIZONTAL);
	WxBoxSizer18->Add(WxBoxSizer19, 1, wxEXPAND | wxALL, 5);

	WxSplitterWindow8 =new wxSplitterWindow(JavaWxNoteBookPage, ID_WXSPLITTERWINDOW8, wxPoint(0,0), wxSize(146,43) , wxSP_3D | wxSP_3DBORDER  | wxSP_LIVE_UPDATE);
	WxBoxSizer19->Add(WxSplitterWindow8,1,wxEXPAND | wxALL,0);

	WxPanel26 = new wxPanel(WxSplitterWindow8, ID_WXPANEL26, wxPoint(5,5), wxSize(71,21));

	WxGridSizer15 = new wxGridSizer(1, 1, 0, 0);
	WxPanel26->SetSizer(WxGridSizer15);
	WxPanel26->SetAutoLayout(true);

	JavaUpWxListCtrl = new wxListCtrl(WxPanel26, ID_JAVAUPWXLISTCTRL, wxPoint(5,5), wxSize(250,150), wxLC_REPORT);
	JavaUpWxListCtrl->InsertColumn(0,wxT("Name"),wxLIST_FORMAT_LEFT,300 );
	JavaUpWxListCtrl->InsertColumn(0,wxT("Type"),wxLIST_FORMAT_LEFT,100 );
	WxGridSizer15->Add(JavaUpWxListCtrl,1,wxEXPAND | wxALL,5);

	WxPanel27 = new wxPanel(WxSplitterWindow8, ID_WXPANEL27, wxPoint(13,36), wxSize(55,33));

	WxGridSizer16 = new wxGridSizer(1, 1, 0, 0);
	WxPanel27->SetSizer(WxGridSizer16);
	WxPanel27->SetAutoLayout(true);

	JavaDownWxListCtrl = new wxListCtrl(WxPanel27, ID_JAVADOWNWXLISTCTRL, wxPoint(5,5), wxSize(35,30), wxLC_REPORT);
	JavaDownWxListCtrl->InsertColumn(0,wxT("Value"),wxLIST_FORMAT_LEFT,250 );
	JavaDownWxListCtrl->InsertColumn(0,wxT("Name"),wxLIST_FORMAT_LEFT,150 );
	WxGridSizer16->Add(JavaDownWxListCtrl,1,wxEXPAND | wxALL,5);

	MMSSingleUpWxPopupMenu = new wxMenu(wxT(""));MMSSingleUpWxPopupMenu->Append(ID_MNU_SAVETOFILE_1104, wxT("Save to file"), wxT(""), wxITEM_NORMAL);

	SMSSingleUpWxPopupMenu = new wxMenu(wxT(""));SMSSingleUpWxPopupMenu->Append(ID_MNU_FORWARD_1095, wxT("Forward current SMS sequence"), wxT(""), wxITEM_NORMAL);
	SMSSingleUpWxPopupMenu->Append(ID_MNU_SENDNEWSMSTOSMSNUMBERS_1144, wxT("Reply to sender(s)"), wxT(""), wxITEM_NORMAL);
	SMSSingleUpWxPopupMenu->Enable(ID_MNU_SENDNEWSMSTOSMSNUMBERS_1144,false);

	WxSplitterWindow7->SplitHorizontally(WxPanel22,WxPanel24,200);

	WxSplitterWindow1->SplitHorizontally(WxPanel3,WxPanel4,107);

	WxSplitterWindow2->SplitHorizontally(WxPanel6,WxPanel7,179);

	WxSplitterWindow3->SplitHorizontally(WxPanel9,WxPanel10,264);

	WxSplitterWindow4->SplitHorizontally(WxPanel14,WxPanel15,185);

	WxSplitterWindow5->SplitHorizontally(WxPanel18,WxPanel19,200);

	WxSplitterWindow6->SplitHorizontally(WxPanel21,WxPanel23,200);

	WxSplitterWindow8->SplitHorizontally(WxPanel26,WxPanel27,185);

	SetTitle(wxT("Untitled1"));
	SetIcon(wxNullIcon);
	
	GetSizer()->Fit(this);
	GetSizer()->SetSizeHints(this);
	Center();
	
	////GUI Items Creation End
}

void PhoneFrm::OnClose(wxCloseEvent& event)
{
	Destroy();
}

int PhoneFrm::FindPage(wxString Str)
{
    unsigned int i=0;

    while (i<WxNotebook1->GetPageCount()) {
        if (WxNotebook1->GetPageText(i) == Str) return i;
        i++;
    }
    return -1;
}

void PhoneFrm::DeleteP(wxString Str)
{
    unsigned int i=FindPage(Str);
    
    WxNotebook1->DeletePage(i);
    while (i<WxNotebook1->GetPageCount()) {
        StatusStr[i].clear();
        StatusStr[i].append(StatusStr[i+1].data());
        StatusStr2[i].clear();
        StatusStr2[i].append(StatusStr2[i+1].data());                  
        i++;
    }
    StatusStr[i].clear();
    StatusStr2[i].clear();
}

/*
 * WxNotebook1PageChanged
 */
void PhoneFrm::WxNotebook1PageChanged(wxNotebookEvent& event)
{
    parent->WxStatusBar1->SetStatusText(wxString(StatusStr[WxNotebook1->GetSelection()].data())+wxString(StatusStr2[WxNotebook1->GetSelection()].data()),0);
}

//--------------------------------- filesystem ----------------------------------------------

int wxCALLBACK FilesWxListCtrlCompareFunction(long item1, long item2, long sortData)
{
    long                            item11,retval,i;
    GSM_FileFolderInfoListSubEntry  *SubEntry,*SubEntry2;
    GSM_FileFolderInfoListsSubEntry *En2 = (GSM_FileFolderInfoListsSubEntry *)sortData;

    item11 = item1;
    if (item11 == 0) return -1;
    SubEntry = NULL;
    for (i=1;i<=item11;i++) En2->Info.GetNext(&SubEntry);

    item11 = item2;
    if (item11 == 0) return 1;
    SubEntry2 = NULL;
    for (i=1;i<=item11;i++) En2->Info.GetNext(&SubEntry2);

    if (SubEntry->Info.Folder != SubEntry2->Info.Folder) {
        retval = -1;
        if (SubEntry->Info.Folder) retval = 1;
    } else {
        retval = wcscoll(SubEntry->Info.Name.data(),SubEntry2->Info.Name.data());
    }

    return retval;
}

void PhoneFrm::DisplayFolder()
{
    wchart                            x;
    char                              buff[1000];
    unsignedstring                    Buffer2;
    GSM_Error                         error;
    FileFolderInfo                    FInfo;
    GSM_FileFolderInfoListSubEntry    *SubEntry;
    long                              tmp,size=0,filesnum=0,foldersnum=0,num2=0;
        
    FilesWxListCtrl->DeleteAllItems();
    FileSystemNum = 0;

    if (ParentFolderIDNum == 1) {
        //root
        num2++;
        AddFileWxButton->Enable(FALSE);
    } else {
        AddFileWxButton->Enable(TRUE);
        
        tmp = FilesWxListCtrl->InsertItem(FileSystemNum++, _T(".."), 0);
        FilesWxListCtrl->SetItemData(tmp, num2++);
        FilesWxListCtrl->SetItem(tmp, 1, _T(""));
        FilesWxListCtrl->SetItem(tmp, 2, _T("Folder"));
        FilesWxListCtrl->SetItem(tmp, 3, _T(""));
        FilesWxListCtrl->SetItem(tmp, 4, _T(""));
    }

    SubEntry = NULL;
    while (En2->Info.GetNext(&SubEntry) == TRUE) {
        if (!En2->Info.SubEntryFullData) {
            error = s->Phones->Current->GetFileFolderInfo(&SubEntry->Info);
            PrintError(error);
        }

        sprintf(buff,"%s",UnicodeToStringReturn(SubEntry->Info.Name.data()));
        tmp = FilesWxListCtrl->InsertItem(FileSystemNum++, buff, 0);
        FilesWxListCtrl->SetItemData(tmp, num2++);
        if (SubEntry->Info.Folder) {
            FilesWxListCtrl->SetItem(tmp, 1, _T(""));
            FilesWxListCtrl->SetItem(tmp, 2, _T("Folder"));

            foldersnum++;
        } else {
            size+=SubEntry->Info.Size;
            filesnum++;

            sprintf(buff, "%i",SubEntry->Info.Size);
            FilesWxListCtrl->SetItem(tmp, 1, buff);
            FilesWxListCtrl->SetItem(tmp, 2, _T("File"));
        }
        if (ParentFolderIDNum == 1) continue;
        if (SubEntry->Info.ModificationDateTimeAvailable) {
            PrintDT(&SubEntry->Info.ModificationDateTime, buff);
        } else {
            buff[0]=0;
        }
        FilesWxListCtrl->SetItem(tmp, 3, buff);

        sprintf(buff,"    ");
        if (SubEntry->Info.DRMForwardLock) buff[0] = 'P';
        if (SubEntry->Info.ReadOnly) buff[1] = 'R';
        if (SubEntry->Info.Hidden) buff[2] = 'H';
        if (SubEntry->Info.System) buff[3] = 'S';
        FilesWxListCtrl->SetItem(tmp, 4, buff);
    }

    FilesWxListCtrl->SortItems(FilesWxListCtrlCompareFunction,(long)En2);
    StatusStr2[FindPage("FileSystem")].clear();
    StatusStr2[FindPage("FileSystem")].append(StringToUnicodeReturn(" sorted by name"));

    StatusStr[FindPage("FileSystem")].clear();
    StatusStr[FindPage("FileSystem")].append(CurrentFolderName.data());
    sprintf(buff," (%i folders, %i bytes in %i files)",foldersnum,size,filesnum);
    StatusStr[FindPage("FileSystem")].append(StringToUnicodeReturn(buff));
    parent->WxStatusBar1->SetStatusText(wxString(StatusStr[WxNotebook1->GetSelection()].data())+wxString(StatusStr2[WxNotebook1->GetSelection()].data()),0);
}

GSM_FileFolderInfoListsSubEntry *PhoneFrm::GetFolderContent(const wchar_t *FileFolderID1)
{
    wchart                            x;
    wxProgressDialog                  *Dialog;
    bool                              skip;
    BOOLEAN                           Start2;
    wchar_t                           name[20];
    char                              buff[1000];
    GSM_MemoryType                    Mem;
    unsignedstring                    Buffer2;
    GSM_Error                         error;
    FileFolderInfo                    FInfo,*FInfo2;
    int                               i,num=0;
    GSM_FileFolderInfoListsSubEntry   *En,*En3;
    BOOLEAN                           Found = FALSE;
    
    En3 = NULL;
    while (s->Phones->Current->FoldersCache.GetNext(&En3)) {
        if (!wcscmp(En3->Info.Info.ID.data(),FileFolderID1)) {
            Found = TRUE;
            break;
        }
    }

    if (Found) return En3;
    
    En3 = new GSM_FileFolderInfoListsSubEntry;

    Dialog=NULL;
    Start2=TRUE;
    En3->Info.Info.SetID((wchar_t *)FileFolderID1);
    
    Found = false;
    while (1) {
        error = s->Phones->Current->GetFolderInfoList(&En3->Info,Start2);

        if (error.Code == GSM_ERR_MEMORY) {
            wxMessageBox("Folder not available in this moment",
                   wxT("Error"),
                   wxICON_WARNING | wxOK);
            //go into parent
            for (i=CurrentFolderName.length(); i > 0; i--) {
                    if (CurrentFolderName.data()[i]=='\\') break;
            }
            x.append(CurrentFolderName.data(),i);
            CurrentFolderName.clear();
            CurrentFolderName.append(x.data());
            ParentFolderID[ParentFolderIDNum-1].clear();
            ParentFolderIDNum--;
            CopyUnicode(FileFolderID0,FileFolderID);

            En = NULL;
            while (s->Phones->Current->FoldersCache.GetNext(&En)) {
                if (!wcscmp(En->Info.Info.ID.data(),FileFolderID)) {
                    Found = TRUE;
                    break;
                }
            }
            if (Found) {
                delete(En3);
                En3=En;
                break;
            }
            En3->Info.Info.SetID(FileFolderID);
            continue;
        } else {
            if (Dialog==NULL) {
                Dialog = new wxProgressDialog(CurrentFolderName.data(), "", 100, this, wxPD_APP_MODAL | wxPD_SMOOTH | wxPD_ELAPSED_TIME);
            }
        }
        Start2 = FALSE;
        if (error.Code == GSM_ERR_FOLDER_MORE) {
            sprintf(buff,"Reading folder content: %i",num++);
            Dialog->Pulse(buff,&skip);
            continue;
        }
        if (error.Code == GSM_ERR_FOLDER_PART) {
            wxMessageBox("There was read only folder part (it's phone firmware problem)",
                wxT("Error"),
                wxICON_WARNING | wxOK);
            break;
        }
        if (error.Code == GSM_ERR_EMPTY) break;
        if (error.Code != GSM_ERR_NONE) PrintError(error);
        break;
    }
    delete (Dialog);

    if (!Found) s->Phones->Current->FoldersCache.AddSubEntry(En3);

    return En3;
}

BOOLEAN PhoneFrm::EnterFolder()
{
    wchart                            x;
    wxProgressDialog                  *Dialog;
    bool                              skip;
    BOOLEAN                           Start2;
    wchar_t                           name[20];
    char                              buff[1000];
    GSM_MemoryType                    Mem;
    unsignedstring                    Buffer2;
    GSM_Error                         error;
    FileFolderInfo                    FInfo,*FInfo2;
    int                               i,num=0;
    GSM_FileFolderInfoListsSubEntry   *En;
    BOOLEAN                           Found = FALSE;
    
    En2 = NULL;
    while (s->Phones->Current->FoldersCache.GetNext(&En2)) {
        if (!wcscmp(En2->Info.Info.ID.data(),FileFolderID)) {
            Found = TRUE;
            break;
        }
    }
    
    if (!Found) {
        En2 = new GSM_FileFolderInfoListsSubEntry;
        if (ParentFolderIDNum == 1) {
            //root
            name[0] = 0;
            En2->Info.Info.SetID(name);
            En2->Info.SubEntryFullData = TRUE;
            
            while (true) {
                error = s->Phones->Current->GetNextRootFolderID(name,&Mem);
                if (error.Code == GSM_ERR_EMPTY) break;
                if (error.Code != GSM_ERR_MEMORY && error.Code != GSM_ERR_NONE) return FALSE;

                FInfo2 = new FileFolderInfo;
                if (Mem == MEM_PHONE) {
                        sprintf(buff,"Phone memory (%c%c)",UnicodeToStringReturn(name)[0],UnicodeToStringReturn(name)[1]);
                } else {
                        sprintf(buff,"Memory card (%c%c)",UnicodeToStringReturn(name)[0],UnicodeToStringReturn(name)[1]);
                }
                FInfo2->SetName(StringToUnicodeReturn(buff));
                FInfo2->Folder = TRUE;
                FInfo2->SetID(name);

                En2->Info.AddSubEntry(FInfo2);
            }
            s->Phones->Current->FoldersCache.AddSubEntry(En2);
        } else {
            En2 = GetFolderContent(FileFolderID);            
        }
    }

    DisplayFolder();

    return TRUE;
}

/*
 * FilesWxListCtrlItemActivated
 */
void PhoneFrm::FilesWxListCtrlItemActivated(wxListEvent& event)
{
    GSM_Error                       error;
    GSM_File                        ReadSaveFile;
    GSM_FileFolderInfoListSubEntry  *SubEntry;
    int                             i;
    wchart                          x;
    long                            item,item2;

    item = FilesWxListCtrl->GetNextItem(-1,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);
    item2 = FilesWxListCtrl->GetItemData(item);

    if (FilesWxListCtrl->GetItemText(item)== "..") {
        for (i=CurrentFolderName.length(); i > 0; i--) {
                if (CurrentFolderName.data()[i]=='\\') break;
        }
        x.append(CurrentFolderName.data(),i);
        CurrentFolderName.clear();
        CurrentFolderName.append(x.data());

        ParentFolderID[ParentFolderIDNum-1].clear();
        ParentFolderIDNum--;
        CopyUnicode((wchar_t *)ParentFolderID[ParentFolderIDNum-1].data(),FileFolderID);
        EnterFolder();
        return;
    }
 
    SubEntry = NULL;
    for (i=1;i<=item2;i++) En2->Info.GetNext(&SubEntry);
        
    CopyUnicode(FileFolderID,FileFolderID0);    
    CopyUnicode(SubEntry->Info.ID.data(),FileFolderID);
    if (SubEntry->Info.Folder) {
        CurrentFolderName.push_back('\\');        
        CurrentFolderName.append(SubEntry->Info.Name.data());                                
        ParentFolderID[ParentFolderIDNum].append(FileFolderID);
        ParentFolderIDNum++;
        EnterFolder();
        return;
    }

    ReadSaveFile.Info.Name.clear();
    ReadSaveFile.Info.Name.append(SubEntry->Info.Name.data(),UnicodeLength(SubEntry->Info.Name.data()));
    ReadSaveFile.Info.SetID(FileFolderID);
    if (!ReadOneFile(&ReadSaveFile)) return;
    parent->WxSaveFileDialog1->SetFilename(SubEntry->Info.Name.data());
    if (parent->WxSaveFileDialog1->ShowModal()!=wxID_OK) return;
    ReadSaveFile.SaveToDisk((char *)parent->WxSaveFileDialog1->GetPath().c_str());
}

BOOLEAN PhoneFrm::ReadOneFile(GSM_File *File)
{
    wxProgressDialog *Dialog;
    GSM_Error error;
    bool                            skip;
    
    Dialog = new wxProgressDialog("Reading file", File->Info.Name.data(), 100, this, wxPD_AUTO_HIDE | wxPD_APP_MODAL | wxPD_SMOOTH | wxPD_ELAPSED_TIME | wxPD_ESTIMATED_TIME | wxPD_REMAINING_TIME | wxPD_CAN_ABORT);
    while(true) {
        error = s->Phones->Current->GetFilePart(File);
        if (error.Code!=GSM_ERR_NONE) {
              PrintError(error);
              return FALSE;
        }

        if (!Dialog->Update((int)File->Buffer.size()*100/File->Info.Size,"",&skip)) {
            delete Dialog;
            return FALSE;
        }
        if (File->Info.Size == File->Buffer.size()) break;
    }
    delete Dialog;
    return TRUE;
}

/*
 * FilesGetWxButtonClick
 */
void PhoneFrm::FilesGetWxButtonClick(wxCommandEvent& event)
{
    s->Phones->Current->FoldersCache.ClearAll();
    EnterFolder();
}

/*
 * AddFileWxButtonClick
 */
void PhoneFrm::AddFileWxButtonClick(wxCommandEvent& event)
{
    GSM_File            File;
    FileFolderInfo      *FInfo2;

//    if (ParentFolderIDNum == 1) return;

    parent->WxOpenFileDialog1->SetMessage("Please select file for adding");
    if (parent->WxOpenFileDialog1->ShowModal()!=wxID_OK) return;

    if (!File.ReadFromDisk(StringToUnicodeReturn((char *)parent->WxOpenFileDialog1->GetPath().c_str()))) return;

	File.Info.SetID((wchar_t *)ParentFolderID[ParentFolderIDNum-1].data()); //parent folder
	File.Info.SetName((wchar_t *)((const wchar_t *)parent->WxOpenFileDialog1->GetFilename().wc_str(wxConvLibc)));

    UploadFile(&File);

    FInfo2 = new FileFolderInfo;
    FInfo2->SetName((wchar_t *)File.Info.Name.data());
    FInfo2->Folder = FALSE;
    FInfo2->SetID((wchar_t *)File.Info.ID.data());
    memcpy(&FInfo2->ModificationDateTime,&File.Info.ModificationDateTime,sizeof(GSM_DateTime));
    FInfo2->ModificationDateTimeAvailable = TRUE;
    FInfo2->Size = File.Info.Size;
    FInfo2->DRMForwardLock = File.Info.DRMForwardLock;
    FInfo2->ReadOnly = File.Info.ReadOnly;
    FInfo2->Hidden = File.Info.Hidden;
    FInfo2->System = File.Info.System;
    En2->Info.AddSubEntry(FInfo2);

    DisplayFolder();
}

bool PhoneFrm::UploadFile(GSM_File *File)
{
    wxProgressDialog    *Dialog;
	int 			    Pos = 0;
	bool                skip;
	GSM_Error           error;
    
    Dialog = new wxProgressDialog("Uploading file", File->Info.Name.data(), 100, this, wxPD_AUTO_HIDE | wxPD_APP_MODAL | wxPD_SMOOTH | wxPD_ELAPSED_TIME | wxPD_ESTIMATED_TIME | wxPD_REMAINING_TIME | wxPD_CAN_ABORT);
    while(true) {
		error = s->Phones->Current->AddFilePart(File,&Pos);
		if (error.Code == GSM_ERR_EMPTY) break;
		PrintError(error);

        if (!Dialog->Update(Pos*100/File->Info.Size,"",&skip)) {
//            delete Dialog;
//            return;
        }
    }
    delete Dialog;
    return TRUE;
}

//--------------------------------------------- phonebook -----------------------------------

bool FindPBKEntry(GSM_Backup *Backup, GSM_Backup_PBKEntry **PBKEntry, GSM_PBKSubEntry **SubEntry, int item1)
{
    int Num;

    *PBKEntry = NULL;
    Num = 0;
    while (Backup->GetNext_PBK(PBKEntry)) {
        *SubEntry = NULL;
        while ((*PBKEntry)->GetEntry()->GetNext(SubEntry)) {
            Num++;
            if (Num == item1) return true;
        }
    }
    return false;
}

typedef struct {
    GSM_Backup  *Backup;
    BOOLEAN     SortReverse;
    int         SortNum;
    wchart      *StatusStr2;    
} PBK_Sort;

int wxCALLBACK PBKUpWxListCtrlCompareFunction(long item1, long item2, long sortData)
{
    GSM_Backup_PBKEntry *PBKEntry, *PBKEntry2;
    GSM_PBKSubEntry     *SubEntry, *SubEntry2;
    int                 retval;
    time_t              One,Two;
    bool                found;
    wchar_t             buff[400],buff2[400],Last[400],First[400];
    PBK_Sort            *En = (PBK_Sort *)sortData;
    
    En->StatusStr2->clear();
    
    if (En->SortNum == 2) return 0; //number
//    if (En->SortNum == 3 && sortData<100) return 0; //date when no date available
    if (En->SortNum == 0) { //location
        En->StatusStr2->append(StringToUnicodeReturn(" sorted by location"));
        retval = 0;
        if (item1 < item2) retval = -1;
        if (item1 > item2) retval = 1;
        if (En->SortReverse) {
            retval = (-1)*retval;
            En->StatusStr2->append(StringToUnicodeReturn(" (reverse)"));
        }
        return retval;
    }
    if (En->SortNum == 1) { //name
        FindPBKEntry(En->Backup, &PBKEntry, &SubEntry, item1);
        Last[0] = 0;
        First[0] = 0;
        buff[0] = 0;
        SubEntry = NULL;
        while (PBKEntry->GetEntry()->GetNext(&SubEntry) == TRUE) {
            switch (SubEntry->GetType()) {
            case PBK_Text_Name: CopyUnicode(SubEntry->GetText(),buff); break;
            case PBK_Text_Name_First: CopyUnicode(SubEntry->GetText(),First); break;
            case PBK_Text_Name_Last: CopyUnicode(SubEntry->GetText(),Last); break;
            default: break;
            }
        }
        if (Last[0] != 0 || First[0] != 0) {
            CopyUnicode(Last,buff);
            buff[UnicodeLength(buff)+1] = 0;
            buff[UnicodeLength(buff)] = ' ';
            CopyUnicode(First,buff+UnicodeLength(buff));
        }
        if (buff[0] == 0) {
            found = false;
            SubEntry = NULL;
            while (PBKEntry->GetEntry()->GetNext(&SubEntry)) {
                switch (SubEntry->GetType()) {
                case PBK_Text_Phone_General:
                case PBK_Text_Phone_Mobile:
                case PBK_Text_Phone_Home:
                case PBK_Text_Phone_Work:
                case PBK_Text_Phone_Fax:
                    CopyUnicode(SubEntry->GetText(),buff);
                    found = true;
                    break;
                default:
                    break;
                }
                if (found) break;
            }
            if (!found) return -1;            
        }    

        FindPBKEntry(En->Backup, &PBKEntry2, &SubEntry2, item2);
        Last[0] = 0;
        First[0] = 0;
        buff2[0] = 0;
        SubEntry2 = NULL;
        while (PBKEntry2->GetEntry()->GetNext(&SubEntry2) == TRUE) {
            switch (SubEntry2->GetType()) {
            case PBK_Text_Name: CopyUnicode(SubEntry2->GetText(),buff2); break;
            case PBK_Text_Name_First: CopyUnicode(SubEntry2->GetText(),First); break;
            case PBK_Text_Name_Last: CopyUnicode(SubEntry2->GetText(),Last); break;
            default: break;
            }
        }
        if (Last[0] != 0 || First[0] != 0) {
            CopyUnicode(Last,buff2);
            buff2[UnicodeLength(buff2)+1] = 0;
            buff2[UnicodeLength(buff2)] = ' ';
            CopyUnicode(First,buff2+UnicodeLength(buff2));
        }
        if (buff2[0] == 0) {
            SubEntry2 = NULL;
            while (PBKEntry2->GetEntry()->GetNext(&SubEntry2)) {
                switch (SubEntry2->GetType()) {
                case PBK_Text_Phone_General:
                case PBK_Text_Phone_Mobile:
                case PBK_Text_Phone_Home:
                case PBK_Text_Phone_Work:
                case PBK_Text_Phone_Fax:
                    CopyUnicode(SubEntry2->GetText(),buff2);                    
                    found = true;
                    break;
                default:
                    break;
                }
                if (found) break;
            }
            if (!found) return 1;
        }

        retval = wcscoll(buff,buff2);
        if (retval == 0) {
            retval = -1;
            if (item1 > item2) retval = 1;
        }
        En->StatusStr2->append(StringToUnicodeReturn(" sorted by name, number, location"));
        if (En->SortReverse) {
            retval = (-1) * retval;
            En->StatusStr2->append(StringToUnicodeReturn(" (reverse)"));            
        }
        return retval;
    }
    //date & time
    FindPBKEntry(En->Backup, &PBKEntry, &SubEntry, item1);
    FindPBKEntry(En->Backup, &PBKEntry2, &SubEntry2, item2);

    One = GSMDateTime2TimeT(SubEntry->GetDateTime());
    Two = GSMDateTime2TimeT(SubEntry2->GetDateTime());
    retval = 0;
    if (One>Two) retval = 1;
    if (One<Two) retval = -1;
    En->StatusStr2->append(StringToUnicodeReturn(" sorted by time"));
    if (En->SortReverse) {
        retval = (-1)*retval;
        En->StatusStr2->append(StringToUnicodeReturn(" (reverse)"));
    }
    return retval;
}

BOOLEAN PhoneFrm::GetPbkMemories()
{
    BOOLEAN             Result = FALSE;
    GSM_PBKStatus       Status;
    GSM_Error           error;
    GSM_Backup_PBKEntry *PBKEntry;

    PbkWxEdit->Enable(FALSE);
    PbkSearchWxButton->Enable(FALSE);
    
    PBKWxComboBox->Clear();
    if (Phone) {
        Status.Memory = MEM_SIM;
        error = s->Phones->Current->GetPBKStatus(&Status);
        if (error.Code == GSM_ERR_NOT_SUPPORTED) return FALSE;
            
        PBKWxComboBox->Append("SIM phonebook");
        PBKMemoryNum[PBKMemoryLen]=MEM_SIM;
        PBKMemoryName[PBKMemoryLen].clear();
        PBKMemoryName[PBKMemoryLen].append(StringToUnicodeReturn("SIM phonebook"));
        PBKMemoryLen++;
    
        Status.Memory = MEM_PHONE;
        error = s->Phones->Current->GetPBKStatus(&Status);
        if (error.Code == GSM_ERR_NONE) {
            PBKWxComboBox->Append("Phone phonebook");
            PBKMemoryNum[PBKMemoryLen]=MEM_PHONE;
            PBKMemoryName[PBKMemoryLen].clear();
            PBKMemoryName[PBKMemoryLen].append(StringToUnicodeReturn("Phone phonebook"));
            PBKMemoryLen++;
        }
    
        Status.Memory = MEM_SIM_OWN;
        error = s->Phones->Current->GetPBKStatus(&Status);
        if (error.Code == GSM_ERR_NONE) {
            PBKWxComboBox->Append("Own numbers");
            PBKMemoryNum[PBKMemoryLen]=MEM_SIM_OWN;
            PBKMemoryName[PBKMemoryLen].clear();
            PBKMemoryName[PBKMemoryLen].append(StringToUnicodeReturn("Own numbers"));
            PBKMemoryLen++;
        }
    
        PBKWxComboBox->Append("Dialled calls");
        PBKMemoryNum[PBKMemoryLen]=MEM_PHONE_DIALLED;
        PBKMemoryName[PBKMemoryLen].clear();
        PBKMemoryName[PBKMemoryLen].append(StringToUnicodeReturn("Dialled calls"));
        PBKMemoryLen++;
    
        PBKWxComboBox->Append("Received calls");
        PBKMemoryNum[PBKMemoryLen]=MEM_PHONE_RECEIVED;
        PBKMemoryName[PBKMemoryLen].clear();
        PBKMemoryName[PBKMemoryLen].append(StringToUnicodeReturn("Received calls"));
        PBKMemoryLen++;
    
        PBKWxComboBox->Append("Missed calls");
        PBKMemoryNum[PBKMemoryLen]=MEM_PHONE_MISSED;
        PBKMemoryName[PBKMemoryLen].clear();
        PBKMemoryName[PBKMemoryLen].append(StringToUnicodeReturn("Missed calls"));
        PBKMemoryLen++;
    
        PBKWxComboBox->Append("Call logs (dialled + received + missed)");
        PBKMemoryNum[PBKMemoryLen]=MEM_Unknown;
        PBKMemoryName[PBKMemoryLen].clear();
        PBKMemoryName[PBKMemoryLen].append(StringToUnicodeReturn("Call logs (dialled + received + missed)"));
        PBKMemoryLen++;
    
//        Status.Memory = MEM_PHONE_SMS_LOGS;
//        error = s->Phones->Current->GetPBKStatus(&Status);
//        if (error.Code == GSM_ERR_NONE) {
//            PBKWxComboBox->Append("Sent SMS list");
//            PBKMemoryNum[PBKMemoryLen]=MEM_PHONE_SMS_LOGS;
//            PBKMemoryName[PBKMemoryLen].clear();
//            PBKMemoryName[PBKMemoryLen].append(StringToUnicodeReturn("Sent SMS list"));
//            PBKMemoryLen++;
//        }
        
        Result = TRUE;
        Backup->Delete_PBK();
    } else {
        PBKEntry = NULL;
        while (Backup->GetNext_PBK(&PBKEntry)) {
            if (PBKEntry->GetEntry()->Memory == MEM_SIM) {
                PBKWxComboBox->Append("SIM phonebook");
                PBKMemoryNum[PBKMemoryLen]=MEM_SIM;
                PBKMemoryName[PBKMemoryLen].clear();
                PBKMemoryName[PBKMemoryLen].append(StringToUnicodeReturn("SIM phonebook"));
                PBKMemoryLen++;
                Result = TRUE;
                break;                
            }
        }
        PBKEntry = NULL;
        while (Backup->GetNext_PBK(&PBKEntry)) {
            if (PBKEntry->GetEntry()->Memory == MEM_PHONE) {
                PBKWxComboBox->Append("Phone phonebook");
                PBKMemoryNum[PBKMemoryLen]=MEM_PHONE;
                PBKMemoryName[PBKMemoryLen].clear();
                PBKMemoryName[PBKMemoryLen].append(StringToUnicodeReturn("Phone phonebook"));
                PBKMemoryLen++;
                Result = TRUE;
                break;
            }
        }
        PbkGetWxButton->Show(FALSE);
    }
    
    PBKUpWxListCtrl->DeleteAllItems();
    PBKDownWxListCtrl->DeleteAllItems();

    SortPBKReverse=FALSE;

    return Result;
}

/*
 * PbkGetWxButtonClick
 */
void PhoneFrm::PbkGetWxButtonClick(wxCommandEvent& event)
{
    GetPbkMemories();
}

void PhoneFrm::ReadPBKMemory(GSM_MemoryType Mem)
{
    char                buff[100];
    GSM_Error           error;
    GSM_PBKStatus       Status;
    int                 i = 0,Pos=1;
    GSM_PBKEntry        *Entry;
    BOOLEAN             newe = TRUE;
    bool                skip;
    wxProgressDialog    *Dialog;
    wxString            Name;

    switch (Mem) {
    case MEM_PHONE:             Name = "phone phonebook";   break;
    case MEM_SIM:               Name = "SIM phonebook";     break;
    case MEM_SIM_OWN:           Name = "own numbers";       break;
    case MEM_PHONE_DIALLED:     Name = "dialled calls";     break;
    case MEM_PHONE_RECEIVED:    Name = "received calls";    break;
    case MEM_PHONE_MISSED:      Name="missed calls";        break;
    case MEM_PHONE_SMS_LOGS:    Name="sent SMS list";       break;    
    default: break;
    }
       
    switch (Mem) {
    case MEM_PHONE:
    case MEM_SIM:
    case MEM_SIM_OWN:
        Status.Memory = Mem;
        error = s->Phones->Current->GetPBKStatus(&Status);

        Dialog = new wxProgressDialog("Reading "+Name,"" , Status.Used, this, wxPD_AUTO_HIDE | wxPD_APP_MODAL | wxPD_SMOOTH | wxPD_ELAPSED_TIME | wxPD_ESTIMATED_TIME | wxPD_REMAINING_TIME | wxPD_CAN_ABORT);
        while (i!=Status.Used) {
            if (newe) {
                Entry = new GSM_PBKEntry;
                newe = false;
            }
            Entry->Location= Pos;
            Entry->Memory = Status.Memory;
            error = s->Phones->Current->GetPBK(Entry);
            Pos++;
            if (error.Code != GSM_ERR_NONE) continue;
            newe = true;
            i++;
            sprintf(buff,"%i %% (%i/%i)",i*100/Status.Used,i,Status.Used);
            Dialog->Update((int)i,buff,&skip);
            Backup->Add_PBK(Entry);
        }
        break;
    default: 
        Dialog = new wxProgressDialog("Reading "+Name, "", 100, this, wxPD_APP_MODAL | wxPD_SMOOTH | wxPD_ELAPSED_TIME);
        error.Code = GSM_ERR_NONE;
        while (error.Code != GSM_ERR_EMPTY) {
            if (newe) {
                Entry = new GSM_PBKEntry;
                newe = false;
            } else {
                Entry->ClearAll();
            }
            Entry->Location= Pos;
            Entry->Memory=Mem;
            error = s->Phones->Current->GetPBK(Entry);
            Pos++;
            if (error.Code != GSM_ERR_NONE) continue;
            sprintf(buff,"%i",Pos);
            Dialog->Pulse(buff,&skip);
            newe=true;
            Backup->Add_PBK(Entry);
        }
    }
    delete Dialog;   
}

void PhoneFrm::DisplayPBK(GSM_MemoryType Mem, long *PbkNum,long *ReceivedSec,long *DialledSec)
{
    GSM_PBKEntry        *Entry;
    GSM_Backup_PBKEntry *PBKEntry;
    wchar_t             buff[400],buff2[40];
    wchar_t             Last[400],First[400];
    char                buff3[200];
    char                buff0[40];
    long                tmp,Num2=0;
    GSM_PBKSubEntry     *SubEntry;
    time_t              DT1;
    GSM_DateTime        DT2;
    BOOLEAN             newe2,found2;
    wchart              Str;

    PBKEntry = NULL;
    while(Backup->GetNext_PBK(&PBKEntry)) {
        Entry = PBKEntry->GetEntry();
        if (Entry->Memory != Mem) {
            SubEntry = NULL;
            while (Entry->GetNext(&SubEntry)) Num2++;            
            continue;
        }
        
        if (PbkWxEdit->GetValue()!="") {
            found2 = false;
            SubEntry = NULL;
            while (Entry->GetNext(&SubEntry) == TRUE) {
                switch (SubEntry->GetType()) {
                case PBK_Text_Phone_General:
                case PBK_Text_Phone_Mobile:
                case PBK_Text_Phone_Home:
                case PBK_Text_Phone_Work:
                case PBK_Text_Phone_Fax:
                case PBK_Text_Email:
                case PBK_Text_URL:
                case PBK_Text_Postal:
                case PBK_Text_UserID:
                case PBK_Text_Note:
                case PBK_Text_Name:
                case PBK_Text_Name_First:
                case PBK_Text_Name_Last:
                    if (UnicodeCaseStr(SubEntry->GetText(),(const wchar_t *)PbkWxEdit->GetValue().wc_str(wxConvLibc))!=NULL) {
                        found2 = true;
                    }
                default:
                    break;
                }
                if (found2) break;
            }
            if (!found2) {
                SubEntry = NULL;
                switch (Mem) {
                case MEM_PHONE:
                case MEM_SIM:
                case MEM_SIM_OWN:
                    while (Entry->GetNext(&SubEntry) == TRUE) {
                        Num2++;
                    }
                    break;
                default:
                    while (Entry->GetNext(&SubEntry) == TRUE) {
                        Num2++;
                        if (SubEntry->GetType()!=PBK_DateTime_Call_Length) continue;
                    }
                    break;
                }
                continue;
            }
        }
        
        //find name
        Last[0] = 0;
        First[0] = 0;
        buff[0] = 0;
        SubEntry = NULL;
        while (Entry->GetNext(&SubEntry) == TRUE) {
            switch (SubEntry->GetType()) {
            case PBK_Text_Name:
                CopyUnicode(SubEntry->GetText(),buff);
                break;
            case PBK_Text_Name_First:
                CopyUnicode(SubEntry->GetText(),First);
                break;
            case PBK_Text_Name_Last:
                CopyUnicode(SubEntry->GetText(),Last);
                break;
            default:
                break;
            }
        }
        if (Last[0] != 0 || First[0] != 0) {
            CopyUnicode(Last,buff);
            buff[UnicodeLength(buff)+1] = 0;
            buff[UnicodeLength(buff)] = ' ';            
            CopyUnicode(First,buff+UnicodeLength(buff));
        }
         
        //display       
        switch (Mem) {
        case MEM_PHONE:
        case MEM_SIM:
        case MEM_SIM_OWN:
            sprintf(buff0,"%i",Entry->Location);
            tmp = PBKUpWxListCtrl->InsertItem((*PbkNum)++, buff0, 0);
            buff3[0] = 0;
            newe2 = true;
            SubEntry = NULL;
            while (Entry->GetNext(&SubEntry) == TRUE) {
                Num2++;                
                if (newe2) {
                    PBKUpWxListCtrl->SetItemData(tmp, Num2);
                    newe2 = false;
                }
            }
            SubEntry = NULL;
            while (Entry->GetNext(&SubEntry) == TRUE) {
                switch (SubEntry->GetType()) {
                case PBK_Text_Phone_General:
                    sprintf(buff3,"%s",UnicodeToStringReturn(SubEntry->GetText()));
                    break;
                case PBK_Text_Phone_Mobile:
                    sprintf(buff3,"%s (mobile)",UnicodeToStringReturn(SubEntry->GetText()));
                    break;
                case PBK_Text_Phone_Home:
                    sprintf(buff3,"%s (home)",UnicodeToStringReturn(SubEntry->GetText()));
                    break;
                case PBK_Text_Phone_Work:
                    sprintf(buff3,"%s (work)",UnicodeToStringReturn(SubEntry->GetText()));
                    break;
                case PBK_Text_Phone_Fax:
                    sprintf(buff3,"%s (fax)",UnicodeToStringReturn(SubEntry->GetText()));
                    break;
                default:
                    break;
                }
                if (buff3[0] != 0) break;
            }
            PBKUpWxListCtrl->SetItem(tmp, 1, buff);
            PBKUpWxListCtrl->SetItem(tmp, 2, buff3);
            PBKUpWxListCtrl->SetItem(tmp, 3, "");
            break;
        default:
            buff2[0] = 0;
            buff3[0] = 0;
            SubEntry = NULL;
            while (Entry->GetNext(&SubEntry) == TRUE) {
                switch (SubEntry->GetType()) {
                case PBK_Text_Phone_General:
                case PBK_Text_Phone_Mobile:
                case PBK_Text_Phone_Home:
                case PBK_Text_Phone_Work:
                case PBK_Text_Phone_Fax:
                    CopyUnicode(SubEntry->GetText(),buff2);
                    break;
                default:
                    break;
                }
            }
            SubEntry = NULL;
            newe2 = true;
            while (Entry->GetNext(&SubEntry) == TRUE) {
                Num2++;
                if (SubEntry->GetType()!=PBK_DateTime_Call_Length) continue;
                PrintDT(SubEntry->GetDateTime(), buff3);
                if (SubEntry->Length!=-1) {
                    if (Mem == MEM_PHONE_DIALLED) *DialledSec += SubEntry->Length;
                    if (Mem == MEM_PHONE_RECEIVED) *ReceivedSec += SubEntry->Length;
                    DT1 = GSMDateTime2TimeT(SubEntry->GetDateTime());
                    DT1 += SubEntry->Length;
                    memcpy(&DT2,&TimeT2GSMDateTime(&DT1),sizeof(GSM_DateTime));
                    sprintf(buff3+strlen(buff3)," - ");
                    PrintDT(&DT2, buff3+strlen(buff3));
                    sprintf(buff3+strlen(buff3)," (%02i:%02i:%02i)",
                            SubEntry->Length/(60*60),
                            SubEntry->Length/60,
                            SubEntry->Length%60);
                }

                buff0[0] = 0;
                if (Mem == MEM_PHONE_DIALLED) sprintf(buff0,"D ");
                if (Mem == MEM_PHONE_RECEIVED) sprintf(buff0,"R ");
                if (Mem == MEM_PHONE_MISSED) sprintf(buff0,"M ");
                sprintf(buff0+strlen(buff0),"%i",Entry->Location);
                tmp = PBKUpWxListCtrl->InsertItem((*PbkNum)++, buff0, 0);
                PBKUpWxListCtrl->SetItemData(tmp, Num2);
                PBKUpWxListCtrl->SetItem(tmp, 1, buff);
                PBKUpWxListCtrl->SetItem(tmp, 2, buff2);
                PBKUpWxListCtrl->SetItem(tmp, 3, buff3);
            }
            break;
        } 
    }
}

/*
 * PBKWxComboBoxSelected
 */
void PhoneFrm::PBKWxComboBoxSelected(wxCommandEvent& event )
{
    GSM_Error           error;
    long                PbkNum = 0, ReceivedSec=-1,DialledSec=-1,i;
    char                buff3[200];
    wxArrayString       choices;
    GSM_MemoryType      Mem,Mem2;
    BOOLEAN             Found = FALSE;
    GSM_Backup_PBKEntry *PBKEntry;
    PBK_Sort            Sort;

    StatusStr[FindPage("PhoneBook")].clear();

    PbkWxEdit->Enable(TRUE);
    PbkSearchWxButton->Enable(TRUE);
    PBKUpWxListCtrl->DeleteAllItems();
    PBKDownWxListCtrl->DeleteAllItems();
    
    for (i=0;i<PBKMemoryLen;i++) {
       if (!strcmp(PBKWxComboBox->GetString(PBKWxComboBox->GetSelection()),UnicodeToStringReturn(PBKMemoryName[i].data()))) {
            Mem = PBKMemoryNum[i];
            Mem2 = Mem;
            if (Mem == MEM_Unknown) {
                Mem = MEM_PHONE_DIALLED;
                Found = FALSE;
                PBKEntry = NULL;
                while(Backup->GetNext_PBK(&PBKEntry)) {
                    if (PBKEntry->GetEntry()->Memory == Mem) {
                        Found = TRUE;
                        break;
                    }
                }
                if (!Found) ReadPBKMemory(Mem);
                Mem = MEM_PHONE_RECEIVED;
                Found = FALSE;
                PBKEntry = NULL;
                while(Backup->GetNext_PBK(&PBKEntry)) {
                    if (PBKEntry->GetEntry()->Memory == Mem) {
                        Found = TRUE;
                        break;
                    }
                }
                if (!Found) ReadPBKMemory(Mem);
                Mem = MEM_PHONE_MISSED;
            }
            break;
       }
    }

    Found = FALSE;
    PBKEntry = NULL;
    while(Backup->GetNext_PBK(&PBKEntry)) {
        if (PBKEntry->GetEntry()->Memory == Mem) {
            Found = TRUE;
            break;
        }
    }
    if (!Found) ReadPBKMemory(Mem);

    Sort.Backup = Backup;
    Sort.SortReverse = SortPBKReverse;
    Sort.StatusStr2 = &StatusStr2[FindPage("PhoneBook")];
    
    PbkNum = 0;
    //display
    if (Mem2 == MEM_PHONE || Mem2 == MEM_SIM || 
        Mem2 == MEM_SIM_OWN || Mem2 == MEM_PHONE_SMS_LOGS) {
        DisplayPBK(Mem, &PbkNum, &ReceivedSec, &DialledSec);
        sprintf(buff3,"%i entries",PbkNum);
        StatusStr[FindPage("PhoneBook")].append(StringToUnicodeReturn(buff3));
        Sort.SortNum = 1;
        PBKUpWxListCtrl->SortItems(PBKUpWxListCtrlCompareFunction,(long)&Sort);
        parent->WxStatusBar1->SetStatusText(wxString(StatusStr[WxNotebook1->GetSelection()].data())+wxString(StatusStr2[WxNotebook1->GetSelection()].data()),0);
        return;
    }

    if (Mem2 == MEM_Unknown) {
        DisplayPBK(MEM_PHONE_DIALLED, &PbkNum, &ReceivedSec, &DialledSec);
        DisplayPBK(MEM_PHONE_RECEIVED, &PbkNum, &ReceivedSec, &DialledSec);
        DisplayPBK(MEM_PHONE_MISSED, &PbkNum, &ReceivedSec, &DialledSec);
    } else {
        DisplayPBK(Mem, &PbkNum, &ReceivedSec, &DialledSec);
    }

    sprintf(buff3,"%i entries",PbkNum);
    StatusStr[FindPage("PhoneBook")].append(StringToUnicodeReturn(buff3));
    if (DialledSec != -1) {
        sprintf(buff3," (dialled %02i:%02i:%02i",DialledSec/(60*60),DialledSec/60,DialledSec%60);
        StatusStr[FindPage("PhoneBook")].append(StringToUnicodeReturn(buff3));
    }
    if (ReceivedSec != -1) {
        if (DialledSec == -1) {
            sprintf(buff3," (");      
        } else {
            sprintf(buff3,", ");            
        }
        StatusStr[FindPage("PhoneBook")].append(StringToUnicodeReturn(buff3));
        sprintf(buff3,"received %02i:%02i:%02i",ReceivedSec/(60*60),ReceivedSec/60,ReceivedSec%60);
        StatusStr[FindPage("PhoneBook")].append(StringToUnicodeReturn(buff3));
    }
    if (DialledSec != -1 || ReceivedSec != -1) {    
        sprintf(buff3,")");
        StatusStr[FindPage("PhoneBook")].append(StringToUnicodeReturn(buff3));
    }
    Sort.SortNum = 3;
    PBKUpWxListCtrl->SortItems(PBKUpWxListCtrlCompareFunction,(long)&Sort);
    parent->WxStatusBar1->SetStatusText(wxString(StatusStr[WxNotebook1->GetSelection()].data())+wxString(StatusStr2[WxNotebook1->GetSelection()].data()),0);
}

void PhoneFrm::DecodePBKSubEntry(GSM_PBKSubEntry *SubEntry, char *type, wchar_t *Value, BOOLEAN *FirstNum)
{
    char buff[100];
    time_t                  DT1;
    GSM_DateTime            DT2;
        
    switch (SubEntry->GetType()) {
    case PBK_Text_Phone_General:
        sprintf(type,"General number");
        if ((*FirstNum)) sprintf(type+strlen(type)," (default)");
        (*FirstNum)=false;
        CopyUnicode(SubEntry->GetText(),Value);
        break;
    case PBK_Text_Phone_Mobile:
        sprintf(type,"Mobile number");
        if ((*FirstNum)) sprintf(type+strlen(type)," (default)");
        (*FirstNum)=false;
        CopyUnicode(SubEntry->GetText(),Value);
        break;
    case PBK_Text_Phone_Home:
        sprintf(type,"Home number");
        if ((*FirstNum)) sprintf(type+strlen(type)," (default)");
        (*FirstNum)=false;
        CopyUnicode(SubEntry->GetText(),Value);
        break;
    case PBK_Text_Phone_Work:
        sprintf(type,"Work number");
        if ((*FirstNum)) sprintf(type+strlen(type)," (default)");
        (*FirstNum)=false;
        CopyUnicode(SubEntry->GetText(),Value);
        break;
    case PBK_Text_Phone_Fax:
        sprintf(type,"Fax number");
        if ((*FirstNum)) sprintf(type+strlen(type)," (default)");
        (*FirstNum)=false;
        CopyUnicode(SubEntry->GetText(),Value);
        break;
    case PBK_Text_Postal:
        sprintf(type,"Postal address");
        CopyUnicode(SubEntry->GetText(),Value);
        break;
	case PBK_Text_Postal_Street:
        sprintf(type,"Street");
        CopyUnicode(SubEntry->GetText(),Value);
        break;
	case PBK_Text_Postal_City:
        sprintf(type,"City");
        CopyUnicode(SubEntry->GetText(),Value);
        break;
	case PBK_Text_Postal_State:
        sprintf(type,"State");
        CopyUnicode(SubEntry->GetText(),Value);
        break;
	case PBK_Text_Postal_ZIP_Code:
        sprintf(type,"ZIP code");
        CopyUnicode(SubEntry->GetText(),Value);
        break;
	case PBK_Text_Postal_Country:
        sprintf(type,"Country");
        CopyUnicode(SubEntry->GetText(),Value);
        break;
    case PBK_Text_Email:
        sprintf(type,"Email address");
        CopyUnicode(SubEntry->GetText(),Value);
        break;
    case PBK_Text_URL:
        sprintf(type,"URL link");
        CopyUnicode(SubEntry->GetText(),Value);
        break;
    case PBK_Text_UserID:
        sprintf(type,"User ID");
        CopyUnicode(SubEntry->GetText(),Value);
        break;
    case PBK_Text_Note:
        sprintf(type,"Note");
        CopyUnicode(SubEntry->GetText(),Value);
        break;
    case PBK_Text_Name:
        sprintf(type,"Name");
        CopyUnicode(SubEntry->GetText(),Value);
        break;
    case PBK_Text_Name_First:
        sprintf(type,"First name");
        CopyUnicode(SubEntry->GetText(),Value);
        break;
    case PBK_Text_Name_Last:
        sprintf(type,"Last name");
        CopyUnicode(SubEntry->GetText(),Value);
        break;
    case PBK_Text_PTT:
        sprintf(type,"Push To Talk address");
        CopyUnicode(SubEntry->GetText(),Value);
        break;
    case PBK_DateTime_Call_Length:
        sprintf(type,"Date & time");
        PrintDT(SubEntry->GetDateTime(), buff);
        if (SubEntry->Length!=-1) {
            DT1 = GSMDateTime2TimeT(SubEntry->GetDateTime());
            DT1 += SubEntry->Length;
            memcpy(&DT2,&TimeT2GSMDateTime(&DT1),sizeof(GSM_DateTime));
            sprintf(buff+strlen(buff)," - ");
            PrintDT(&DT2, buff+strlen(buff));
            sprintf(buff+strlen(buff)," (%02i:%02i:%02i)",
                    SubEntry->Length/(60*60),
                    SubEntry->Length/60,
                    SubEntry->Length%60);
        }
        StringToUnicode(buff,Value);
        break;
    default:
        break;
    }
}

/*
 * PBKUpWxListCtrlSelected
 */
void PhoneFrm::PBKUpWxListCtrlSelected(wxListEvent& event)
{
    GSM_Error               error;
    GSM_File                ReadSaveFile;
    GSM_PBKSubEntry         *SubEntry;
    int                     EntryNum=0;
    wchart                  x;
    long                    item,tmp;
    GSM_Backup_PBKEntry     *PBKEntry;
    char                    type[50],buff[100];
    wchar_t                 Value[500];
    time_t                  DT1;
    GSM_DateTime            DT2;
    boolean                 FirstNum = true;

    PBKDownWxListCtrl->DeleteAllItems();

    item = PBKUpWxListCtrl->GetNextItem(-1,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);
    item = PBKUpWxListCtrl->GetNextItem(item,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);
    if (item!=-1) return;

    item = PBKUpWxListCtrl->GetNextItem(-1,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);

    FindPBKEntry(Backup, &PBKEntry, &SubEntry, PBKUpWxListCtrl->GetItemData(item));

    tmp = PBKDownWxListCtrl->InsertItem(EntryNum++, "Location", 0);
    PBKDownWxListCtrl->SetItemData(tmp, 0);
    PBKDownWxListCtrl->SetItem(tmp, 1, PBKUpWxListCtrl->GetItemText(item));

    SubEntry = NULL;
    while (PBKEntry->GetEntry()->GetNext(&SubEntry)) {
        DecodePBKSubEntry(SubEntry, type, Value, &FirstNum);
        tmp = PBKDownWxListCtrl->InsertItem(EntryNum++, type, 0);
        PBKDownWxListCtrl->SetItemData(tmp, 0);
        PBKDownWxListCtrl->SetItem(tmp, 1, Value);
    }
}

/*
 * PBKUpWxListCtrlColLeftClick
 */
void PhoneFrm::PBKUpWxListCtrlColLeftClick(wxListEvent& event)
{
    PBK_Sort            Sort;
    GSM_Error           error;
    long                i;
    GSM_MemoryType      Mem;

    for (i=0;i<PBKMemoryLen;i++) {
       if (!strcmp(PBKWxComboBox->GetString(PBKWxComboBox->GetSelection()),UnicodeToStringReturn(PBKMemoryName[i].data()))) {
            Mem = PBKMemoryNum[i];
        }
    }
    Sort.Backup = Backup;
    Sort.SortReverse = SortPBKReverse;
    Sort.StatusStr2 = &StatusStr2[FindPage("PhoneBook")];
    Sort.SortNum = event.GetColumn();
    if (Mem == MEM_PHONE || Mem == MEM_SIM ||
        Mem == MEM_SIM_OWN || Mem == MEM_PHONE_SMS_LOGS) {
            if (Sort.SortNum==3) Sort.SortNum=2;
    }
    
    SortPBKReverse = !SortPBKReverse;
    PBKUpWxListCtrl->SortItems(PBKUpWxListCtrlCompareFunction,(long)&Sort);
    parent->WxStatusBar1->SetStatusText(wxString(StatusStr[WxNotebook1->GetSelection()].data())+wxString(StatusStr2[WxNotebook1->GetSelection()].data()),0);
}

/*
 * PbkSearchWxButtonClick
 */
void PhoneFrm::PbkSearchWxButtonClick(wxCommandEvent& event)
{
    PBKWxComboBoxSelected(event);
}

void PhoneFrm::FindNumber(wchar_t *Number)
{
    boolean                     wrong;
    wchar_t                     Buffer2[500],Last[500],First[500];
    GSM_Error                   error,preverror;
    char                        buff[200];
    GSM_MMSFile                 Entry2;
    boolean                     wasmore = false;
	BOOLEAN                     Found;
    GSM_PBKSubEntry             *PBKSubEntry;
    GSM_Backup_PBKEntry         *PBKEntry;


//	return;

    if (UnicodeLength(Number) == 0) return;

    Found = FALSE;
    PBKEntry = NULL;
    while(Backup->GetNext_PBK(&PBKEntry)) {
        if (PBKEntry->GetEntry()->Memory == MEM_PHONE) {
            Found = TRUE;
            break;
        }
    }
    if (!Found) {
//        if (FirstPBK) AddAllPBKMemories();
        ReadPBKMemory(MEM_PHONE);
    }

    buff[0]=0;
    Buffer2[0] = 0;
    PBKEntry = NULL;
    while (Backup->GetNext_PBK(&PBKEntry)) {
        if (PBKEntry->GetEntry()->Memory != MEM_PHONE) continue;

        PBKSubEntry = NULL;
        while (PBKEntry->GetEntry()->GetNext(&PBKSubEntry)) {
            switch (PBKSubEntry->GetType()) {
            case PBK_Text_Phone_General:
                if (UnicodeCaseCmp(PBKSubEntry->GetText(),Number,-1)) {
                    sprintf(buff,"general");
                }
                break;
            case PBK_Text_Phone_Mobile:
                if (UnicodeCaseCmp(PBKSubEntry->GetText(),Number,-1)) {
                    sprintf(buff,"mobile");
                }
                break;
            case PBK_Text_Phone_Home:
                if (UnicodeCaseCmp(PBKSubEntry->GetText(),Number,-1)) {
                    sprintf(buff,"home");
                }
                break;
            case PBK_Text_Phone_Work:
                if (UnicodeCaseCmp(PBKSubEntry->GetText(),Number,-1)) {
                    sprintf(buff,"work");
                }
                break;
            case PBK_Text_Phone_Fax:
                if (UnicodeCaseCmp(PBKSubEntry->GetText(),Number,-1)) {
                    sprintf(buff,"fax");
                }
                break;
            default:
                break;
            }
            if (buff[0] != 0) break;
        }
        if (buff[0] != 0) {
            Last[0] = 0;
            First[0] = 0;
            PBKSubEntry = NULL;
            while (PBKEntry->GetEntry()->GetNext(&PBKSubEntry) == TRUE) {
                switch (PBKSubEntry->GetType()) {
                case PBK_Text_Name: CopyUnicode(PBKSubEntry->GetText(),Buffer2); break;
                case PBK_Text_Name_First: CopyUnicode(PBKSubEntry->GetText(),First); break;
                case PBK_Text_Name_Last: CopyUnicode(PBKSubEntry->GetText(),Last); break;
                default: break;
                }
            }
            if (Last[0] != 0 || First[0] != 0) {
                CopyUnicode(Last,Buffer2);
                buff[UnicodeLength(Buffer2)+1] = 0;
                buff[UnicodeLength(Buffer2)] = ' ';
                CopyUnicode(First,Buffer2+UnicodeLength(Buffer2));
            }
            CopyUnicode(StringToUnicodeReturn(" ("),Buffer2+UnicodeLength(Buffer2));
            CopyUnicode(StringToUnicodeReturn(buff),Buffer2+UnicodeLength(Buffer2));
            CopyUnicode(StringToUnicodeReturn(", "),Buffer2+UnicodeLength(Buffer2));
            CopyUnicode(Number,Buffer2+UnicodeLength(Buffer2));
            CopyUnicode(StringToUnicodeReturn(")"),Buffer2+UnicodeLength(Buffer2));
            CopyUnicode(Buffer2,Number);
            return;
        }
    }
}

// ------------------------ sms, mms ------------------------------------------

BOOLEAN PhoneFrm::ReadSMSMMSFolders(BOOLEAN SMS)
{
    BOOLEAN                    RetVal=FALSE;
    GSM_SMSMMSFoldersSubEntry  *SubFolder;
    GSM_Error                  error,preverror;
    char                       buff[200];
    int                        FolderMax=0;

    ReadSMSMMS.clear();
    
    SMSFolders.ClearAll();
    error = s->Phones->Current->GetSMSMMSFolders(&SMSFolders);
    PrintError(error);
    FolderMax = 0;
    SubFolder = NULL;
    while (SMSFolders.GetNext(&SubFolder) == TRUE) FolderMax ++;

    if (SMS || FirstSMS) {
        Backup->Delete_SMS();
        SMSWxComboBox->Clear();
        SMSUpWxListCtrl->DeleteAllItems();
        SMSDetailsWxListCtrl->DeleteAllItems();
        SMSWxComboBox->Append("(all SMS folders)");
    }
    if (!SMS || FirstMMS) {
        Backup->Delete_MMS();
        MMSWxComboBox->Clear();
//        MMSUpWxListCtrl->DeleteAllItems();
//        MMSDetailsWxListCtrl->DeleteAllItems();
        MMSWxComboBox->Append("(all MMS folders)");
    }

    SubFolder = NULL;
    while (SMSFolders.GetNext(&SubFolder) == TRUE) {
        buff[0] = 0;
        if (SubFolder->MMS) {
            if (!SMS || FirstMMS) {
                if (SubFolder->Memory == MEM_PHONE) sprintf(buff,"%s (phone)",UnicodeToStringReturn(SubFolder->GetName()));
                MMSWxComboBox->Append(buff);
                RetVal=TRUE;
            }
        } else {
            if (SMS || FirstSMS) {
                if (SubFolder->Memory == MEM_PHONE) sprintf(buff,"%s (phone)",UnicodeToStringReturn(SubFolder->GetName()));
                if (SubFolder->Memory == MEM_SIM) sprintf(buff,"%s (SIM)",UnicodeToStringReturn(SubFolder->GetName()));
                SMSWxComboBox->Append(buff);
                RetVal=TRUE;
            }
        }
    }
    FirstSMS = FALSE;
    FirstMMS = FALSE;
    return RetVal;
}

BOOLEAN PhoneFrm::ReadSMSMMSFolder(int Num2, GSM_SMSMMSFoldersSubEntry *SubFolder)
{
    bool                        skip;
    wxProgressDialog            *Dialog = NULL;
    GSM_Backup_SMSEntry         *En;
    GSM_Backup_MMSEntry         *En2;
    int                         i = 1, mmsfiles=0;
    int                         opernum=1;
    int                         Current, MaxInFolder;
    GSM_Error                   error,preverror;
    char                        buff[200];
    GSM_SMSList                 *Entry;
    GSM_MMSFile                 *Entry2;
    boolean                     wasmore = false;
    int                         EntryNum=0,Entry2Num=0;
    BOOLEAN                     start = TRUE, found=FALSE,BigBreak=FALSE;

    if (FindPage("SMS")!=-1) {
           SMSDetailsWxListCtrl->DeleteAllItems();
            SMSTextWxMemo->Clear();
            SMSNumbersWxListBox->Clear();
            SMSNumbersWxListBox->SetSizeHints(300,0);
            WxBoxSizer4->Layout();
    }
    if (FindPage("MMS")!=-1) {
    }


    for (i=0;i<ReadSMSMMS.size();i++) {
        if (ReadSMSMMS.data()[i] == Num2) {
            start = FALSE;
            break;
        }
    }

    if (start) {
        if (SubFolder->FileSystem) found = FALSE;
        if (SubFolder->MMS) opernum++;
        i = 0;
        preverror.Code = GSM_ERR_UNKNOWN;
        Entry = new GSM_SMSList;
        Entry2 = new GSM_MMSFile;
        while (true) {
            error = s->Phones->Current->GetNextSMSMMSIDFromFolder(start, SubFolder,Entry,Entry2,&Current, &MaxInFolder);
            if (error.Code == GSM_ERR_EMPTY) break;
            start = FALSE;
            if (error.Code == GSM_ERR_FOLDER_MORE) {
                if (Dialog == NULL) {
                    if (SubFolder->MMS) {
                        sprintf(buff,"Reading from '%s' MMS folder",UnicodeToStringReturn(SubFolder->GetName()));
                    } else {
                        sprintf(buff,"Reading from '%s' SMS folder",UnicodeToStringReturn(SubFolder->GetName()));
                    }
                    Dialog = new wxProgressDialog(buff, "", 100, this, wxPD_APP_MODAL | wxPD_SMOOTH | wxPD_ELAPSED_TIME);
                    opernum++;
                }
                i++;
                sprintf(buff,"Part 1/2 - reading folder content: %i",i);
                Dialog->Pulse(buff,&skip);
                wasmore = TRUE;
                continue;
            }
            if (wasmore) {
                wasmore = FALSE;
                delete(Dialog);
                Dialog = NULL;
            }
            if (error.Code == GSM_ERR_FOLDER_PART) {
                wxMessageBox("There was read only folder part (it's phone firmware problem)",
                        wxT("Error"),
                        wxICON_WARNING | wxOK);
                continue;
            }
            PrintError(error);

            if (Dialog == NULL) {
                if (SubFolder->MMS) {
                    sprintf(buff,"Reading from '%s' MMS folder",UnicodeToStringReturn(SubFolder->GetName()));
                } else {
                    sprintf(buff,"Reading from '%s' SMS folder",UnicodeToStringReturn(SubFolder->GetName()));
                }
                Dialog = new wxProgressDialog(buff, "", MaxInFolder, this, wxPD_AUTO_HIDE | wxPD_APP_MODAL | wxPD_SMOOTH | wxPD_ELAPSED_TIME | wxPD_ESTIMATED_TIME | wxPD_REMAINING_TIME | wxPD_CAN_ABORT);
            } else {
                if (SubFolder->MMS) {
                    sprintf(buff,"Part %i/%i - reading MMS info: %i %% (%i/%i)",2,opernum,Current*100/MaxInFolder,Current,MaxInFolder);
                } else {
                    sprintf(buff,"Part %i/%i - reading SMS: %i %% (%i/%i)",opernum,opernum,Current*100/MaxInFolder,Current,MaxInFolder);
                }
                //fixme
                if (!Dialog->Update((int)Current,buff,&skip)) {
                    BigBreak = TRUE;
                    break;
                }
            }
    		if (Entry->Folder == 0) {
                if (!SubFolder->MMS) {
                    if (Entry2Num==0) {
                        Entry2Num = -1;
                        En2 = NULL;
                        while (Backup->GetNext_MMS(&En2)) {
                            if (En2->GetEntry()->Folder==Entry2->Folder) {
                                Entry2Num = Entry2->Folder;
                                break;
                            }
                        }
                    }
                } else {
                    Entry2Num = -1;
                }
                if (Entry2Num < 0) {
                    Backup->Add_MMS(Entry2);
                } else {
                    delete (Entry2);
                }
                Entry2 = new GSM_MMSFile;
            } else {
                if (SubFolder->MMS) {
                    if (EntryNum==0) {
                        EntryNum = -1;
                        En = NULL;
                        while (Backup->GetNext_SMS(&En)) {
                            if (En->GetEntry()->Folder==Entry->Folder) {
                                EntryNum = Entry->Folder;
                                break;
                            }
                        }
                    }
                } else {
                    EntryNum = -1;
                }
                if (EntryNum < 0) {
                    Backup->Add_SMS(Entry);
                } else {
                    delete (Entry);
                }
                Entry = new GSM_SMSList;
            }
        }
        delete (Dialog);
        delete (Entry);
        delete (Entry2);
        start = TRUE;
        if (EntryNum<0) {
            Dialog = new wxProgressDialog("Linking SMS", "", 100, this, wxPD_APP_MODAL | wxPD_SMOOTH | wxPD_ELAPSED_TIME);
            Backup->LinkSMS();
            delete (Dialog);
        }
        if (SubFolder->FileSystem && !found) {
//            Folders.AddSubEntry(En4);
        }
    }
    if (!BigBreak) {
        ReadSMSMMS.push_back(SubFolder->Number);
        if (SubFolder->OtherNumber != -1) ReadSMSMMS.push_back(SubFolder->OtherNumber);
    }    
    if (SubFolder->MMS) {
        mmsfiles = 0;
        En2 = NULL;
        while (Backup->GetNext_MMS(&En2)) {
            if (En2->GetEntry()->Folder!=Num2) continue;
            if (En2->GetEntry()->File.Buffer.size()==0) mmsfiles++;
        }
        if (mmsfiles != 0) {
            sprintf(buff,"Reading from '%s' MMS folder",UnicodeToStringReturn(SubFolder->GetName()));
            Dialog = new wxProgressDialog(buff, "", mmsfiles*100, this, wxPD_AUTO_HIDE | wxPD_APP_MODAL | wxPD_SMOOTH | wxPD_ELAPSED_TIME | wxPD_ESTIMATED_TIME | wxPD_REMAINING_TIME | wxPD_CAN_ABORT);
            En2 = NULL;
            i=0;
            while (Backup->GetNext_MMS(&En2)) {
                if (En2->GetEntry()->Folder!=Num2) continue;
//                if (En2->GetEntry()->File.Buffer.size()!=0) continue;
                while(true) {
                    error = s->Phones->Current->GetMMSFilePart(&En2->GetEntry()->File);
                    if (error.Code!=GSM_ERR_NONE) {
                          PrintError(error);
                    }
                    sprintf(buff,"Part %i/%i - reading MMS files: %i %% (%i/%i)",3,opernum,(i*100+En2->GetEntry()->File.Buffer.size()*100/En2->GetEntry()->File.Info.Size)*100/(mmsfiles*100),i+1,mmsfiles);
                    Dialog->Update((int)(i*100+En2->GetEntry()->File.Buffer.size()*100/En2->GetEntry()->File.Info.Size),buff,&skip);

                    if (En2->GetEntry()->File.Info.Size == En2->GetEntry()->File.Buffer.size()) break;
                }
                i++;
            }
            delete (Dialog);
        }
    }

    return start;
}

// ---------------------------------------- sms -----------------------------------------

bool FindSMSEntry(GSM_Backup *Backup, GSM_Backup_SMSEntry **SMSEntry, int item1)
{
    int EntryNum=0;

    *SMSEntry = NULL;
    while (Backup->GetNext_SMS(SMSEntry)) {
        EntryNum++;
        if (EntryNum==item1) return true;
    }
    return false;
}

typedef struct {
    GSM_Backup *Backup;
    BOOLEAN SortReverse;
    int SortNum;
    wchart *StatusStr2;
} SMS_Sort;

int wxCALLBACK SMSUpWxListCtrlCompareFunction(long item1, long item2, long sortData)
{
    int                         retval;
    time_t                      One,Two;
    GSM_Backup_SMSEntry         *En,*En2;
    GSM_SMSListSubEntry         *SubEntry,*SubEntry2;
    GSM_DateTime                DT,DT2;
    SMS_Sort                    *En3 = (SMS_Sort *)sortData;
    
    FindSMSEntry(En3->Backup, &En, item1);
    SubEntry=NULL;
    En->GetEntry()->GetNext(&SubEntry);
    FindSMSEntry(En3->Backup, &En2, item2);
    SubEntry2=NULL;
    En2->GetEntry()->GetNext(&SubEntry2);    
    if (SubEntry->GetSMS()->GetType()==SMS_Submit) {
       if (SubEntry2->GetSMS()->GetType()==SMS_Submit) return 0;
       return 1;        
    }
    if (SubEntry2->GetSMS()->GetType()==SMS_Submit) {
       return -11;
    }

    SubEntry->GetSMS()->GetDateTime(&DT);
    SubEntry2->GetSMS()->GetDateTime(&DT2);

    One = GSMDateTime2TimeT(&DT);
    Two = GSMDateTime2TimeT(&DT2);
    retval = 0;
    if (One>Two) retval = 1;
    if (One<Two) retval = -1;
    En3->StatusStr2->clear();
    En3->StatusStr2->append(StringToUnicodeReturn(" sorted by time"));
//    if (SortPBKReverse) {
//        retval = (-1)*retval;
//        StatusStr2[0].append(StringToUnicodeReturn(" (reverse)"));
//    }
    return retval;
}

/*
 * SMSGetWxButtonClick
 */
void PhoneFrm::SMSGetWxButtonClick(wxCommandEvent& event)
{
    ReadSMSMMSFolders(TRUE);
    SMSWxEdit->Enable(FALSE);
    SMSSearchWxButton->Enable(FALSE);
}

void PhoneFrm::ClearSMSView()
{
    SMSDetailsWxListCtrl->DeleteAllItems();
    SMSTextWxMemo->Clear();
    SMSNumbersWxListBox->Clear();
    SMSNumbersWxListBox->SetSizeHints(300,0*15);
    WxBoxSizer4->Layout();

}

void PhoneFrm::DisplaySMSFolder()
{
    GSM_Backup_SMSEntry         *En;
    GSM_SMSListSubEntry         *SubEntry;
    GSM_SMSEntry                *SMS;
    boolean                     wrong;
    wchar_t                     Buffer[500];
    long                        tmp;
    int                         i = 1,j;
    int                         EntryNum = 0, Num, Num2, EntryNum2 = 0;
	int                         SequencesNum=0,PartsNum=0;
    GSM_DateTime                DT;
    GSM_SMSMMSFoldersSubEntry   *SubFolder;
    GSM_Error                   error,preverror;
    char                        buff[200];
    GSM_MMSFile                 Entry2;
    boolean                     wasmore = false;
	GSM_SMSNumbersSubEntry      *Number;
	BOOLEAN                     was = FALSE, Found2;
	SMS_Sort                    Sort;
	wchart                      SMSTextSearch;

    SMSUpWxListCtrl->DeleteAllItems();
    ClearSMSView();

    if (SMSWxComboBox->GetSelection()==0) {
        Num2=0;
        SubFolder = NULL;
        while (SMSFolders.GetNext(&SubFolder)) {
            Num2++;
            if (SubFolder->MMS) continue;
            if (!was) {
                was = ReadSMSMMSFolder(Num2,SubFolder);
            } else {
                ReadSMSMMSFolder(Num2,SubFolder);
            }
        }
    } else {
        Num = 0;
        Num2=0;
        SubFolder = NULL;
        while (Num!=SMSWxComboBox->GetSelection()) {
            SMSFolders.GetNext(&SubFolder);
            Num2++;
            if (SubFolder->MMS) continue;
            Num++;
        }
        was = ReadSMSMMSFolder(Num2,SubFolder);
    }

    En = NULL;
    while (Backup->GetNext_SMS(&En)) {
        EntryNum2++;
        wrong = false;
        SubEntry = NULL;
        if (!En->GetEntry()->GetNext(&SubEntry)) continue;
        if (SMSWxComboBox->GetSelection()!=0) {
            if (En->GetEntry()->Folder != Num2) {
                continue;
            }
        }
        if (SMSWxEdit->GetValue()!="") {
            Found2 = FALSE;
            SMSTextSearch.clear();
            SubEntry = NULL;
            while (En->GetEntry()->GetNext(&SubEntry)) {
                SMS = SubEntry->GetSMS();

        		Number = NULL;
        		while (SMS->PhoneNumbers.GetNext(&Number)) {
        			error = Number->GetPhoneNumber(Buffer);
                    PrintError(error);
                    if (UnicodeLength(Buffer)!=0) {
                        FindNumber(Buffer);
                        if (UnicodeCaseStr((const wchar_t *)Buffer,(const wchar_t *)SMSWxEdit->GetValue().wc_str(wxConvLibc))!=NULL) {
                            Found2=TRUE;
                            break;
                        }
                    }
                }

                if (Found2) break;
                switch (SMS->GetCoding()) {
                case SMS_Coding_Unicode_No_Compression:
                case SMS_Coding_Default_No_Compression:
                    error = SMS->GetDecodedText(Buffer);
                    PrintError(error);
                    FixBuffer(Buffer);
                    SMSTextSearch.append(Buffer);
                    break;
                default:
                    break;
                }
            }
            if (!Found2 && UnicodeCaseStr(SMSTextSearch.data(),
                        (const wchar_t *)SMSWxEdit->GetValue().wc_str(wxConvLibc))!=NULL) {
                Found2=TRUE;
            }
            if (!Found2) continue;
            SubEntry = NULL;
            if (!En->GetEntry()->GetNext(&SubEntry)) continue;
        }
        SequencesNum++;
        PartsNum++;

        SMS = SubEntry->GetSMS();
        if (SMS->GetType()!=SMS_Submit) {
            SMS->GetDateTime(&DT);
            PrintDT(&DT, buff);
            StringToUnicode(buff,Buffer);
            tmp = SMSUpWxListCtrl->InsertItem(EntryNum++, Buffer, 0);
        } else {
            tmp = SMSUpWxListCtrl->InsertItem(EntryNum++, "", 0);
        }
        SMSUpWxListCtrl->SetItemData(tmp, EntryNum2);
        j=0;
		Number = NULL;
		while (SMS->PhoneNumbers.GetNext(&Number)) j++;
		if (j>1) {
            SMSUpWxListCtrl->SetItem(tmp, 1, "(many recipients)");
            PartsNum+=j-1;
            SequencesNum+=j-1;
        } else if (j==1) {
    		Number = NULL;
    		SMS->PhoneNumbers.GetNext(&Number);
            Number->GetPhoneNumber(Buffer);
            FindNumber(Buffer);
            SMSUpWxListCtrl->SetItem(tmp, 1, Buffer);
        } else {
            Buffer[0] = 0;
            SMSUpWxListCtrl->SetItem(tmp, 1, Buffer);
        }

        if (SMS->GetType()!=SMS_Report && (SMS->GetCoding()==SMS_Coding_Unicode_No_Compression || SMS->GetCoding()==SMS_Coding_Default_No_Compression)) {
            SMS->GetDecodedText(Buffer);
            FixBuffer(Buffer);
            SMSUpWxListCtrl->SetItem(tmp, 2, Buffer);
        } else {
            SMSUpWxListCtrl->SetItem(tmp, 2, "");
        }
        i=0;
        SubEntry=NULL;
        while (En->GetEntry()->GetNext(&SubEntry)) i++;
        if (i>1) PartsNum+=i-1;
        sprintf(buff,"%i",i);
        StringToUnicode(buff,Buffer);
        SMSUpWxListCtrl->SetItem(tmp, 3, Buffer);
    }

    sprintf(buff,"%i parts in %i sequences",PartsNum,SequencesNum);
    StatusStr[FindPage("SMS")].clear();
    StatusStr[FindPage("SMS")].append(StringToUnicodeReturn(buff));
    parent->WxStatusBar1->SetStatusText(wxString(StatusStr[WxNotebook1->GetSelection()].data())+wxString(StatusStr2[WxNotebook1->GetSelection()].data()),0);

    Sort.Backup = Backup;
//    Sort.SortReverse = SortPBKReverse;
    Sort.StatusStr2 = &StatusStr2[FindPage("SMS")];
    SMSUpWxListCtrl->SortItems(SMSUpWxListCtrlCompareFunction,(long)&Sort);
}

/*
 * SMSWxComboBoxSelected
 */
void PhoneFrm::SMSWxComboBoxSelected(wxCommandEvent& event )
{
    DisplaySMSFolder();
    SMSWxEdit->Enable(TRUE);
    SMSSearchWxButton->Enable(TRUE);
}

/*
 * SMSUpWxListCtrlSelected
 */
void PhoneFrm::SMSUpWxListCtrlSelected(wxListEvent& event)
{
    GSM_Error                   error;
    GSM_File                    ReadSaveFile;
    int                         EntryNum=0,j,NumbersNum=0,Parts=-1,PartNum=-1;
    wchart                      x;
    long                        item,tmp;
    GSM_Backup_SMSEntry         *En;
    GSM_SMSListSubEntry         *SubEntry;
    GSM_SMSEntry                *SMS;
    boolean                     wrong,display;
    wchar_t                     Buffer[500];
    char                        buff[200];
    GSM_DateTime                DT;
    unsignedstring              UDH;
    UDHList                     UDH2;
	GSM_SMSNumbersSubEntry      *Number;
    BOOLEAN                     FirstEntry;

    ClearSMSView();
    
    item = SMSUpWxListCtrl->GetNextItem(-1,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);
    item = SMSUpWxListCtrl->GetNextItem(item,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);
    if (item!=-1) return;

    item = SMSUpWxListCtrl->GetNextItem(-1,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);

    FindSMSEntry(Backup, &En, SMSUpWxListCtrl->GetItemData(item));

    FirstEntry = TRUE;
    SubEntry = NULL;
    while (En->GetEntry()->GetNext(&SubEntry)) {
        SMS = SubEntry->GetSMS();
        switch (SMS->GetType()) {
        case SMS_Deliver:
            tmp = SMSDetailsWxListCtrl->InsertItem(EntryNum++, "SMS Deliver", 0);
            SMSDetailsWxListCtrl->SetItemData(tmp, 0);

            error = SMS->GetSMSCNumber(Buffer);
            PrintError(error);
            if (UnicodeLength(Buffer)!=0) {
                tmp = SMSDetailsWxListCtrl->InsertItem(EntryNum++, "   SMSC Number", 0);
                SMSDetailsWxListCtrl->SetItemData(tmp, 0);
                SMSDetailsWxListCtrl->SetItem(tmp, 1, UnicodeToStringReturn(Buffer));
            }

            SMS->GetDateTime(&DT);
            tmp = SMSDetailsWxListCtrl->InsertItem(EntryNum++, "   Sending date & time", 0);
            SMSDetailsWxListCtrl->SetItemData(tmp, 0);
            PrintDT(&DT, buff);
            SMSDetailsWxListCtrl->SetItem(tmp, 1, buff);
            /* no break */
        case SMS_Submit:
            if (SMS->GetType() == SMS_Submit) {
                tmp = SMSDetailsWxListCtrl->InsertItem(EntryNum++, "SMS Submit", 0);
                SMSDetailsWxListCtrl->SetItemData(tmp, 0);
            }
    		Number = NULL;
    		while (SMS->PhoneNumbers.GetNext(&Number)) {
    			error = Number->GetPhoneNumber(Buffer);
                PrintError(error);
                if (UnicodeLength(Buffer)!=0) {
                    tmp = SMSDetailsWxListCtrl->InsertItem(EntryNum++, "   Phone number", 0);
                    SMSDetailsWxListCtrl->SetItemData(tmp, 0);
                    FindNumber(Buffer);
                    SMSDetailsWxListCtrl->SetItem(tmp, 1, Buffer);
                    if (FirstEntry) {
                        SMSNumbersWxListBox->Append(Buffer);
                        NumbersNum++;
                    }
                }
            }
            if (SMS->GetClass() != -1) {
                tmp = SMSDetailsWxListCtrl->InsertItem(EntryNum++, "   SMS class", 0);
                sprintf(buff,"%i",SMS->GetClass());
                SMSDetailsWxListCtrl->SetItemData(tmp, 0);
                SMSDetailsWxListCtrl->SetItem(tmp, 1, buff);
            }
            if (SMS->SenderSMSCReply() == TRUE) {
                tmp = SMSDetailsWxListCtrl->InsertItem(EntryNum++, "   SMSC reply", 0);
                SMSDetailsWxListCtrl->SetItemData(tmp, 0);
                SMSDetailsWxListCtrl->SetItem(tmp, 1, "yes");
            }

            error = SMS->GetUDH(&UDH);
            PrintError(error);
            if (UDH.size()!=0) {
                error = SMS->DecodeUDH(&UDH2);
                if (error.Code == GSM_ERR_NONE) {
                    for (j=0;j<UDH2.size();j++) {
                        tmp = SMSDetailsWxListCtrl->InsertItem(EntryNum++, "   UDH", 0);
                        switch (UDH2.data()[j].Type) {
                        case SMS_UDH_Linked_Short:
                            sprintf(buff,"linked (short, ID %i, part %i/%i)",UDH2.data()[j].ID8bit,UDH2.data()[j].PartNumber8bit,UDH2.data()[j].AllParts8bit);
                            SMSDetailsWxListCtrl->SetItemData(tmp, 0);
                            SMSDetailsWxListCtrl->SetItem(tmp, 1, buff);
                            if (FirstEntry && UDH2.data()[j].PartNumber8bit!=1) {
                                SMSTextWxMemo->AppendText("(PART MISSED) ");
                            }
                            Parts = UDH2.data()[j].AllParts8bit;
                            PartNum = UDH2.data()[j].PartNumber8bit;
                            break;
                        case SMS_UDH_Linked_Long:
                            sprintf(buff,"linked (long, ID %i, part %i/%i)",UDH2.data()[j].ID16bit,UDH2.data()[j].PartNumber8bit,UDH2.data()[j].AllParts8bit);
                            SMSDetailsWxListCtrl->SetItemData(tmp, 0);
                            SMSDetailsWxListCtrl->SetItem(tmp, 1, buff);
                            if (FirstEntry && UDH2.data()[j].PartNumber8bit!=1) {
                                SMSTextWxMemo->AppendText("(PART MISSED) ");
                            }
                            Parts = UDH2.data()[j].AllParts8bit;
                            PartNum = UDH2.data()[j].PartNumber8bit;
                            break;
                        default:
                            break;
                        }
                    }
                }
            }

            tmp = SMSDetailsWxListCtrl->InsertItem(EntryNum++, "   Coding", 0);
            SMSDetailsWxListCtrl->SetItemData(tmp, 0);
            switch (SMS->GetCoding()) {
            case SMS_Coding_Unicode_No_Compression:
                SMSDetailsWxListCtrl->SetItem(tmp, 1, "Unicode, no compression");
                error = SMS->GetDecodedText(Buffer);
                PrintError(error);
                tmp = SMSDetailsWxListCtrl->InsertItem(EntryNum++, "   Text", 0);
                SMSDetailsWxListCtrl->SetItemData(tmp, 0);
                FixBuffer(Buffer);
                SMSTextWxMemo->AppendText(Buffer);
                SMSDetailsWxListCtrl->SetItem(tmp, 1, Buffer);
                break;
            case SMS_Coding_Unicode_Compression:
                SMSDetailsWxListCtrl->SetItem(tmp, 1, "Unicode, compression, no support from Gammu+ now");
                break;
            case SMS_Coding_Default_No_Compression:
                SMSDetailsWxListCtrl->SetItem(tmp, 1, "Default, no compression");
                error = SMS->GetDecodedText(Buffer);
                PrintError(error);
                tmp = SMSDetailsWxListCtrl->InsertItem(EntryNum++, "   Text", 0);
                SMSDetailsWxListCtrl->SetItemData(tmp, 0);
                FixBuffer(Buffer);
                SMSTextWxMemo->AppendText(Buffer);
                SMSDetailsWxListCtrl->SetItem(tmp, 1, Buffer);
                break;
            case SMS_Coding_Default_Compression:
                SMSDetailsWxListCtrl->SetItem(tmp, 1, "Default, compression, no support from Gammu+ now");
                break;
            case SMS_Coding_8bit:
                SMSDetailsWxListCtrl->SetItem(tmp, 1, "8 bit");
                break;
            }
            break;
        case SMS_Report:
            tmp = SMSDetailsWxListCtrl->InsertItem(EntryNum++, "SMS report", 0);
        }
        FirstEntry = FALSE;
    }
    if (Parts != -1 && Parts != PartNum) {
        SMSTextWxMemo->AppendText(" (PART MISSED)");
    }
    SMSNumbersWxListBox->SetSizeHints(300,NumbersNum*15);
    WxBoxSizer4->Layout();    
}

int SMSSendTPMR;

void SMSSendReply(int TPMR)
{
	SMSSendTPMR = TPMR;
}

void PhoneFrm::SendSMS(GSM_SMSList *List, wxListCtrl *ListCtrl) 
{
    wxProgressDialog        *Dialog;
    int                     i,Num=1,MaxNum=0;
	GSM_SMSListSubEntry	    *SubEntry;
	GSM_Error               error;
    char                    buff[200];
    bool                    skip;

	//we set handler
	s->SetSMSSendReply(SMSSendReply);

    Dialog = new wxProgressDialog("Sending SMS", "", 100, this, wxPD_APP_MODAL | wxPD_SMOOTH | wxPD_ELAPSED_TIME | wxPD_CAN_ABORT);

    SubEntry = NULL;
    while (List->GetNext(&SubEntry) == TRUE) MaxNum++;

    for (i=0;i<ListCtrl->GetItemCount();i++) {
		SubEntry = NULL;
		while (List->GetNext(&SubEntry) == TRUE) {
            SubEntry->GetSMS()->SetType(SMS_Submit);            
            SubEntry->GetSMS()->PhoneNumbers.ClearAll();
            SubEntry->GetSMS()->PhoneNumbers.Add((wchar_t *)((const wchar_t *)ListCtrl->GetItemText(i).wc_str(wxConvLibc)));

        	error = s->Phones->Current->SendSMS(SubEntry->GetSMS());
        	PrintError(error);

            SMSSendTPMR = -2;

        	while (true) {
                sprintf(buff,"SMS %i of %i",Num,MaxNum*ListCtrl->GetItemCount());
                Dialog->Pulse(buff,&skip);

#ifdef WIN32
        		Sleep(5);
#else
        		usleep(500);
#endif
        		s->Phones->Current->Read(-1,NULL);

        		if (SMSSendTPMR != -2) break;
        	}

        	if (SMSSendTPMR == -1) {
                    wxMessageBox("Sending error",
                           wxT("Error"),
                           wxICON_WARNING | wxOK);                
        		break;
        	}
        	Num++;
        }
    	if (SMSSendTPMR == -1) {
    		break;
        }
    }

    //we set handler
    s->SetSMSSendReply(NULL);

    delete Dialog;
}

/*
 * WxButton1Click
 */
void PhoneFrm::SMSSendWxButtonClick(wxCommandEvent& event)
{
    SMSEditorDlg          *dialog;
	GSM_SMSList		      List;
	GSM_Error             error;

    dialog = new SMSEditorDlg(s,&List,this,-1,"Sending new SMS",wxDefaultPosition,wxDefaultSize,SMSEditorDlg_STYLE);

    if (dialog->ShowModal()!=wxID_OK) {
        dialog->Destroy();
        return;
    }

    SendSMS(&List, dialog->RecipientsWxListCtrl);    

    dialog->Destroy();
}

/*
 * Mnuforward1095Click
 */
void PhoneFrm::Mnuforward1095Click(wxCommandEvent& event)
{
	GSM_SMSList		      List;
	GSM_Error             error;
	GSM_SMSListSubEntry	  *SubEntry;
    long                  item;
    GSM_Backup_SMSEntry   *En;
    GSM_SMSEntry          *SMS;
    SMSEditorDlg          *dialog;

    item = SMSUpWxListCtrl->GetNextItem(-1,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);

    FindSMSEntry(Backup, &En, SMSUpWxListCtrl->GetItemData(item));

    SubEntry = NULL;
    while (En->GetEntry()->GetNext(&SubEntry)) {
        SMS = SubEntry->GetSMS();
        List.Add(SMS);
    }

    dialog = new SMSEditorDlg(s,&List,this,-1,"Forward SMS",wxDefaultPosition,wxDefaultSize,SMSEditorDlg_STYLE);
    dialog->WxNotebook2->DeletePage(0);    
    if (dialog->ShowModal()!=wxID_OK) {
        dialog->Destroy();
        return;
    }

    SendSMS(&List, dialog->RecipientsWxListCtrl);

    dialog->Destroy();
}

/*
 * Mnusendnewsmstosmsnumbers1144Click1
 */
void PhoneFrm::Mnusendnewsmstosmsnumbers1144Click1(wxCommandEvent& event)
{
    SMSEditorDlg          *dialog;
	GSM_SMSList		      List;
	GSM_Error             error;
	GSM_SMSListSubEntry	  *SubEntry;
    long                  item;
    GSM_Backup_SMSEntry   *En;
    GSM_SMSEntry          *SMS;

    dialog = new SMSEditorDlg(s,&List,this,-1,"Sending reply",wxDefaultPosition,wxDefaultSize,SMSEditorDlg_STYLE);

    item = SMSUpWxListCtrl->GetNextItem(-1,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);

    FindSMSEntry(Backup, &En, SMSUpWxListCtrl->GetItemData(item));

    SubEntry = NULL;
    En->GetEntry()->GetNext(&SubEntry);
    //get numbers
//        SMS = SubEntry->GetSMS();
    
    if (dialog->ShowModal()!=wxID_OK) {
        dialog->Destroy();
        return;
    }

    SendSMS(&List, dialog->RecipientsWxListCtrl);

    dialog->Destroy();
}

/*
 * SMSUpWxListCtrlRightClick
 */
void PhoneFrm::SMSUpWxListCtrlRightClick(wxListEvent& event)
{
    long item;
    
    item = SMSUpWxListCtrl->GetNextItem(-1,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);
    item = SMSUpWxListCtrl->GetNextItem(item,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);
    if (item!=-1) {
        //multiple
        return;
    }

    //single
    PopupMenu(SMSSingleUpWxPopupMenu, wxDefaultPosition);
}


/*
 * SMSSearchWxButtonClick
 */
void PhoneFrm::SMSSearchWxButtonClick(wxCommandEvent& event)
{
    DisplaySMSFolder();
}

// ----------------------------- mms -----------------------------------------------


/*
 * MMSGetWxButtonClick
 */
void PhoneFrm::MMSGetWxButtonClick(wxCommandEvent& event)
{
    ReadSMSMMSFolders(FALSE);
    MMSSearchWxEdit->Enable(FALSE);
    MMSSearchWxButton->Enable(FALSE);    
}


void PhoneFrm::ClearMMSView()
{
    MMSDetailsWxListCtrl->DeleteAllItems();
    Freeze();
    MMSFileWxMediaCtrl->Show(false);
    MMSFileWxMemo->Show(false);
    WxBoxSizer10->Layout();
    Thaw();
    MMFilesWxComboBox->Clear();
    MMSSaveWxButton->Enable(false);    
}

/*
 * MMSWxComboBoxSelected
 */
void PhoneFrm::MMSWxComboBoxSelected(wxCommandEvent& event )
{
    GSM_Backup_MMSEntry         *En;
    boolean                     wrong;
    wchar_t                     Buffer[500];
    long                        tmp,filesnum=0,filessize=0;
    int                         i = 1,num5=0;
    int                         EntryNum = 0, Num, Num2;
    GSM_SMSMMSFoldersSubEntry   *SubFolder;
    GSM_Error                   error,preverror;
    char                        buff[200];
    GSM_MMSFile                 Entry2;
    boolean                     wasmore = false;
	BOOLEAN                     was = FALSE;
	GSM_MMSDecodedFile          Decoded;
	GSM_MMSDecodedFileSubEntry  *SubDecoded;
	boolean                     found;
	wchart                      UTF8Text;

    MMSSearchWxEdit->Enable(TRUE);
    MMSSearchWxButton->Enable(TRUE);

    ClearMMSView();
    MMSUpWxListCtrl->DeleteAllItems();
    
    if (MMSWxComboBox->GetSelection()==0) {
        Num2=0;
        SubFolder = NULL;
        while (SMSFolders.GetNext(&SubFolder)) {
            Num2++;
            if (!SubFolder->MMS) continue;
            if (!was) {
                was = ReadSMSMMSFolder(Num2,SubFolder);
            } else {
                ReadSMSMMSFolder(Num2,SubFolder);
            }
        }
    } else {
        Num = 0;
        Num2=0;
        SubFolder = NULL;
        while (Num!=MMSWxComboBox->GetSelection()) {
            SMSFolders.GetNext(&SubFolder);
            Num2++;
            if (!SubFolder->MMS) continue;
            Num++;
        }
        was = ReadSMSMMSFolder(Num2,SubFolder);
    }
    En = NULL;
    while (Backup->GetNext_MMS(&En)) {
        num5++;
        if (MMSWxComboBox->GetSelection()!=0) {
            if (En->GetEntry()->Folder!=Num2) continue;
        }
        error = Decoded.Read(&En->GetEntry()->File);
        PrintError(error);

        filesnum++;
        filessize+=En->GetEntry()->File.Info.Size;
        
        //searching
        if (MMSSearchWxEdit->GetValue()!="") {
            found = false;

            SubDecoded = NULL;
            while (Decoded.GetNext(&SubDecoded)) {
                switch (SubDecoded->Type) {
                case MMS_Address_Phone_Source:
            	case MMS_Address_Unknown_Source:
                case MMS_Address_Phone_Destination:
                case MMS_Address_Unknown_Destination:
                case MMS_Address_Phone_CC:
                case MMS_Address_Unknown_CC:
                case MMS_Address_Phone_BCC:
                case MMS_Address_Unknown_BCC:
                case MMS_Text_Subject:
                    if (UnicodeCaseStr(SubDecoded->Text.data(),(const wchar_t *)MMSSearchWxEdit->GetValue().wc_str(wxConvLibc))!=NULL) {
                        found = true;
                    }
                    break;
                case MMS_File:
                    if (!wcscmp(SubDecoded->Text.data(),StringToUnicodeReturn("text/plain")) ||
                        !wcscmp(SubDecoded->Text.data(),StringToUnicodeReturn("text/x-vCard")) ||
                        !wcscmp(SubDecoded->Text.data(),StringToUnicodeReturn("text/x-vCalendar"))) {
                        if (UnicodeCaseStr(StringToUnicodeReturn((char *)SubDecoded->File.Buffer.data()),(const wchar_t *)MMSSearchWxEdit->GetValue().wc_str(wxConvLibc))!=NULL) {
                            found = true;
                        }
                    }
                    break;
                default:
                    break;
                }
                if (found) break;
            }
            if (!found) {
                continue;
            }
        }

        found = false;
        SubDecoded = NULL;
        while (Decoded.GetNext(&SubDecoded)) {
            if (SubDecoded->Type == MMS_DT_DateTime) {
                PrintDT(&SubDecoded->DT, buff);
                tmp = MMSUpWxListCtrl->InsertItem(EntryNum++, buff, 0);
                found = TRUE;
                break;
            }
        }
        if (!found) {
            tmp = MMSUpWxListCtrl->InsertItem(EntryNum++, "", 0);
        }
        MMSUpWxListCtrl->SetItemData(tmp, num5);
        found = false;
        SubDecoded = NULL;
        while (Decoded.GetNext(&SubDecoded)) {
            if (SubDecoded->Type ==  MMS_Address_Phone_Source ||
                SubDecoded->Type ==  MMS_Address_Unknown_Source) {

                memcpy(Buffer,SubDecoded->Text.data(),(SubDecoded->Text.length()+1)*sizeof(wchar_t));
                FindNumber(Buffer);

                MMSUpWxListCtrl->SetItem(tmp, 1, Buffer);
                found = true;
                break;
            }
        }
        if (!found) {
            SubDecoded = NULL;
            while (Decoded.GetNext(&SubDecoded)) {
                if (SubDecoded->Type ==  MMS_Address_Phone_Destination ||
                    SubDecoded->Type ==  MMS_Address_Unknown_Destination) {

                    memcpy(Buffer,SubDecoded->Text.data(),(SubDecoded->Text.length()+1)*sizeof(wchar_t));
                    FindNumber(Buffer);

                    MMSUpWxListCtrl->SetItem(tmp, 1, Buffer);
                    found = true;
                    break;
                }
            }
        }
        SubDecoded = NULL;
        while (Decoded.GetNext(&SubDecoded)) {
            if (SubDecoded->Type !=  MMS_File) continue;
            if (!wcscmp(SubDecoded->Text.data(),StringToUnicodeReturn("text/plain"))) {                
                if (UnicodeCaseStr(SubDecoded->Text2.data(),StringToUnicodeReturn("charset=utf8"))!=NULL) {
                    UTF8ToUnicode(SubDecoded->File.Buffer.data(), &UTF8Text, SubDecoded->File.Buffer.size());
                    MMSUpWxListCtrl->SetItem(tmp, 2, UTF8Text.data());
                } else {
                    MMSUpWxListCtrl->SetItem(tmp, 2, SubDecoded->File.Buffer.data());
                }                
            }
        }
        i=0;
        SubDecoded = NULL;
        while (Decoded.GetNext(&SubDecoded)) {
            if (SubDecoded->Type ==  MMS_File) i++;
        }
        sprintf(buff,"%i",i);
        MMSUpWxListCtrl->SetItem(tmp, 3, buff);
        sprintf(buff,"%i",En->GetEntry()->File.Info.Size);
        MMSUpWxListCtrl->SetItem(tmp, 4, buff);
    }
    
    sprintf(buff,"%i files (%i bytes)",filesnum,filessize);
    StatusStr[FindPage("MMS")].clear();
    StatusStr[FindPage("MMS")].append(StringToUnicodeReturn(buff));
    parent->WxStatusBar1->SetStatusText(wxString(StatusStr[WxNotebook1->GetSelection()].data())+wxString(StatusStr2[WxNotebook1->GetSelection()].data()),0);
}

void PhoneFrm::FindMMSFile(GSM_Backup_MMSEntry **En)
{
    boolean                     wrong;
    int                         Num, Num2;
    GSM_SMSMMSFoldersSubEntry   *SubFolder;
    GSM_Error                   error,preverror;
    GSM_MMSFile                 Entry2;
    boolean                     wasmore = false;
	GSM_MMSDecodedFile          Decoded;
	boolean                     found;
	wxImage                     newImage ;
	long                        item,item2=0;

    item = MMSUpWxListCtrl->GetNextItem(-1,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);

    if (MMSWxComboBox->GetSelection()!=0) {
        Num=0;
        Num2=0;
        SubFolder = NULL;
        while (Num!=MMSWxComboBox->GetSelection()) {
            SMSFolders.GetNext(&SubFolder);
            Num2++;
            if (!SubFolder->MMS) continue;
            Num++;
        }
    }

    *En = NULL;
    while (Backup->GetNext_MMS(En)) {
        if (MMSWxComboBox->GetSelection()!=0) {
            if ((*En)->GetEntry()->Folder!=Num2) continue;
        }
        item2++;
        if (item2-1!=item) continue;

        break;
    }    
}

/*
 * MMFilesWxComboBoxSelected
 */
void PhoneFrm::MMFilesWxComboBoxSelected(wxCommandEvent& event )
{
    GSM_Backup_MMSEntry         *En;
	GSM_MMSDecodedFile          Decoded;
	GSM_Error                   error;

    FindMMSFile(&En);

    error = Decoded.Read(&En->GetEntry()->File);
    PrintError(error);

    MMSSelect(MMFilesWxComboBox->GetSelection(), &Decoded, MMSFileWxMediaCtrl, MMSFileWxMemo, WxBoxSizer10, MMSSaveWxButton);
}

/*
 * MMSFileWxMediaCtrlMediaLoaded
 */
void PhoneFrm::MMSFileWxMediaCtrlMediaLoaded(wxMediaEvent& event)
{
    MMSFileWxMediaCtrl->Play();
#ifdef WIN32
    DeleteFile("tmpbitmap.amr");
    DeleteFile("tmpbitmap.jpg");
    DeleteFile("tmpbitmap.gif");
#endif    
}

/*
 * MMSSaveWxButtonClick
 */
void PhoneFrm::MMSSaveWxButtonClick(wxCommandEvent& event)
{
    GSM_Backup_MMSEntry         *En;
	GSM_MMSDecodedFile          Decoded;
    GSM_Error                   error;

    FindMMSFile(&En);

    error = Decoded.Read(&En->GetEntry()->File);
    PrintError(error);

    SaveMMSFile(&Decoded, parent->WxSaveFileDialog1, MMFilesWxComboBox->GetSelection());
}

/*
 * MMSUpWxListCtrlSelected
 */
void PhoneFrm::MMSUpWxListCtrlSelected(wxListEvent& event)
{
    long                        item;
    int                         num;
    GSM_Backup_MMSEntry         *En;
    GSM_Error                   error;

    ClearMMSView();

    item = MMSUpWxListCtrl->GetNextItem(-1,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);
    item = MMSUpWxListCtrl->GetNextItem(item,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);
    if (item!=-1) return;

    FindMMSFile(&En);
    
    error = Decoded.Read(&En->GetEntry()->File);
    PrintError(error);
    
    num=ViewMMSFile(&En->GetEntry()->File, &Decoded, MMSDetailsWxListCtrl, MMFilesWxComboBox);
    if (num!=-1) {
        MMFilesWxComboBox->Select(num-1);
        MMFilesWxComboBoxSelected(event);
    }
}

/*
 * Mnusavetofile1104Click
 */
void PhoneFrm::Mnusavetofile1104Click(wxCommandEvent& event)
{
    GSM_Backup_MMSEntry *En;

    FindMMSFile(&En);

    if (parent->WxSaveFileDialog1->ShowModal()!=wxID_OK) return;
    En->GetEntry()->File.SaveToDisk((char *)parent->WxSaveFileDialog1->GetPath().c_str());
}

/*
 * MMSUpWxListCtrlRightClick
 */
void PhoneFrm::MMSUpWxListCtrlRightClick(wxListEvent& event)
{
    long item;

    item = MMSUpWxListCtrl->GetNextItem(-1,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);
    item = MMSUpWxListCtrl->GetNextItem(item,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);
    if (item!=-1) {
        //multiple
        return;
    }

    //single
    PopupMenu(MMSSingleUpWxPopupMenu, wxDefaultPosition);
}

/*
 * MMSSearchWxButtonClick
 */
void PhoneFrm::MMSSearchWxButtonClick(wxCommandEvent& event)
{
    MMSWxComboBoxSelected(event );
}

//------------------------------------ calendar ----------------------------------------

void PhoneFrm::ReadCalendar()
{
    bool                newe = TRUE, Start = TRUE, skip;
    GSM_Error           error;
    GSM_CalendarEntry   *Entry;
    int                 Current,Max;
    wxProgressDialog    *Dialog = NULL;

    Backup->Delete_Calendar();
    
    FirstCalendar = FALSE;
    while (1) {
        if (newe) {
            Entry = new GSM_CalendarEntry;
            newe = false;
        }
        error = s->Phones->Current->GetNextCalendar(Entry,Start,&Current,&Max);
        if (error.Code == GSM_ERR_EMPTY) break;
        PrintError(error);
        if (Dialog == NULL) {
            if (Max != -1) {
                Dialog = new wxProgressDialog("Reading calendar", "", Max, this, wxPD_AUTO_HIDE | wxPD_APP_MODAL | wxPD_SMOOTH | wxPD_ELAPSED_TIME | wxPD_ESTIMATED_TIME | wxPD_REMAINING_TIME | wxPD_CAN_ABORT);
            } else {
                Dialog = new wxProgressDialog("Reading calendar", "", 100, this, wxPD_APP_MODAL | wxPD_SMOOTH);
            }
        } else {
            if (Max != -1) {
                Dialog->Update((int)Current,"",&skip);
            } else {
                Dialog->Pulse("",&skip);
            }
        }

        Backup->Add_Cal(Entry);
        newe = true;
        Start = false;
    }
    delete Dialog;
    DisplayCalendar();
}

/*
 * CalendarGetWxButtonClick
 */
void PhoneFrm::CalendarGetWxButtonClick(wxCommandEvent& event)
{
    ReadCalendar();
}

void PhoneFrm::DisplayCalendar()
{
    GSM_Backup_CalEntry     *CalEntry;
    GSM_CalendarEntry       *CalEntry2;
    wchart                  Text;
    GSM_DateTime            DT,DT2;
    GSM_CalendarSubEntry    *SubEntry;
    long                    EntryNum = 0, tmp,num=0;
    char                    buff[200];
    boolean                 found;

    CalendarSearchWxEdit->Enable(TRUE);
    CalendarSearchWxButton->Enable(TRUE);
    
    CalendarUpWxListCtrl->DeleteAllItems();
    CalendarDownWxListCtrl->DeleteAllItems();
    
    CalEntry = NULL;
    while (Backup->GetNext_Cal(&CalEntry)) {
        CalEntry2 = CalEntry->GetEntry();
        Text.clear();

        SubEntry = NULL;
        while (CalEntry2->GetNext(&SubEntry)) {
            switch (SubEntry->GetType()) {
            case Calendar_Text_Text:
                Text.append(SubEntry->GetText());
                break;
            case Calendar_DateTime_Start:
                memcpy(&DT,SubEntry->GetDateTime(),sizeof(GSM_DateTime));
                break;
            default:
                break;
            }
        }
        if (!CalendarWxCheckBox->GetValue()) {
                DT2.Year = WxCalendarCtrl1->GetDate().GetYear();
                DT2.Month = WxCalendarCtrl1->GetDate().GetMonth();
                DT2.Day = WxCalendarCtrl1->GetDate().GetDay();
                if (!CalEntry2->IsNoteInDay(DT2)) continue;
        }

        num++;

        //searching
        if (CalendarSearchWxEdit->GetValue()!="") {
            found=false;
            SubEntry = NULL;
            while (CalEntry2->GetNext(&SubEntry)) {
                switch (SubEntry->GetType()) {
                case Calendar_Text_Text:
                case Calendar_Text_Phone:
                case Calendar_Text_Location:
                    if (UnicodeCaseStr(SubEntry->GetText(),(const wchar_t *)CalendarSearchWxEdit->GetValue().wc_str(wxConvLibc))!=NULL) {
                        found = true;
                    }
                default:
                    break;
                }
                if (found) break;
            }
            if (!found) {
                continue;
            }
        }

        PrintDT(&DT, buff);
        
        tmp = CalendarUpWxListCtrl->InsertItem(EntryNum++, buff, 0);
        CalendarUpWxListCtrl->SetItemData(tmp, num);
        
        switch(CalEntry2->Type) {
        case Calendar_Type_Meeting:
            CalendarUpWxListCtrl->SetItem(tmp, 1, "meeting");
            break;
        case Calendar_Type_Memo:
            CalendarUpWxListCtrl->SetItem(tmp, 1, "memo");
            break;
        case Calendar_Type_Call:
            CalendarUpWxListCtrl->SetItem(tmp, 1, "phone call");
            break;
        case Calendar_Type_Birthday:
            CalendarUpWxListCtrl->SetItem(tmp, 1, "birthday");
            break;
        case Calendar_Type_Reminder:
            CalendarUpWxListCtrl->SetItem(tmp, 1, "reminder");
            break;
        case Calendar_Type_Not_Assigned:
            break;
        }
        
        CalendarUpWxListCtrl->SetItem(tmp, 2, Text.data());
    }    
    
    if (CalendarWxCheckBox->GetValue()) {
        sprintf(buff,"All calendar notes (%i entries)",num);
    } else {
        sprintf(buff,"Calendar for %s %02i-%02i-%04i (%i entries)",
            DayOfWeekStr(
                WxCalendarCtrl1->GetDate().GetYear(),
                WxCalendarCtrl1->GetDate().GetMonth(),
                WxCalendarCtrl1->GetDate().GetDay()),
            WxCalendarCtrl1->GetDate().GetDay(),
            WxCalendarCtrl1->GetDate().GetMonth(),
            WxCalendarCtrl1->GetDate().GetYear(),num);
    }
    StatusStr[FindPage("Calendar")].clear();
    StatusStr[FindPage("Calendar")].append(StringToUnicodeReturn(buff));
    parent->WxStatusBar1->SetStatusText(wxString(StatusStr[WxNotebook1->GetSelection()].data())+wxString(StatusStr2[WxNotebook1->GetSelection()].data()),0);
}

/*
 * WxCalendarCtrl1SelChanged
 */
void PhoneFrm::WxCalendarCtrl1SelChanged(wxCalendarEvent& event)
{
    DisplayCalendar();
}

/*
 * CalendarWxCheckBoxClick
 */
void PhoneFrm::CalendarWxCheckBoxClick(wxCommandEvent& event)
{
    WxCalendarCtrl1->Enable(!CalendarWxCheckBox->GetValue());
    DisplayCalendar();
}

/*
 * CalendarUPWxListCtrlSelected
 */
void PhoneFrm::CalendarUPWxListCtrlSelected(wxListEvent& event)
{
    GSM_Backup_CalEntry     *CalEntry;
    GSM_CalendarEntry       *CalEntry2;
    wchart                  Text;
    GSM_CalendarSubEntry    *SubEntry;
    long                    EntryNum = 0, tmp, item;
    char                    buff[200];
    int                     RepeatEach,RepeatDay,RepeatMonth,RepeatDOW,num=0;
    boolean                 found;

    CalendarDownWxListCtrl->DeleteAllItems();
    
    item = CalendarUpWxListCtrl->GetNextItem(-1,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);
    item = CalendarUpWxListCtrl->GetNextItem(item,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);
    if (item!=-1) return;

    item = CalendarUpWxListCtrl->GetNextItem(-1,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);

    CalEntry = NULL;
    while (Backup->GetNext_Cal(&CalEntry)) {
        CalEntry2 = CalEntry->GetEntry();
        num++;        
        if (CalendarUpWxListCtrl->GetItemData(item)!=num) continue;
        
        tmp = CalendarDownWxListCtrl->InsertItem(EntryNum++, "Note type", 0);

        switch(CalEntry2->Type) {
        case Calendar_Type_Meeting:
            CalendarDownWxListCtrl->SetItem(tmp, 1, "meeting");
            break;
        case Calendar_Type_Memo:
            CalendarDownWxListCtrl->SetItem(tmp, 1, "memo");
            break;
        case Calendar_Type_Call:
            CalendarDownWxListCtrl->SetItem(tmp, 1, "phone call");
            break;
        case Calendar_Type_Birthday:
            CalendarDownWxListCtrl->SetItem(tmp, 1, "birthday");
            break;
        case Calendar_Type_Reminder:
            CalendarDownWxListCtrl->SetItem(tmp, 1, "reminder");
            break;
        }

        RepeatEach      = -1;
        RepeatDay       = -1;
        RepeatMonth     = -1;
        RepeatDOW       = -1;
        SubEntry        = NULL;
        while (CalEntry2->GetNext(&SubEntry) == TRUE) {
            switch (SubEntry->GetType()) {
            case Calendar_Text_Text:
                tmp = CalendarDownWxListCtrl->InsertItem(EntryNum++, "Text", 0);
                CalendarDownWxListCtrl->SetItemData(tmp, 0);
                CalendarDownWxListCtrl->SetItem(tmp, 1, SubEntry->GetText());
                break;
            case Calendar_Text_Phone:
                tmp = CalendarDownWxListCtrl->InsertItem(EntryNum++, "Phone number", 0);
                CalendarDownWxListCtrl->SetItemData(tmp, 0);
                CalendarDownWxListCtrl->SetItem(tmp, 1, SubEntry->GetText());
                break;
            case Calendar_Text_Location:
                tmp = CalendarDownWxListCtrl->InsertItem(EntryNum++, "Location", 0);
                CalendarDownWxListCtrl->SetItemData(tmp, 0);
                CalendarDownWxListCtrl->SetItem(tmp, 1, SubEntry->GetText());
                break;
            case Calendar_DateTime_Start:
                tmp = CalendarDownWxListCtrl->InsertItem(EntryNum++, "Start", 0);
                CalendarDownWxListCtrl->SetItemData(tmp, 0);
                PrintDT(SubEntry->GetDateTime(), buff);
                CalendarDownWxListCtrl->SetItem(tmp, 1, buff);
                break;
            case Calendar_DateTime_End:
                tmp = CalendarDownWxListCtrl->InsertItem(EntryNum++, "End", 0);
                CalendarDownWxListCtrl->SetItemData(tmp, 0);
                PrintDT(SubEntry->GetDateTime(), buff);
                CalendarDownWxListCtrl->SetItem(tmp, 1, buff);
                break;
            case Calendar_DateTime_SilentAlarm:
            case Calendar_DateTime_ToneAlarm:
                if (SubEntry->GetType() == Calendar_DateTime_SilentAlarm) {
                    tmp = CalendarDownWxListCtrl->InsertItem(EntryNum++, "Silent alarm", 0);
                } else {
                    tmp = CalendarDownWxListCtrl->InsertItem(EntryNum++, "Tone alarm", 0);
                }
                CalendarDownWxListCtrl->SetItemData(tmp, 0);
                if (CalEntry2->Type == Calendar_Type_Birthday) {
                    sprintf(buff,"%02i:%02i:%02i %02i-%02i in each year",
                            SubEntry->GetDateTime()->Hour,
                            SubEntry->GetDateTime()->Minute,
                            SubEntry->GetDateTime()->Second,
                            SubEntry->GetDateTime()->Day,
                            SubEntry->GetDateTime()->Month);
                } else {
                    PrintDT(SubEntry->GetDateTime(), buff);
                }
                CalendarDownWxListCtrl->SetItem(tmp, 1, buff);
                break;
            case Calendar_DateTime_End_Repeat:
                tmp = CalendarDownWxListCtrl->InsertItem(EntryNum++, "Repeat end", 0);
                CalendarDownWxListCtrl->SetItemData(tmp, 0);
                PrintDT(SubEntry->GetDateTime(), buff);
                CalendarDownWxListCtrl->SetItem(tmp, 1, buff);
                break;
            case Calendar_Int_Repeat_Frequency:
                RepeatEach = SubEntry->GetInt();
                break;
            case Calendar_Int_Repeat_DayOfWeek:
                RepeatDOW = SubEntry->GetInt();
                break;                  
            case Calendar_Int_Repeat_Day:
                RepeatDay = SubEntry->GetInt();
                break;
            case Calendar_Int_Repeat_Month:
                RepeatMonth = SubEntry->GetInt();
                break;
            }
        }

        if (RepeatEach != -1 || RepeatDOW != -1 ||
            RepeatDay != -1 || RepeatMonth != -1) {
            tmp = CalendarDownWxListCtrl->InsertItem(EntryNum++, "Repeat", 0);
            CalendarDownWxListCtrl->SetItemData(tmp, 0);
            buff[0] = 0;
            if (RepeatEach == 1) sprintf(buff+strlen(buff),"each ");
            if (RepeatEach == 2) sprintf(buff+strlen(buff),"each second ");
            if (RepeatDOW != -1) {
                switch (RepeatDOW) {
                    case 1: sprintf(buff+strlen(buff),"Monday ");      break;
                    case 2: sprintf(buff+strlen(buff),"Tuesday ");     break;
                    case 3: sprintf(buff+strlen(buff),"Wednesday ");   break;
                    case 4: sprintf(buff+strlen(buff),"Thursday ");    break;
                    case 5: sprintf(buff+strlen(buff),"Friday ");      break;
                    case 6: sprintf(buff+strlen(buff),"Saturday ");    break;
                    case 7: sprintf(buff+strlen(buff),"Sunday ");      break;
                    default:sprintf(buff+strlen(buff)," ");
                }
            }
            if (RepeatDay != -1) {
                sprintf(buff+strlen(buff),"%i ",RepeatDay);
                if (RepeatMonth != -1) {
                    switch (RepeatMonth) {
                        case  1: sprintf(buff+strlen(buff),"January ");    break;
                        case  2: sprintf(buff+strlen(buff),"February ");   break;
                        case  3: sprintf(buff+strlen(buff),"March ");      break;
                        case  4: sprintf(buff+strlen(buff),"April ");      break;
                        case  5: sprintf(buff+strlen(buff),"May ");        break;
                        case  6: sprintf(buff+strlen(buff),"June ");       break;
                        case  7: sprintf(buff+strlen(buff),"July ");       break;
                        case  8: sprintf(buff+strlen(buff),"August ");     break;
                        case  9: sprintf(buff+strlen(buff),"September ");  break;
                        case 10: sprintf(buff+strlen(buff),"October ");    break;
                        case 11: sprintf(buff+strlen(buff),"November ");   break;
                        case 12: sprintf(buff+strlen(buff),"December ");   break;
                        default:sprintf(buff+strlen(buff)," ");
                    }
                } else {
                    sprintf(buff+strlen(buff),"month day ");
                }
            }
            CalendarDownWxListCtrl->SetItem(tmp, 1, buff);
        }
    }
}

BOOLEAN PhoneFrm::CheckCalendar()
{
    GSM_Backup_CalEntry *CalEntry;
    
    if (Phone) {
        return TRUE;
    } else {
        CalendarGetWxButton->Show(FALSE);
        CalEntry = NULL;
        if (Backup->GetNext_Cal(&CalEntry)) {
            DisplayCalendar();            
            return TRUE;
        }
        return FALSE;
    }
}

/*
 * WxButton1Click
 */
void PhoneFrm::WxButton1Click(wxCommandEvent& event)
{
//    wxDateTime DT;
    
//	WxCalendarCtrl1->GetDate(DT);
}

/*
 * CalendarSearchWxButtonClick
 */
void PhoneFrm::CalendarSearchWxButtonClick(wxCommandEvent& event)
{
	DisplayCalendar();
}

// -------------------------- info sheet ---------------------------------------------------

void PhoneFrm::FindFeatures(GSM_Backup_FileFormatFunctions *Func)
{
    int i;
    
    Func->ToDo = TRUE;
    Func->Notes = TRUE;
    
    Func->Calendar = FindPage("Calendar");
    Func->PhonePBK = FALSE;
    Func->SIMPBK = FALSE;
    for (i=0;i<PBKMemoryLen;i++) {
        if (PBKMemoryNum[i]==MEM_PHONE) Func->PhonePBK = TRUE;
        if (PBKMemoryNum[i]==MEM_SIM) Func->SIMPBK = TRUE;
    }
}

/*
 * BackupWxButtonClick
 */
void PhoneFrm::BackupWxButtonClick(wxCommandEvent& event)
{
    GSM_Error                       error;
    BackupDlg                       *dialog;
    GSM_Backup_FileFormatFunctions  Func;
    GSM_Backup_PBKEntry             *PBKEntry;
    BOOLEAN                         Found;

    FindFeatures(&Func);
            
    dialog = new BackupDlg(&Func, this,-1,"Backup",wxDefaultPosition,wxDefaultSize,BackupDlg_STYLE);

    if (dialog->ShowModal()!=wxID_OK) {
        dialog->Destroy();
        return;
    }
    
    if (parent->WxSaveFileDialog1->ShowModal()!=wxID_OK) {
        dialog->Destroy();        
        return;
    }

    if (Func.PhonePBK) {
        Found = FALSE;
        PBKEntry = NULL;
        while(Backup->GetNext_PBK(&PBKEntry)) {
            if (PBKEntry->GetEntry()->Memory == MEM_PHONE) {
                Found = TRUE;
                break;
            }
        }
        if (!Found) ReadPBKMemory(MEM_PHONE);        
    }
    if (Func.SIMPBK) {
        Found = FALSE;
        PBKEntry = NULL;
        while(Backup->GetNext_PBK(&PBKEntry)) {
            if (PBKEntry->GetEntry()->Memory == MEM_SIM) {
                Found = TRUE;
                break;
            }
        }
        if (!Found) ReadPBKMemory(MEM_SIM);
    }
    if (Func.Calendar) {
        if (FirstCalendar) ReadCalendar();
    }
    if (Func.Notes) {
        ReadNotes();
    }
    if (Func.ToDo) {
        ReadToDo();
    }

	error = Backup->SaveToFile((char *)parent->WxSaveFileDialog1->GetPath().c_str());
	
    dialog->Destroy();	
}

/*
 * RestoreWxButtonClick
 */
void PhoneFrm::RestoreWxButtonClick(wxCommandEvent& event)
{
    LogDlg                          *Log;
    wxProgressDialog                *Dialog;
    GSM_Backup                      *Backup2;
    GSM_Backup_FileFormatFunctions  Func;
    GSM_Backup_PBKEntry             *PBKEntry;
	GSM_PBKEntry 		            PBKEntry2;
    GSM_Backup_CalEntry             *CalEntry;
    GSM_CalendarEntry               CalEntry2;
    GSM_Error                       error;
    BOOLEAN                         Found;
    BackupDlg                       *dialog;
    int                             i,num,Current,Max;
    char                            Buff[200];
    bool                            skip,Pulse;
    int                             Num=0;
    
    if (parent->WxOpenFileDialog1->ShowModal()!=wxID_OK) return;

    Backup2 = new GSM_Backup;
    
    error = Backup2->ReadFromFile((char *)parent->WxOpenFileDialog1->GetPath().c_str());
    if (PrintError(error)) {
        delete Backup2;
        return;
    }
    
    FindFeatures(&Func);

    if (Func.Notes) {
    }
    if (Func.ToDo) {
    }
    if (Func.Calendar) {
        CalEntry = NULL;
        Func.Calendar = Backup2->GetNext_Cal(&CalEntry);
    }
    if (Func.PhonePBK) {
        Found = FALSE;
        PBKEntry = NULL;
        while(Backup2->GetNext_PBK(&PBKEntry)) {
            if (PBKEntry->GetEntry()->Memory == MEM_PHONE) {
                Found = TRUE;
                break;
            }
        }
        Func.PhonePBK = Found;
    }
    if (Func.SIMPBK) {
        Found = FALSE;
        PBKEntry = NULL;
        while(Backup2->GetNext_PBK(&PBKEntry)) {
            if (PBKEntry->GetEntry()->Memory == MEM_SIM) {
                Found = TRUE;
                break;
            }
        }
        Func.SIMPBK = Found;
    }    
    
    dialog = new BackupDlg(&Func, this,-1,"Restore",wxDefaultPosition,wxDefaultSize,BackupDlg_STYLE);

    dialog->WxCheckBox4->Show(FALSE);
    dialog->WxCheckBox5->Show(FALSE);
    
    if (dialog->ShowModal()!=wxID_OK) {
        delete Backup2;
        dialog->Destroy();
        return;
    }

    if (wxMessageBox("This is quite early version and it can not support some features. Do you want to continue ?",
              wxT("Question"),
             wxICON_WARNING | wxYES_NO) !=  wxYES) {
        delete Backup2;
        dialog->Destroy();
        return;
    }

    delete Backup;
    Backup = Backup2;
    
    Log = new LogDlg(this,-1,"About...",wxDefaultPosition,wxDefaultSize,LogDlg_STYLE);
    
    if (Func.Notes) {
        RestoreNotes();
    }
    if (Func.ToDo) {
        RestoreToDo();
    }
    if (Func.PhonePBK) {
        RestorePBK(MEM_PHONE, "Restoring phone phonebook",Log->WxListCtrl1,&Num);
    }
    if (Func.SIMPBK) {
        RestorePBK(MEM_SIM, "Restoring SIM phonebook",Log->WxListCtrl1,&Num);
    }
    if (Func.Calendar) {
        //deleting old calendar
        i=1;
        Dialog = NULL;
        while (1) {
            error = s->Phones->Current->GetNextCalendar(&CalEntry2,TRUE,&Current,&Max);
            if (error.Code == GSM_ERR_EMPTY) break;
            PrintError(error);
            if (Dialog == NULL) {
                if (Max != -1) {
                    Dialog = new wxProgressDialog("Deleting old calendar", "", Max, this, wxPD_AUTO_HIDE | wxPD_APP_MODAL | wxPD_SMOOTH | wxPD_ELAPSED_TIME | wxPD_ESTIMATED_TIME | wxPD_REMAINING_TIME | wxPD_CAN_ABORT);
                    Pulse = false;
                } else {
                    Dialog = new wxProgressDialog("Deleting old calendar", "", 100, this, wxPD_APP_MODAL | wxPD_SMOOTH);
                    Pulse = true;
                }
            } else {
                if (Pulse) {
                    Dialog->Pulse("",&skip);
                } else {
                    Dialog->Update((int)i,"",&skip);
                    i++;
                }
            }
            error = s->Phones->Current->DeleteCalendar(&CalEntry2);
            PrintError(error);
        }
        delete Dialog;
        
        num=0;
		CalEntry = NULL;
		while (Backup->GetNext_Cal(&CalEntry)) num++;
        Dialog = new wxProgressDialog("Restoring calendar", "", 100, this, wxPD_AUTO_HIDE | wxPD_APP_MODAL | wxPD_SMOOTH | wxPD_ELAPSED_TIME | wxPD_ESTIMATED_TIME | wxPD_REMAINING_TIME | wxPD_CAN_ABORT);
		i=0;
		CalEntry = NULL;
		while (Backup->GetNext_Cal(&CalEntry)) {
			error = s->Phones->Current->AddCalendar(CalEntry->GetEntry());
			PrintError(error);
    		sprintf(Buff,"%i %% (%i/%i)",i*100/num,i,num);
            if (!Dialog->Update((int)(i*100/num),Buff,&skip)) {
//                    delete Dialog;
//                    return;
            }
            i++;
		}        
		delete Dialog;
    }
    
    dialog->Destroy();
    
    if (Num!=0) Log->ShowModal();
    
    delete Log;
}

void PhoneFrm::RestoreCalendar()
{
    wxProgressDialog                *Dialog;
	GSM_PBKEntry 		            PBKEntry2;
    GSM_Backup_CalEntry             *CalEntry;
    GSM_CalendarEntry               CalEntry2;
    GSM_Error                       error;
    int                             i,num,Current,Max;
    char                            Buff[200];
    bool                            skip,Pulse;

    //deleting old calendar
    i=1;
    Dialog = NULL;
    while (1) {
        error = s->Phones->Current->GetNextCalendar(&CalEntry2,TRUE,&Current,&Max);
        if (error.Code == GSM_ERR_EMPTY) break;
        PrintError(error);
        if (Dialog == NULL) {
            if (Max != -1) {
                Dialog = new wxProgressDialog("Deleting old calendar", "", Max, this, wxPD_AUTO_HIDE | wxPD_APP_MODAL | wxPD_SMOOTH | wxPD_ELAPSED_TIME | wxPD_ESTIMATED_TIME | wxPD_REMAINING_TIME | wxPD_CAN_ABORT);
                Pulse = false;
            } else {
                Dialog = new wxProgressDialog("Deleting old calendar", "", 100, this, wxPD_APP_MODAL | wxPD_SMOOTH);
                Pulse = true;
            }
        } else {
            if (Pulse) {
                Dialog->Pulse("",&skip);
            } else {
                Dialog->Update((int)i,"",&skip);
                i++;
            }
        }
        error = s->Phones->Current->DeleteCalendar(&CalEntry2);
        PrintError(error);
    }
    delete Dialog;

    num=0;
	CalEntry = NULL;
	while (Backup->GetNext_Cal(&CalEntry)) num++;
    Dialog = new wxProgressDialog("Restoring calendar", "", 100, this, wxPD_AUTO_HIDE | wxPD_APP_MODAL | wxPD_SMOOTH | wxPD_ELAPSED_TIME | wxPD_ESTIMATED_TIME | wxPD_REMAINING_TIME | wxPD_CAN_ABORT);
	i=0;
	CalEntry = NULL;
	while (Backup->GetNext_Cal(&CalEntry)) {
		error = s->Phones->Current->AddCalendar(CalEntry->GetEntry());
		PrintError(error);
		sprintf(Buff,"%i %% (%i/%i)",i*100/num,i,num);
        if (!Dialog->Update((int)(i*100/num),Buff,&skip)) {
//                    delete Dialog;
//                    return;
        }
        i++;
	}
	delete Dialog;
}

void PhoneFrm::RestoreNotes()
{
}

void PhoneFrm::RestoreToDo()
{
}

bool PhoneFrm::RestorePBK(GSM_MemoryType Mem, wxString Text, wxListCtrl *List, int *Num)
{
    wxProgressDialog                *Dialog;
	GSM_PBKStatus 		            Status;
    GSM_Backup_PBKEntry             *PBKEntry;
	GSM_PBKEntry 		            PBKEntry2;
	GSM_PBKSubEntry 		        *SubEntry;
	int                             i;
    bool                            skip;
    GSM_Error                       error;
    char                            Buff[100];
    long                            tmp;
    char type[2000];
    wchar_t Value[200];
    BOOLEAN FirstNum = FALSE;

    Dialog = new wxProgressDialog(Text, "", 100, this, wxPD_AUTO_HIDE | wxPD_APP_MODAL | wxPD_SMOOTH | wxPD_ELAPSED_TIME | wxPD_ESTIMATED_TIME | wxPD_REMAINING_TIME | wxPD_CAN_ABORT);
	Status.Memory=Mem;
	error = s->Phones->Current->GetPBKStatus(&Status);

	PBKEntry2.Memory=Mem;
	for(i=1;i<=Status.Used + Status.Free;i++) {
		PBKEntry = NULL;
		while (Backup->GetNext_PBK(&PBKEntry)) {
			if (PBKEntry->GetEntry()->Memory != Mem) continue;
			if (PBKEntry->GetEntry()->Location != i) continue;
			error = s->Phones->Current->SetPBK(PBKEntry->GetEntry());
			PrintError(error);
			
            SubEntry = NULL;
            while (PBKEntry->GetEntry()->GetNext(&SubEntry)) {			
                if (SubEntry->SetError.Code != GSM_ERR_NONE) {
                    DecodePBKSubEntry(SubEntry, type, Value, &FirstNum);

                    tmp = List->InsertItem((*Num)++, type, 0);
                    List->SetItem(tmp, 1, Value);
                    sprintf((char *)type,"   %s",GSM_GetErrorInfo(SubEntry->SetError));
                    tmp = List->InsertItem((*Num)++, type, 0);
                }
            }
			break;
		}
		sprintf(Buff,"%i %% (%i/%i)",i*100/(Status.Used + Status.Free),i,Status.Used + Status.Free);
        if (!Dialog->Update((int)(i*100/(Status.Used + Status.Free)),Buff,&skip)) {
//                    delete Dialog;
//                    return;
        }
		if (PBKEntry != NULL && PBKEntry->GetEntry()->Location == i) continue;
		PBKEntry2.Location = i;
		error = s->Phones->Current->DeletePBK(&PBKEntry2);
		PrintError(error);
	}
    delete Dialog;
    return true;
}

/*
 * OnlineInfoWxButtonClick
 */
void PhoneFrm::OnlineInfoWxButtonClick(wxCommandEvent& event)
{
	GSM_File 	        File;
    char                Model2[200],buff[200],Firm[200],ver[50];
	unsignedstring	    X;
	long                tmp,pos=0,oldpos=0,EntryNum=0,i;
	GSM_Error           error;

    if (wxMessageBox("This option will send your phone codename.\nIMEI and all personal infos WON'T BE SENT.\n\nDo you want to continue ?",
              wxT("Question"),
             wxICON_WARNING | wxYES_NO) !=  wxYES) {
            return;
    }

	error = s->Phones->Current->GetCodeNameModel((unsigned char *)Model2);
	PrintError(error);

	error = s->Phones->Current->GetFirmwareVersion((unsigned char *)Firm);
	PrintError(error);

	X.push_back(0x00);
    InfoDownWxListCtrl->DeleteAllItems();

    //------------------- gammu.org -------------------

	sprintf(buff,"support/phones/phonedbxml.php?model=%s",Model2);
    if (!File.ReadFromWWW("www.gammu.org",buff)) return;

    tmp = InfoDownWxListCtrl->InsertItem(EntryNum++, "Gammu.org database", 0);
    
	while (pos < File.Buffer.size()) {
		if (File.Buffer.data()[pos] != 10) {
			pos++;
			continue;
		}
		File.Buffer.replace(pos,1,X);
		if (strstr((char *)File.Buffer.data()+oldpos,"<firmware>")==NULL) {
			pos++;
			oldpos = pos;
			continue;
		}
		sprintf(ver,strstr((char *)File.Buffer.data()+oldpos,"<version>")+9);
		for (i=0;i<(int)strlen(ver);i++) {
			if (ver[i] == '<') {
				ver[i] = 0;
				break;
			}
		}
		pos++;
		oldpos = pos;
	}


	if (Firm[0] == '0') {
		i=1;
	} else {
		i=0;
	}
	while(i!=strlen(ver)) {
		if (ver[i] > Firm[i]) {
           tmp = InfoDownWxListCtrl->InsertItem(EntryNum++, "    Available higher device firmware", 0);
           ToDoDownWxListCtrl->SetItem(tmp, 1, ver);
           break;
		}
		i++;
	}
    tmp = InfoDownWxListCtrl->InsertItem(EntryNum++, "    No higher device firmware", 0);
}

// ------------------------------------- notes ----------------------------------------------

void PhoneFrm::ReadNotes()
{
    bool                newe = TRUE, Start = TRUE, skip;
    GSM_Error           error;
    GSM_NoteEntry       *Entry;
    int                 Current,Max;
    wxProgressDialog    *Dialog = NULL;

    Backup->Delete_Notes();
    
    FirstCalendar = FALSE;
    while (1) {
        if (newe) {
            Entry = new GSM_NoteEntry;
            newe = false;
        }
        error = s->Phones->Current->GetNextNote(Entry,Start,&Current,&Max);
        if (error.Code == GSM_ERR_EMPTY) break;
        PrintError(error);
        if (Dialog == NULL) {
            Dialog = new wxProgressDialog("Reading notes", "", Max, this, wxPD_AUTO_HIDE | wxPD_APP_MODAL | wxPD_SMOOTH | wxPD_ELAPSED_TIME | wxPD_ESTIMATED_TIME | wxPD_REMAINING_TIME | wxPD_CAN_ABORT);
        } else {
            Dialog->Update((int)Current,"",&skip);
        }

        Backup->Add_Note(Entry);
        newe = true;
        Start = false;
    }
    delete Dialog;
    DisplayNotes();
}

/*
 * NotesGetWxButtonClick
 */
void PhoneFrm::NotesGetWxButtonClick(wxCommandEvent& event)
{
    ReadNotes();
}

void PhoneFrm::DisplayNotes()
{
    GSM_Backup_NoteEntry    *NoteEntry;
    wchart                  Text;
    long                    EntryNum = 0, tmp,num=0;
    char                    buff[200];
    boolean                 found;

    NotesWxListCtrl->DeleteAllItems();

    NoteEntry = NULL;
    while (Backup->GetNext_Note(&NoteEntry)) {
        tmp = NotesWxListCtrl->InsertItem(EntryNum++, NoteEntry->GetEntry()->Text.data(), 0);
        NotesWxListCtrl->SetItemData(tmp, num);
        num++;
    }

    sprintf(buff,"Text notes (%i entries)",num);
    StatusStr[FindPage("Notes")].clear();
    StatusStr[FindPage("Notes")].append(StringToUnicodeReturn(buff));
    parent->WxStatusBar1->SetStatusText(wxString(StatusStr[WxNotebook1->GetSelection()].data())+wxString(StatusStr2[WxNotebook1->GetSelection()].data()),0);
}

/*
 * NotesWxListCtrlSelected
 */
void PhoneFrm::NotesWxListCtrlSelected(wxListEvent& event)
{
    wchart                  Text;
    long                    item;
    int                     num=0;
    boolean                 found;
    GSM_Backup_NoteEntry    *NoteEntry;

    item = NotesWxListCtrl->GetNextItem(-1,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);
    item = NotesWxListCtrl->GetNextItem(item,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);
    if (item!=-1) return;

    item = NotesWxListCtrl->GetNextItem(-1,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);

    NotesWxMemo->Clear();

    NoteEntry = NULL;
    while (Backup->GetNext_Note(&NoteEntry)) {
        if (NotesWxListCtrl->GetItemData(item)!=num) {
            num++;
            continue;
        }

        NotesWxMemo->AppendText(NoteEntry->GetEntry()->Text.data());
        break;
    }
}

BOOLEAN PhoneFrm::CheckNotes()
{
    GSM_Backup_NoteEntry *NoteEntry;

    if (Phone) {
        return TRUE;
    } else {
        NotesGetWxButton->Show(FALSE);
        NoteEntry = NULL;
        if (Backup->GetNext_Note(&NoteEntry)) {
            DisplayNotes();
            return TRUE;
        }
        return FALSE;
    }
}
//------------------------------------------------------------------------------------------

void PhoneFrm::DisplayToDo()
{
    GSM_Backup_ToDoEntry    *ToDoEntry;
    GSM_ToDoSubEntry        *SubEntry;
    wchart                  Text;
    long                    EntryNum = 0, tmp,num=0;
    char                    buff[200],buff3[200];
    wchart                  buff2;
    boolean                 found,completed;

    ToDoUpWxListCtrl->DeleteAllItems();
    ToDoDownWxListCtrl->DeleteAllItems();

    ToDoEntry = NULL;
    while (Backup->GetNext_ToDo(&ToDoEntry)) {
        buff[0] = 0;
        buff3[0] = 0;
        buff2.clear();
        completed = false;
        
        SubEntry = NULL;
        while (ToDoEntry->GetEntry()->GetNext(&SubEntry) == TRUE) {
            switch (SubEntry->Type) {
	        case ToDo_Text_Text:
                buff2.append(SubEntry->Text.data(),SubEntry->Text.length());
                break;
	        case ToDo_Priority:
                switch (SubEntry->Priority) {
	            case GSM_Priority_High:
                    sprintf(buff,"high");
                    break;
	            case GSM_Priority_Medium:
                    sprintf(buff,"medium");
                    break;
	            case GSM_Priority_Low:                    
                    sprintf(buff,"low");
                    break;
                }
                break;
	        case ToDo_Bool_Completed:
                completed = true;
                break;
	        case ToDo_DateTime_End:
                PrintDT(&SubEntry->DT, buff3);
                break;
	        case ToDo_DateTime_ToneAlarm:
                break;
	        case ToDo_DateTime_SilentAlarm:                
                break;
            case ToDo_Not_Assigned:
                break;
            }
        }
                        
        tmp = ToDoUpWxListCtrl->InsertItem(EntryNum++, buff3, 0);
        if (completed) {
            ToDoUpWxListCtrl->SetItem(tmp, 1, "completed");
        } else {
            ToDoUpWxListCtrl->SetItem(tmp, 1, buff);
        }
        ToDoUpWxListCtrl->SetItem(tmp, 2,buff2.data());
        ToDoUpWxListCtrl->SetItemData(tmp, num);
        num++;
    }

    sprintf(buff,"ToDo (%i entries)",num);
    StatusStr[FindPage("ToDo")].clear();
    StatusStr[FindPage("ToDo")].append(StringToUnicodeReturn(buff));
    parent->WxStatusBar1->SetStatusText(wxString(StatusStr[WxNotebook1->GetSelection()].data())+wxString(StatusStr2[WxNotebook1->GetSelection()].data()),0);
}

void PhoneFrm::ReadToDo()
{
    bool                newe = TRUE, Start = TRUE, skip;
    GSM_Error           error;
    GSM_ToDoEntry       *Entry;
    int                 Current,Max;
    wxProgressDialog    *Dialog = NULL;

    Backup->Delete_ToDo();

    while (1) {
        if (newe) {
            Entry = new GSM_ToDoEntry;
            newe = false;
        }
        error = s->Phones->Current->GetNextToDo(Entry,Start,&Current,&Max);
        if (error.Code == GSM_ERR_EMPTY) break;
        PrintError(error);
        if (Dialog == NULL) {
            Dialog = new wxProgressDialog("Reading ToDo", "", Max, this, wxPD_AUTO_HIDE | wxPD_APP_MODAL | wxPD_SMOOTH | wxPD_ELAPSED_TIME | wxPD_ESTIMATED_TIME | wxPD_REMAINING_TIME | wxPD_CAN_ABORT);
        } else {
            Dialog->Update((int)Current,"",&skip);
        }

        Backup->Add_ToDo(Entry);
        newe = true;
        Start = false;
    }
    delete Dialog;
    DisplayToDo();
}

/*
 * ToDoGetWxButtonClick
 */
void PhoneFrm::ToDoGetWxButtonClick(wxCommandEvent& event)
{
    ReadToDo();
}

/*
 * ToDoWxListCtrlSelected
 */
void PhoneFrm::ToDoWxListCtrlSelected(wxListEvent& event)
{
    wchart                  Text;
    long                    EntryNum = 0, tmp, item;
    int                     num=0;
    boolean                 found;
    GSM_Backup_ToDoEntry    *ToDoEntry;
    GSM_ToDoSubEntry        *SubEntry;
    char                    buff3[200];

    item = ToDoUpWxListCtrl->GetNextItem(-1,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);
    item = ToDoUpWxListCtrl->GetNextItem(item,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);
    if (item!=-1) return;

    item = ToDoUpWxListCtrl->GetNextItem(-1,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);

    ToDoDownWxListCtrl->DeleteAllItems();

    ToDoEntry = NULL;
    while (Backup->GetNext_ToDo(&ToDoEntry)) {
        if (ToDoUpWxListCtrl->GetItemData(item)!=num) {
            num++;
            continue;
        }
        
        SubEntry = NULL;
        while (ToDoEntry->GetEntry()->GetNext(&SubEntry)) {
            switch (SubEntry->Type) {
	        case ToDo_Text_Text:
                tmp = ToDoDownWxListCtrl->InsertItem(EntryNum++, "Text", 0);
                ToDoDownWxListCtrl->SetItem(tmp, 1, SubEntry->Text.data());
                break;
	        case ToDo_Priority:
                tmp = ToDoDownWxListCtrl->InsertItem(EntryNum++, "Priority", 0);
                switch (SubEntry->Priority) {
	            case GSM_Priority_High:
                    ToDoDownWxListCtrl->SetItem(tmp, 1, "high");
                    break;
	            case GSM_Priority_Medium:
                    ToDoDownWxListCtrl->SetItem(tmp, 1, "medium");
                    break;
	            case GSM_Priority_Low:
                    ToDoDownWxListCtrl->SetItem(tmp, 1, "low");
                    break;
                }
                break;
	        case ToDo_Bool_Completed:
                tmp = ToDoDownWxListCtrl->InsertItem(EntryNum++, "Completed", 0);
                ToDoDownWxListCtrl->SetItem(tmp, 1, "yes");
                break;
	        case ToDo_DateTime_End:
                tmp = ToDoDownWxListCtrl->InsertItem(EntryNum++, "End", 0);
                PrintDT(&SubEntry->DT, buff3);
                ToDoDownWxListCtrl->SetItem(tmp, 1, buff3);
                break;
	        case ToDo_DateTime_ToneAlarm:
                tmp = ToDoDownWxListCtrl->InsertItem(EntryNum++, "Alarm with tone", 0);
                PrintDT(&SubEntry->DT, buff3);
                ToDoDownWxListCtrl->SetItem(tmp, 1, buff3);
                break;
	        case ToDo_DateTime_SilentAlarm:
                tmp = ToDoDownWxListCtrl->InsertItem(EntryNum++, "Silent alarm", 0);
                PrintDT(&SubEntry->DT, buff3);
                ToDoDownWxListCtrl->SetItem(tmp, 1, buff3);
            }
        }
        
        break;
    }        
}

BOOLEAN PhoneFrm::CheckToDo()
{
    GSM_Backup_ToDoEntry *ToDoEntry;

    if (Phone) {
        return TRUE;
    } else {
        ToDoGetWxButton->Show(FALSE);
        ToDoEntry = NULL;
        if (Backup->GetNext_ToDo(&ToDoEntry)) {
            DisplayToDo();
            return TRUE;
        }
        return FALSE;
    }
}

//-------------------------------------- Java ----------------------------------------

/*
 * JavaGetWxButtonClick
 */
void PhoneFrm::JavaGetWxButtonClick(wxCommandEvent& event)
{
	GSM_Error		                   error;
	wchart			                   ID;
	unsignedstring		               Buffer2,Name;
	BOOLEAN 		                   NeedSubFolder,Start;
	FileFolderInfo 	                   FInfo;
	int 			                   i=1;
	long                               Num=0;
    GSM_FileFolderInfoListsSubEntry    List;

    JavaUpWxListCtrl->DeleteAllItems();

	while (true) {
		Start = TRUE;
		while (true) {
			if (i==1 ) {
				error = s->Phones->Current->GetJavaGamesFolderID(&ID, &NeedSubFolder, Start);
			} else {
				error = s->Phones->Current->GetJavaAppsFolderID(&ID, &NeedSubFolder, Start);
			}
			Start = FALSE;
			if (error.Code == GSM_ERR_FOLDER_MORE) continue;
			PrintError(error);
			break;
		}
        FInfo.Folder = TRUE;
		FInfo.SetID((wchar_t *)ID.data());        
		if (i==1) {
            FindJADFiles(&Num,&FInfo,TRUE,Name,TRUE);
        } else {
            FindJADFiles(&Num,&FInfo,TRUE,Name,FALSE);
        }

		i++;
		if (i==3) break;
	}
}

BOOLEAN PhoneFrm::FindJADFiles(long *Num, FileFolderInfo *FInfo, BOOLEAN DetailsAvail, unsignedstring Name, BOOLEAN Game)
{
    long                            tmp;
	GSM_FileFolderInfoListsSubEntry *List;
	GSM_FileFolderInfoListSubEntry  *SubEntry;
	BOOLEAN 			            x;
	GSM_File			            *File;
	GSM_Error			            error;
	int 				            JAD_JAR_Size;
	unsignedstring 			        JAD_Vendor, JAD_Name, JAD_JAR, JAD_Version;

	if (DetailsAvail == FALSE) {
		error = s->Phones->Current->GetFileFolderInfo(FInfo);
		PrintError(error);
	}
	if (FInfo->Folder == FALSE) {
		if (StringCaseStr(UnicodeToStringReturn(FInfo->Name.data()),".jad")!=NULL) {
            File = new GSM_File;
			File->Info.SetID((wchar_t *)FInfo->ID.data());
            File->Info.Name.clear();
            File->Info.Name.append(FInfo->Name.data(),UnicodeLength(FInfo->Name.data()));			
            if (!ReadOneFile(File)) {
                delete File;
                return FALSE;
            }
            Backup->Add_JAD(File);
			File->JAD_Find_Data(&JAD_Vendor, &JAD_Name, &JAD_JAR, &JAD_Version, &JAD_JAR_Size);
			if (Name.length() != 0) {
				return StringCaseCmp((char *)JAD_Name.data(),(char *)Name.data(),-1);
			} else {
                if (Game) {
                    tmp = JavaUpWxListCtrl->InsertItem((*Num)++, "Game", 0);
                } else {
                    tmp = JavaUpWxListCtrl->InsertItem((*Num)++, "Application", 0);
                }
                JavaUpWxListCtrl->SetItem(tmp, 1, JAD_Name.data());                
                JavaUpWxListCtrl->SetItemData(tmp, (*Num)-1);                
			}
		}
		return FALSE;
	}

    GetFolderContent(FInfo->ID.data());

    List = NULL;
    while (s->Phones->Current->FoldersCache.GetNext(&List)) {
        if (!wcscmp(List->Info.Info.ID.data(),FInfo->ID.data())) {
            SubEntry = NULL;
            while (List->Info.GetNext(&SubEntry) == TRUE) {
        		x = FindJADFiles(Num,&SubEntry->Info,List->Info.SubEntryFullData,Name,Game);
          		if (x) return x;
            }
            break;
        }
    }
    return FALSE;
}

/*
 * JavaUpWxListCtrlSelected
 */
void PhoneFrm::JavaUpWxListCtrlSelected(wxListEvent& event)
{
    wchart                          Text;
    long                            tmp, item;
    int                             num=0;
    boolean                         found;
    GSM_Backup_JADEntry             *JADEntry;
	int 				            Num=0;
	GSM_Error			            error;
	int 				            JAD_JAR_Size;
	unsignedstring 			        JAD_Vendor, JAD_Name, JAD_JAR, JAD_Version;

    item = JavaUpWxListCtrl->GetNextItem(-1,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);
    item = JavaUpWxListCtrl->GetNextItem(item,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);
    if (item!=-1) return;

    item = JavaUpWxListCtrl->GetNextItem(-1,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);

    JavaDownWxListCtrl->DeleteAllItems();

    JADEntry = NULL;
    while (Backup->GetNext_JAD(&JADEntry)) {
        if (JavaUpWxListCtrl->GetItemData(item)!=num) {
            num++;
            continue;
        }

        JADEntry->GetEntry()->JAD_Find_Data(&JAD_Vendor, &JAD_Name, &JAD_JAR, &JAD_Version, &JAD_JAR_Size);
        tmp = JavaDownWxListCtrl->InsertItem(Num++, "Name", 0);
        JavaDownWxListCtrl->SetItem(tmp, 1, JAD_Name.data());
        tmp = JavaDownWxListCtrl->InsertItem(Num++, "Author", 0);
        JavaDownWxListCtrl->SetItem(tmp, 1, JAD_Vendor.data());
        tmp = JavaDownWxListCtrl->InsertItem(Num++, "Version", 0);
        JavaDownWxListCtrl->SetItem(tmp, 1, JAD_Version.data());
//JAD_JAR_Size+File.Info.Size
        break;
    }
}

void PhoneFrm::AddJava(BOOLEAN Game)
{
    GSM_File            File;
    long                Num;
	GSM_Error           error;
    FileFolderInfo      *FInfo2;
	wchart			    ID;
	BOOLEAN 		    NeedSubFolder;
	GSM_File		    JAD_File, JAR_File;
	char			    Buffer2[500];
	unsignedstring 		JAD_Vendor, JAD_Name, JAD_JAR, JAD_Version;
	int 			    JAD_JAR_Size,pos;
	BOOLEAN			    Start, Found;
	FileFolderInfo 	    FInfo;

    parent->WxOpenFileDialog1->SetWildcard("JAD files (*.jad)|*.jad");
    parent->WxOpenFileDialog1->SetMessage("Please select file for adding");
    if (parent->WxOpenFileDialog1->ShowModal()!=wxID_OK) {
        parent->WxOpenFileDialog1->SetWildcard("");        
        return;
    }
    parent->WxOpenFileDialog1->SetWildcard("");

    if (!JAD_File.ReadFromDisk(StringToUnicodeReturn((char *)parent->WxOpenFileDialog1->GetPath().c_str()))) {
        wxMessageBox("Can't read JAD file",
            wxT("Error"),
            wxICON_WARNING | wxOK);
    }

    sprintf(Buffer2,"%s",(char *)parent->WxOpenFileDialog1->GetPath().c_str());
    Buffer2[strlen(Buffer2)-1]='r';
    if (!JAR_File.ReadFromDisk(StringToUnicodeReturn((char *)Buffer2))) {
        wxMessageBox("Can't read JAR file",
            wxT("Error"),
            wxICON_WARNING | wxOK);
    }

	//---------------------- checking JAD content -------------------------

	JAD_File.JAD_Find_Data(&JAD_Vendor, &JAD_Name, &JAD_JAR, &JAD_Version, &JAD_JAR_Size);
	if (JAD_Vendor.size()==0) {
        wxMessageBox("No vendor info in JAD file",
            wxT("Error"),
            wxICON_WARNING | wxOK);
        return;
    }
	if (JAD_Name.size()==0) {
        wxMessageBox("No name in JAD file",
            wxT("Error"),
            wxICON_WARNING | wxOK);
        return;
    }
	if (JAD_JAR.size()==0) {
        wxMessageBox("No JAR URL in JAD file",
            wxT("Error"),
            wxICON_WARNING | wxOK);
        return;
    }
	if (JAD_JAR_Size!=JAR_File.Buffer.size()) {
		printf("Wrong JAD file size inside JAR\n");
//		printf("JAD size will be fixed inside file %i %i\n",JAD_JAR_Size,JAR_File.Buffer.size());
	}

	// no http path in JAR name allowed for many phones
	if (strstr((char *)JAD_JAR.data(),"http://") != NULL) {
		pos = JAD_JAR.length()-1;
		while (JAD_JAR.data()[pos] != '/') pos--;
		strcpy(Buffer2,(char *)JAD_JAR.data()+pos+1);
		JAD_JAR.clear();
		JAD_JAR.append((unsigned char *)Buffer2,strlen(Buffer2));
	}

	// Changing all #13 or #10 to #13#10 in JAD
	JAD_File.SetWin32EndLines();

	//---------------------------------------------------------------------

//	printf("Adding \"%s\" (version \"%s\") created by \"%s\"\n",JAD_Name.data(),JAD_Version.data(),JAD_Vendor.data());

	Start = TRUE;
	while (true) {
		if (Game) {
			error = s->Phones->Current->GetJavaGamesFolderID(&ID, &NeedSubFolder, Start);
		} else {
			error = s->Phones->Current->GetJavaAppsFolderID(&ID, &NeedSubFolder, Start);
		}
		Start = FALSE;
		if (error.Code == GSM_ERR_FOLDER_MORE) continue;
		PrintError(error);
		break;
	}

	// ----------------------- search for midlet in phone -----------------
	// -------------------- if found, replace old application -------------
	FInfo.SetID((wchar_t *)ID.data());
	Found = FindJADFiles(&Num, &FInfo, FALSE, JAD_Name, FALSE);
	if (Found) {
		ID.clear();
		ID.append(FInfo.ID.data(),UnicodeLength(FInfo.ID.data()));
        if (wxMessageBox("Do you want to replace old version in phone ?",
              wxT("Question"),
             wxICON_WARNING | wxYES_NO) !=  wxYES) {
            return;
        }
	} else {
		if (NeedSubFolder) {
			FInfo.SetID((wchar_t *)ID.data());
			sprintf(Buffer2,"%s",JAD_JAR.data());
			Buffer2[strlen(Buffer2)-4] = 0;
			FInfo.SetName(StringToUnicodeReturn(Buffer2));

			error = s->Phones->Current->AddFolder(&FInfo);
			PrintError(error);

			ID.clear();
			ID.append(FInfo.ID.data(),UnicodeLength(FInfo.ID.data()));
		}
	}

	//------------------------- writing files -----------------------------

	printf("Writing JAD file\n");
	sprintf(Buffer2,"%s",JAD_JAR.data());
	Buffer2[strlen(Buffer2)-1] = 'd';
	JAD_File.Info.SetName(StringToUnicodeReturn(Buffer2));
	JAD_File.Info.SetID((wchar_t *)ID.data());
	JAD_File.Info.DRMForwardLock = FALSE;
	JAD_File.Info.ReadOnly	 = FALSE;
	JAD_File.Info.Hidden	 = FALSE;
	JAD_File.Info.System	 = FALSE;
    UploadFile(&JAD_File);

	printf("Writing JAR file\n");
	sprintf(Buffer2,"%s",JAD_JAR.data());
	JAR_File.Info.SetName(StringToUnicodeReturn(Buffer2));
	JAR_File.Info.SetID((wchar_t *)ID.data());
	JAR_File.Info.DRMForwardLock = FALSE;
	JAR_File.Info.ReadOnly	 = FALSE;
	JAR_File.Info.Hidden	 = FALSE;
	JAR_File.Info.System	 = FALSE;
    UploadFile(&JAR_File);

return;

    FInfo2 = new FileFolderInfo;
    FInfo2->SetName((wchar_t *)File.Info.Name.data());
    FInfo2->Folder = FALSE;
    FInfo2->SetID((wchar_t *)File.Info.ID.data());
    memcpy(&FInfo2->ModificationDateTime,&File.Info.ModificationDateTime,sizeof(GSM_DateTime));
    FInfo2->ModificationDateTimeAvailable = TRUE;
    FInfo2->Size = File.Info.Size;
    FInfo2->DRMForwardLock = File.Info.DRMForwardLock;
    FInfo2->ReadOnly = File.Info.ReadOnly;
    FInfo2->Hidden = File.Info.Hidden;
    FInfo2->System = File.Info.System;
    En2->Info.AddSubEntry(FInfo2);

    DisplayFolder();
}

/*
 * GameAddWxButtonClick
 */
void PhoneFrm::GameAddWxButtonClick(wxCommandEvent& event)
{
    PhoneFrm::AddJava(TRUE);
}

/*
 * AppAddWxButtonClick
 */
void PhoneFrm::AppAddWxButtonClick(wxCommandEvent& event)
{
    PhoneFrm::AddJava(FALSE);
}
