/* (C) 2006-2007 by Marcin Wiacek www.mwiacek.com */

#include <string.h>
#include <sys/stat.h>
#include <stdlib.h>
#ifdef WIN32
#  include <sys/types.h>
#  ifndef BORLANDC
#    include <sys/utime.h>
#  endif
#else
#  include <netdb.h>
#  include <netinet/in.h>
#  include <utime.h>
#endif

#include "../../cfg/config.h"
#include "../misc/coding/coding.h"
#include "gsmfiles.h"
#include "../misc/files.h"

GSM_FileFolderInfoListSubEntry::GSM_FileFolderInfoListSubEntry()
{
	Next = NULL;
}

GSM_FileFolderInfoListSubEntry::~GSM_FileFolderInfoListSubEntry()
{
	delete(Next);
}

GSM_FileFolderInfoListSubEntry *GSM_FileFolderInfoListSubEntry::GetNext()
{
	return Next;
}

void GSM_FileFolderInfoListSubEntry::SetNext(GSM_FileFolderInfoListSubEntry *Nxt)
{
	Next = Nxt;
}

//-----------------------------------------------------------------------------

GSM_FileFolderInfoList::GSM_FileFolderInfoList()
{
	Entries = NULL;
}

GSM_FileFolderInfoList::~GSM_FileFolderInfoList()
{
	delete (Entries);
}

GSM_Error GSM_FileFolderInfoList::AddSubEntry(FileFolderInfo *FInfo)
{
	GSM_FileFolderInfoListSubEntry *Entry,*Entry2;

	Entry = new GSM_FileFolderInfoListSubEntry;
	if (Entry==NULL) return GSM_Return_Error(GSM_ERR_UNKNOWN);

	Entry->Info.Folder 		= FInfo->Folder;
	Entry->Info.DRMForwardLock 	= FInfo->DRMForwardLock;
	Entry->Info.ReadOnly 		= FInfo->ReadOnly;
	Entry->Info.Hidden 		= FInfo->Hidden;
	Entry->Info.System 		= FInfo->System;
	Entry->Info.ModificationDateTimeAvailable = FInfo->ModificationDateTimeAvailable;
	if (FInfo->ModificationDateTimeAvailable == TRUE) {
		memcpy(&Entry->Info.ModificationDateTime,&FInfo->ModificationDateTime,sizeof(GSM_DateTime));
	}
	Entry->Info.Size = FInfo->Size;
	Entry->Info.SetID((wchar_t *)FInfo->ID.data());
	if (FInfo->Name.size()!=0) Entry->Info.SetName((wchar_t *)FInfo->Name.data());

	if (Entries == NULL) {
		Entries = Entry;
	} else {
		Entry2 = Entries;
		while (Entry2->GetNext()!=NULL) Entry2 = Entry2->GetNext();
		Entry2->SetNext(Entry);
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

BOOLEAN GSM_FileFolderInfoList::GetNext(GSM_FileFolderInfoListSubEntry **En)
{
	if ((*En) == NULL) {
		(*En) = Entries;
	} else {
		(*En) = (*En)->GetNext();
	}
	if ((*En) == NULL) return FALSE;
	return TRUE;
}

void GSM_FileFolderInfoList::ClearAll()
{
	delete(Entries);
	Entries = NULL;
}

//----------------------------------------------------------------------------------

GSM_File::GSM_File()
{
}

GSM_File::~GSM_File()
{
}

void GSM_File::JAD_Find_Line(char *Name, unsignedstring *Value)
{
	char 	Line[2000];
	unsigned int	Pos = 0;

	Value->clear();

	while (Pos<Buffer.size()) {
		Line[0] = 0;
		while (Pos<Buffer.size()) {
			if (Buffer.data()[Pos] == 0x00) break;
			if (Buffer.data()[Pos] == 0x0A || Buffer.data()[Pos] == 0x0D) {
				Pos++;
				if (strlen(Line)!=0x00) break;
				continue;
			}
			Line[strlen(Line) + 1] = 0;
			Line[strlen(Line)]     = Buffer.data()[Pos];
			Pos++;
		}
		if (strlen(Line) == 0) break;
		if (!strncmp(Line,Name,strlen(Name))) {
			Pos = strlen(Name);
			while (Line[Pos] == 0x20) Pos++;
			Value->append((unsigned char *)Line+Pos,strlen(Line+Pos));
			return;
		}
	}
}

void GSM_File::JAD_Find_Data(unsignedstring *Vendor, unsignedstring *Name, unsignedstring *JAR, unsignedstring *Version, int *Size)
{
	unsignedstring Size2;

	JAD_Find_Line("MIDlet-Vendor:", Vendor);
	JAD_Find_Line("MIDlet-Name:", Name);
	JAD_Find_Line("MIDlet-Jar-URL:", JAR);
	JAD_Find_Line("MIDlet-Version:", Version);
	JAD_Find_Line("MIDlet-Jar-Size:", &Size2);
	*Size = -1;
	if (Size2.length() != 0) (*Size) = atoi((char *)Size2.data());
}

void GSM_File::SetWin32EndLines()
{
	unsignedstring str;

	// Changing all #13 or #10 to #13#10 in JAD
	str.push_back(13);
	UnsignedStringReplaceChars(&Buffer, 10, str);
	str.clear();
	str.push_back(13);
	str.push_back(10);
	UnsignedStringReplaceChars(&Buffer, 13, str);
	Info.Size = Buffer.size();

}

//-----------------------------------------------------------------------------

GSM_FileFolderInfoListsSubEntry::GSM_FileFolderInfoListsSubEntry()
{
	Next = NULL;
}

GSM_FileFolderInfoListsSubEntry::~GSM_FileFolderInfoListsSubEntry()
{
	delete(Next);
}

GSM_FileFolderInfoListsSubEntry *GSM_FileFolderInfoListsSubEntry::GetNext()
{
	return Next;
}

void GSM_FileFolderInfoListsSubEntry::SetNext(GSM_FileFolderInfoListsSubEntry *Nxt)
{
	Next = Nxt;
}

//-----------------------------------------------------------------------------

GSM_FileFolderInfoLists::GSM_FileFolderInfoLists()
{
	Entries = NULL;
}

GSM_FileFolderInfoLists::~GSM_FileFolderInfoLists()
{
	delete (Entries);
}

GSM_Error GSM_FileFolderInfoLists::AddSubEntry(GSM_FileFolderInfoListsSubEntry *FInfo)
{
	GSM_FileFolderInfoListsSubEntry *Entry2;

	if (Entries == NULL) {
		Entries = FInfo;
	} else {
		Entry2 = Entries;
		while (Entry2->GetNext()!=NULL) Entry2 = Entry2->GetNext();
		Entry2->SetNext(FInfo);
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

BOOLEAN GSM_FileFolderInfoLists::GetNext(GSM_FileFolderInfoListsSubEntry **En)
{
	if ((*En) == NULL) {
		(*En) = Entries;
	} else {
		(*En) = (*En)->GetNext();
	}
	if ((*En) == NULL) return FALSE;
	return TRUE;
}

void GSM_FileFolderInfoLists::ClearAll()
{
	delete(Entries);
	Entries = NULL;
}
