/* (C) 2003 - 2006 by Marcin Wiacek www.mwiacek.com */

#include <stdio.h>

#include "../../../service/gsmmisc.h"
#include "../../../device/gsmdev.h"
#include "../../gsmphone.h"
#include "../ndct34.h"

class GSM_Protocol;
class GSM_Protocol_Message;

typedef struct {
        int                     NoteID;
        GSM_Calendar_Type       NoteType;
} GSM_Cal_Types;

class GSM_Phone_N6510:virtual public GSM_Phone
{
public:
        GSM_Phone_N6510(DebugInfo **Deb, GSM_Device **Dev, GSM_AllProtocols **Prot, GSM_AllPhones **Pho):GSM_Phone(Deb,Dev,Prot,Pho) {
        /*1*/   Info.push_back(GSM_Phone_Info("3100" , "RH-19"  ,  ""            ,"fbus", ""));
        /*1*/   Info.push_back(GSM_Phone_Info("3120" , "RH-19"  ,  ""            ,"fbus", ""));
        /*1*/   Info.push_back(GSM_Phone_Info("3100b", "RH-50"  ,  ""            ,"fbus", ""));
        /*1*/   Info.push_back(GSM_Phone_Info("3120b", "RH-50"  ,  ""            ,"fbus", ""));
        /*1*/   Info.push_back(GSM_Phone_Info("3200" , "RH-30"  ,  ""            ,"fbus|irdaphonet", ""));//fixme
        /*1*/   Info.push_back(GSM_Phone_Info("3200b", "RH-31"  ,  ""            ,"fbus|irdaphonet", ""));//fixme
        /*2*/   Info.push_back(GSM_Phone_Info("3220" , "RH-37"  ,  ""            ,"fbus", ""));
        /*2*/   Info.push_back(GSM_Phone_Info("3220b" ,"RH-49"  ,  ""            ,"fbus", ""));
        /*1*/   Info.push_back(GSM_Phone_Info("3300" , "NEM-1"  ,  ""            ,"fbus", ""));
        /*1*/   Info.push_back(GSM_Phone_Info("3300b", "NEM-2"  ,  ""            ,"fbus", ""));
        /*1*/   Info.push_back(GSM_Phone_Info("3510" , "NHM-8"  ,  ""            ,"fbus", "-cal35--file1only-"));
        /*1*/   Info.push_back(GSM_Phone_Info("3510i", "RH-9"   ,  ""            ,"fbus", "-cal35--file1only-"));
        /*1*/   Info.push_back(GSM_Phone_Info("5100" , "NPM-6"  ,  "Nokia 5100"  ,"fbus|irdaphonet|dku5fbus|dku5", "-file1only-"));
        /*1*/   Info.push_back(GSM_Phone_Info("5100" , "NPM-6U" ,  "Nokia 5100"  ,"fbus|irdaphonet|dku5fbus|dku5", "-file1only-"));
        /*1*/   Info.push_back(GSM_Phone_Info("5100" , "NPM-6X" ,  "Nokia 5100"  ,"fbus|irdaphonet", "-file1only-"));
        /*2*/   Info.push_back(GSM_Phone_Info("5140" , "NPL-5"  ,  "Nokia 5140"  ,"fbus|irdaphonet", ""));
        /*2*/   Info.push_back(GSM_Phone_Info("5140b", "NPL-4"  ,  "Nokia 5140"  ,"fbus|irdaphonet", ""));
        /*2*/   Info.push_back(GSM_Phone_Info("5140i", "RM-104" ,  "Nokia 5140i" ,"fbus|irdaphonet", ""));
//5200 - RM-174
        /*2*/   Info.push_back(GSM_Phone_Info("6020" , "RM-30"  ,  "Nokia 6020"  ,"fbus|irdaphonet", ""));
        /*2*/   Info.push_back(GSM_Phone_Info("6020b", "RM-31"  ,  "Nokia 6020"  ,"fbus|irdaphonet", ""));
        /*1*/   Info.push_back(GSM_Phone_Info("6100" , "NPL-2"  ,  "Nokia 6100"  ,"fbus|irdaphonet|bluephonet|bluerfphonet|dku2phonet|dku2", ""));
        /*3*/   Info.push_back(GSM_Phone_Info("6111" , "RM-82"  ,  "Nokia 6111"  ,"fbus|irdaphonet|bluephonet|bluerfphonet|dku2phonet|dku2", "-s40_30--todo6610-"));
        /*1*/   Info.push_back(GSM_Phone_Info("6170" , "RM-47"  ,  "Nokia 6170"  ,"fbus|irdaphonet|dku2phonet|dku2", ""));
        /*1*/   Info.push_back(GSM_Phone_Info("6220" , "RH-20"  ,  "Nokia 6220"  ,"fbus|irdaphonet|dku5fbus|dku5", "-file1only-"));
        /*2*/   Info.push_back(GSM_Phone_Info("6230" , "RH-12"  ,  "Nokia 6230"  ,"fbus|irdaphonet|bluephonet|bluerfphonet|dku2phonet|dku2", "-file1-"));
        /*2*/   Info.push_back(GSM_Phone_Info("6230b", "RH-28"  ,  "Nokia 6230"  ,"fbus|irdaphonet|bluephonet|bluerfphonet|dku2phonet|dku2", "-file1-"));
        /*2*/   Info.push_back(GSM_Phone_Info("6230i", "RM-72"  ,  "Nokia 6230i" ,"fbus|irdaphonet|bluephonet|bluerfphonet|dku2phonet|dku2", "-file1-"));
        /*3*/   Info.push_back(GSM_Phone_Info("6233",  "RM-145" ,  "Nokia 6233"  ,"fbus|irdaphonet|bluephonet|bluerfphonet|dku2phonet|dku2", "-s40_30-"));
        /*3*/   Info.push_back(GSM_Phone_Info("6234",  "RM-123" ,  "Nokia 6234"  ,"fbus|irdaphonet|bluephonet|bluerfphonet|dku2phonet|dku2", "-s40_30-"));
                Info.push_back(GSM_Phone_Info("6310",  "NPE-4"  ,  "Nokia 6310"  ,"fbus|irdaphonet|bluephonet|bluerfphonet|dlr3fbus|dlr3", "-cal65--nofile-"));
                Info.push_back(GSM_Phone_Info("6310i", "NPL-1"  ,  "Nokia 6310i" ,"fbus|irdaphonet|bluephonet|bluerfphonet|dlr3fbus|dlr3", "-cal65--file1only-"));
                Info.push_back(GSM_Phone_Info("6510" , "NPM-9"  ,  "Nokia 6510"  ,"fbus|irdaphonet", "-cal65-"));
                Info.push_back(GSM_Phone_Info("6610" , "NHL-4U" ,  "Nokia 6610"  ,"fbus|irdaphonet", ""));
                Info.push_back(GSM_Phone_Info("6610i", "RM-37"  ,  "Nokia 6610i" ,"fbus|irdaphonet", ""));
                Info.push_back(GSM_Phone_Info("6650" , "NHM-1"  ,  "Nokia 6650"  ,"fbus|irdaphonet", ""));
                Info.push_back(GSM_Phone_Info("6800" , "NHL-6"  ,  "Nokia 6800"  ,"fbus|irdaphonet", ""));
                Info.push_back(GSM_Phone_Info("6800" , "NSB-9"  ,  "Nokia 6800"  ,"fbus|irdaphonet", ""));
                Info.push_back(GSM_Phone_Info("6810" , "RM-2"   ,  "Nokia 6810"  ,"fbus|irdaphonet", ""));
                Info.push_back(GSM_Phone_Info("6820" , "NHL-9"  ,  "Nokia 6820"  ,"fbus|irdaphonet", ""));
                Info.push_back(GSM_Phone_Info("7200" , "RH-23"  ,  "Nokia 7200"  ,"fbus|irdaphonet", ""));
                Info.push_back(GSM_Phone_Info("7200" , "RH-33"  ,  "Nokia 7200"  ,"fbus|irdaphonet", ""));
                Info.push_back(GSM_Phone_Info("7210" , "NHL-4"  ,  "Nokia 7210"  ,"fbus|irdaphonet", ""));
                Info.push_back(GSM_Phone_Info("7250" , "NHL-4J" ,  "Nokia 7250"  ,"fbus|irdaphonet", ""));
                Info.push_back(GSM_Phone_Info("7250i", "NHL-4JX",  "Nokia 7250i" ,"fbus|irdaphonet", ""));
                Info.push_back(GSM_Phone_Info("7270" , "RM-8"   ,  "Nokia 7270"  ,"fbus|irdaphonet|dku2phonet|dku2", ""));
                Info.push_back(GSM_Phone_Info("7600" , "NMM-3"  ,  "Nokia 7600"  ,"fbus|irdaphonet", ""));
                Info.push_back(GSM_Phone_Info("8910" , "NHM-4"  ,  "Nokia 8910"  ,"fbus|irdaphonet", ""));
                Info.push_back(GSM_Phone_Info("8910i", "NHM-4NX",  "Nokia 8910i" ,"fbus|irdaphonet", ""));

                DCT34 = new GSM_Phone_NDCT34((*Phones)->GetID(),Deb,&(*Phones));

                ModuleName      = "dct4s40/n6510";
                ModulesUsed     = "";
                ModulesRequired = "";

                for (int i=0;i<5;i++) {
                        CalendarIcons[i].NoteType = Calendar_Type_Not_Assigned;
                }
        }
        ~GSM_Phone_N6510() {
                delete DCT34;
        }

        GSM_Error        Open                   (char *FrameID);
        GSM_Error        Dispatch               (GSM_Protocol_Message *msg, void *Struct, int RequestID);
        GSM_Error        Close();

        //phone info
        GSM_Error        GetManufacturer        (unsigned char *Manufacturer);
        GSM_Error        GetIMEI                (unsigned char *IMEI);
        GSM_Error        GetCodeNameModel       (unsigned char *Model);
        GSM_Error        GetFirmwareVersion     (unsigned char *Firm);
        GSM_Error        GetFirmwareDate        (unsigned char *Dat);
	GSM_Error 	 GetProductCode		(unsigned char *ProductCode);
        //date time
        GSM_Error        GetDateTime            (GSM_DateTime *DT);
        //phonebook memories
        GSM_Error        GetPBKStatus           (GSM_PBKStatus *Status);
        GSM_Error        GetPBK                 (GSM_PBKEntry *Entry);
        GSM_Error        SetPBK                 (GSM_PBKEntry *Entry);
        GSM_Error        DeletePBK              (GSM_PBKEntry *Entry);
        //calendar
        GSM_Error        GetNextCalendar        (GSM_CalendarEntry *Entry, BOOLEAN start, int *Current, int *Max);
        GSM_Error        AddCalendar            (GSM_CalendarEntry *Entry);
        GSM_Error        DeleteCalendar         (GSM_CalendarEntry *Entry);
        //notes
        GSM_Error        GetNextNote		(GSM_NoteEntry *Entry, BOOLEAN start, int *Current, int *Max);
        GSM_Error        AddNote		(GSM_NoteEntry *Entry);
        GSM_Error        DeleteNote		(GSM_NoteEntry *Entry);
        //todo
        GSM_Error        GetNextToDo		(GSM_ToDoEntry *Entry, BOOLEAN start, int *Current, int *Max);
        GSM_Error        AddToDo		(GSM_ToDoEntry *Entry);
        GSM_Error        DeleteToDo		(GSM_ToDoEntry *Entry);
        //sms
        GSM_Error        GetSMSStatus           (GSM_SMSStatus *Status);
        GSM_Error        GetSMSC                (GSM_SMSC *SMSC);
//      GSM_Error        AddSMS                 (GSM_SMSList *List);
        GSM_Error        SetSMS                 (GSM_SMSList *List);
        GSM_Error        SendSMS                (GSM_SMSEntry *SMS);
        GSM_Error        DeleteSMS              (GSM_SMSList *List);
        //sms & mms
	GSM_Error 	 GetSMSMMSFolders	(GSM_SMSMMSFolders *Folders);
	GSM_Error      GetNextSMSMMSIDFromFolder(BOOLEAN start, GSM_SMSMMSFoldersSubEntry *SMSFolder, GSM_SMSList *SMS, GSM_MMSFile *MMS, int *Current, int *MaxInFolder);
        //filesystem
        GSM_Error        GetFileFolderInfo      (FileFolderInfo *FInfo);
        GSM_Error        GetFolderInfoList      (GSM_FileFolderInfoList *FInfo, BOOLEAN Start);
        GSM_Error        GetNextRootFolderID    (wchar_t *ID, GSM_MemoryType *MemType);
        GSM_Error        GetFilePart            (GSM_File *File);
        GSM_Error        GetMMSFilePart         (GSM_File *File);
        GSM_Error        AddFilePart            (GSM_File *File, int *Pos);
        GSM_Error        DeleteFile             (wchar_t *FileID);
        GSM_Error        DeleteFolder           (wchar_t *FolderID);
        GSM_Error        AddFolder              (FileFolderInfo *FInfo);
        GSM_Error        GetJavaGamesFolderID   (wchart *ID, BOOLEAN *NeedSubFolder, BOOLEAN Start);
        GSM_Error        GetJavaAppsFolderID    (wchart *ID, BOOLEAN *NeedSubFolder, BOOLEAN Start);
private:
        GSM_Phone_NDCT34                *DCT34;
	//pbk
	GSM_PBK_Features		PhonePBKFeatures;
	GSM_PBK_Features		SIMPBKFeatures;
        //calendar
        int                             CurrentCalendarNumber;
        GSM_Cal_Loc                     CalendarLocations;
        GSM_Cal_Types                   CalendarIcons[5];
        //sms 1
        GSM_SMS_Loc                     SMSLocations;
        int                             SMSFoldersNum;
        unsigned char                   SMSFolderID;
        int                             SMSLocation;
        //sms 2
	GSM_FileFolderInfoListsSubEntry *SMSCache2;
        GSM_FileFolderInfoListSubEntry  *SMSSubEntry;
        int                             SMSListMax, SMSListPos;
        GSM_Error                       GetNextSMSFolder2;
        //filesystem 2
        unsignedint                     FileSystemOpened2;
        int                             GetFolderListing2;
	GSM_File			MMSFile;
        //Java folders
        GSM_FileFolderInfoList          JavaFInfo;
        GSM_FileFolderInfoListSubEntry  *JavaFInfoSubEntry;
	
	//calendar,note,todo
	void 		 FindCalendarDateDifference(GSM_DateTime *DT,long diff);
	GSM_Error 	 GetNextCalendar3NoteToDo2(void *Entry, BOOLEAN start, int *Current, int *Max, int *Location, unsigned char Type, int request);
	GSM_Error 	 PrivGetCalendar3NoteToDo2(void *Entry, int Location, int request);
	GSM_Error 	 GetCalendar3NoteToDo2Info(unsigned char type);
        GSM_Error        AddCalendar3           (GSM_CalendarEntry *Entry);
	GSM_Error 	 AddToDo2		(GSM_ToDoEntry *Entry);
        GSM_Error        GetFirstCalendarPos3   (int *Location);
	GSM_Error 	 FindCalendarNoteType3	(GSM_CalendarEntry *Entry, int *NoteID);
        //sms
        GSM_Error        GetSMSFolderStatus1    (GSM_SMS_Loc *SMSLocations);
        GSM_Error        GetSMS1                (GSM_SMSList *List, wchart SMS_ID);
        GSM_Error        GetSMS2                (GSM_SMSList *List, GSM_File *File);
        GSM_Error        DecodeSMSFrame1        (GSM_SMSEntry *SMS, const unsigned char *buffer, int len, GSM_DateTime *SaveDateTime);
        GSM_Error        EncodeSMSFrameToBuffer1(GSM_SMSEntry *SMS, unsignedstring *Buffer);
	GSM_Error     GetNextSMSMMSIDFromFolder1(BOOLEAN start, GSM_SMSMMSFoldersSubEntry *SMSFolder, GSM_SMSList *SMS, GSM_MMSFile *MMS, int *Current, int *MaxInFolder);
	GSM_Error     GetNextSMSMMSIDFromFolder2(BOOLEAN start, GSM_SMSMMSFoldersSubEntry *SMSFolder, GSM_SMSList *SMS, GSM_MMSFile *MMS, int *Current, int *MaxInFolder);
        GSM_Error        GetSMSStatus1          (GSM_SMSStatus *Status);
	GSM_Error 	 GetSMSMMSFolders1	(GSM_SMSMMSFolders *Folders);
	GSM_Error 	 GetSMSMMSFolders2	(GSM_SMSMMSFolders *Folders);
        GSM_Error        SetSMS1                (GSM_SMSList *List);
        GSM_Error        DeleteSMS1             (GSM_SMSList *List);
        GSM_Error        DeleteSMS2             (GSM_SMSList *List);
        //filesystem
        GSM_Error        GetFileFolderInfo1     (FileFolderInfo *FInfo);
        GSM_Error        GetFileFolderInfo2     (FileFolderInfo *FInfo);
        GSM_Error        GetFolderInfoList1     (GSM_FileFolderInfoList *FInfo, BOOLEAN Start);
        GSM_Error        GetFolderInfoList2     (GSM_FileFolderInfoList *FInfo, BOOLEAN Start);
        GSM_Error        GetFilePart1           (GSM_File *File);
        GSM_Error        GetFilePart2           (GSM_File *File);
        GSM_Error        GetFileCheckSum1       (GSM_File *File,unsigned int *CheckSum);
        GSM_Error        GetFileCheckSum2       (GSM_File *File,unsigned int *CheckSum);
        GSM_Error        AddFilePart1           (GSM_File *File, int *Pos);
        GSM_Error        AddFilePart2           (GSM_File *File, int *Pos);
        GSM_Error        OpenFile2              (GSM_File *File, BOOLEAN Create);
        GSM_Error        CloseFile2             (GSM_File *File);
        void             FFolderPathGammu2Phone2(wchar_t *src, unsignedstring *dest);
        unsigned int     FindFileCheckSum12     (const unsigned char *ptr, int len);
        GSM_Error        DeleteFile1            (wchar_t *FileID);
        GSM_Error        DeleteFile2            (wchar_t *FileID);
        GSM_Error        DeleteFolder1          (wchar_t *FolderID);
        GSM_Error        DeleteFolder2          (wchar_t *FolderID);
        GSM_Error        DeleteFFolder1         (wchar_t *MyID);
        GSM_Error        AddFolder1             (FileFolderInfo *FInfo);
        GSM_Error        AddFolder2             (FileFolderInfo *FInfo);
        GSM_Error        MakeFileSystemFrame2   (unsignedstring *Buffer, wchar_t *Name, unsigned char ID);
        GSM_Error        FileSystemFunc         (wchar_t *ID, int *Num);
	//pbk
        GSM_Error        ReplyGetPBKStatus      (GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
        GSM_Error        ReplyGetIMEI           (GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *IMEI);
        GSM_Error        ReplyGetPBK            (GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
	GSM_Error 	 ReplyGetProductCode	(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *ProductCode);
	//calendar,todo,notes
        GSM_Error        ReplyGetNextToDo2      (GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
        GSM_Error        ReplyGetNextNote       (GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
        GSM_Error        ReplyGetNextCalendar3  (GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
        GSM_Error        ReplyGetCalendarNoteToDoInfo3(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
        GSM_Error        ReplyGetDateTime       (GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
        GSM_Error        ReplyAddCalendar3      (GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
        GSM_Error        ReplyGetFirstCalPos3   (GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
        //sms
        GSM_Error        ReplyGetSMSStatus1     (GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
        GSM_Error        ReplyGetSMS1           (GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
        GSM_Error        ReplyGetSMSFolders1    (GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
        GSM_Error        ReplyGetSMSFolderStatus1(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
        GSM_Error        ReplySetSMS1           (GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
        GSM_Error        ReplyDeleteSMS1        (GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
        GSM_Error        ReplyGetSMSC           (GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
        GSM_Error        ReplySendSMS           (GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
        //filesystem
        GSM_Error        ReplyGetFFolderInfo1   (GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
        GSM_Error        ReplyGetFFolderInfo2   (GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
        GSM_Error        ReplyGetFolderInfoList1(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
        GSM_Error        ReplyGetFolderInfoList2(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
        GSM_Error        ReplyGetFFolderInfo2Part(GSM_Protocol_Message *msg, DebugInfo **Debug, FileFolderInfo *FInfo);
        GSM_Error        ReplyOpenFile2         (GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
        GSM_Error        ReplyAddFilePart1      (GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
        GSM_Error        ReplyGetFilePart12     (GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
        GSM_Error        ReplyGetFileCheckSum12 (GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
        GSM_Error        ReplyAddFolder1        (GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
        GSM_Error        ReplyAddFolder2        (GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
        GSM_Error        ReplyDeleteFFolder1    (GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
        GSM_Error        ReplyDeleteFolder2     (GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
        GSM_Error        ReplyDeleteFile2       (GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
};
