/* (C) 2003 - 2006 by Marcin Wiacek www.mwiacek.com */

#include "../../../../cfg/config.h" //msvc2005
#include "../../../misc/coding/coding.h"
#include "../../../protocol/gsmprot.h"
#include "../../../service/gsmmisc.h"
#include "../ndct34.h"
#include "n6510.h"
#include "6510cal.cpp"
#include "6510file.cpp"
#include "6510sms.cpp"

GSM_Error GSM_Phone_N6510::Dispatch(GSM_Protocol_Message *msg, void *Struct, int RequestID)
{
	int		ID3 = DCT34->GetID();
	AnsStruct 	AS;

	AS.RequestID  = RequestID;
	AS.FrameFound = false;

if(Ans("\x02",0x03,0x03,ID_IncomingFrame,&AS))     	return ReplySendSMS	 		(msg,Debug,(unsigned char *)Struct);
if(Ans("\x02",0x03,0x15,ID_GetSMSC+ID,&AS))     	return ReplyGetSMSC	 		(msg,Debug,(unsigned char *)Struct);

if(Ans("\x03",0x03,0x04,ID_GetPBKStatus+ID,&AS))     	return ReplyGetPBKStatus 		(msg,Debug,(unsigned char *)Struct);
if(Ans("\x03",0x03,0x08,ID_GetPBK+ID, &AS))     	return ReplyGetPBK 			(msg,Debug,(unsigned char *)Struct);
if(Ans("\x03",0x03,0x0C,ID_SetPBK+ID, &AS))     	return DCT34->ReplySetPBK 		(msg,Debug,(unsigned char *)Struct);
if(Ans("\x03",0x03,0x10,ID_DelPBK+ID, &AS))     	return DCT34->ReplyDelPBK 		(msg,Debug,(unsigned char *)Struct);
if(Ans("\x03",0x03,0x26,ID_GetPBK+ID3, &AS))     	return DCT34->ReplyGetPBKFeatures 	(msg,Debug,(unsigned char *)Struct);

if(Ans("\x13",0x03,0x02,ID_AddCalendar+ID3,&AS))   	return DCT34->ReplyAddCalendar1		(msg,Debug,(unsigned char *)Struct);
if(Ans("\x13",0x03,0x04,ID_AddCalendar+ID3,&AS))   	return DCT34->ReplyAddCalendar1		(msg,Debug,(unsigned char *)Struct);
if(Ans("\x13",0x03,0x06,ID_AddCalendar+ID3,&AS))   	return DCT34->ReplyAddCalendar1		(msg,Debug,(unsigned char *)Struct);
if(Ans("\x13",0x03,0x08,ID_AddCalendar+ID3,&AS))   	return DCT34->ReplyAddCalendar1		(msg,Debug,(unsigned char *)Struct);
if(Ans("\x13",0x03,0x0C,ID_DelCalendar+ID3,&AS))   	return DCT34->ReplyDelCalendar		(msg,Debug,(unsigned char *)Struct);
if(Ans("\x13",0x03,0x1A,ID_GetCalendar+ID3,&AS))   	return DCT34->ReplyGetNextCalendar1	(msg,Debug,(unsigned char *)Struct);
if(Ans("\x13",0x03,0x32,ID_GetFirstCalendarPos+ID3,&AS))return DCT34->ReplyGetFirstCalPos1	(msg,Debug,(unsigned char *)Struct);
if(Ans("\x13",0x03,0x3B,ID_GetCalendarInfo+ID3,&AS))    return DCT34->ReplyGetCalendarInfo1	(msg,Debug,(unsigned char *)Struct);
if(Ans("\x13",0x03,0x41,ID_AddCalendar+ID3,&AS))   	return DCT34->ReplyAddCalendar2		(msg,Debug,(unsigned char *)Struct);
if(Ans("\x13",0x03,0x66,ID_AddCalendar+ID,&AS))   	return ReplyAddCalendar3		(msg,Debug,(unsigned char *)Struct);
if(Ans("\x13",0x03,0x7E,ID_GetToDo+ID,&AS))    		return ReplyGetNextToDo2 		(msg,Debug,(unsigned char *)Struct);
if(Ans("\x13",0x03,0x7E,ID_GetCalendar+ID,&AS))    	return ReplyGetNextCalendar3		(msg,Debug,(unsigned char *)Struct);
if(Ans("\x13",0x03,0x7E,ID_GetNote+ID,&AS))    		return ReplyGetNextNote 		(msg,Debug,(unsigned char *)Struct);
if(Ans("\x13",0x03,0x96,ID_GetFirstCalendarPos+ID,&AS)) return ReplyGetFirstCalPos3		(msg,Debug,(unsigned char *)Struct);
if(Ans("\x13",0x03,0x9F,ID_GetCalendarInfo+ID,&AS))     return ReplyGetCalendarNoteToDoInfo3	(msg,Debug,(unsigned char *)Struct);

if(Ans("\x14",0x03,0x01,ID_SetSMS+ID,&AS))     		return ReplySetSMS1			(msg,Debug,(unsigned char *)Struct);
if(Ans("\x14",0x03,0x03,ID_GetSMS+ID,&AS))     		return ReplyGetSMS1			(msg,Debug,(unsigned char *)Struct);
if(Ans("\x14",0x03,0x05,ID_DelSMS+ID,&AS))     		return ReplyDeleteSMS1			(msg,Debug,(unsigned char *)Struct);
if(Ans("\x14",0x03,0x06,ID_DelSMS+ID,&AS))     		return ReplyDeleteSMS1			(msg,Debug,(unsigned char *)Struct);
if(Ans("\x14",0x03,0x09,ID_GetSMSStatus+ID,&AS))     	return ReplyGetSMSStatus1		(msg,Debug,(unsigned char *)Struct);
if(Ans("\x14",0x03,0x0D,ID_GetSMSFolderStatus+ID,&AS))  return ReplyGetSMSFolderStatus1		(msg,Debug,(unsigned char *)Struct);
if(Ans("\x14",0x03,0x0F,ID_GetSMS+ID,&AS))  		return ReplyGetSMS1			(msg,Debug,(unsigned char *)Struct);
if(Ans("\x14",0x03,0x13,ID_GetSMSFolders+ID,&AS))     	return ReplyGetSMSFolders1		(msg,Debug,(unsigned char *)Struct);

if(Ans("\x19",0x03,0x0B,ID_GetDateTime+ID,&AS))     	return ReplyGetDateTime			(msg,Debug,(unsigned char *)Struct);

if(Ans("\x1B",0x03,0x01,ID_GetIMEI+ID,&AS))     	return ReplyGetIMEI      		(msg,Debug,(unsigned char *)Struct);
if(Ans("\x1B",0x03,0x0C,ID_GetProductCode+ID,&AS))     	return ReplyGetProductCode		(msg,Debug,(unsigned char *)Struct);

//filesystem1
if(Ans("\x6D",0x03,0x03,ID_AddFilePart+ID,&AS))         return ReplyAddFilePart1		(msg,Debug,(unsigned char *)Struct);
if(Ans("\x6D",0x03,0x05,ID_AddFolder+ID,&AS))         	return ReplyAddFolder1			(msg,Debug,(unsigned char *)Struct);
if(Ans("\x6D",0x03,0x0F,ID_GetFilePart+ID,&AS))         return ReplyGetFilePart12		(msg,Debug,(unsigned char *)Struct);
if(Ans("\x6D",0x03,0x15,ID_GetFileFolderInfo+ID,&AS))   return ReplyGetFFolderInfo1		(msg,Debug,(unsigned char *)Struct);
if(Ans("\x6D",0x03,0x1F,ID_DeleteFile+ID,&AS))   	return ReplyDeleteFFolder1		(msg,Debug,(unsigned char *)Struct);
if(Ans("\x6D",0x03,0x2F,ID_GetFileFolderInfo+ID,&AS))   return ReplyGetFFolderInfo1		(msg,Debug,(unsigned char *)Struct);
if(Ans("\x6D",0x03,0x33,ID_GetFileFolderInfo+ID,&AS))   return ReplyGetFolderInfoList1		(msg,Debug,(unsigned char *)Struct);
if(Ans("\x6D",0x03,0x41,ID_AddFilePart+ID,&AS))         return ReplyAddFilePart1		(msg,Debug,(unsigned char *)Struct);
if(Ans("\x6D",0x03,0x43,ID_GetFileCheckSum+ID,&AS))     return ReplyGetFileCheckSum12		(msg,Debug,(unsigned char *)Struct);
//filesystem2
if(Ans("\x6D",0x03,0x59,ID_AddFilePart+ID,&AS))         return GSM_Return_Error(GSM_ERR_NONE);
if(Ans("\x6D",0x03,0x5F,ID_GetFilePart+ID,&AS))         return ReplyGetFilePart12		(msg,Debug,(unsigned char *)Struct);
if(Ans("\x6D",0x03,0x63,ID_DeleteFile+ID,&AS))          return ReplyDeleteFile2			(msg,Debug,(unsigned char *)Struct);
if(Ans("\x6D",0x03,0x65,ID_AddFolder+ID,&AS))           return ReplyAddFolder2			(msg,Debug,(unsigned char *)Struct);
if(Ans("\x6D",0x03,0x67,ID_GetFileCheckSum+ID,&AS))     return ReplyGetFileCheckSum12		(msg,Debug,(unsigned char *)Struct);
if(Ans("\x6D",0x03,0x69,ID_GetFolderList+ID,&AS))     	return ReplyGetFolderInfoList2		(msg,Debug,(unsigned char *)Struct);
if(Ans("\x6D",0x03,0x6B,ID_DeleteFolder+ID,&AS))        return ReplyDeleteFolder2		(msg,Debug,(unsigned char *)Struct);
if(Ans("\x6D",0x03,0x6D,ID_GetFileFolderInfo+ID,&AS))   return ReplyGetFFolderInfo2		(msg,Debug,(unsigned char *)Struct);
if(Ans("\x6D",0x03,0x73,ID_OpenFile+ID,&AS))            return ReplyOpenFile2			(msg,Debug,(unsigned char *)Struct);
if(Ans("\x6D",0x03,0x75,ID_CloseFile+ID,&AS))     	return GSM_Return_Error(GSM_ERR_NONE);
if(Ans("\x6D",0x03,0x87,ID_SetFileDate+ID,&AS))         return GSM_Return_Error(GSM_ERR_NONE);

if (msg->Type==0xD0) 					return GSM_Return_Error(GSM_ERR_TIMEOUT); //Bluetooth init

if(Ans("\xD2",0x02,0x00,ID_GetID+ID3,      &AS))     	return DCT34->ReplyGetID 		(msg,Debug,(unsigned char *)Struct);

	if (AS.FrameFound) return GSM_Return_Error(GSM_ERR_FRAME_NOT_REQUESTED);
        return GSM_Return_Error(GSM_ERR_FRAME_TYPE_UNKNOWN);
}

GSM_Error GSM_Phone_N6510::ReplyGetIMEI(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *IMEI)
{
	memcpy(IMEI,msg->Buffer.data()+10, 16);
	(*Debug)->Deb("IMEI %s\n",IMEI);
        return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_N6510::GetIMEI(unsigned char *IMEI)
{
	unsigned char Buff[] = {NOKIA_FRAME1, 0x00, 0x41};

//	(*Phones)->Switch("auto","irdaphonet");
//	(*Phones)->Current->GetIMEI(IMEI);
//	(*Phones)->Switch("6510","irdaphonet");
//	(*Debug)->Deb("Getting IMEI2\n");

	(*Debug)->Deb("SENT: getting IMEI\n");
	return Write(Buff, sizeof(Buff), 0x1B, 2, ID_GetIMEI+ID, IMEI);
}

GSM_Error GSM_Phone_N6510::ReplyGetProductCode(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *ProductCode)
{
	sprintf((char *)ProductCode,"%s",msg->Buffer.data()+10);
//	(*Debug)->Deb("IMEI %s\n",IMEI);
        return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_N6510::GetProductCode(unsigned char *ProductCode)
{
	unsigned char Buff[] = {0x00, 0x03, 0x04, 0x0B, 0x00, 0x02};

	(*Debug)->Deb("SENT: getting product code\n");
	return Write(Buff, sizeof(Buff), 0x1B, 2, ID_GetProductCode+ID, ProductCode);
}

GSM_Error GSM_Phone_N6510::GetCodeNameModel(unsigned char *Model)
{
	return DCT34->GetCodeNameModel(Model);
}

GSM_Error GSM_Phone_N6510::GetFirmwareVersion(unsigned char *Firm)
{
	return DCT34->GetFirmwareVersion(Firm);
}

GSM_Error GSM_Phone_N6510::GetManufacturer(unsigned char *Manufacturer)
{
	strcpy((char *)Manufacturer,"Nokia");
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_N6510::ReplyGetPBKStatus(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	GSM_PBKStatus *Status = (GSM_PBKStatus *)S;

	(*Debug)->Deb("RECEIVED: PBK memory status\n");

	if (msg->Buffer.data()[14] == 0x10) {
		Status->Free = msg->Buffer.data()[18] * 256 + msg->Buffer.data()[19];
	} else {
		Status->Free = msg->Buffer.data()[17];
	}
	(*Debug)->Deb("Size - %i\n",Status->Free);

	Status->Used = msg->Buffer.data()[20] * 256 + msg->Buffer.data()[21];
	Status->Free -= Status->Used;
	(*Debug)->Deb("Used - %i\n",Status->Used);
	(*Debug)->Deb("Free - %i\n",Status->Free);

        return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_N6510::GetPBKStatus(GSM_PBKStatus *Status)
{
	unsigned char Buff[] = {
		NOKIA_FRAME1, 0x03, 0x02, 
		0x00, 			// memory type
		0x55, 0x55, 0x55, 0x00};

	Buff[5] = DCT34->Get7110DCT4MemoryType(Status->Memory);
	if (Buff[5] == 0x00) return GSM_Return_Error(GSM_ERR_UNKNOWN);

	(*Debug)->Deb("SENT: getting status for %s memory\n",GSM_GetMemoryName(Status->Memory));
	return Write(Buff, sizeof(Buff), 0x03, 4, ID_GetPBKStatus+ID, Status);
}

GSM_Error GSM_Phone_N6510::Open(char *FrameID)
{
	GSM_Phone::Open(FrameID);

	if (FrameID[0] != 0) DCT34->SetFrameID(FrameID);

	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_N6510::Close()
{
	GSM_File File;

	while (FileSystemOpened2.size()!=0) {
		File.Handle = FileSystemOpened2.data()[0];
		CloseFile2(&File);
	}

	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_N6510::ReplyGetPBK(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	GSM_PBKEntry *Entry = (GSM_PBKEntry *)S;

	if (msg->Buffer.data()[6] == 0x0F) {
		switch (msg->Buffer.data()[10]) {
		case 0x30:
		case 0x33:
		case 0x34:
		case 0x3B:
			return GSM_Return_Error(GSM_ERR_EMPTY);
		}
		(*Debug)->Deb("RECEIVED: error %i receiving PBK entry\n",msg->Buffer.data()[10]);
	        return GSM_Return_Error(GSM_ERR_UNKNOWN);
	}

	(*Debug)->Deb("RECEIVED: PBK entry received\n");
	DCT34->DecodePBKToEntry(msg->Buffer.data()+21, Entry);
        return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_N6510::GetPBK(GSM_PBKEntry *Entry)
{
	unsigned char Buff[] = {
		NOKIA_FRAME1, 0x07, 0x01, 0x01, 0x00, 0x01, 0xFE,
		0x00, 			// memory type
		0x00, 0x00, 0x00, 0x00,
		0x00, 0x01, 		// memory location
		0x00, 0x00, 0x01};

	Buff[9] = DCT34->Get7110DCT4MemoryType(Entry->Memory);
	if (Buff[9] == 0x00) return GSM_Return_Error(GSM_ERR_UNKNOWN);

	if (Entry->Location==0x00) return GSM_Return_Error(GSM_ERR_INVALID_LOCATION);
	Buff[14] = Entry->Location / 256;
	Buff[15] = Entry->Location % 256;

	(*Debug)->Deb("SENT: getting entry %i in memory %s\n",Entry->Location,GSM_GetMemoryName(Entry->Memory));
	return Write(Buff, sizeof(Buff), 0x03, 4, ID_GetPBK+ID, Entry);
}

GSM_Error GSM_Phone_N6510::SetPBK(GSM_PBKEntry *Entry)
{
	unsignedstring 		Buffer, Buffer2;
	GSM_Error		error;
	int			Number = 0;
	unsigned char		Buff[] = {
		NOKIA_FRAME1, 0x0b, 0x00, 0x01, 0x01, 0x00, 0x00, 0x10, 0x02, 
		0x00,  			// memory type
		0x00, 0x00,  		// location
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

	if (Entry->Memory == MEM_PHONE && PhonePBKFeatures.Types.size() == 0) {
		PhonePBKFeatures.Memory = MEM_PHONE;
		error = DCT34->GetPBKFeatures(&PhonePBKFeatures);
		if (error.Code != GSM_ERR_NONE) return error;
	}

	Buff[11] = DCT34->Get7110DCT4MemoryType(Entry->Memory);
	if (Buff[11] == 0x00) return GSM_Return_Error(GSM_ERR_UNKNOWN);

	if (Entry->Location==0x00) return GSM_Return_Error(GSM_ERR_INVALID_LOCATION);
	Buff[12] = Entry->Location / 256;
	Buff[13] = Entry->Location % 256;

	while (true) {
		if (Entry->Memory == MEM_PHONE) {
			error = DCT34->EncodeEntryToPBK(&Buffer, Entry, &Number, &PhonePBKFeatures);
		} else {
			error = DCT34->EncodeEntryToPBK(&Buffer, Entry, &Number, NULL);
		}
		if (error.Code != GSM_ERR_NONE) return error;

		Buffer2.append((const unsigned char*)Buff,sizeof(Buff));
		Buffer2.push_back(Number);
		Buffer2.append((const unsigned char*)Buffer.data(),Buffer.size());

		(*Debug)->Deb("SENT: setting entry %i in memory %s\n",Entry->Location,GSM_GetMemoryName(Entry->Memory));
		error = Write((unsigned char *)Buffer2.data(), Buffer2.size(), 0x03, 4, ID_SetPBK+ID, Entry);
		if (error.Code == GSM_ERR_TOO_MANY_ENTRIES) {
			Buffer.clear();
			Buffer2.clear();
			Number--;
			continue;
		}
		return error;
	}
}

GSM_Error GSM_Phone_N6510::DeletePBK(GSM_PBKEntry *Entry)
{
	unsigned char Buff[] = {
		NOKIA_FRAME1, 0x0f, 0x55, 0x01, 0x04, 0x55, 0x00, 0x10, 0xFF, 0x02,
		0x00, 0x00,		// location
		0x00, 0x00, 0x00, 0x00,
		0x00,			// memory type
		0x55, 0x55, 0x55};

	if (Entry->Location==0x00) return GSM_Return_Error(GSM_ERR_INVALID_LOCATION);
	Buff[12] = Entry->Location / 256;
	Buff[13] = Entry->Location % 256;

	Buff[18] = DCT34->Get7110DCT4MemoryType(Entry->Memory);
	if (Buff[18] == 0x00) return GSM_Return_Error(GSM_ERR_UNKNOWN);

	(*Debug)->Deb("SENT: deleting entry %i in memory %s\n",Entry->Location,GSM_GetMemoryName(Entry->Memory));
	return Write(Buff, sizeof(Buff), 0x03, 4, ID_DelPBK+ID, Entry);
}

GSM_Error GSM_Phone_N6510::GetFirmwareDate(unsigned char *Dat)
{
	return DCT34->GetFirmwareDate(Dat);
}

GSM_Error GSM_Phone_N6510::ReplyGetDateTime(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	GSM_DateTime *DT = (GSM_DateTime *)S;

	(*Debug)->Deb("RECEIVED: datetime\n");

	if (msg->Buffer.data()[4] == 0x01) {
		memcpy(DT,NokiaGetDT(msg->Buffer.data()+10),sizeof(GSM_DateTime));
		return GSM_Return_Error(GSM_ERR_NONE);
	}
	return GSM_Return_Error(GSM_ERR_EMPTY);
}

GSM_Error GSM_Phone_N6510::GetDateTime(GSM_DateTime *DT)
{
	unsigned char Buff[] = {NOKIA_FRAME1, 0x0A, 0x00, 0x00};

	(*Debug)->Deb("SENT: getting datetime\n");
	return Write(Buff, sizeof(Buff), 0x19, 4, ID_GetDateTime+ID, DT);
}
