/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#include <stdio.h>

#include "../../../service/gsmmisc.h"
#include "../../../device/gsmdev.h"
#include "../../gsmphone.h"
#include "../ndct34.h"
#include "ndct3.h"

class GSM_Protocol;
class GSM_Protocol_Message;

class GSM_Phone_N6110:virtual public GSM_Phone
{
public:
	GSM_Phone_N6110(DebugInfo **Deb, GSM_Device **Dev, GSM_AllProtocols **Prot, GSM_AllPhones **Pho):GSM_Phone(Deb,Dev,Prot,Pho) {
		Info.push_back(GSM_Phone_Info("2100", "NAM-2", "" ,"fbus", ""));
		Info.push_back(GSM_Phone_Info("3310", "NHM-5", "" ,"fbus", ""));
		Info.push_back(GSM_Phone_Info("3315", "NHM-5", "" ,"fbus", ""));
		Info.push_back(GSM_Phone_Info("3330", "NHM-6", "" ,"fbus", ""));
		Info.push_back(GSM_Phone_Info("3410", "NHM-2", "" ,"fbus", ""));
		Info.push_back(GSM_Phone_Info("5110", "NSE-1", "" ,"fbus", ""));
		Info.push_back(GSM_Phone_Info("5110i","NSE-2", "" ,"fbus", ""));
		Info.push_back(GSM_Phone_Info("5130", "NSK-1", "" ,"fbus", ""));
		Info.push_back(GSM_Phone_Info("5210", "NSM-5", "Nokia 5210","fbus|irdaphonet", ""));
		Info.push_back(GSM_Phone_Info("5510", "NPM-5", "" ,"fbus", ""));
		Info.push_back(GSM_Phone_Info("6110", "NSE-3", "" ,"fbus", ""));
		Info.push_back(GSM_Phone_Info("6130", "NSK-3", "" ,"fbus", ""));
		Info.push_back(GSM_Phone_Info("6150", "NSM-1", "" ,"fbus", ""));
		Info.push_back(GSM_Phone_Info("8210", "NSM-3", "Nokia 8210","fbus|irdaphonet", ""));

		DCT34 = new GSM_Phone_NDCT34((*Phones)->GetID(),Deb,&(*Phones));
		DCT3  = new GSM_Phone_NDCT3((*Phones)->GetID(),Deb,&((*Phones)->Current),&((*Protocols)->Current));

		ModuleName      = "dct3/n6110";
		ModulesUsed     = "";
		ModulesRequired = "";
	}
	~GSM_Phone_N6110() {
		delete DCT34;
		delete DCT3;
	}

	GSM_Error	Open		   	(char *FrameID);
	GSM_Error	Dispatch	       	(GSM_Protocol_Message *msg, void *Struct, int RequestID);

	GSM_Error	GetManufacturer		(unsigned char *Manufacturer);
	GSM_Error	GetIMEI			(unsigned char *IMEI);
	GSM_Error	GetCodeNameModel       	(unsigned char *Model);
	GSM_Error	GetFirmwareVersion     	(unsigned char *Firm);
	GSM_Error	GetFirmwareDate		(unsigned char *Dat);
	GSM_Error	GetDateTime	    	(GSM_DateTime *DT);
	GSM_Error	GetPBKStatus	   	(GSM_PBKStatus *Status);
	GSM_Error	GetPBK		 	(GSM_PBKEntry *Entry);
	GSM_Error	SetPBK		 	(GSM_PBKEntry *Entry);
	GSM_Error	DeletePBK	      	(GSM_PBKEntry *Entry);
	GSM_Error	DeleteCalendar	 	(GSM_CalendarEntry *Entry);
	GSM_Error	AddCalendar	    	(GSM_CalendarEntry *Entry);
	GSM_Error	GetNextCalendar		(GSM_CalendarEntry *Entry, BOOLEAN start, int *Current, int *Max);
	GSM_Error	GetSMSStatus	   	(GSM_SMSStatus *Status);
	GSM_Error	GetSMSC			(GSM_SMSC *SMSC);
//      GSM_Error	AddSMS		 	(GSM_SMSList *List);
	GSM_Error	SetSMS		 	(GSM_SMSList *List);
	GSM_Error	SendSMS			(GSM_SMSEntry *SMS);
	GSM_Error	DeleteSMS	      	(GSM_SMSList *List);
private:
	GSM_Phone_NDCT34 *DCT34;
	GSM_Phone_NDCT3  *DCT3;
	int	      	 CalendarLocation;
	GSM_SMSStatus    SMSStatus;
	int	      	 SMSLocation;

	GSM_Error	ReplyGetIMEI	   	(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *IMEI);
	GSM_Error	ReplyGetPBKStatus      	(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
	GSM_Error	ReplyGetPBK	    	(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
	GSM_Error	ReplySetPBK	    	(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
	GSM_Error	ReplyNetworkInfo       	(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
	GSM_Error	ReplyGetNextCalendar   	(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
	GSM_Error	ReplyAddCalendar       	(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
	GSM_Error	ReplyDeleteCalendar    	(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
	GSM_Error	ReplyGetSMSStatus      	(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
	GSM_Error	ReplyGetSMS	    	(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
	GSM_Error	ReplySetSMS	    	(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
	GSM_Error	ReplyDeleteSMS	 	(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);

	unsigned char    GetMemoryType	  	(GSM_MemoryType Type);
};
