/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#ifndef gsm_state_h
#define gsm_state_h

#include "misc/misc.h"
#include "misc/files.h"
#include "device/gsmdev.h"
#include "phone/gsmphone.h"
#include "protocol/gsmprot.h"

typedef struct {
	char		Device[200];
	char		Protocol[200];
	char		Phone[200];
	char		Compatibility[200];
	char		LogFile[500];
	char		LogLevel[200];
	char		SyncTime[200];

	char		RSSLevel[200];
} GSM_GPlusConfig;

/**
 * main class for managing phone
 */
class GSM_StateMachine
{
public:
        GSM_AllDevices          *Devices;
        GSM_AllProtocols        *Protocols;
        GSM_AllPhones           *Phones;
        DebugInfo           	*Debug;

        GSM_StateMachine(FILE *deb_file, char *FileName, bool enable);
        ~GSM_StateMachine();

	void 			ReadCfg		(GSM_GPlusConfig *CFG);
	void 			SaveCfg		(GSM_GPlusConfig *CFG);

	GSM_Error 		Open		(GSM_GPlusConfig *CFG);

	GSM_Error		Close		();
	void 			SetUserReply	(GSM_Error(*UsrReply)(int MsgLength, unsigned char MsgType, unsigned char *MsgBuffer, void *Struct, int RequestID));
	void 			SetSMSSendReply	(void(*SMSSndReply)(int TPMR));
private:
	BOOLEAN 		ReadCfgFile	(INI_File *File);
};

#endif
