//---------------------------------------------------------------------------
//
// Name:        SMSSendDlg.cpp
// Author:      Marcinello
// Created:     2007-02-07 00:44:17
// Description: SMSSendDlg class implementation
//
//---------------------------------------------------------------------------

#include "SMSSendDlg.h"

//Do not add custom headers
//wxDev-C++ designer will remove them
////Header Include Start
////Header Include End

//----------------------------------------------------------------------------
// SMSSendDlg
//----------------------------------------------------------------------------
//Add Custom Events only in the appropriate block.
//Code added in other places will be removed by wxDev-C++
////Event Table Start
BEGIN_EVENT_TABLE(SMSSendDlg,wxDialog)
	////Manual Code Start
	////Manual Code End
	
	EVT_CLOSE(SMSSendDlg::OnClose)
	EVT_BUTTON(ID_WXBUTTON5,SMSSendDlg::WxButton5Click)
	EVT_BUTTON(ID_WXBUTTON4,SMSSendDlg::WxButton4Click)
	EVT_BUTTON(ID_WXBUTTON2,SMSSendDlg::WxButton2Click)
	
	EVT_TEXT(ID_WXEDIT1,SMSSendDlg::WxEdit1Updated)
	EVT_BUTTON(ID_WXBUTTON1,SMSSendDlg::WxButton1Click)
END_EVENT_TABLE()
////Event Table End

SMSSendDlg::SMSSendDlg(GSM_StateMachine *s2, int Parts2, wxWindow *parent, wxWindowID id, const wxString &title, const wxPoint &position, const wxSize& size, long style)
: wxDialog(parent, id, title, position, size, style)
{
	GSM_SMSC		SMSC;
	GSM_Error       error;
	int             Num=1;
	char            buff[200];
	
    s = s2;
    Parts = Parts2;
	num = 0;
    
	CreateGUIControls();
	SetTitle(title);

    while (true) {
    	SMSC.Location = Num;
    	error = s->Phones->Current->GetSMSC(&SMSC);
    	if (error.Code != GSM_ERR_NONE) break;
     	sprintf(buff,"%s",UnicodeToStringReturn(SMSC.GetSMSCNumber()));
//    	if (UnicodeLength(SMSC.GetName())!=0) {
//        	sprintf(buff+strlen(buff)," (%s)",UnicodeToStringReturn(SMSC.GetName()));
//        }            
        if (strlen(buff)!=0) WxComboBox1->Append(buff);
        Num++;
    }
    WxComboBox1->Select(0);
    
    SetInfo();
}

SMSSendDlg::~SMSSendDlg()
{
} 

void SMSSendDlg::CreateGUIControls()
{
	//Do not add custom code between
        //GUI Items Creation Start and GUI Items Creation End.
	//wxDev-C++ designer will remove them.
	//Add the custom code before or after the blocks
	////GUI Items Creation Start

	SetTitle(wxT("Untitled1"));
	SetIcon(wxNullIcon);
	SetSize(8,8,457,371);
	Center();
	

	WxCheckBox1 = new wxCheckBox(this, ID_WXCHECKBOX1, wxT("Delivery report (with no extra costs)"), wxPoint(14,255), wxSize(223,19), 0, wxDefaultValidator, wxT("WxCheckBox1"));

	WxStaticText2 = new wxStaticText(this, ID_WXSTATICTEXT2, wxT("SMSC"), wxPoint(16,234), wxDefaultSize, 0, wxT("WxStaticText2"));

	wxArrayString arrayStringFor_WxComboBox1;
	WxComboBox1 = new wxComboBox(this, ID_WXCOMBOBOX1, wxT("WxComboBox1"), wxPoint(106,232), wxSize(226,21), arrayStringFor_WxComboBox1, wxCB_READONLY, wxDefaultValidator, wxT("WxComboBox1"));

	WxStaticBox2 = new wxStaticBox(this, ID_WXSTATICBOX2, wxT("Other options"), wxPoint(5,216), wxSize(439,61));

	WxListCtrl1 = new wxListCtrl(this, ID_WXLISTCTRL1, wxPoint(16,57), wxSize(316,146), wxLC_REPORT | wxLC_NO_HEADER);
	WxListCtrl1->InsertColumn(0,wxT("Name"),wxLIST_FORMAT_LEFT,200 );
	WxListCtrl1->InsertColumn(0,wxT("Number"),wxLIST_FORMAT_LEFT,100 );

	WxButton5 = new wxButton(this, ID_WXBUTTON5, wxT("Cancel"), wxPoint(355,314), wxSize(86,25), 0, wxDefaultValidator, wxT("WxButton5"));

	WxStaticText1 = new wxStaticText(this, ID_WXSTATICTEXT1, wxT("WxStaticText1"), wxPoint(6,287), wxDefaultSize, 0, wxT("WxStaticText1"));

	WxButton4 = new wxButton(this, ID_WXBUTTON4, wxT("Delete"), wxPoint(341,58), wxSize(93,22), 0, wxDefaultValidator, wxT("WxButton4"));
	WxButton4->Enable(false);

	WxButton2 = new wxButton(this, ID_WXBUTTON2, wxT("Add"), wxPoint(341,24), wxSize(94,23), 0, wxDefaultValidator, wxT("WxButton2"));
	WxButton2->Enable(false);

	WxEdit1 = new wxTextCtrl(this, ID_WXEDIT1, wxT(""), wxPoint(17,25), wxSize(315,21), 0, wxDefaultValidator, wxT("WxEdit1"));

	WxStaticBox1 = new wxStaticBox(this, ID_WXSTATICBOX1, wxT("Recipient"), wxPoint(5,7), wxSize(440,207));

	WxButton1 = new wxButton(this, ID_WXBUTTON1, wxT("Send now"), wxPoint(6,312), wxSize(87,26), 0, wxDefaultValidator, wxT("WxButton1"));
	WxButton1->Enable(false);
	////GUI Items Creation End
}

void SMSSendDlg::OnClose(wxCloseEvent& /*event*/)
{
	Destroy();
}

/*
 * WxButton2Click
 */
void SMSSendDlg::WxButton2Click(wxCommandEvent& event)
{
    long tmp;

    tmp = WxListCtrl1->InsertItem((num)++, WxEdit1->GetValue(), 0);
    SetInfo();
}

/*
 * WxButton4Click
 */
void SMSSendDlg::WxButton4Click(wxCommandEvent& event)
{
    long item=-1;

    for (;;) {
        item = WxListCtrl1->GetNextItem(item,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);
        if (item==-1) break;
        WxListCtrl1->DeleteItem(item);
        item=-1;
    }
    SetInfo();
}

/*
 * WxEdit1Updated
 */
void SMSSendDlg::WxEdit1Updated(wxCommandEvent& event)
{
	WxButton2->Enable((WxEdit1->GetValue()!=""));
}

void SMSSendDlg::SetInfo()
{
    char buff[200];
    
	WxButton1->Enable((WxListCtrl1->GetItemCount()!=0));
	WxButton4->Enable((WxListCtrl1->GetItemCount()!=0));
	WxStaticText1->SetLabel("");

    if (WxListCtrl1->GetItemCount()!=0) {
        sprintf(buff,"Note: you will be charged for %i SMS by your operator",Parts*WxListCtrl1->GetItemCount());
        WxStaticText1->SetLabel(buff);
    }
}

/*
 * WxButton1Click
 */
void SMSSendDlg::WxButton1Click(wxCommandEvent& event)
{
	EndModal(wxID_OK);
}

/*
 * WxButton5Click
 */
void SMSSendDlg::WxButton5Click(wxCommandEvent& event)
{
    EndModal(wxID_CANCEL);
}
