//---------------------------------------------------------------------------
//
// Name:        SMSEditDlg.cpp
// Author:      Marcinello
// Created:     2007-02-06 23:39:09
// Description: SMSEditDlg class implementation
//
//---------------------------------------------------------------------------

#include "../cfg/config.h"
#include "../common/service/gsmdata.h"
#include "../common/service/gsmmisc.h"
#include "../common/service/backup/gsmback.h"
#include "../common/gsmstate.h"

#include "SMSEditDlg.h"

//Do not add custom headers
//wxDev-C++ designer will remove them
////Header Include Start
////Header Include End

//----------------------------------------------------------------------------
// SMSEditDlg
//----------------------------------------------------------------------------
//Add Custom Events only in the appropriate block.
//Code added in other places will be removed by wxDev-C++
////Event Table Start
BEGIN_EVENT_TABLE(SMSEditDlg,wxDialog)
	////Manual Code Start
	////Manual Code End
	
	EVT_CLOSE(SMSEditDlg::OnClose)
	EVT_BUTTON(ID_WXBUTTON2,SMSEditDlg::WxButton2Click)
	EVT_BUTTON(ID_WXBUTTON1,SMSEditDlg::WxButton1Click)
	
	EVT_TEXT(ID_WXMEMO1,SMSEditDlg::WxMemo1Updated)
	EVT_CHECKBOX(ID_WXCHECKBOX1,SMSEditDlg::WxCheckBox1Click)
END_EVENT_TABLE()
////Event Table End

SMSEditDlg::SMSEditDlg(GSM_SMSList *List2, wxWindow *parent, wxWindowID id, const wxString &title, const wxPoint &position, const wxSize& size, long style)
: wxDialog(parent, id, title, position, size, style)
{
    List = List2;
    
	CreateGUIControls();
    SetTitle(title);
    
    WxMemo1->SetFocus();
}

SMSEditDlg::~SMSEditDlg()
{
} 

void SMSEditDlg::CreateGUIControls()
{
	//Do not add custom code between
        //GUI Items Creation Start and GUI Items Creation End.
	//wxDev-C++ designer will remove them.
	//Add the custom code before or after the blocks
	////GUI Items Creation Start

	WxPanel1 = new wxPanel(this, ID_WXPANEL1, wxPoint(0,0), wxSize(527,397));

	WxNotebook1 = new wxNotebook(WxPanel1, ID_WXNOTEBOOK1, wxPoint(7,6),wxSize(400,386));

	WxNoteBookPage1 = new wxPanel(WxNotebook1, ID_WXNOTEBOOKPAGE1, wxPoint(4,24), wxSize(392,358));
	WxNotebook1->AddPage(WxNoteBookPage1, wxT("Text SMS"));

	WxStaticBox1 = new wxStaticBox(WxNoteBookPage1, ID_WXSTATICBOX1, wxT("Text"), wxPoint(4,7), wxSize(381,140));

	WxStaticBox2 = new wxStaticBox(WxNoteBookPage1, ID_WXSTATICBOX2, wxT("Text preview in recipients' phone(s)"), wxPoint(5,151), wxSize(380,137));

	WxStaticBox3 = new wxStaticBox(WxNoteBookPage1, ID_WXSTATICBOX3, wxT("Options"), wxPoint(5,294), wxSize(379,59));

	WxCheckBox1 = new wxCheckBox(WxNoteBookPage1, ID_WXCHECKBOX1, wxT("Send in Unicode alphabet"), wxPoint(14,309), wxSize(330,17), 0, wxDefaultValidator, wxT("WxCheckBox1"));

	WxCheckBox2 = new wxCheckBox(WxNoteBookPage1, ID_WXCHECKBOX2, wxT("Send in class 0 (displayed immedietaly)"), wxPoint(14,323), wxSize(332,24), 0, wxDefaultValidator, wxT("WxCheckBox2"));

	WxMemo1 = new wxTextCtrl(WxNoteBookPage1, ID_WXMEMO1, wxT(""), wxPoint(13,26), wxSize(362,112), wxTE_MULTILINE, wxDefaultValidator, wxT("WxMemo1"));
	WxMemo1->SetMaxLength(0);
	WxMemo1->SetFocus();
	WxMemo1->SetInsertionPointEnd();

	WxMemo2 = new wxTextCtrl(WxNoteBookPage1, ID_WXMEMO2, wxT(""), wxPoint(13,169), wxSize(362,111), wxTE_READONLY | wxTE_WORDWRAP | wxTE_MULTILINE, wxDefaultValidator, wxT("WxMemo2"));
	WxMemo2->SetMaxLength(0);
	WxMemo2->SetFocus();
	WxMemo2->SetInsertionPointEnd();
	WxMemo2->SetBackgroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_BTNFACE));

	WxButton1 = new wxButton(WxPanel1, ID_WXBUTTON1, wxT("Next >>"), wxPoint(420,11), wxSize(100,22), 0, wxDefaultValidator, wxT("WxButton1"));

	WxButton2 = new wxButton(WxPanel1, ID_WXBUTTON2, wxT("Cancel"), wxPoint(420,42), wxSize(101,22), 0, wxDefaultValidator, wxT("WxButton2"));

	SetTitle(wxT("Untitled1"));
	SetIcon(wxNullIcon);
	SetSize(8,8,535,424);
	Center();
	
	////GUI Items Creation End
}

void SMSEditDlg::OnClose(wxCloseEvent& /*event*/)
{
	Destroy();
}

/*
 * WxMemo1Updated
 */
void SMSEditDlg::WxMemo1Updated(wxCommandEvent& event)
{
    GSM_Error       error;
    unsigned char   buff[500];
    char            buff2[500];
    int             len;
    wchar_t         Destination[500];
    
    WxMemo2->Clear();
    if (!WxCheckBox1->GetValue()) {
        error = GSM_EncodeSMSText(buff, (const wchar_t *)WxMemo1->GetValue().wc_str(wxConvLibc), &len, 160, 0);
		GSM_DecodeSMSText(Destination, buff, len,len, 0);
        WxMemo2->AppendText(Destination);
        sprintf(buff2,"Text (%i chars left)",160-len);
    } else {
        WxMemo2->AppendText((const wchar_t *)WxMemo1->GetValue().wc_str(wxConvLibc));
        sprintf(buff2,"Text (%i chars left)",80-UnicodeLength((const wchar_t *)WxMemo1->GetValue().wc_str(wxConvLibc)));
    }
    WxStaticBox1->SetLabel(buff2);
}

/*
 * WxCheckBox1Click
 */
void SMSEditDlg::WxCheckBox1Click(wxCommandEvent& event)
{
    WxMemo1Updated(event);
}

/*
 * WxButton1Click
 */
void SMSEditDlg::WxButton1Click(wxCommandEvent& event)
{
    GSM_SMSEntry    SMS;
    wchar_t         Buffer[200],Destination[200];
    unsigned char   buff[200];
    int             len;
        
    List->ClearAll();
    
	SMS.SetType(SMS_Submit);
    if (!WxCheckBox1->GetValue()) {
    	SMS.SetCoding(SMS_Coding_Default_No_Compression);

        GSM_EncodeSMSText(buff, (const wchar_t *)WxMemo1->GetValue().wc_str(wxConvLibc), &len, 160, 0);
		GSM_DecodeSMSText(Destination, buff, len,len, 0);
    } else {
    	SMS.SetCoding(SMS_Coding_Unicode_No_Compression);

    	CopyUnicode((const wchar_t *)WxMemo1->GetValue().wc_str(wxConvLibc),Destination);
    	Destination[70] = 0;
    }
	SMS.SetDecodedText(Destination);
    if (WxCheckBox1->GetValue()) SMS.SetClass(0);
    
    List->Add(&SMS);
    
	EndModal(wxID_OK);
}

/*
 * WxButton2Click
 */
void SMSEditDlg::WxButton2Click(wxCommandEvent& event)
{
	EndModal(wxID_CANCEL);
}
