/* (C) 2007 by Marcin Wiacek www.mwiacek.com */

#ifndef gsm_data_h
#define gsm_data_h

#include "gsmfiles.h"

class GSM_MMSFile
{
public:
	int		Folder;
	GSM_File	File;
};

typedef enum {
	MMS_Address_Phone_Source = 1,
	MMS_Address_Unknown_Source,
	MMS_Address_Phone_Destination,
	MMS_Address_Unknown_Destination,
	MMS_Address_Phone_CC,
	MMS_Address_Unknown_CC,
	MMS_Address_Phone_BCC,
	MMS_Address_Unknown_BCC,
	MMS_Text_TransactionID,
	MMS_Text_Subject,
	MMS_Text_ContentLocation,
	MMS_Text_ContentType,
	MMS_Text_MessageType,
	MMS_Text_MessageID,
	MMS_Text_MessageClass,
	MMS_Text_Priority,
	MMS_Text_Version,
	MMS_Text_Response_Status,
	MMS_Text_Status,
	MMS_DT_DateTime,
	MMS_DT_Expiry,
	MMS_Bool_Report,
	MMS_Bool_Read_Reply,
	MMS_Bool_Report_Allowed,
	MMS_File,
	MMS_Unknown
} GSM_MMS_Types;

class GSM_MMSDecodedFileSubEntry
{
	friend class GSM_MMSDecodedFile;
public:
	GSM_MMSDecodedFileSubEntry();
	~GSM_MMSDecodedFileSubEntry();

	GSM_MMS_Types			Type;
	GSM_File			File;

	wchart				Text;
	wchart				Text2;
	wchart				Header;
	BOOLEAN				Bool;
	GSM_DateTime			DT;

	GSM_MMSDecodedFileSubEntry	*GetNext();
private:
	void 				SetNext(GSM_MMSDecodedFileSubEntry *Nxt);

	GSM_MMSDecodedFileSubEntry	*Next;
};

class GSM_MMSDecodedFile
{
public:
	GSM_MMSDecodedFile();
	~GSM_MMSDecodedFile();

	void 				ClearAll();	
	BOOLEAN 			GetNext(GSM_MMSDecodedFileSubEntry **En);
	GSM_Error	 		Add(GSM_MMSDecodedFileSubEntry *En);
	GSM_Error			Read(GSM_File *File);
private:
	GSM_MMSDecodedFileSubEntry	*Entries;

	void 				DecodeAddress(unsignedstring *buffer, GSM_MMS_Types *Type);
	void 				DecodeVersion(unsignedstring *Buff, long *Pos, unsignedstring *Dest, float *Version);
	int 				DecodeContentType(unsignedstring *Buff, long *Pos, unsignedstring *Dest, unsignedstring *Dest2, wchart *Name, float Version);

	int 				DecodeValuelength(unsignedstring *Buff, long *Pos);
	int 				DecodeShortinteger(unsignedstring *Buff, long *Pos);
	long 				DecodeUintvar(unsignedstring *Buff, long *Pos);
	long 				DecodeLonginteger(unsignedstring *Buff, long *Pos);
	void 				DecodeText(unsignedstring *Buff, long *Pos, unsignedstring *Dest);
	void 				DecodeEncodedString(unsignedstring *Buff, long *Pos, unsignedstring *Dest);
	long 				DecodeInteger(unsignedstring *Buff, long *Pos);
};

#endif
