/* (C) 2006 by Marcin Wiacek www.mwiacek.com */

#include "../../../../cfg/config.h" //msvc2005
#include "../../../protocol/gsmprot.h"
#include "../../../misc/coding/coding.h"
#include "../../../misc/files.h"

//---------------- filesystem 1 (obsolete, entries identified by numbers) ---------------------------------------

GSM_Error GSM_Phone_N6510::ReplyDeleteFFolder1(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	wchar_t 	*ID = (wchar_t *)S;
	GSM_Error 	error;

	(*Debug)->Deb("RECEIVED: filesystem 1, deleting file\\folder\n");
	if (msg->Buffer.data()[4] == 0x01) {
		return GSM_Return_Error(GSM_ERR_NONE);
	} else if (msg->Buffer.data()[4] == 0x04) {
		return GSM_Return_Error(GSM_ERR_FILE_FOLDER_NOT_EXIST);
	}

	return GSM_Return_Error(GSM_ERR_FRAME_CONTENT_UNKNOWN);
}

GSM_Error GSM_Phone_N6510::DeleteFFolder1(wchar_t *MyID)
{
	unsignedstring 		Buffer;
	unsigned char   	Delete[] = {
		NOKIA_FRAME1, 0x1E, 0x00, 0x00, 0x00, 0x01,
		0x00, 0x00};	    // File/folder ID

	Delete[8] = atoi(UnicodeToStringReturn(MyID+3)) / 256;
	Delete[9] = atoi(UnicodeToStringReturn(MyID+3)) % 256;

	return Write(Delete, sizeof(Delete), 0x6D, 4, ID_DeleteFile+ID,MyID);
}

GSM_Error GSM_Phone_N6510::DeleteFile1(wchar_t *FileID)
{
	(*Debug)->Deb("SENT: filesystem 1, deleting file\n");
	return DeleteFFolder1(FileID);
}

GSM_Error GSM_Phone_N6510::DeleteFolder1(wchar_t *FolderID)
{
	unsignedstring 			Buffer;
	GSM_FileFolderInfoList 		FInfo;
	GSM_Error			error;

	//phone allow for deleting non empty folders, we not
	FInfo.Info.ID.clear();
	FInfo.Info.ID.append(FolderID,UnicodeLength(FolderID));
	error = GetFileFolderInfo1(&FInfo.Info);
	if (error.Code !=GSM_ERR_NONE) return error;
	if (FInfo.Info.Folder==TRUE) {
		error = GetFolderInfoList1(&FInfo,TRUE);
		if (error.Code != GSM_ERR_EMPTY) {
			if (error.Code == GSM_ERR_FOLDER_PART ||
			    error.Code == GSM_ERR_NONE) {
				error.Code=GSM_ERR_FOLDER_NOT_EMPTY;
				error.Parameter.append((const wchar_t *)FolderID,UnicodeLength(FolderID));
				return error;
			}
			return error;
		}
	}

	(*Debug)->Deb("SENT: filesystem 1, deleting folder\n");
	return DeleteFFolder1(FolderID);
}

GSM_Error GSM_Phone_N6510::ReplyAddFolder1(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	FileFolderInfo 	*FInfo = (FileFolderInfo *)S;
	GSM_Error 		error;
	unsigned char		buffer[10];
	
	(*Debug)->Deb("RECEIVED: filesystem 1, adding folder\n");

	sprintf((char *)buffer,"c:\\%i",msg->Buffer.data()[8]*256+msg->Buffer.data()[9]);
	FInfo->ID.clear();
	FInfo->ID.append(StringToUnicodeReturn((char *)buffer),UnicodeLength(StringToUnicodeReturn((char *)buffer)));

	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_N6510::AddFolder1(FileFolderInfo *FInfo)
{
	GSM_Error		error;
	unsignedstring 		bufferstring;
	unsigned char 		Add[400] = {
		NOKIA_FRAME1, 0x04, 0x00, 0x00, 0x00, 0x01,
		0x00, 0x00,	     // parent folder ID
		0x00, 0x00, 0x00, 0xE8};

	Add[8] = atoi(UnicodeToStringReturn(FInfo->ID.data()+3)) / 256;
	Add[9] = atoi(UnicodeToStringReturn(FInfo->ID.data()+3)) % 256;
	memset(Add+14, 0x00, 300);
	NokiaSetUnicodeString(FInfo->Name.data(),&bufferstring);
	memcpy(Add+14,bufferstring.data(),bufferstring.size());
	Add[233] = 0x02;
	Add[235] = 0x01;
	Add[236] = atoi(UnicodeToStringReturn(FInfo->ID.data()+3)) / 256;
	Add[237] = atoi(UnicodeToStringReturn(FInfo->ID.data()+3)) % 256;

	(*Debug)->Deb("SENT: filesystem 1, adding folder\n");
	error = Write(Add, 246, 0x6D, 4, ID_AddFolder+ID,FInfo);

	if (!strcmp(UnicodeToStringReturn(FInfo->ID.data()),"0")) return GSM_Return_Error(GSM_ERR_FILE_EXIST);

	return error;
}

GSM_Error GSM_Phone_N6510::ReplyAddFilePart1(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	FileFolderInfo 	*FInfo = (FileFolderInfo *)S;
	char			buffer[10];
	wchar_t			name[10];

	switch (msg->Buffer.data()[3]) {
	case 0x03:
		(*Debug)->Deb("RECEIVED: filesystem 1, file header added\n");
		sprintf(buffer,"c:\\%i",msg->Buffer.data()[8]*256+msg->Buffer.data()[9]);
		StringToUnicode(buffer,name);
		FInfo->SetID(name);
		return GSM_Return_Error(GSM_ERR_NONE);
	case 0x41:
		(*Debug)->Deb("RECEIVED: filesystem 1, added part of file\n");
		return GSM_Return_Error(GSM_ERR_NONE);
	default:
		return GSM_Return_Error(GSM_ERR_FRAME_CONTENT_UNKNOWN);
	}
}

GSM_Error GSM_Phone_N6510::AddFilePart1(GSM_File *File, int *Pos)
{
	unsignedstring	bufferstring;
	char		buffer[200];
	unsigned int 	i,j;
	GSM_Error 	error;
	unsigned char 	AddHeader[400] = {
		NOKIA_FRAME1, 0x02, 0x00, 0x00, 0x00, 0x01,
		0x00, 0x00,	     // parent folder ID
		0x00, 0x00, 0x00, 0xE8};
	unsigned char	AddPart[14+2000] = {
		NOKIA_FRAME1, 0x40, 0x00, 0x00, 0x00, 0x01,
		0x00, 0x00,	     // file ID
		0x00, 0x00,
		0x01, 0x28};	     // buffer len

	if (*Pos == 0) {
		AddHeader[8] = atoi(UnicodeToStringReturn(File->Info.ID.data()+3)) / 256;
		AddHeader[9] = atoi(UnicodeToStringReturn(File->Info.ID.data()+3)) % 256;
		memset(AddHeader+14, 0x00, 300);
		NokiaSetUnicodeString(File->Info.Name.data(),&bufferstring);
		memcpy(AddHeader+14,bufferstring.data(),bufferstring.size());
		AddHeader[222] = File->Buffer.size() / (256*256*256);
		AddHeader[223] = File->Buffer.size() / (256*256);
		AddHeader[224] = File->Buffer.size() / 256;
		AddHeader[225] = File->Buffer.size() % 256;
		sprintf(buffer,"%s",UnicodeToStringReturn(File->Info.Name.data()));
		       if (StringCaseStr(buffer,".jpg")!=NULL)  { AddHeader[231]=0x02; AddHeader[233]=0x01;
		} else if (StringCaseStr(buffer,".jpeg")!=NULL) { AddHeader[231]=0x02; AddHeader[233]=0x01;
		} else if (StringCaseStr(buffer,".bmp") !=NULL) { AddHeader[231]=0x02; AddHeader[233]=0x02;
		} else if (StringCaseStr(buffer,".png") !=NULL) { AddHeader[231]=0x02; AddHeader[233]=0x03;
		} else if (StringCaseStr(buffer,".gif") !=NULL) { AddHeader[231]=0x02; AddHeader[233]=0x05;
		} else if (StringCaseStr(buffer,".wbmp")!=NULL) { AddHeader[231]=0x02; AddHeader[233]=0x09;
		} else if (StringCaseStr(buffer,".amr") !=NULL) { AddHeader[231]=0x04; AddHeader[233]=0x01;
		} else if (StringCaseStr(buffer,".mid") !=NULL) { AddHeader[231]=0x04; AddHeader[233]=0x05; //AddHeader[238]=0x01;
		} else if (StringCaseStr(buffer,".midi")!=NULL) { AddHeader[231]=0x04; AddHeader[233]=0x05; //AddHeader[238]=0x01;
		} else if (StringCaseStr(buffer,".nrt") !=NULL) { AddHeader[231]=0x04; AddHeader[233]=0x06;
		} else if (StringCaseStr(buffer,".3gp") !=NULL) { AddHeader[231]=0x08; AddHeader[233]=0x05;
		} else if (StringCaseStr(buffer,".jar") !=NULL) { AddHeader[231]=0x10; AddHeader[233]=0x01;
		} else {					  AddHeader[231]=0x01; AddHeader[233]=0x05;}
		AddHeader[235] = 0x01;
		AddHeader[236] = atoi(UnicodeToStringReturn(File->Info.ID.data()+3)) / 256;
		AddHeader[237] = atoi(UnicodeToStringReturn(File->Info.ID.data()+3)) % 256;
		if (File->Info.DRMForwardLock) 	AddHeader[238] = 0x01; //Nokia forward lock
		if (File->Info.Hidden)    	AddHeader[241] = 0x01;
		if (File->Info.System)    	AddHeader[242] = 0x01; //fixme

		(*Debug)->Deb("SENT: filesystem 1, adding file header\n");
		error = Write(AddHeader, 246, 0x6D, 4, ID_AddFilePart+ID,File);
		if (error.Code != GSM_ERR_NONE) return error;
	}

	j = 2000;
	if (File->Info.Size - *Pos < 2000) j = File->Info.Size - *Pos;

	AddPart[8]  = atoi(UnicodeToStringReturn(File->Info.ID.data()+3)) / 256;
	AddPart[9]  = atoi(UnicodeToStringReturn(File->Info.ID.data()+3)) % 256;
	AddPart[12] = j / 256;
	AddPart[13] = j % 256;

	memcpy(AddPart+14,File->Buffer.data()+(*Pos),j);

	(*Debug)->Deb("SENT: filesystem 1, adding file part\n");
	error = Write(AddPart, 14+j, 0x6D, 4, ID_AddFilePart+ID,File);
	if (error.Code != GSM_ERR_NONE) return error;

	*Pos = *Pos + j;

	if (j == 2000) return GSM_Return_Error(GSM_ERR_NONE);

	AddPart[12] = 0;
	AddPart[13] = 0;

	(*Debug)->Deb("SENT: filesystem 1, adding last file part\n");
	error = Write(AddPart, 14, 0x6D, 4, ID_AddFilePart+ID,File);
	if (error.Code != GSM_ERR_NONE) return error;

	//set datetime

	error = GetFileCheckSum1(File, &j);
	if (error.Code != GSM_ERR_NONE) return error;

	i=FindFileCheckSum12(File->Buffer.data(),File->Buffer.size());
	(*Debug)->Deb("  CheckSum from phone %i, CheckSum from Gammu %i\n",j,i);
	if (i!=j) return GSM_Return_Error(GSM_ERR_FILE_CHECKSUM);

	return GSM_Return_Error(GSM_ERR_EMPTY);
}

GSM_Error GSM_Phone_N6510::GetFileCheckSum1(GSM_File *File,unsigned int *CheckSum)
{
	unsigned char req[] = {NOKIA_FRAME1, 0x42, 0x00, 0x00, 0x00, 0x01,
			       0x00, 0x1E};    // file ID

	req[8] = atoi(UnicodeToStringReturn(File->Info.ID.data()+3)) / 256;
	req[9] = atoi(UnicodeToStringReturn(File->Info.ID.data()+3)) % 256;

	(*Debug)->Deb("SENT: filesystem 1, getting file checksum\n");
	return Write(req, sizeof(req), 0x6D, 4, ID_GetFileCheckSum+ID,CheckSum);
}

GSM_Error GSM_Phone_N6510::GetFilePart1(GSM_File *File)
{
	unsigned int		old,old2;
	GSM_Error		error;
	unsigned char	   	req[] = {
		NOKIA_FRAME1, 0x0E, 0x00, 0x00, 0x00, 0x01,
		0x00, 0x00,			//file ID
		0x00, 0x00, 0x00, 0x00, 	//start position
		0x00, 0x00, 
		0x03, 0xE8}; 			//length

	old     = File->Buffer.size();
	req[8]  = atoi(UnicodeToStringReturn(File->Info.ID.data()+3)) / 256;
	req[9]  = atoi(UnicodeToStringReturn(File->Info.ID.data()+3)) % 256;
	req[10] = old / (256*256*256);
	req[11] = old / (256*256);
	req[12] = old / 256;
	req[13] = old % 256;

	(*Debug)->Deb("SENT: filesystem 1, getting file part\n");
	error = Write(req, sizeof(req), 0x6D, 4, ID_GetFilePart+ID,File);
	if (error.Code != GSM_ERR_NONE) return error;

	if (File->Buffer.size()-old != (0x03 * 256 + 0xE8)) {
		error = GetFileCheckSum1(File, &old);
		if (error.Code != GSM_ERR_NONE) return error;

		old2=FindFileCheckSum12(File->Buffer.data(),File->Buffer.size());
		(*Debug)->Deb("  CheckSum from phone %i, CheckSum from Gammu %i\n",old,old2);
		if (old!=old2) return GSM_Return_Error(GSM_ERR_FILE_CHECKSUM);
	}

	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_N6510::ReplyGetFFolderInfo1(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	FileFolderInfo 	*FInfo = (FileFolderInfo *)S;
	int 			i;
	GSM_Error		error;

	switch (msg->Buffer.data()[3]) {
	case 0x15:
		(*Debug)->Deb("RECEIVED: filesystem 1, file/folder info\n");

		if (msg->Buffer.size() == 14) {
			(*Debug)->Deb("  file or folder not available ?\n");
			error.Code=GSM_ERR_FILE_FOLDER_NOT_EXIST;
			error.Parameter.append((const wchar_t *)FInfo->ID.data(),UnicodeLength(FInfo->ID.data()));
			return error;
		}

		FInfo->SetName(NokiaGetUnicodeString(msg->Buffer.data()+10));
		if (!strncmp(UnicodeToStringReturn(FInfo->Name.data()),"GMSTemp",7)) return GSM_Return_Error(GSM_ERR_EMPTY);
		if (UnicodeLength(FInfo->Name.data()) == 0) return GSM_Return_Error(GSM_ERR_UNKNOWN);

		i = msg->Buffer.data()[8]*256+msg->Buffer.data()[9];

		FInfo->Folder = FALSE;
		if (msg->Buffer.data()[i-5] == 0x00 && msg->Buffer.data()[i-3]==0x02) FInfo->Folder = TRUE;

		FInfo->ReadOnly  	= FALSE;
		FInfo->DRMForwardLock 	= FALSE;
		FInfo->System    	= FALSE;
		FInfo->Hidden    	= FALSE;
		if (msg->Buffer.data()[i+2] == 0x01) FInfo->DRMForwardLock    	= TRUE;
		if (msg->Buffer.data()[i+4] == 0x01) FInfo->ReadOnly     	= TRUE;
		if (msg->Buffer.data()[i+5] == 0x01) FInfo->Hidden       	= TRUE;
		if (msg->Buffer.data()[i+6] == 0x01) FInfo->System       	= TRUE;//fixme

		FInfo->ModificationDateTimeAvailable = TRUE;
		memcpy(&FInfo->ModificationDateTime,NokiaGetDT(msg->Buffer.data()+i-22),sizeof(GSM_DateTime));
		if (FInfo->ModificationDateTime.Year == 0x00 ||
		    FInfo->ModificationDateTime.Year == 0xFFFF) {
			FInfo->ModificationDateTimeAvailable = FALSE;
		}

		return GSM_Return_Error(GSM_ERR_NONE);
	case 0x2F:
		FInfo->Size = msg->Buffer.data()[6]*256*256*256+
			      msg->Buffer.data()[7]*256*256+
			      msg->Buffer.data()[8]*256+
			      msg->Buffer.data()[9];
		return GSM_Return_Error(GSM_ERR_NONE);
	default:
		return GSM_Return_Error(GSM_ERR_FRAME_CONTENT_UNKNOWN);
	}
}

GSM_Error GSM_Phone_N6510::GetFileFolderInfo1(FileFolderInfo *FInfo)
{
	GSM_Error		error;
	unsigned char 		Buffer[] = {
		NOKIA_FRAME1,
		0x14,	   	/* 0x14 - filefolder info, 0x22 - filesystem free/total, 0x2E - file used, 0x32 - folder sublocations */
		0x01,	   	/* 0x00 for sublocations reverse sorting (0x32), 0x01 for free (0x22) */
		0x00, 0x00, 0x01,
		0x00, 0x01};    /* Folder or file ID */

	Buffer[8] = atoi(UnicodeToStringReturn(FInfo->ID.data()+3)) / 256;
	Buffer[9] = atoi(UnicodeToStringReturn(FInfo->ID.data()+3)) % 256;

	Buffer[3] = 0x14; Buffer[4] = 0x01;
	(*Debug)->Deb("SENT: filesystem 1, getting file/folder info\n");
	error = Write(Buffer, sizeof(Buffer), 0x6D, 4, ID_GetFileFolderInfo+ID,FInfo);
	if (error.Code != GSM_ERR_NONE) return error;
 
	if (FInfo->Folder == FALSE) {
		Buffer[3] = 0x2E; Buffer[4] = 0x01;
		(*Debug)->Deb("SENT: filesystem 1, getting file size\n");
		return Write(Buffer, sizeof(Buffer), 0x6D, 4, ID_GetFileFolderInfo+ID,FInfo);
	}
	return error;
}

GSM_Error GSM_Phone_N6510::ReplyGetFolderInfoList1(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	GSM_FileFolderInfoList 	*FInfo = (GSM_FileFolderInfoList *)S;
	FileFolderInfo 	*Info;
	wchar_t 		name[20];
	char			buffer[20];
	int 			i;
	GSM_Error		error;

	if (msg->Buffer.data()[3]!=0x33) {
		return GSM_Return_Error(GSM_ERR_FRAME_CONTENT_UNKNOWN);
	}

	error.Code = GSM_ERR_EMPTY;
	for (i=0;i<(msg->Buffer.data()[8]*256+msg->Buffer.data()[9]);i++) {
		Info = new FileFolderInfo;

		sprintf(buffer,"c:\\%i",msg->Buffer.data()[13+i*4-1]*256 + msg->Buffer.data()[13+i*4]);
		StringToUnicode(buffer,name);

		Info->SetID(name);
		(*Debug)->Deb("  %s\n",UnicodeToStringReturn(Info->ID.data()));

		FInfo->AddSubEntry(Info);

		error.Code = GSM_ERR_NONE;
	}
	return error;
}

GSM_Error GSM_Phone_N6510::GetFolderInfoList1(GSM_FileFolderInfoList *FInfo, BOOLEAN Start)
{
	unsigned char Buffer[] = {
		NOKIA_FRAME1,
		0x32,	   	/* 0x14 - filefolder info, 0x22 - filesystem free/total, 0x2E - file used, 0x32 - folder sublocations */
		0x00,	   	/* 0x00 for sublocations reverse sorting (0x32), 0x01 for free (0x22) */
		0x00, 0x00, 0x01,
		0x00, 0x01};    /* Folder or file ID */

	Buffer[8] = atoi(UnicodeToStringReturn(FInfo->Info.ID.data()+3)) / 256;
	Buffer[9] = atoi(UnicodeToStringReturn(FInfo->Info.ID.data()+3)) % 256;

	FInfo->SubEntryFullData = FALSE;

	(*Debug)->Deb("SENT: filesystem 1, getting folder subentries\n");
	return Write(Buffer, sizeof(Buffer), 0x6D, 4, ID_GetFileFolderInfo+ID,FInfo);
}

//---------------- filesystem 2 (entries identified by full names) --------------------------------

GSM_Error GSM_Phone_N6510::ReplyDeleteFile2(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	wchar_t 	*ID = (wchar_t *)S;
	GSM_Error 	error;

	(*Debug)->Deb("RECEIVED: filesystem 2, deleting file\n");

	return GSM_Return_Error(GSM_ERR_FRAME_CONTENT_UNKNOWN);

	if (msg->Buffer.data()[4] == 0x00) {
		(*Debug)->Deb("  OK\n");
		return GSM_Return_Error(GSM_ERR_NONE);
	} else if (msg->Buffer.data()[4] == 0x03 || msg->Buffer.data()[4] == 0x06) {
		if (msg->Buffer.data()[4] == 0x03) {
			error.Code=GSM_ERR_MUST_BE_FOLDER;
			(*Debug)->Deb("  should be folder\n");
		} else {
			(*Debug)->Deb("  folder not exist\n");
			error.Code=GSM_ERR_FOLDER_NOT_EXIST;
		}
		error.Parameter.append((const wchar_t *)ID,UnicodeLength(ID));
		return error;
	} else if (msg->Buffer.data()[4] == 0x0C) {
		(*Debug)->Deb("  probably no memory card\n");
		return GSM_Return_Error(GSM_ERR_MEMORY);
	}

	return GSM_Return_Error(GSM_ERR_FRAME_CONTENT_UNKNOWN);
}

GSM_Error GSM_Phone_N6510::DeleteFile2(wchar_t *FileID)
{
	unsignedstring 			Buffer;
	GSM_Error			error;

	MakeFileSystemFrame2(&Buffer, FileID, 0x62);

	(*Debug)->Deb("SENT: filesystem 2, deleting file\n");
	return Write((unsigned char *)Buffer.data(), Buffer.size(), 0x6D, 4, ID_DeleteFile+ID, FileID);
}

GSM_Error GSM_Phone_N6510::ReplyDeleteFolder2(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	wchar_t 	*ID = (wchar_t *)S;
	GSM_Error 	error;

	(*Debug)->Deb("RECEIVED: filesystem 2, deleting folder\n");

	if (msg->Buffer.data()[4] == 0x00) {
		(*Debug)->Deb("  OK\n");
		return GSM_Return_Error(GSM_ERR_NONE);
	} else if (msg->Buffer.data()[4] == 0x03 || msg->Buffer.data()[4] == 0x06) {
		if (msg->Buffer.data()[4] == 0x03) {
			error.Code=GSM_ERR_MUST_BE_FOLDER;
			(*Debug)->Deb("  should be folder\n");
		} else {
			(*Debug)->Deb("  folder not exist\n");
			error.Code=GSM_ERR_FOLDER_NOT_EXIST;
		}
		error.Parameter.append((const wchar_t *)ID,UnicodeLength(ID));
		return error;
	} else if (msg->Buffer.data()[4] == 0x0C) {
		(*Debug)->Deb("  probably no memory card\n");
		return GSM_Return_Error(GSM_ERR_MEMORY);
	}

	return GSM_Return_Error(GSM_ERR_FRAME_CONTENT_UNKNOWN);
}

GSM_Error GSM_Phone_N6510::DeleteFolder2(wchar_t *FolderID)
{
	unsignedstring 			Buffer;
	GSM_FileFolderInfoList 		FInfo;
	GSM_Error			error;

	//phone allow for deleting non empty folders, we not
	FInfo.Info.SetID(FolderID);
	error = GetFileFolderInfo2(&FInfo.Info);
	if (error.Code !=GSM_ERR_NONE) return error;
//	if (FInfo.Info.Folder==TRUE) {
		//error = GetFolderInfoList2(&FInfo);
		//if (error.Code != GSM_ERR_EMPTY) {
			//if (error.Code == GSM_ERR_FOLDER_PART ||
			    //error.Code == GSM_ERR_NONE) {
				//error.Code=GSM_ERR_FOLDER_NOT_EMPTY;
				//error.Parameter.append((const wchar_t *)FolderID,UnicodeLength(FolderID));
				//return error;
			//}
			//return error;
		//}
	//}

	MakeFileSystemFrame2(&Buffer, FolderID, 0x6A);

	(*Debug)->Deb("SENT: filesystem 2, deleting folder\n");
	return Write((unsigned char *)Buffer.data(), Buffer.size(), 0x6D, 4, ID_DeleteFolder+ID, FolderID);
}

GSM_Error GSM_Phone_N6510::ReplyAddFolder2(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	FileFolderInfo 	*FInfo = (FileFolderInfo *)S;
	GSM_Error 		error;
	int			Len;
	wchar_t			*Buf;
	
	(*Debug)->Deb("RECEIVED: filesystem 2, adding folder\n");

	if (msg->Buffer.data()[4] == 0x00) {
		(*Debug)->Deb("  OK\n");
		return GSM_Return_Error(GSM_ERR_NONE);
	} else if (msg->Buffer.data()[4] == 0x04) {
		(*Debug)->Deb("  folder already exist\n");

		Len = UnicodeLength(FInfo->ID.data());
		if (UnicodeToStringReturn(FInfo->ID.data())[Len-1] != '\\' &&
	            UnicodeToStringReturn(FInfo->ID.data())[Len-1] != '/') {
			Len ++;
		}
		Len+=UnicodeLength(FInfo->Name.data());
		Buf=(wchar_t *)malloc((Len+1)*sizeof(wchar_t));
		CopyUnicode(FInfo->ID.data(),Buf);
		if (Buf[UnicodeLength(Buf)-1] != '\\' &&
		    Buf[UnicodeLength(Buf)-1] != '/') {
			StringToUnicode("\\",Buf+UnicodeLength(Buf));
		}
		CopyUnicode(FInfo->Name.data(),Buf+UnicodeLength(Buf));

		error.Code=GSM_ERR_FOLDER_EXIST;
		error.Parameter.append(Buf,UnicodeLength(Buf));

		free(Buf);

		return error;
	} else if (msg->Buffer.data()[4] == 0x06) {
		(*Debug)->Deb("  parent folder not available\n");
		error.Code=GSM_ERR_FOLDER_NOT_EXIST;
		error.Parameter.append((const wchar_t *)FInfo->ID.data(),UnicodeLength(FInfo->ID.data()));
		return error;
	} else if (msg->Buffer.data()[4] == 0x0C) {
		(*Debug)->Deb("  probably no memory card\n");
		return GSM_Return_Error(GSM_ERR_MEMORY);
	}
	return GSM_Return_Error(GSM_ERR_FRAME_CONTENT_UNKNOWN);
}

GSM_Error GSM_Phone_N6510::AddFolder2(FileFolderInfo *FInfo)
{
	unsignedstring 	Buffer;
	int		Len;
	wchar_t		*Buf;

	Len = UnicodeLength(FInfo->ID.data());
	if (UnicodeToStringReturn(FInfo->ID.data())[Len-1] != '\\' &&
            UnicodeToStringReturn(FInfo->ID.data())[Len-1] != '/') {
		Len ++;
	}
	Len+=UnicodeLength(FInfo->Name.data());
	Buf=(wchar_t *)malloc((Len+1)*sizeof(wchar_t));
	CopyUnicode(FInfo->ID.data(),Buf);
	if (Buf[UnicodeLength(Buf)-1] != '\\' &&
	    Buf[UnicodeLength(Buf)-1] != '/') {
		StringToUnicode("\\",Buf+UnicodeLength(Buf));
	}
	CopyUnicode(FInfo->Name.data(),Buf+UnicodeLength(Buf));

	MakeFileSystemFrame2(&Buffer, Buf, 0x64);

	free(Buf);

	(*Debug)->Deb("SENT: filesystem 2, adding folder\n");
	return Write((unsigned char *)Buffer.data(), Buffer.size(), 0x6D, 4, ID_AddFolder+ID,FInfo);
}

GSM_Error GSM_Phone_N6510::ReplyGetFFolderInfo2Part(GSM_Protocol_Message *msg, DebugInfo **Debug, FileFolderInfo *FInfo)
{
	GSM_Error error;

	(*Debug)->Deb("RECEIVED: filesystem 2, file or folder info\n");

	if (msg->Buffer.data()[4] == 0x06) {
		(*Debug)->Deb("  file or folder not available ?\n");
		error.Code=GSM_ERR_FILE_FOLDER_NOT_EXIST;
		error.Parameter.append((const wchar_t *)FInfo->ID.data(),UnicodeLength(FInfo->ID.data()));
		return error;
	}
	if (msg->Buffer.data()[4] == 0x0C) {
		(*Debug)->Deb("  probably no memory card\n");
		return GSM_Return_Error(GSM_ERR_MEMORY);
	}
	if (msg->Buffer.data()[4] == 0x00 || msg->Buffer.data()[4] == 0x0D) {
		switch (msg->Buffer.data()[5]) {
		case 0x00:
			break;
		case 0x06:
			//no file
			(*Debug)->Deb("  file not exist\n");
			error.Code=GSM_ERR_FILE_FOLDER_NOT_EXIST;
			error.Parameter.append((const wchar_t *)FInfo->ID.data(),UnicodeLength(FInfo->ID.data()));
			return error;
		case 0x0C:
			(*Debug)->Deb("  probably no memory card\n");
			return GSM_Return_Error(GSM_ERR_MEMORY);
		default:
			(*Debug)->Deb("  unknown status code\n");
			return GSM_Return_Error(GSM_ERR_FRAME_CONTENT_UNKNOWN);
		}

		//folder flag not set for root
		FInfo->ReadOnly  	= FALSE;
		FInfo->Hidden    	= FALSE;
		FInfo->System    	= FALSE;
		FInfo->DRMForwardLock 	= FALSE;
		FInfo->Folder    	= FALSE;
		if ((msg->Buffer.data()[29] & 0x01) == 0x01) FInfo->ReadOnly  		= TRUE;
		if ((msg->Buffer.data()[29] & 0x02) == 0x02) FInfo->Hidden    		= TRUE;
		if ((msg->Buffer.data()[29] & 0x04) == 0x04) FInfo->System    		= TRUE;
		if ((msg->Buffer.data()[29] & 0x08) == 0x08) FInfo->DRMForwardLock 	= TRUE;
		if ((msg->Buffer.data()[29] & 0x10) == 0x10) FInfo->Folder    		= TRUE;

		if (FInfo->Folder == FALSE) {
			FInfo->Size = msg->Buffer.data()[10]*256*256*256+
				      msg->Buffer.data()[11]*256*256+
				      msg->Buffer.data()[12]*256+
				      msg->Buffer.data()[13];
		} else {
			(*Debug)->Deb("  folder\n");
		}

		FInfo->ModificationDateTimeAvailable = TRUE;
		memcpy(&FInfo->ModificationDateTime,NokiaGetDT(msg->Buffer.data()+14),sizeof(GSM_DateTime));
		if (FInfo->ModificationDateTime.Year == 0x00 ||
		    FInfo->ModificationDateTime.Year == 0xFFFF) {
			FInfo->ModificationDateTimeAvailable = FALSE;
		}
	
		return GSM_Return_Error(GSM_ERR_NONE);
	}

	return GSM_Return_Error(GSM_ERR_FRAME_CONTENT_UNKNOWN);
}

GSM_Error GSM_Phone_N6510::ReplyGetFFolderInfo2(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	FileFolderInfo 	*FInfo = (FileFolderInfo *)S;
	GSM_Error 		error;
	wchar_t 		name[20];

	if (msg->Buffer.data()[3]!=0x6D) {
		return GSM_Return_Error(GSM_ERR_FRAME_CONTENT_UNKNOWN);
	}

	error=ReplyGetFFolderInfo2Part(msg, Debug, FInfo);

	name[0] = 0;
	FInfo->SetName(name);

	if (UnicodeLength(FInfo->ID.data())!=2 && UnicodeLength(FInfo->ID.data())!=3) {
		return error;
	}

	if ((FInfo->ID.data()[0] == 'a' || FInfo->ID.data()[0] == 'A') ||
	    (FInfo->ID.data()[0] == 'd' || FInfo->ID.data()[0] == 'D')) {
		if (FInfo->ID.data()[1] == ':' && FInfo->ID.data()[2] == 0x00) FInfo->Folder=TRUE;
		if ((FInfo->ID.data()[2] == '\\' || FInfo->ID.data()[2] == '/') &&
		     FInfo->ID.data()[3] == 0x00) {
			FInfo->Folder=TRUE;
		}
	}

	return error;
}

GSM_Error GSM_Phone_N6510::GetFileFolderInfo2(FileFolderInfo *FInfo)
{
	unsignedstring Buffer;

	MakeFileSystemFrame2(&Buffer, (wchar_t *)FInfo->ID.data(), 0x6C);

	(*Debug)->Deb("SENT: filesystem 2, getting file/folder info\n");
	return Write((unsigned char *)Buffer.data(), Buffer.size(), 0x6D, 4, ID_GetFileFolderInfo+ID,FInfo);
}

GSM_Error GSM_Phone_N6510::ReplyGetFolderInfoList2(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	GSM_FileFolderInfoList 	*FInfo = (GSM_FileFolderInfoList *)S;
	FileFolderInfo 	*Info;
	GSM_Error		error;
	wchar_t 		*name;

	if (msg->Buffer.data()[3]!=0x69) {
		return GSM_Return_Error(GSM_ERR_FRAME_CONTENT_UNKNOWN);
	}

	if (msg->Buffer.data()[4] == 0x0E) {
		(*Debug)->Deb("  folder empty\n");
		return GSM_Return_Error(GSM_ERR_EMPTY);
	}

	Info = new FileFolderInfo;

	Info->SetName(NokiaGetUnicodeString(msg->Buffer.data()+32));
	(*Debug)->Deb("  %s\n",UnicodeToStringReturn(Info->Name.data()));

	name = (wchar_t *)malloc((UnicodeLength(FInfo->Info.ID.data())+1+UnicodeLength(Info->Name.data())+1)*sizeof(wchar_t));
	CopyUnicode(FInfo->Info.ID.data(),name);
	StringToUnicode("\\",name+UnicodeLength(name));
	CopyUnicode(Info->Name.data(),name+UnicodeLength(name));

	Info->SetID(name);

	(*Debug)->Deb("  %s\n",UnicodeToStringReturn(name));

	free(name);

	error = ReplyGetFFolderInfo2Part(msg, Debug, Info);
	if (error.Code!=GSM_ERR_NONE) return error;

	error = FInfo->AddSubEntry(Info);
	if (error.Code!=GSM_ERR_NONE) return error;

	if (msg->Buffer.data()[4] == 0x00) {
		(*Debug)->Deb("  last one\n");
		return GSM_Return_Error(GSM_ERR_NONE); //last
	}
	return GSM_Return_Error(GSM_ERR_FOLDER_MORE); // we will have more
}

GSM_Error GSM_Phone_N6510::GetFolderInfoList2(GSM_FileFolderInfoList *FInfo, BOOLEAN Start)
{
        GSM_Error       error;
	wchar_t		*Buf;
	unsignedstring  Buffer;

	if (Start) {
		Buf=(wchar_t *)malloc((UnicodeLength(FInfo->Info.ID.data())+3)*sizeof(wchar_t));
		CopyUnicode(FInfo->Info.ID.data(),Buf);
		StringToUnicode("\\*",Buf+UnicodeLength(Buf));

		MakeFileSystemFrame2(&Buffer, Buf, 0x68);

		free(Buf);

		FInfo->SubEntryFullData = TRUE;

		(*Debug)->Deb("SENT: filesystem 2, getting folder listing\n");
		error = (*Protocols)->Current->Write((unsigned char *)Buffer.data(), Buffer.size(), 0x6D);
		if (error.Code!=GSM_ERR_NONE) return error;

		GetFolderListing2 = 0;
	}

	error = ReadOnce(ID_GetFolderList+ID,FInfo);
	if (error.Code == GSM_ERR_TIMEOUT) {
		GetFolderListing2++;
		if (GetFolderListing2==3) {
			return GSM_Return_Error(GSM_ERR_FOLDER_PART);
		} else {
			return GSM_Return_Error(GSM_ERR_FOLDER_MORE);
		}
	}
	return error;
}

GSM_Error GSM_Phone_N6510::GetFileCheckSum2(GSM_File *File,unsigned int *CheckSum)
{
	unsigned char req[] = {NOKIA_FRAME1, 0x66, 0x00, 0x00,
			       0x00, 0x00, 0x00, 0x00}; //file handle

	req[6] = File->Handle / (256*256*256);
	req[7] = File->Handle / (256*256);
	req[8] = File->Handle / 256;
	req[9] = File->Handle % 256;

	(*Debug)->Deb("SENT: filesystem 2, getting file checksum\n");
	return Write(req, sizeof(req), 0x6D, 200, ID_GetFileCheckSum+ID,CheckSum);
}

GSM_Error GSM_Phone_N6510::CloseFile2(GSM_File *File)
{
	unsigned int 	i;
	unsigned char 	req[] = {NOKIA_FRAME1, 0x74, 0x00, 0x00,
			         0x00, 0x00, 0x00, 0x00}; //file handle

	req[6] = File->Handle / (256*256*256);
	req[7] = File->Handle / (256*256);
	req[8] = File->Handle / 256;
	req[9] = File->Handle % 256;

	for(i=0;i<FileSystemOpened2.size();i++) {
		if (FileSystemOpened2.data()[i]==File->Handle) {
			FileSystemOpened2.erase(i);
			break;
		}
	}

	(*Debug)->Deb("SENT: filesystem 2, closing file\n");
	return Write(req, sizeof(req), 0x6D, 4, ID_CloseFile+ID,&File->Handle);
}

GSM_Error GSM_Phone_N6510::ReplyOpenFile2(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	int *Handle = (int *)S;

	switch (msg->Buffer.data()[4]) {
	case 0x00:
		(*Handle) = msg->Buffer.data()[6]*256*256*256+
			 msg->Buffer.data()[7]*256*256+
			 msg->Buffer.data()[8]*256+
			 msg->Buffer.data()[9];
		FileSystemOpened2.push_back(*Handle);
		return GSM_Return_Error(GSM_ERR_NONE);
	default:
		return GSM_Return_Error(GSM_ERR_FRAME_CONTENT_UNKNOWN);
	}
}

GSM_Error GSM_Phone_N6510::OpenFile2(GSM_File *File, BOOLEAN Create)
{
	unsignedstring Buffer;

	Buffer.push_back(0x00);
	Buffer.push_back(0x01);
	Buffer.push_back(0x00);
	Buffer.push_back(0x72);
	if (Create == TRUE) {
		Buffer.push_back(0x11);//read write create
	} else {
		Buffer.push_back(0x00);//read only
	}
	Buffer.push_back(0x02);
	Buffer.push_back((UnicodeLength(File->Info.ID.data())*2+2)/256);
	Buffer.push_back((UnicodeLength(File->Info.ID.data())*2+2)%256);
		FFolderPathGammu2Phone2((wchar_t *)File->Info.ID.data(),&Buffer);
		Buffer.push_back(0x00); Buffer.push_back(0x00);
	Buffer.push_back(0x00);
	Buffer.push_back(0x00);

	(*Debug)->Deb("SENT: filesystem 2, opening file\n");
	return Write((unsigned char *)Buffer.data(), Buffer.size(), 0x6D, 4, ID_OpenFile+ID,&File->Handle);
}

GSM_Error GSM_Phone_N6510::GetFilePart2(GSM_File *File)
{
	unsigned int		old,old2;
	GSM_Error		error;
	wchar_t			*Buf;
	unsigned char	   	req[] = {
		NOKIA_FRAME1, 0x5E, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00,		//file handle
		0x00, 0x00, 0x00, 0x00, 	//start position
		0x00, 0x00, 0x03, 0xE8, 	//length
		0x00, 0x00, 0x03, 0xE8};	//buffer length

	if (File->Buffer.size() == 0x00) {
		Buf=(wchar_t *)malloc((UnicodeLength(File->Info.ID.data())+1)*sizeof(wchar_t));
		CopyUnicode(File->Info.ID.data(),Buf);

		for (old=UnicodeLength(Buf);old>=0;old--) {
			if (Buf[old] == '\\' || Buf[old] == '/') break;
		}

		File->Info.SetName(Buf+old+1);

		free(Buf);

		error = OpenFile2(File, FALSE);
		if (error.Code != GSM_ERR_NONE) return error;
	}

	old     = File->Buffer.size();
	req[6]  = File->Handle / (256*256*256);
	req[7]  = File->Handle / (256*256);
	req[8]  = File->Handle / 256;
	req[9]  = File->Handle % 256;
	req[10] = old / (256*256*256);
	req[11] = old / (256*256);
	req[12] = old / 256;
	req[13] = old % 256;

	(*Debug)->Deb("SENT: filesystem 2, getting file part\n");
	error = Write(req, sizeof(req), 0x6D, 4, ID_GetFilePart+ID,File);
	if (error.Code != GSM_ERR_NONE) return error;

	if (File->Buffer.size()-old != (0x03 * 256 + 0xE8)) {
		error = GetFileCheckSum2(File, &old);
		if (error.Code != GSM_ERR_NONE) return error;

		error = CloseFile2(File);
		if (error.Code != GSM_ERR_NONE) return error;

		old2=FindFileCheckSum12(File->Buffer.data(),File->Buffer.size());
		(*Debug)->Deb("  CheckSum from phone %i, CheckSum from Gammu %i\n",old,old2);
		if (old!=old2) return GSM_Return_Error(GSM_ERR_FILE_CHECKSUM);
	}

	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_N6510::AddFilePart2(GSM_File *File, int *Pos)
{
	wchar_t 	*name;
	int 		j;
	GSM_Error 	error;
	unsignedstring 	Buffer;
	unsigned char 	AddPart[14+2000] = {
		NOKIA_FRAME1, 0x58, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 	// handle
		0x00, 0x00, 0x08, 0x00};	// buffer len

	//overwriting

	if (*Pos == 0) {
		name = (wchar_t *)malloc((UnicodeLength(File->Info.ID.data())+1+UnicodeLength(File->Info.Name.data())+1)*sizeof(wchar_t));
		CopyUnicode(File->Info.ID.data(),name);
		StringToUnicode("\\",name+UnicodeLength(name));
		CopyUnicode(File->Info.Name.data(),name+UnicodeLength(name));

		File->Info.SetID(name);
		(*Debug)->Deb("  %s\n",UnicodeToStringReturn(File->Info.ID.data()));

		free(name);

		error = OpenFile2(File, TRUE);
		if (error.Code != GSM_ERR_NONE) return error;
	}

	j = 2000;
	if (File->Info.Size - *Pos < j) j = File->Info.Size - *Pos;

	AddPart[6]  = File->Handle / (256*256*256);
	AddPart[7]  = File->Handle / (256*256);
	AddPart[8]  = File->Handle / 256;
	AddPart[9]  = File->Handle % 256;
	AddPart[10] = j / (256*256*256);
	AddPart[11] = j / (256*256);
	AddPart[12] = j / 256;
	AddPart[13] = j % 256;

	memcpy(AddPart+14,File->Buffer.data()+(*Pos),j);

	(*Debug)->Deb("SENT: filesystem 2, adding file part\n");
	error = Write(AddPart, 14+j, 0x6D, 4, ID_AddFilePart+ID,File);
	if (error.Code != GSM_ERR_NONE) return error;

	*Pos = *Pos + j;

	if (j == 2000) return GSM_Return_Error(GSM_ERR_NONE);

	error = CloseFile2(File);
	if (error.Code != GSM_ERR_NONE) return error;

	if (!File->Info.ModificationDateTimeAvailable) return GSM_Return_Error(GSM_ERR_EMPTY);

	Buffer.push_back(0x00);
	Buffer.push_back(0x01);
	Buffer.push_back(0x00);
	Buffer.push_back(0x86);
	Buffer.push_back((UnicodeLength(File->Info.ID.data())*2+2)/256);
	Buffer.push_back((UnicodeLength(File->Info.ID.data())*2+2)%256);
	Buffer.push_back(File->Info.ModificationDateTime.Year / 256);
	Buffer.push_back(File->Info.ModificationDateTime.Year % 256);
	Buffer.push_back(File->Info.ModificationDateTime.Month);
	Buffer.push_back(File->Info.ModificationDateTime.Day);
	Buffer.push_back(0x00);
	Buffer.push_back(File->Info.ModificationDateTime.Hour);
	Buffer.push_back(File->Info.ModificationDateTime.Minute);
	Buffer.push_back(File->Info.ModificationDateTime.Second);
	FFolderPathGammu2Phone2((wchar_t *)File->Info.ID.data(),&Buffer);
	Buffer.push_back(0x00); Buffer.push_back(0x00);
	Buffer.push_back(0x00);
	Buffer.push_back(0x00);

	(*Debug)->Deb("SENT: filesystem 2, setting file date\n");
	error = Write((unsigned char *)Buffer.data(), Buffer.size(), 0x6D, 4, ID_SetFileDate+ID,File);
	if (error.Code == GSM_ERR_NONE) return GSM_Return_Error(GSM_ERR_EMPTY);
	return error;
}

typedef struct {
	wchar_t 	Gammu;
	unsigned char	Phone;
} N6510_FileSystem2Drives;

static N6510_FileSystem2Drives N6510FileSystem2Drives[5] = 
{
	{'a','b'},{'A','b'},
	{'d','a'},{'D','a'},
	{0x00,0x00}
};

//Gammu -> phone path conversion
void GSM_Phone_N6510::FFolderPathGammu2Phone2(wchar_t *src, unsignedstring *dest)
{
	int i = 0;

	while (N6510FileSystem2Drives[i].Gammu!=0x00) {
		if (src[0] == N6510FileSystem2Drives[i].Gammu) {
			dest->push_back(0x00); dest->push_back(N6510FileSystem2Drives[i].Phone);
			NokiaSetUnicodeString(src+1,dest);
			return;
		}
		i++;
	}
	NokiaSetUnicodeString(src,dest);
}

GSM_Error GSM_Phone_N6510::MakeFileSystemFrame2(unsignedstring *Buffer, wchar_t *Name, unsigned char ID)
{
	Buffer->push_back(0x00);
	Buffer->push_back(0x01);
	Buffer->push_back(0x00);
	Buffer->push_back(ID);
	Buffer->push_back((UnicodeLength(Name)*2+2)/256);
	Buffer->push_back((UnicodeLength(Name)*2+2)%256);
		FFolderPathGammu2Phone2(Name,Buffer);
		Buffer->push_back(0x00); Buffer->push_back(0x00);
	Buffer->push_back(0x00);
	Buffer->push_back(0x00);

	return GSM_Return_Error(GSM_ERR_NONE);
}

//-------------------- shared for filesystem 1 and 2 -------------------------------------------

GSM_Error GSM_Phone_N6510::GetNextRootFolderID(wchar_t *ID, GSM_MemoryType *MemType)
{
	FileFolderInfo 	FInfo;
	GSM_Error 		error;

	//no filesystem
	if ((*Phones)->Feature("nofile")==TRUE) {
		return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
	}

	//filesystem 1
	if ((*Phones)->Feature("file1")==TRUE || (*Phones)->Feature("file1only")==TRUE) {
		if (ID[0] == 0) {
			ID[0] = 'c'; ID[1] = ':'; ID[2] = '\\'; ID[3] = '1'; ID[4] = 0;
			*MemType = MEM_PHONE;
			return GSM_Return_Error(GSM_ERR_NONE);
		}
		if ((*Phones)->Feature("file1only")==TRUE) {
			return GSM_Return_Error(GSM_ERR_EMPTY);
		}
	}

	//filesystem 2
	if (ID[0] == 0 || ID[0] == 'c') {
		ID[0] = 'd'; ID[1] = ':'; ID[2] = 0;
		*MemType = MEM_PHONE;
		return GSM_Return_Error(GSM_ERR_NONE);
	}
	if (ID[0] == 'd') {
		FInfo.SetID(StringToUnicodeReturn("a:"));
		error = GetFileFolderInfo2(&FInfo);
		if (error.Code == GSM_ERR_FILE_FOLDER_NOT_EXIST) {
			return GSM_Return_Error(GSM_ERR_EMPTY);
		}
		if (error.Code != GSM_ERR_NONE && error.Code != GSM_ERR_MEMORY) return error;

		ID[0] = 'a'; ID[1] = ':'; ID[2] = 0;
		*MemType = MEM_MEMORY_CARD;
		return error;
	}
	return GSM_Return_Error(GSM_ERR_EMPTY);
}

/* function for making CRC for filesystem (c) 2003 by Michael Schroeder */
unsigned int GSM_Phone_N6510::FindFileCheckSum12(const unsigned char *ptr, int len)
{
	int acc, i, accx;

	accx = 0;
	acc  = 0xffff;
	while (len--) {
		accx = (accx & 0xffff00ff) | (acc & 0xff00);
		acc  = (acc  & 0xffff00ff) | *ptr++ << 8;
		for (i = 0; i < 8; i++) {
			acc <<= 1;
			if (acc & 0x10000)     acc ^= 0x1021;
			if (accx & 0x80000000) acc ^= 0x1021;
			accx <<= 1;
		}
	}
	return (acc & 0xffff);
}

GSM_Error GSM_Phone_N6510::ReplyGetFileCheckSum12(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	unsigned int *CheckSum = (unsigned int *)S;

	(*CheckSum)=msg->Buffer.data()[6]*256+msg->Buffer.data()[7];

	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_N6510::ReplyGetFilePart12(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	GSM_File *File = (GSM_File *)S;

	File->Buffer.append((const unsigned char *)msg->Buffer.data()+10,msg->Buffer.data()[6]*256*256*256+msg->Buffer.data()[7]*256*256+msg->Buffer.data()[8]*256+msg->Buffer.data()[9]);

	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_N6510::GetFileFolderInfo(FileFolderInfo *FInfo)
{
	int 		Num;
	GSM_Error 	error;

	error = FileSystemFunc((wchar_t *)FInfo->ID.data(), &Num);
	if (error.Code!=GSM_ERR_NONE) return error;

	if (Num==1) return GetFileFolderInfo1(FInfo);
	return GetFileFolderInfo2(FInfo);
}

GSM_Error GSM_Phone_N6510::GetFolderInfoList(GSM_FileFolderInfoList *FInfo, BOOLEAN Start)
{
	int 		Num;
	GSM_Error 	error;

	error = FileSystemFunc((wchar_t*)FInfo->Info.ID.data(), &Num);
	if (error.Code!=GSM_ERR_NONE) return error;

	if (Start) FInfo->ClearAll();

	if (Num==1) return GetFolderInfoList1(FInfo, Start);
	return GetFolderInfoList2(FInfo, Start);
}

GSM_Error GSM_Phone_N6510::GetFilePart(GSM_File *File)
{
	int 		Num;
	GSM_Error 	error;

	error = FileSystemFunc((wchar_t *)File->Info.ID.data(), &Num);
	if (error.Code!=GSM_ERR_NONE) return error;

	if (File->Buffer.size() == 0x00) {
		error = GetFileFolderInfo(&File->Info);
		if (error.Code != GSM_ERR_NONE) return error;

		if (File->Info.Folder==TRUE) {
			error.Code=GSM_ERR_MUST_BE_FILE;
			error.Parameter.append((const wchar_t *)File->Info.ID.data(),UnicodeLength(File->Info.ID.data()));
			return error;
		}
	}

	if (Num==1) {
		error=GetFilePart1(File);
	} else {
		error=GetFilePart2(File);
	}
	if (error.Code == GSM_ERR_FILE_FOLDER_NOT_EXIST) error.Code=GSM_ERR_FILE_NOT_EXIST;
	return error;
}

GSM_Error GSM_Phone_N6510::GetMMSFilePart(GSM_File *File)
{
	long		s;
	int 		Num;
	GSM_Error 	error;

	error = FileSystemFunc((wchar_t *)File->Info.ID.data(), &Num);
	if (error.Code!=GSM_ERR_NONE) return error;

	if (File->Buffer.size() == 0x00) {
		error = GetFileFolderInfo(&File->Info);
		if (error.Code != GSM_ERR_NONE) return error;

		if (File->Info.Folder==TRUE) {
			error.Code=GSM_ERR_MUST_BE_FILE;
			error.Parameter.append((const wchar_t *)File->Info.ID.data(),UnicodeLength(File->Info.ID.data()));
			return error;
		}
		MMSFile.Info.SetID((wchar_t *)File->Info.ID.data());
		MMSFile.Buffer.clear();
	}

	if (Num==1) {
		error=GetFilePart1(&MMSFile);
	} else {
		error=GetFilePart2(&MMSFile);
	}
	if (error.Code == GSM_ERR_FILE_FOLDER_NOT_EXIST) error.Code=GSM_ERR_FILE_NOT_EXIST;
	if (error.Code == GSM_ERR_NONE) {
		if ((*Phones)->Feature("s40_30")==TRUE) {
			if (File->Buffer.size() == 0x00) {
				File->Info.Size = MMSFile.Buffer.data()[7]+MMSFile.Buffer.data()[6]*256+
						 MMSFile.Buffer.data()[5]*256*256+MMSFile.Buffer.data()[4]*256*256*256*256;
			}
			s = MMSFile.Buffer.size()-176;
			if (s>File->Info.Size) s = File->Info.Size;
			File->Buffer.clear();
			File->Buffer.append(MMSFile.Buffer.data()+176,s);
		} else {
			File->Buffer.clear();
			File->Buffer.append(MMSFile.Buffer.data(),MMSFile.Buffer.size());
		}
	}
	return error;
}

GSM_Error GSM_Phone_N6510::AddFilePart(GSM_File *File, int *Pos)
{
	int 		Num;
	GSM_Error 	error;

	error = FileSystemFunc((wchar_t *)File->Info.ID.data(), &Num);
	if (error.Code!=GSM_ERR_NONE) return error;

	if (Num==1) return AddFilePart1(File,Pos);
	return AddFilePart2(File,Pos);
}

GSM_Error GSM_Phone_N6510::DeleteFile(wchar_t *FileID)
{
	int 		Num;
	GSM_Error 	error;

	error = FileSystemFunc(FileID, &Num);
	if (error.Code!=GSM_ERR_NONE) return error;

	if (Num==1) return DeleteFile1(FileID);
	return DeleteFile2(FileID);
}

GSM_Error GSM_Phone_N6510::DeleteFolder(wchar_t *FolderID)
{
	int 		Num;
	GSM_Error 	error;

	error = FileSystemFunc(FolderID, &Num);
	if (error.Code!=GSM_ERR_NONE) return error;

	if (Num==1) return DeleteFolder1(FolderID);
	return DeleteFolder2(FolderID);
}

GSM_Error GSM_Phone_N6510::AddFolder(FileFolderInfo *FInfo)
{
	int 		Num;
	GSM_Error 	error;

	error = FileSystemFunc((wchar_t *)FInfo->ID.data(), &Num);
	if (error.Code!=GSM_ERR_NONE) return error;

	if (Num==1) return AddFolder1(FInfo);
	return AddFolder2(FInfo);
}

GSM_Error GSM_Phone_N6510::FileSystemFunc(wchar_t *ID, int *Num)
{
	//no filesystem
	if ((*Phones)->Feature("nofile")==TRUE) return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);

	if (ID[0] == 'c' || ID[0] == 'C') {
		//filesystem1
		if ((*Phones)->Feature("file1")==FALSE && (*Phones)->Feature("file1only")==FALSE) {
			return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
		}
		*Num = 1;
	} else {
		//filesystem2
		*Num = 2;
	}

	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_N6510::GetJavaGamesFolderID(wchart *ID, BOOLEAN *NeedSubFolder, BOOLEAN Start)
{
	GSM_Error	error;
	char 		buff[80];

	if ((*Phones)->Feature("nofile")==TRUE) return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);

	if ((*Phones)->Feature("s40_30")==TRUE) {
		sprintf(buff,"d:/predefjava/predefgames");
		ID->clear();
		ID->append((const wchar_t *)StringToUnicodeReturn(buff),strlen(buff));
		*NeedSubFolder = FALSE;
		return GSM_Return_Error(GSM_ERR_NONE);
	}

	//series 40 1.0 and 2.0 - filesystem 1
	if (Start) {
		JavaFInfoSubEntry = NULL;

		JavaFInfo.ClearAll();
		JavaFInfo.Info.SetID(StringToUnicodeReturn("c:\\3"));
		//we don't need to use GetFolderInfoList
		//because of it we don't check all error codes
		error = GetFolderInfoList1(&JavaFInfo, TRUE);
		if (error.Code == GSM_ERR_NONE) return GSM_Return_Error(GSM_ERR_FOLDER_MORE);
		return error;
	} else {
		if (JavaFInfo.GetNext(&JavaFInfoSubEntry) == FALSE) return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
		error = GetFileFolderInfo(&JavaFInfoSubEntry->Info);
		if (error.Code != GSM_ERR_NONE) return error;
		if (UnicodeCaseCmp(JavaFInfoSubEntry->Info.Name.data(),StringToUnicodeReturn("games"),-1)) {
			ID->clear();
			ID->append(JavaFInfoSubEntry->Info.ID.data(),UnicodeLength(JavaFInfoSubEntry->Info.ID.data()));
			*NeedSubFolder = TRUE;
			return GSM_Return_Error(GSM_ERR_NONE);
		}
		return GSM_Return_Error(GSM_ERR_FOLDER_MORE);
	}

	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_N6510::GetJavaAppsFolderID(wchart *ID, BOOLEAN *NeedSubFolder, BOOLEAN Start)
{
	GSM_Error	error;
	char 		buff[80];

	if ((*Phones)->Feature("nofile")==TRUE) return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);

	//series 40 3.0 - filesystem 2
	if ((*Phones)->Feature("s40_30")==TRUE) {
		sprintf(buff,"d:/predefjava/predefcollections");
		ID->clear();
		ID->append((const wchar_t *)StringToUnicodeReturn(buff),strlen(buff));
		*NeedSubFolder = FALSE;
		return GSM_Return_Error(GSM_ERR_NONE);
	}

	//series 40 1.0 and 2.0 - filesystem 1
	if (Start) {
		JavaFInfoSubEntry = NULL;

		JavaFInfo.ClearAll();
		JavaFInfo.Info.SetID(StringToUnicodeReturn("c:\\3"));
		//we don't need to use GetFolderInfoList
		//because of it we don't check all error codes
		error = GetFolderInfoList1(&JavaFInfo, TRUE);
		if (error.Code == GSM_ERR_NONE) return GSM_Return_Error(GSM_ERR_FOLDER_MORE);
		return error;
	} else {
		if (JavaFInfo.GetNext(&JavaFInfoSubEntry) == FALSE) return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
		error = GetFileFolderInfo(&JavaFInfoSubEntry->Info);
		if (error.Code != GSM_ERR_NONE) return error;
		if (UnicodeCaseCmp(JavaFInfoSubEntry->Info.Name.data(),StringToUnicodeReturn("applications"),-1)) {
			ID->clear();
			ID->append(JavaFInfoSubEntry->Info.ID.data(),UnicodeLength(JavaFInfoSubEntry->Info.ID.data()));
			*NeedSubFolder = TRUE;
			return GSM_Return_Error(GSM_ERR_NONE);
		}
		return GSM_Return_Error(GSM_ERR_FOLDER_MORE);
	}

	return GSM_Return_Error(GSM_ERR_NONE);
}
