/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#ifndef misc_h
#define misc_h

#ifdef WIN32
#  include <windows.h>
#endif
#include <string>
#include <stdio.h>

#ifndef WIN32
#  ifndef BOOLEAN
#    define BOOLEAN char
#  endif
#  ifndef FALSE
#    define FALSE 0
#  endif
#  ifndef TRUE
#    define TRUE 1
#  endif
#endif

typedef struct {
	unsigned char			Hour;
	unsigned char 			Minute;
	unsigned char			Second;

	unsigned char			Day;
	unsigned char			Month;		// January = 1
	unsigned int			Year;		// complete year
} GSM_DateTime;

using namespace std;

class DebugInfo
{
public:
        DebugInfo			();
        ~DebugInfo			();

	void 		SetDebug	(FILE *deb_file, char *FileName, bool enable);
	void 		DumpDeb		(const unsigned char *buffer, int len);        
        void            Deb		(char *format, ...);
	void 		Error		(char *Description);
private:
	bool		UseDeb;
        FILE            *debfile;
};

char *GetCompiler	(void);
char *GetOS		(void);
char *OSErrorInfo	(void);
int  DayOfWeek 		(int Year, int Month, int Day);

typedef basic_string<unsigned char> 	unsignedstring;
typedef basic_string<unsigned int> 	unsignedint;
typedef basic_string<wchar_t> 		wchart;

BOOLEAN ReadVCalendarDateTime(char *Buffer, GSM_DateTime *DT);
void SaveVCalendarDateTime(GSM_DateTime *DT, char *Buffer);

time_t 		GSMDateTime2TimeT(const GSM_DateTime *DT);
GSM_DateTime 	TimeT2GSMDateTime(time_t *src);
void 		GSM_GetCurrentDateTime(GSM_DateTime *Date);

void 		UnsignedStringReplaceChars(unsignedstring *str, unsigned char chr, unsignedstring replace);


#endif
