/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#include "../../cfg/config.h" //msvc2005
#include <stdarg.h>
#include <time.h>
#include <memory.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#ifdef WIN32
#  include <windows.h>
#else
#  include <errno.h>
#endif

#include "misc.h"

DebugInfo::DebugInfo()
{
	debfile = NULL;
	UseDeb  = false;
}

DebugInfo::~DebugInfo()
{
	if (debfile != stdout && debfile != stderr && debfile != NULL) {
		fclose(debfile);
	}
}

void DebugInfo::SetDebug(FILE *deb_file, char *FileName, bool enable)
{
	if (deb_file == NULL && FileName[0] == 0) return;

	if (debfile != stdout && debfile != stderr && debfile != NULL) {
		fclose(debfile);
	}

	UseDeb = enable;
	if (enable) {
		if (deb_file != NULL) {
		        debfile = deb_file;
		} else if (FileName[0] != 0) {
			debfile = fopen(FileName,"ab");
		}
	} else {
		debfile = NULL;
	}
}

void DebugInfo::Deb(char *format, ...)
{
        va_list argp;

	if (UseDeb) {
	        va_start(argp, format);
	        vfprintf(debfile,format,argp);
//		fflush(debfile);
	        va_end(argp);
	}
};

void DebugInfo::DumpDeb(const unsigned char *buffer, int len)
{
	int 		i,j=0,l=16;
	unsigned char	line[200];

	if (!UseDeb || len == 0) return;

	memset(line,32,sizeof(line));
	line[l*5-1]=0;

	for (i=0; i<len; i++) {
		sprintf((char *)line+j*4,"%02X",buffer[i]);
		line[j*4+2] 		= 32;
		line[(l-1)*4+j+3]	= '.';
		if (isprint(buffer[i]) && buffer[i]!=0x09) {
			if (j != l-1) line[j*4+2] 	= buffer[i];
			line[(l-1)*4+j+3]		= buffer[i];
		}
		if (j != l-1 && i != len-1) line[j*4+3] = '|';
		if (j == l-1) {
			fprintf(debfile,"%s\n",line);
			memset(line,32,sizeof(line));
			line[l*5-1]=0;
			j = 0;
		} else {
			j++;
		}
	}
	if (j != 0) fprintf(debfile,"%s\n",line);
}

void DebugInfo::Error(char *Description)
{
 //	fprintf(debfile,"[ERROR     : %s, %s]\n",Description,OSErrorInfo());
 Deb("[ERROR     : %s, %s]\n",Description,OSErrorInfo());
}

char *GetOS(void)
{
#ifdef WIN32
	OSVERSIONINFOEX Ver;
	bool		Extended = true;
#endif
	static char 	Buffer[100] = {0x00};

#ifdef WIN32
	memset(&Ver,sizeof(OSVERSIONINFOEX),0);	
	Ver.dwOSVersionInfoSize = sizeof(OSVERSIONINFOEX);

   	if (!GetVersionEx((OSVERSIONINFO *)&Ver)) {
		Extended 		= false;
	      	Ver.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	        if (!GetVersionEx((OSVERSIONINFO *)&Ver)) {
//#ifdef _MSC_VER
//			Ver.dwMajorVersion = _winmajor;
//			Ver.dwMinorVersion = _winminor;
//			Ver.dwBuildNumber  = _osver;
//#else
			sprintf(Buffer, "Windows");
			return Buffer;
//#endif
		}
	}

	/* ----------------- 9x family ------------------ */

	/* no info about Win95 SP1, Win95 OSR2.1, Win95 OSR2.5.... */
	if (Ver.dwMajorVersion == 4 && Ver.dwMinorVersion == 0 && Ver.dwBuildNumber == 950) {
		sprintf(Buffer,"Win 95");
	} else if (Ver.dwMajorVersion == 4 && Ver.dwMinorVersion == 0 && Ver.dwBuildNumber == 1111) {
		sprintf(Buffer,"Win 95 OSR2.x");

	/* no info about Win98 SP1.... */
	} else if (Ver.dwMajorVersion == 4 && Ver.dwMinorVersion == 10 && Ver.dwBuildNumber == 1998) {
		sprintf(Buffer,"Win 98");
	} else if (Ver.dwMajorVersion == 4 && Ver.dwMinorVersion == 10 && Ver.dwBuildNumber == 2222) {
		sprintf(Buffer,"Win 98 SE");

	} else if (Ver.dwMajorVersion == 4 && Ver.dwMinorVersion == 90 && Ver.dwBuildNumber == 3000) {
		sprintf(Buffer,"Win ME");

	/* ---------------- NT family ------------------- */

	} else if (Ver.dwMajorVersion == 4 && Ver.dwMinorVersion == 0 && Ver.dwBuildNumber == 1381) {
		sprintf(Buffer,"Win NT 4.0");

	} else if (Ver.dwMajorVersion == 5 && Ver.dwMinorVersion == 0 && Ver.dwBuildNumber == 2195) {
		sprintf(Buffer,"Win 2000");

	} else if (Ver.dwMajorVersion == 5 && Ver.dwMinorVersion == 1 && Ver.dwBuildNumber == 2600) {
		sprintf(Buffer,"Win XP");
#if _MSC_VER > 1200 //6.0 has it undeclared
		if (Extended) {
			if (Ver.wSuiteMask & VER_SUITE_PERSONAL) {
				sprintf(Buffer+strlen(Buffer)," Home");
			} else {
				sprintf(Buffer+strlen(Buffer)," Pro");
			}
		}
#endif
	} else if (Ver.dwMajorVersion == 5 && Ver.dwMinorVersion == 2) {
		sprintf(Buffer,"Win 2003");
	} else if (Ver.dwMajorVersion == 6 && Ver.dwMinorVersion == 0) {
		sprintf(Buffer,"Win Vista");
	} else {
		sprintf(Buffer, "Windows %i.%i.%i",Ver.dwMajorVersion,Ver.dwMinorVersion,Ver.dwBuildNumber);
	}

	if (Extended && Ver.wServicePackMajor != 0) {
		sprintf(Buffer+strlen(Buffer)," SP%i",Ver.wServicePackMajor);
	}
#endif
	return Buffer;
}

char *GetCompiler(void)
{
	static char Buffer[100] = {0x00};

#ifdef WIN32
#  ifdef _MSC_VER
	if (_MSC_VER == 1200) { //?
		sprintf(Buffer, "MS VC 6.0");
	} else if (_MSC_VER == 1300) {
		sprintf(Buffer, "MS VC .NET 2002");
	} else if (_MSC_VER == 1310) {
		sprintf(Buffer, "MS VC .NET 2003");
	} else if (_MSC_VER == 1400) {
		sprintf(Buffer, "MS VC .NET 2005");
	} else {
		sprintf(Buffer, "MS VC %i",_MSC_VER);
	}
#  elif defined(__BORLANDC__)
	sprintf(Buffer, "Borland C++ %i",__BORLANDC__);
#  endif
#elif defined(DJGPP)
	sprintf(Buffer, "djgpp");
#endif

	return Buffer;
}

char *OSErrorInfo(void)
{
	static char   	Buffer[2000] = {0x00};
#ifdef WIN32
	int 		i;
	char 		*lpMsgBuf;

	/* We don't use errno in win32 - GetLastError gives better info */
	if (GetLastError()!=-1) {
		FormatMessage( 
			FORMAT_MESSAGE_ALLOCATE_BUFFER | 
			FORMAT_MESSAGE_FROM_SYSTEM | 
			FORMAT_MESSAGE_IGNORE_INSERTS,
			NULL,
			GetLastError(),
			MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
			(LPTSTR) &lpMsgBuf,
			0,
			NULL 
		);
		for (i=0;i<(int)strlen(lpMsgBuf);i++) {
			if (lpMsgBuf[i] == 13 || lpMsgBuf[i] == 10) {
				lpMsgBuf[i] = ' ';
			}
		}
		sprintf(Buffer,"%i, ",GetLastError());
		strcat(Buffer,lpMsgBuf);
		LocalFree(lpMsgBuf);
	}
	return Buffer;
#endif

	if (errno!=-1) {
		sprintf(Buffer,"%i, %s",errno,strerror(errno));
	}
	return Buffer;
}

//according to Acta Mathematica (1886, 1887) by Julius Johannes Zeller
//and other materials
//returns result according to ISO 8601 (Monday = 1,..)
int DayOfWeek (int Year, int Month, int Day) 
{
	int holder,Century;

	if (Month < 3) {
		Month += 12;
		Year--;
	}
	Century = Year/100;
	Year    = Year%100;
	holder  = Day + (Month+1)*26/10 + Year + Year/4;
	holder  = holder + Century/4 + 5*Century; 	// Gregorian calendar

	return ((holder+5)%7) + 1;		 	// convert to ISO 8601
}

void SaveVCalendarDateTime(GSM_DateTime *DT, char *Buffer)
{
	sprintf(Buffer+strlen(Buffer),
		"%04d%02d%02dT%02d%02d%02d",
		DT->Year, DT->Month, DT->Day,
		DT->Hour, DT->Minute, DT->Second);
}

BOOLEAN ReadVCalendarDateTime(char *Buffer, GSM_DateTime *DT)
{
	int i;

	if (strlen(Buffer) != 15) return FALSE;

	for (i=0;i<15;i++) {
		if (i==8) {
			if (Buffer[8] != 'T') return FALSE;
		} else {
			if (Buffer[i] < '0' || Buffer[i] > '9') return FALSE;
		}
	}

	DT->Year = (Buffer[0]-'0')*1000 + (Buffer[1]-'0')*100 + (Buffer[2]-'0')*10 + (Buffer[3]-'0');
	DT->Month = (Buffer[4]-'0')*10 + (Buffer[5]-'0');
	if (DT->Month == 0 || DT->Month > 12) return FALSE;
	DT->Day = (Buffer[6]-'0')*10 + (Buffer[7]-'0');
	//fixme check day
	DT->Hour = (Buffer[9]-'0')*10 + (Buffer[10]-'0');
	if (DT->Hour > 23) return FALSE;
	DT->Minute = (Buffer[11]-'0')*10 + (Buffer[12]-'0');
	if (DT->Minute > 59) return FALSE;
	DT->Second = (Buffer[13]-'0')*10 + (Buffer[14]-'0');
	if (DT->Second > 59) return FALSE;

	return TRUE;
}

time_t GSMDateTime2TimeT(const GSM_DateTime *DT)
{
	struct tm tmstruct;

	tmstruct.tm_year  = DT->Year - 1900;
	tmstruct.tm_mon   = DT->Month - 1;
	tmstruct.tm_mday  = DT->Day;
	tmstruct.tm_hour  = DT->Hour;
	tmstruct.tm_min   = DT->Minute;
	tmstruct.tm_sec   = DT->Second;
	tmstruct.tm_isdst = -1;

	return mktime(&tmstruct);
}

GSM_DateTime TimeT2GSMDateTime(time_t *src)
{
	struct tm 	tmstruct;
	GSM_DateTime 	dest;

	memcpy(&tmstruct,localtime(src),sizeof(struct tm));
	dest.Year	= tmstruct.tm_year + 1900;
	dest.Month	= tmstruct.tm_mon+1;
	dest.Day	= tmstruct.tm_mday;
	dest.Hour	= tmstruct.tm_hour;
	dest.Minute	= tmstruct.tm_min;
	dest.Second	= tmstruct.tm_sec;

	return dest;
}

void GSM_GetCurrentDateTime(GSM_DateTime *Date)
{
	time_t 		t=time(NULL);
	GSM_DateTime 	dt;

	dt=TimeT2GSMDateTime(&t);
	memcpy(Date,&dt,sizeof(GSM_DateTime));
}

void UnsignedStringReplaceChars(unsignedstring *str, unsigned char chr, unsignedstring replace)
{
	unsignedstring 	str2;
	unsigned int 	i;

	for (i=0;i<str->length();i++) {
		if (str->data()[i] == chr) {
			str2.append(replace);
		} else {
			str2.push_back(str->data()[i]);
		}
	}
	str->clear();
	str->append(str2);
}
