/* (C) 2003 - 2007 by Marcin Wiacek www.mwiacek.com */

#ifdef WIN32
#  include <windows.h>
#endif
#include <stdio.h>

#include "misc.h"

#ifndef ini_h
#define ini_h

class FileFolderInfo
{
public:
	FileFolderInfo();
	~FileFolderInfo();

	//shared for file and folder
	BOOLEAN			DRMForwardLock;
	BOOLEAN			ReadOnly;
	BOOLEAN			Hidden;
	BOOLEAN			System;
	GSM_DateTime		ModificationDateTime;
	BOOLEAN			ModificationDateTimeAvailable;

	//folder or file
	BOOLEAN			Folder;
	int			Size;

	wchart			Name;
	wchart			ID;

	void	 		SetID(wchar_t *Txt);	
	void	 		SetName(wchar_t *Txt);	
};

class Gen_File
{
public:
	Gen_File();
	~Gen_File();

	FileFolderInfo		Info;
	unsignedstring		Buffer;

	BOOLEAN 		ReadFromDisk(wchar_t *FileName);
	BOOLEAN 		SaveToDisk(char *FileName);
	BOOLEAN 		ReadFromWWW(char *server, char *filename);
};

class INI_File_Entry {
public:
	INI_File_Entry(wchart Name2, wchart Value2, long Pos2, int Len2);
	~INI_File_Entry();

	long			Pos;
	int			Len;
	wchart			Name;
	wchart			Value;

	void SetNext		(INI_File_Entry *Nxt);
	INI_File_Entry 		*GetNext();
private:
	INI_File_Entry 		*Next;
};

class INI_File_Section {
public:
	INI_File_Section(wchart Name2, long Pos2, int Len2);
	~INI_File_Section();

	long			Pos;
	int			Len;
	wchart			Name;

	void AddEntry		(wchart Name2, wchart Value2, long Pos2,int Len2);
	BOOLEAN GetNextEntry	(INI_File_Entry **Entry);

	void SetNext		(INI_File_Section *Nxt);
	INI_File_Section 	*GetNext();
private:
	INI_File_Section 	*Next;
	INI_File_Entry 		*Entries;
};

class INI_File:virtual public Gen_File {
public:
	INI_File();
	~INI_File();

	BOOLEAN ReadFile	(char *FileName);

	void AddSection		(wchart Name2, long Pos2,int Len2);
	BOOLEAN GetNextSection	(INI_File_Section **Section);
	INI_File_Section 	*GetLastSection();

	wchar_t *GetValue	(wchar_t *Sec, wchar_t *Nam);
	void SetValue		(wchar_t *Sec, wchar_t *Nam, wchar_t *Val);
private:
	INI_File_Section 	*Sections;
	int			Unicode;

	BOOLEAN 		Decode();
};

#endif
