/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#include <windows.h>
#include <string.h>
#include <stdio.h>
#include <io.h>
#include <memory.h>

#include "../../../cfg/config.h"
#include "../../phone/gsmphone.h"
#include "blue_w32.h"

/* MS Platform SDK */

#include <pshpack1.h>		// Without it compiled code hangs up BT stack

typedef ULONGLONG 		BTH_ADDR, *PBTH_ADDR;

#define NAP_MASK                ((ULONGLONG) 0xFFFF00000000)
#define SAP_MASK                ((ULONGLONG) 0x0000FFFFFFFF)

#define NAP_BIT_OFFSET          (8 * 4)
#define SAP_BIT_OFFSET          (0)

#define GET_NAP(_bth_addr)  	((USHORT) (((_bth_addr) & NAP_MASK) >> NAP_BIT_OFFSET))
#define GET_SAP(_bth_addr)  	((ULONG)  (((_bth_addr) & SAP_MASK) >> SAP_BIT_OFFSET))

#define BTHPROTO_RFCOMM  	0x0003

#ifndef AF_BTH
#  define AF_BTH  		32
#endif

typedef struct _SOCKADDR_BTH {
	USHORT      		addressFamily;  // Always AF_BTH
	BTH_ADDR    		btAddr;         // Bluetooth device address
	GUID        		serviceClassId; // [OPTIONAL] system will query SDP for port
	ULONG       		port;           // RFCOMM channel or L2CAP PSM
} SOCKADDR_BTH, *PSOCKADDR_BTH;

#ifdef BLUETOOTH_RF_SEARCHING

#pragma comment(lib, "irprops")
#pragma comment(lib, "ws2_32")

typedef struct _SOCKET_ADDRESS {
    	LPSOCKADDR 		lpSockaddr ;
    	INT 			iSockaddrLength ;
} SOCKET_ADDRESS, *PSOCKET_ADDRESS, FAR * LPSOCKET_ADDRESS ;

typedef struct _CSADDR_INFO {
    	SOCKET_ADDRESS 		LocalAddr ;
    	SOCKET_ADDRESS 		RemoteAddr ;
    	INT 			iSocketType ;
    	INT 			iProtocol ;
} CSADDR_INFO, *PCSADDR_INFO, FAR * LPCSADDR_INFO ;

typedef struct _AFPROTOCOLS {
   	INT 			iAddressFamily;
    	INT 			iProtocol;
} AFPROTOCOLS, *PAFPROTOCOLS, *LPAFPROTOCOLS;

typedef enum _WSAEcomparator {
    	COMP_EQUAL = 0,
    	COMP_NOTLESS
} WSAECOMPARATOR, *PWSAECOMPARATOR, *LPWSAECOMPARATOR;

typedef struct _WSAVersion {
    	DWORD           	dwVersion;
    	WSAECOMPARATOR  	ecHow;
}WSAVERSION, *PWSAVERSION, *LPWSAVERSION;

typedef struct _WSAQuerySetA {
    	DWORD           	dwSize;
    	LPSTR           	lpszServiceInstanceName;
    	LPGUID          	lpServiceClassId;
    	LPWSAVERSION    	lpVersion;
    	LPSTR           	lpszComment;
    	DWORD           	dwNameSpace;
    	LPGUID          	lpNSProviderId;
    	LPSTR           	lpszContext;
    	DWORD           	dwNumberOfProtocols;
    	LPAFPROTOCOLS   	lpafpProtocols;
    	LPSTR           	lpszQueryString;
    	DWORD           	dwNumberOfCsAddrs;
    	LPCSADDR_INFO  	 	lpcsaBuffer;
    	DWORD           	dwOutputFlags;
    	LPBLOB          	lpBlob;
} WSAQUERYSET, WSAQUERYSETA, *PWSAQUERYSETA, *LPWSAQUERYSETA;

DEFINE_GUID(L2CAP_PROTOCOL_UUID,  0x00000100, 0x0000, 0x1000, 0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB);

#ifndef NS_BTH
#  define NS_BTH  16
#endif

#define LUP_CONTAINERS          0x0002
#define LUP_RETURN_NAME         0x0010
#define LUP_RETURN_TYPE         0x0020
#define LUP_RETURN_COMMENT      0x0080
#define LUP_RETURN_ADDR         0x0100
#define LUP_RETURN_BLOB         0x0200
#define LUP_FLUSHCACHE       	0x1000
#define LUP_RES_SERVICE         0x8000

#define WSAAPI                  FAR PASCAL

extern "C" {

#ifndef WINSOCK_API_LINKAGE
#  ifdef DECLSPEC_IMPORT
#    define WINSOCK_API_LINKAGE DECLSPEC_IMPORT
#  else
#    define WINSOCK_API_LINKAGE
#  endif
#endif

WINSOCK_API_LINKAGE INT WSAAPI WSALookupServiceBeginA(
    IN  LPWSAQUERYSETA lpqsRestrictions,
    IN  DWORD          dwControlFlags,
    OUT LPHANDLE       lphLookup
    );

#define WSALookupServiceBegin  WSALookupServiceBeginA

WINSOCK_API_LINKAGE INT WSAAPI WSALookupServiceNextA(
    IN     HANDLE           hLookup,
    IN     DWORD            dwControlFlags,
    IN OUT LPDWORD          lpdwBufferLength,
    OUT    LPWSAQUERYSETA   lpqsResults
    );

#define WSALookupServiceNext  WSALookupServiceNextA

WINSOCK_API_LINKAGE INT WSAAPI WSALookupServiceEnd(IN HANDLE hLookup);

#define MAX_PROTOCOL_CHAIN 7

typedef struct _WSAPROTOCOLCHAIN {
    int ChainLen;                                 /* the length of the chain,     */
                                                  /* length = 0 means layered protocol, */
                                                  /* length = 1 means base protocol, */
                                                  /* length > 1 means protocol chain */
    DWORD ChainEntries[MAX_PROTOCOL_CHAIN];       /* a list of dwCatalogEntryIds */
} WSAPROTOCOLCHAIN, FAR * LPWSAPROTOCOLCHAIN;

#define WSAPROTOCOL_LEN  255

typedef struct _WSAPROTOCOL_INFOA {
    DWORD 		dwServiceFlags1;
    DWORD 		dwServiceFlags2;
    DWORD 		dwServiceFlags3;
    DWORD 		dwServiceFlags4;
    DWORD 		dwProviderFlags;
    GUID 		ProviderId;
    DWORD 		dwCatalogEntryId;
    WSAPROTOCOLCHAIN 	ProtocolChain;
    int 		iVersion;
    int 		iAddressFamily;
    int 		iMaxSockAddr;
    int 		iMinSockAddr;
    int 		iSocketType;
    int 		iProtocol;
    int 		iProtocolMaxOffset;
    int 		iNetworkByteOrder;
    int 		iSecurityScheme;
    DWORD 		dwMessageSize;
    DWORD 		dwProviderReserved;
    CHAR   		szProtocol[WSAPROTOCOL_LEN+1];
} WSAPROTOCOL_INFOA, FAR * LPWSAPROTOCOL_INFOA;

typedef WSAPROTOCOL_INFOA WSAPROTOCOL_INFO;

#define SO_PROTOCOL_INFOA 0x2004      /* WSAPROTOCOL_INFOA structure */
#define SO_PROTOCOL_INFO  SO_PROTOCOL_INFOA

WINSOCK_API_LINKAGE INT WSAAPI WSAAddressToStringA(
    IN     LPSOCKADDR          	lpsaAddress,
    IN     DWORD               	dwAddressLength,
    IN     LPWSAPROTOCOL_INFOA 	lpProtocolInfo,
    IN OUT LPSTR             	lpszAddressString,
    IN OUT LPDWORD             	lpdwAddressStringLength
    );

#define WSAAddressToString  WSAAddressToStringA

}

#endif

GSM_Error GSM_Device_Bluetooth::Connect(char *address, int channel)
{
	SOCKADDR_BTH 			sab;
	int				i;
	GSM_Error			error;

	(*Debug)->Deb("[DEVICE    :   connecting to channel %i]\n",channel);

	error = Sock->Init(Debug);
	if (error.Code != GSM_ERR_NONE) return error;

	Device = socket(AF_BTH, SOCK_STREAM, BTHPROTO_RFCOMM);
	if (Device == INVALID_SOCKET) {
		return GSM_Return_Error(GSM_ERR_DRIVER_NOT_AVAILABLE);
	}

	memset (&sab, 0, sizeof(sab));
	sab.port 		= channel;
	sab.addressFamily 	= AF_BTH;
	sab.btAddr 		= 0;
	for (i=0;i<(int)strlen(address);i++) {
		if (address[i] >='0' && address[i] <='9') {
			sab.btAddr = sab.btAddr * 16;
			sab.btAddr = sab.btAddr + (address[i]-'0');
		}
		if (address[i] >='a' && address[i] <='f') {
			sab.btAddr = sab.btAddr * 16;
			sab.btAddr = sab.btAddr + (address[i]-'a'+10);
		}
		if (address[i] >='A' && address[i] <='F') {
			sab.btAddr = sab.btAddr * 16;
			sab.btAddr = sab.btAddr + (address[i]-'A'+10);
		}
	}

	if (connect (Device, (struct sockaddr *)&sab, sizeof(sab)) != 0) {
//		close(Device);
		return GSM_Return_Error(GSM_ERR_DEVICE_OPEN);
	}
	Opened = true;
	return GSM_Return_Error(GSM_ERR_NONE);
}

#ifdef BLUETOOTH_RF_SEARCHING

bool GSM_Device_Bluetooth::CheckServiceName(char *service, char *Prot)
{
        if (!strcmp(Prot,"bluephonet") && strstr(service,"Nokia PC Suite")!=NULL) return true;

	return false;
}

GSM_Error GSM_Device_Bluetooth::FindChannelInDevice(char *address, char *Prot, void *protocolInfo)
{
	WSAQUERYSET 			querySet;
	DWORD				flags;
	GUID				protocol;
	int				i, result;
	BYTE 				buffer[2000];
	char 				addressAsString[1000];
	DWORD 				bufferLength, addressSize;
	WSAQUERYSET 			*pResults = (WSAQUERYSET*)&buffer;
	HANDLE				handle;
	GSM_Error			error;
	bool				found = false, one = false;
	int				channel;

	memset(&querySet, 0, sizeof(querySet));
	querySet.dwSize 	  = sizeof(querySet);
	protocol 		  = L2CAP_PROTOCOL_UUID;
	querySet.lpServiceClassId = &protocol;
	querySet.dwNameSpace 	  = NS_BTH;
	querySet.lpszContext 	  = address;

	flags = LUP_FLUSHCACHE  | LUP_RETURN_NAME |
		LUP_RETURN_TYPE | LUP_RETURN_ADDR |
		LUP_RETURN_BLOB | LUP_RETURN_COMMENT;

        result = WSALookupServiceBegin(&querySet, flags, &handle);
	if (result != 0) GSM_Return_Error(GSM_ERR_UNKNOWN);

	bufferLength = sizeof(buffer);
	while (1) {
                result = WSALookupServiceNext(handle, flags, &bufferLength, pResults);
		if (result != 0) break;
 		addressSize 		= sizeof(addressAsString);
		addressAsString[0] 	= 0;
		if (WSAAddressToString(pResults->lpcsaBuffer->RemoteAddr.lpSockaddr, pResults->lpcsaBuffer->RemoteAddr.iSockaddrLength, (WSAPROTOCOL_INFO*)protocolInfo, addressAsString,&addressSize)==0) {
		}
		if (addressAsString[0] != 0) {
			one = true;
			for (i=strlen(addressAsString)-1;i>0;i--) {
				if (addressAsString[i] == ':') break;
			}
			(*Debug)->Deb("[DEVICE    :     channel %02i - \"%s\"]\n",atoi(addressAsString+i+1),pResults->lpszServiceInstanceName);
			if (!found && CheckServiceName(pResults->lpszServiceInstanceName,Prot)) {
				channel = atoi(addressAsString+i+1);
				found = true;
			}
		}
	}
	if (!one) {
		return GSM_Return_Error(GSM_ERR_DEVICE_OPEN);
	} else {
		error.Code = GSM_ERR_NOT_SUPPORTED;
	}
	if (found) {
		error = Connect(address+1,channel);
		//fixme
	}
	result = WSALookupServiceEnd(handle);
	//fixme
	if (error.Code == GSM_ERR_NONE) Opened = true;
	return error;
}

GSM_Error GSM_Device_Bluetooth::FindChannelInAllDevices(char *Prot, void *protocolInfo)
{
	int			result;
	GSM_Error		error;
	WSAQUERYSET 		querySet;
	DWORD 			bufferLength, addressSize;
	char 			addressAsString[1000];
	DWORD			flags;
	HANDLE			handle;
	BYTE 			buffer[2000];
	WSAQUERYSET 		*pResults = (WSAQUERYSET*)&buffer;

	bufferLength = sizeof(buffer);

	flags = LUP_RETURN_NAME | LUP_CONTAINERS |
		LUP_RETURN_ADDR | LUP_FLUSHCACHE |
		LUP_RETURN_TYPE | LUP_RETURN_BLOB | LUP_RES_SERVICE;

	memset(&querySet, 0, sizeof(querySet));
      	querySet.dwSize 	= sizeof(querySet);
      	querySet.dwNameSpace 	= NS_BTH;

	(*Debug)->Deb("[DEVICE    : searching for phone\n");

	if (WSALookupServiceBeginA(&querySet, flags, &handle) != 0) {
	        Sock->Error("WSALookupServiceBegin");
		return GSM_Return_Error(GSM_ERR_DEVICE_OPEN);
	}

	while (1) {
		if (WSALookupServiceNextA(handle, flags, &bufferLength, pResults) != 0) break;

 		addressSize 		= sizeof(addressAsString);
		addressAsString[0] 	= 0;
		if (WSAAddressToString(pResults->lpcsaBuffer->RemoteAddr.lpSockaddr, pResults->lpcsaBuffer->RemoteAddr.iSockaddrLength, (WSAPROTOCOL_INFO *)protocolInfo, addressAsString,&addressSize)==0) {
			(*Debug)->Deb("[DEVICE    :   checking device %s (\"%s\")]\n",addressAsString,pResults->lpszServiceInstanceName);
			error = FindChannelInDevice(addressAsString,Prot,(WSAPROTOCOL_INFO *)protocolInfo);
			if (error.Code == GSM_ERR_NONE) {
				result = WSALookupServiceEnd(handle);
				Opened = true;
				return error;
			}
		}
	}

	return GSM_Return_Error(GSM_ERR_TIMEOUT);
}

#endif

GSM_Error GSM_Device_Bluetooth::Open(char *Dev, char *Prot, char *Pho, char **DeviceModel, GSM_AllPhones *Phones)
{
#ifdef BLUETOOTH_RF_SEARCHING
	GSM_Error		error;
	int			protocolInfoSize;
	WSAPROTOCOL_INFO 	protocolInfo;
#endif

	(*Debug)->Deb("[DEVICE    : opening device blue\n");

	if (!strcmp(Prot,"bluephonet")) {
#ifdef BLUETOOTH_RF_SEARCHING
		error = Sock->Init(Debug);
		if (error.Code != GSM_ERR_NONE) return error;

		Device = socket(AF_BTH, SOCK_STREAM, BTHPROTO_RFCOMM);
		if (Device == INVALID_SOCKET) {
			return GSM_Return_Error(GSM_ERR_DRIVER_NOT_AVAILABLE);
		}

		protocolInfoSize = sizeof(protocolInfo);
	        if (getsockopt(Device, SOL_SOCKET, SO_PROTOCOL_INFO, (char*)&protocolInfo, &protocolInfoSize) != 0) {
		        Sock->Error("getsockopt");
			closesocket(Device);
			return GSM_Return_Error(GSM_ERR_DEVICE_OPEN);
		}
		closesocket(Device);

		if (Dev[0] == 0) {
			return FindChannelInAllDevices(Prot,&protocolInfo);
		} else {
			(*Debug)->Deb("[DEVICE    :   connecting to device %s]\n",Dev);
			return FindChannelInDevice(Dev,Prot,&protocolInfo);
		}
#else
		return GSM_Return_Error(GSM_ERR_SOURCE_NOT_COMPILED);
#endif
	}
	if (!strcmp(Prot,"bluerfphonet")) {
		if (Dev[0] == 0) {
			return GSM_Return_Error(GSM_ERR_DEVICE_OPEN);
		} else {
			return Connect(Dev, 15);
		}
	}

        return GSM_Return_Error(GSM_ERR_UNKNOWN);
}

GSM_Error GSM_Device_Bluetooth::Close()
{
        (*Debug)->Deb("[STATE     : closing device]\n");

	if (!Opened) return GSM_Return_Error(GSM_ERR_NONE); 
	return Sock->Close(Device);
}

GSM_Error GSM_Device_Bluetooth::Read(unsigned char *buf, int *len)
{
	return Sock->Read(Device,buf,len);
}

GSM_Error GSM_Device_Bluetooth::Write(const unsigned char *buf, int len)
{
	return Sock->Write(Device,buf,len);
}
