//---------------------------------------------------------------------------
//
// Name:        CfgDlg.cpp
// Author:      Marcinello
// Created:     2007-01-25 22:01:44
// Description: CfgDlg class implementation
//
//---------------------------------------------------------------------------

#include "CfgDlg.h"

//Do not add custom headers
//wxDev-C++ designer will remove them
////Header Include Start
////Header Include End

//----------------------------------------------------------------------------
// CfgDlg
//----------------------------------------------------------------------------
//Add Custom Events only in the appropriate block.
//Code added in other places will be removed by wxDev-C++
////Event Table Start
BEGIN_EVENT_TABLE(CfgDlg,wxDialog)
	////Manual Code Start
	////Manual Code End
	
	EVT_CLOSE(CfgDlg::OnClose)
	EVT_COMBOBOX(ID_WXCOMBOBOX2,CfgDlg::WxComboBox2Selected)
	EVT_COMBOBOX(ID_WXCOMBOBOX1,CfgDlg::WxComboBox1Selected)
	EVT_BUTTON(ID_WXBUTTON3,CfgDlg::WxButton3Click)
	EVT_BUTTON(ID_WXBUTTON2,CfgDlg::WxButton2Click)
END_EVENT_TABLE()
////Event Table End

CfgDlg::CfgDlg(wxWindow *parent, wxWindowID id, const wxString &title, const wxPoint &position, const wxSize& size, long style)
: wxDialog(parent, id, title, position, size, style)
{
	CreateGUIControls();
}

CfgDlg::~CfgDlg()
{
} 

void CfgDlg::CreateGUIControls()
{
	//Do not add custom code between
        //GUI Items Creation Start and GUI Items Creation End.
	//wxDev-C++ designer will remove them.
	//Add the custom code before or after the blocks
	////GUI Items Creation Start

	SetTitle(wxT("Configuration for phone connection"));
	SetIcon(wxNullIcon);
	SetSize(8,8,446,172);
	Center();
	

	wxArrayString arrayStringFor_WxComboBox2;
	WxComboBox2 = new wxComboBox(this, ID_WXCOMBOBOX2, wxT("WxComboBox2"), wxPoint(92,76), wxSize(259,21), arrayStringFor_WxComboBox2, wxCB_DROPDOWN | wxCB_READONLY | wxCB_SORT, wxDefaultValidator, wxT("WxComboBox2"));

	wxArrayString arrayStringFor_WxComboBox1;
	WxComboBox1 = new wxComboBox(this, ID_WXCOMBOBOX1, wxT("WxComboBox1"), wxPoint(93,22), wxSize(333,21), arrayStringFor_WxComboBox1, wxCB_DROPDOWN | wxCB_READONLY | wxCB_SORT, wxDefaultValidator, wxT("WxComboBox1"));

	WxButton3 = new wxButton(this, ID_WXBUTTON3, wxT("&Cancel"), wxPoint(353,116), wxSize(81,23), 0, wxDefaultValidator, wxT("WxButton3"));

	WxButton2 = new wxButton(this, ID_WXBUTTON2, wxT("&OK"), wxPoint(4,117), wxSize(82,23), 0, wxDefaultValidator, wxT("WxButton2"));

	WxStaticText3 = new wxStaticText(this, ID_WXSTATICTEXT3, wxT("Phone model"), wxPoint(14,78), wxDefaultSize, 0, wxT("WxStaticText3"));

	WxStaticText2 = new wxStaticText(this, ID_WXSTATICTEXT2, wxT("Device"), wxPoint(14,52), wxDefaultSize, 0, wxT("WxStaticText2"));

	WxStaticText1 = new wxStaticText(this, ID_WXSTATICTEXT1, wxT("Type"), wxPoint(15,23), wxDefaultSize, 0, wxT("WxStaticText1"));

	WxEdit1 = new wxTextCtrl(this, ID_WXEDIT1, wxT("WxEdit1"), wxPoint(93,49), wxSize(257,21), 0, wxDefaultValidator, wxT("WxEdit1"));

	WxStaticBox1 = new wxStaticBox(this, ID_WXSTATICBOX1, wxT("Parameters"), wxPoint(3,5), wxSize(432,103));
	////GUI Items Creation End
}

void CfgDlg::OnClose(wxCloseEvent& /*event*/)
{
	Destroy();
}

void CfgDlg::SetConfig(char *Conn, char *Dev, char *Mod, GSM_StateMachine *s2)
{
	list<GSM_Protocol_Info>::iterator 	proinfo;
	list<GSM_Phone_Info>::iterator 		phoinfo;
    GSM_Protocol            		    *pro;
        GSM_Phone               		*pho;
    int                                 Num=0;
    char                                buff[200];
    
    s=s2;
    Connection = Conn;
    Device = Dev;
    Model = Mod;
    
    //device
    WxEdit1->SetValue(StringToUnicodeReturn(Device));
    
    //phone model
    WxComboBox2->Clear();
    WxComboBox2->Append("(selected automatic)");
    WxComboBox2->SetSelection(0);
    Num=0;
    pho = NULL;
    while(1) {
        if (!s->Phones->GetNext(&pho)) break;
    	for (phoinfo=pho->Info.begin(); phoinfo!=pho->Info.end(); ++phoinfo) {
            if ((*phoinfo).Model[0]==0) continue;
            sprintf(buff,"%s (%s)",(*phoinfo).Model,(*phoinfo).CodeNameModel);
            WxComboBox2->Append(buff);
            Num++;
            if (!strcmp(Model,(*phoinfo).Model)) WxComboBox2->SetSelection(Num);            
        }
    }    
    
    //connection
    SelectChoice2();
}

void CfgDlg::GetConfig(char *Conn, char *Dev, char *Mod)
{
    sprintf(Conn,"%s",Connection);
    sprintf(Dev,"%s",Device);
    sprintf(Mod,"%s",Model);
}

typedef struct {
 	char		*Connection;
	char		*Description;
} X;

    X   X2[] = {
    	"bluerfphonet", "Nokia - bluetooth for old models (channel selected by Gammu+)",
    	"bluephonet", "Nokia - bluetooth for new models (with channel searching)",
    	"irdaphonet", "Nokia - infrared",
    	"dku2", "Nokia - DKU2 USB cable for PopPort",
    	"fbus", "Nokia - FBUS cable",
    	"",""};

void CfgDlg::SelectChoice1()
{
    char                                buff[200];
	list<GSM_Protocol_Info>::iterator 	proinfo;
	list<GSM_Phone_Info>::iterator 		phoinfo;
    GSM_Protocol            		    *pro;
        GSM_Phone               		*pho;
	int Num,i;

    i = 0;
    while (X2[i].Connection[0] != 0) {
        if (strcmp(WxComboBox1->GetStringSelection(),X2[i].Description)) {
            i++;
            continue;
        }
        pro = NULL;
        while(1) {
            if (!s->Protocols->GetNext(&pro)) break;
            for (proinfo=pro->Info.begin(); proinfo!=pro->Info.end(); ++proinfo) {
                if (!strcmp((*proinfo).Protocol,X2[i].Connection)) {
                    sprintf(Connection,"%s",X2[i].Connection);
                    WxEdit1->Enable((*proinfo).NeedPort);
                    WxStaticText2->Enable((*proinfo).NeedPort);
                }
            }
        }
        break;
    }
}

void CfgDlg::SelectChoice2()
{
    char                                buff[200];
	list<GSM_Protocol_Info>::iterator 	proinfo;
	list<GSM_Phone_Info>::iterator 		phoinfo;
    GSM_Protocol            		    *pro;
        GSM_Phone               		*pho;
	int i,j;

    WxComboBox1->Clear();
    if (WxComboBox2->GetValue()=="(selected automatic)") {
        sprintf(Model,"");
        pro = NULL;
        while(1) {
            if (!s->Protocols->GetNext(&pro)) break;
            for (proinfo=pro->Info.begin(); proinfo!=pro->Info.end(); ++proinfo) {
                i = 0;
                while (X2[i].Connection[0] != 0) {
                    if (!strcmp((*proinfo).Protocol,X2[i].Connection)) {
                        WxComboBox1->Append(X2[i].Description);
                    }
                    i++;
                }
            }
        }
    } else {
        pho = NULL;
        while(1) {
            if (!s->Phones->GetNext(&pho)) break;
        	for (phoinfo=pho->Info.begin(); phoinfo!=pho->Info.end(); ++phoinfo) {
                if ((*phoinfo).Model[0]==0) continue;
                sprintf(buff,"%s (%s)",(*phoinfo).Model,(*phoinfo).CodeNameModel);
                if (strcmp(buff,WxComboBox2->GetStringSelection())) continue;
                sprintf(Model,"%s",(*phoinfo).Model);

                pro = NULL;
                while(1) {
                    if (!s->Protocols->GetNext(&pro)) break;
                    for (proinfo=pro->Info.begin(); proinfo!=pro->Info.end(); ++proinfo) {
                        i = 0;
                        while (X2[i].Connection[0] != 0) {
                            if (!strcmp((*proinfo).Protocol,X2[i].Connection) &&
                                strstr((*phoinfo).Protocol,X2[i].Connection)!=NULL) {
                                WxComboBox1->Append(X2[i].Description);
                            }
                            i++;
                        }
                    }
                }
            }
        }
    }
    
    for (i=0;i<WxComboBox1->GetCount();i++) {
        if (i==0) WxComboBox1->SetSelection(0);
        j = 0;
        while (X2[j].Connection[0] != 0) {
            if (!strcmp(WxComboBox1->GetString(i),X2[j].Description)) {
                if (!strcmp(Connection,X2[j].Connection)) {
                    WxComboBox1->SetSelection(i);
                }                
            }
            j++;
        }
    }
    SelectChoice1();
}


/*
 * WxButton2Click
 */
void CfgDlg::WxButton2Click(wxCommandEvent& event)
{
    sprintf(Device,"%s",UnicodeToStringReturn((wchar_t *)((const wchar_t *)WxEdit1->GetValue().wc_str(wxConvLibc))));
    
//    wxMessageBox(Connection,"connection",
//           wxICON_WARNING | wxOK);
//    wxMessageBox(Device,"device",
//           wxICON_WARNING | wxOK);
//    wxMessageBox(Model,"model",
//           wxICON_WARNING | wxOK);
                               
    EndModal(wxID_OK);
}

/*
 * WxButton3Click
 */
void CfgDlg::WxButton3Click(wxCommandEvent& event)
{
    EndModal(wxID_CANCEL);
}

/*
 * WxComboBox1Selected
 */
void CfgDlg::WxComboBox1Selected(wxCommandEvent& event )
{
	SelectChoice1();
}

/*
 * WxComboBox2Selected
 */
void CfgDlg::WxComboBox2Selected(wxCommandEvent& event )
{
	SelectChoice2();
}
