/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#include "gsmpbk.h"
#include "../misc/coding/coding.h"

wchar_t	*GSM_PBKSubEntry::GetText()
{
	if (Text==NULL) return 0x00;
	return Text;
}

GSM_PBKSubEntry::GSM_PBKSubEntry()
{
	Length = -1;
	Type   = PBK_Not_Assigned;
	Text   = NULL;
	Next   = NULL;
}

GSM_PBKSubEntry::~GSM_PBKSubEntry()
{
	delete(Next);
	free(Text);
}

GSM_PBK_SubEntryType GSM_PBKSubEntry::GetType()
{
	return Type;
}

GSM_Error GSM_PBKSubEntry::SetToText(GSM_PBK_SubEntryType Typ, wchar_t *Txt)
{
	int len = (UnicodeLength(Txt)+1)*sizeof(wchar_t);

	if (Typ < PBK_Text_Phone_General || Typ > PBK_Text_Name_First) return GSM_Return_Error(GSM_ERR_GPLUS_NOT_SUPPORTED);

	Type = Typ;

	Text = (wchar_t *)realloc(Text,len);
	memcpy(Text,Txt,len);

	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_PBKSubEntry *GSM_PBKSubEntry::GetNext()
{
	return Next;
}

void GSM_PBKSubEntry::SetNext(GSM_PBKSubEntry *Nxt)
{
	Next = Nxt;
}

GSM_Error GSM_PBKSubEntry::SetToDateTime(GSM_PBK_SubEntryType Typ, GSM_DateTime DT2)
{
	if (Typ != PBK_DateTime_Call_Length) return GSM_Return_Error(GSM_ERR_GPLUS_NOT_SUPPORTED);
	Type = Typ;

	memcpy(&DT,&DT2,sizeof(GSM_DateTime));
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_DateTime *GSM_PBKSubEntry::GetDateTime()
{
	return &DT;
}

/* ------------------------------------------------------------------------ */

GSM_PBKEntry::GSM_PBKEntry()
{
	Entries = NULL;
}


GSM_PBKEntry::~GSM_PBKEntry()
{
	delete(Entries);
}

BOOLEAN GSM_PBKEntry::GetNext(GSM_PBKSubEntry **En)
{
	if ((*En) == NULL) {
		(*En) = Entries;
	} else {
		(*En) = (*En)->GetNext();
	}
	if ((*En) == NULL) return FALSE;
	return TRUE;
}

GSM_Error GSM_PBKEntry::AddText(GSM_PBK_SubEntryType Typ, wchar_t *Txt)
{
	GSM_PBKSubEntry *Entry,*Entry2;
	GSM_Error	error;

	Entry = new GSM_PBKSubEntry;
	error = Entry->SetToText(Typ, Txt);
	if (error.Code != GSM_ERR_NONE) {
		delete (Entry);
		return error;
	}

	if (Entries == NULL) {
		Entries = Entry;
	} else {
		Entry2 = Entries;
		while (Entry2->GetNext()!=NULL) Entry2 = Entry2->GetNext();
		Entry2->SetNext(Entry);
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_PBKEntry::AddDateTime(GSM_PBK_SubEntryType Typ, GSM_DateTime DT2)
{
	GSM_PBKSubEntry *Entry,*Entry2;
	GSM_Error	error;

	Entry = new GSM_PBKSubEntry;
	error = Entry->SetToDateTime(Typ, DT2);
	if (error.Code != GSM_ERR_NONE) {
		delete (Entry);
		return error;
	}

	if (Entries == NULL) {
		Entries = Entry;
	} else {
		Entry2 = Entries;
		while (Entry2->GetNext()!=NULL) Entry2 = Entry2->GetNext();
		Entry2->SetNext(Entry);
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

void GSM_PBKEntry::ClearAll()
{
	delete(Entries);
	Entries = NULL;
}
