/* (C) 2006 by Marcin Wiacek www.mwiacek.com */

#ifndef gsm_files_h
#define gsm_files_h

#include "gsmmisc.h"
#include "../misc/misc.h"

class GSM_FileFolderInfo
{
public:
	GSM_FileFolderInfo();
	~GSM_FileFolderInfo();

	//shared for file and folder
	BOOLEAN				DRMForwardLock;
	BOOLEAN				ReadOnly;
	BOOLEAN				Hidden;
	BOOLEAN				System;
	GSM_DateTime			ModificationDateTime;
	BOOLEAN				ModificationDateTimeAvailable;

	//folder or file
	BOOLEAN				Folder;
	int				Size;
	
	GSM_Error 			SetName(wchar_t *Txt);
	wchar_t 			*GetName();
	GSM_Error 			SetID(wchar_t *Txt);
	wchar_t 			*GetID();
private:
	wchar_t				*Name;
	wchar_t				*ID;
};

class GSM_FileFolderInfoListSubEntry
{
	friend class GSM_FileFolderInfoList;
public:
	GSM_FileFolderInfoListSubEntry();
	~GSM_FileFolderInfoListSubEntry();

	GSM_FileFolderInfo		Info;
	GSM_FileFolderInfoListSubEntry	*GetNext();	
private:
	void				SetNext(GSM_FileFolderInfoListSubEntry *Nxt);

	GSM_FileFolderInfoListSubEntry	*Next;
};

class GSM_FileFolderInfoList
{
public:
	GSM_FileFolderInfoList();
	~GSM_FileFolderInfoList();

	GSM_FileFolderInfo		Info;
	BOOLEAN				SubEntryFullData;

	GSM_Error	 		AddSubEntry(GSM_FileFolderInfo *FInfo);
	BOOLEAN 			GetNext(GSM_FileFolderInfoListSubEntry **En);
	void 				ClearAll();
private:
	GSM_FileFolderInfoListSubEntry	*Entries;
};

class GSM_FileFolderInfoListsSubEntry
{
	friend class GSM_FileFolderInfoLists;
public:
	GSM_FileFolderInfoListsSubEntry();
	~GSM_FileFolderInfoListsSubEntry();

	GSM_FileFolderInfoList		Info;
	GSM_FileFolderInfoListsSubEntry	*GetNext();	
private:
	void				SetNext(GSM_FileFolderInfoListsSubEntry *Nxt);

	GSM_FileFolderInfoListsSubEntry	*Next;
};

class GSM_FileFolderInfoLists
{
public:
	GSM_FileFolderInfoLists();
	~GSM_FileFolderInfoLists();

	GSM_Error	 		AddSubEntry(GSM_FileFolderInfoListsSubEntry *FInfo);
	BOOLEAN 			GetNext(GSM_FileFolderInfoListsSubEntry **En);
	void 				ClearAll();
private:
	GSM_FileFolderInfoListsSubEntry	*Entries;
};

class GSM_File
{
	friend class GSM_Phone_N6510;
public:
	GSM_File();
	~GSM_File();

	GSM_FileFolderInfo		Info;
	unsignedstring			Buffer;

	GSM_Error 			ReadFromDisk(wchar_t *FileName);
	GSM_Error 			SaveToDisk(char *FileName);
	GSM_Error 			ReadFromWWW(char *server, char *filename);

	void 				JAD_Find_Data(unsignedstring *Vendor, unsignedstring *Name, unsignedstring *JAR, unsignedstring *Version, int *Size);
	void 				SetWin32EndLines();
private:
	int				Handle;

	void 				JAD_Find_Line(char *Name, unsignedstring *Value);
};

#endif
