/* (C) 2005 by Marcin Wiacek www.mwiacek.com */

#include "gsmcal.h"
#include "../misc/coding/coding.h"

GSM_CalendarSubEntry::GSM_CalendarSubEntry()
{
	Type = Calendar_Not_Assigned;
	Text = NULL;
	Next = NULL;
}

GSM_CalendarSubEntry::~GSM_CalendarSubEntry()
{
	delete(Next);
	free(Text);
}

GSM_Calendar_SubEntryType GSM_CalendarSubEntry::GetType()
{
	return Type;
}

GSM_CalendarSubEntry *GSM_CalendarSubEntry::GetNext()
{
	return Next;
}

void GSM_CalendarSubEntry::SetNext(GSM_CalendarSubEntry *Nxt)
{
	Next = Nxt;
}

GSM_Error GSM_CalendarSubEntry::SetToDateTime(GSM_Calendar_SubEntryType Typ, GSM_DateTime DT2)
{
	if (Typ < Calendar_DateTime_Start || Typ > Calendar_DateTime_SilentAlarm) {
		return GSM_Return_Error(GSM_ERR_GPLUS_NOT_SUPPORTED);
	}
	Type = Typ;

	memcpy(&DT,&DT2,sizeof(GSM_DateTime));
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_DateTime *GSM_CalendarSubEntry::GetDateTime()
{
	return &DT;
}

GSM_Error GSM_CalendarSubEntry::SetToInt(GSM_Calendar_SubEntryType Typ, int Value)
{
	if (Typ < Calendar_Int_Repeat_Frequency || Typ > Calendar_Int_Repeat_Month) {
		return GSM_Return_Error(GSM_ERR_GPLUS_NOT_SUPPORTED);
	}

	Type = Typ;

	IntValue = Value;

	return GSM_Return_Error(GSM_ERR_NONE);
}

int GSM_CalendarSubEntry::GetInt()
{
	return IntValue;
}

GSM_Error GSM_CalendarSubEntry::SetToText(GSM_Calendar_SubEntryType Typ, wchar_t *Txt)
{
	int len = (UnicodeLength(Txt)+1)*sizeof(wchar_t);

	if (Typ < Calendar_Text_Text || Typ > Calendar_Text_Phone) return GSM_Return_Error(GSM_ERR_GPLUS_NOT_SUPPORTED);

	Type = Typ;

	Text = (wchar_t *)realloc(Text,len);
	memcpy(Text,Txt,len);

	return GSM_Return_Error(GSM_ERR_NONE);
}

wchar_t	*GSM_CalendarSubEntry::GetText()
{
	if (Text==NULL) return 0x00;
	return Text;
}

/* ------------------------------------------------------------------------ */

GSM_CalendarEntry::GSM_CalendarEntry()
{
	Type = Calendar_Type_Not_Assigned;
	Entries = NULL;
}


GSM_CalendarEntry::~GSM_CalendarEntry()
{
	delete(Entries);
}

BOOLEAN GSM_CalendarEntry::GetNext(GSM_CalendarSubEntry **En)
{
	if ((*En) == NULL) {
		(*En) = Entries;
	} else {
		(*En) = (*En)->GetNext();
	}
	if ((*En) == NULL) return FALSE;
	return TRUE;
}

GSM_Error GSM_CalendarEntry::AddText(GSM_Calendar_SubEntryType Typ, wchar_t *Txt)
{
	GSM_CalendarSubEntry 	*Entry,*Entry2;
	GSM_Error		error;

	Entry = new GSM_CalendarSubEntry;
	error = Entry->SetToText(Typ, Txt);
	if (error.Code != GSM_ERR_NONE) {
		delete (Entry);
		return error;
	}

	if (Entries == NULL) {
		Entries = Entry;
	} else {
		Entry2 = Entries;
		while (Entry2->GetNext()!=NULL) Entry2 = Entry2->GetNext();
		Entry2->SetNext(Entry);
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_CalendarEntry::AddDateTime(GSM_Calendar_SubEntryType Typ, GSM_DateTime DT2)
{
	GSM_CalendarSubEntry 	*Entry,*Entry2;
	GSM_Error		error;

	Entry = new GSM_CalendarSubEntry;
	error = Entry->SetToDateTime(Typ, DT2);
	if (error.Code != GSM_ERR_NONE) {
		delete (Entry);
		return error;
	}

	if (Entries == NULL) {
		Entries = Entry;
	} else {
		Entry2 = Entries;
		while (Entry2->GetNext()!=NULL) Entry2 = Entry2->GetNext();
		Entry2->SetNext(Entry);
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_CalendarEntry::AddInt(GSM_Calendar_SubEntryType Typ, int Value)
{
	GSM_CalendarSubEntry 	*Entry,*Entry2;
	GSM_Error		error;

	Entry = new GSM_CalendarSubEntry;
	error = Entry->SetToInt(Typ, Value);
	if (error.Code != GSM_ERR_NONE) {
		delete (Entry);
		return error;
	}

	if (Entries == NULL) {
		Entries = Entry;
	} else {
		Entry2 = Entries;
		while (Entry2->GetNext()!=NULL) Entry2 = Entry2->GetNext();
		Entry2->SetNext(Entry);
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

void GSM_CalendarEntry::ClearAll()
{
	delete(Entries);
	Entries = NULL;
}

BOOLEAN GSM_CalendarEntry::IsNoteInDay(GSM_DateTime DT)
{
	int 			RepeatEach,RepeatDay,RepeatMonth,RepeatDOW;
	GSM_CalendarSubEntry 	*SubEntry;

        RepeatEach      = -1;
        RepeatDay       = -1;
        RepeatMonth     = -1;
        RepeatDOW       = -1;
        SubEntry        = NULL;
        while (GetNext(&SubEntry)) {
		switch (SubEntry->GetType()) {
		case Calendar_DateTime_Start:
                	break;
		case Calendar_DateTime_End:
                	break;
            	case Calendar_DateTime_End_Repeat:
                	break;
            	case Calendar_Int_Repeat_Frequency:
                	RepeatEach = SubEntry->GetInt();
                	break;
            	case Calendar_Int_Repeat_DayOfWeek:
                	RepeatDOW = SubEntry->GetInt();
                	break;                  
            	case Calendar_Int_Repeat_Day:
                	RepeatDay = SubEntry->GetInt();
                	break;
            	case Calendar_Int_Repeat_Month:
                	RepeatMonth = SubEntry->GetInt();
                	break;
		default:
			break;
            	}
        }

	return TRUE;
}
