/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#ifdef WIN32
#  include <windows.h>
#endif

#include "../sms/gsmsms.h"
#include "../../misc/misc.h"
#include "../gsmmisc.h"
#include "../gsmpbk.h"
#include "../gsmcal.h"
#include "../gsmdata.h"

#ifndef gsm_back_h
#define gsm_back_h

typedef struct {
	BOOLEAN PhonePBK;
	BOOLEAN SIMPBK;
	BOOLEAN Calendar;
} GSM_Backup_FileFormatFunctions;

typedef enum {
	Backup_Gammu = 1
} GSM_Backup_FileFormatNum;

class GSM_Backup_PBKEntry {
        friend class GSM_Backup;
public:
        GSM_Backup_PBKEntry();
        ~GSM_Backup_PBKEntry();

        GSM_Backup_PBKEntry     *GetNext();
        GSM_PBKEntry            *GetEntry();
private:
        void                    SetNext(GSM_Backup_PBKEntry *Nxt);
        void                    SetEntry(GSM_PBKEntry *En);

        GSM_Backup_PBKEntry     *Next;
        GSM_PBKEntry            *Entry;
};

class GSM_Backup_CalEntry {
        friend class GSM_Backup;
public:
        GSM_Backup_CalEntry();
        ~GSM_Backup_CalEntry();

        GSM_Backup_CalEntry     *GetNext();
        GSM_CalendarEntry       *GetEntry();
private:
        void                    SetNext(GSM_Backup_CalEntry *Nxt);
        void                    SetEntry(GSM_CalendarEntry *En);

        GSM_Backup_CalEntry     *Next;
        GSM_CalendarEntry       *Entry;
};

class GSM_Backup_SMSEntry {
        friend class GSM_Backup;
public:
        GSM_Backup_SMSEntry();
        ~GSM_Backup_SMSEntry();

        GSM_Backup_SMSEntry     *GetNext();
        GSM_SMSList             *GetEntry();
private:
        void                    SetNext(GSM_Backup_SMSEntry *Nxt);
        void                    SetEntry(GSM_SMSList *En);

        GSM_Backup_SMSEntry     *Next;
        GSM_SMSList             *Entry;
};

class GSM_Backup_MMSEntry {
        friend class GSM_Backup;
public:
        GSM_Backup_MMSEntry();
        ~GSM_Backup_MMSEntry();

        GSM_Backup_MMSEntry     *GetNext();
	GSM_MMSFile		*GetEntry();
private:
        void                    SetNext(GSM_Backup_MMSEntry *Nxt);
        void                    SetEntry(GSM_MMSFile *En);

        GSM_Backup_MMSEntry     *Next;
        GSM_MMSFile             *Entry;
};

class GSM_Backup {
public:
        char                    IMEI[100];
        char                    Model[100];
        char                    Creator[80];
        GSM_DateTime            DateTime;
        BOOLEAN                 DateTimeAvailable;
        char                    MD5Original[100];
        char                    MD5Calculated[100];

        GSM_Backup();
        ~GSM_Backup();

	void			GetFileFunctions(GSM_Backup_FileFormatNum Num, GSM_Backup_FileFormatFunctions *Func);
        GSM_Error               ReadFromFile(char *FileName);
	GSM_Error 		SaveToFile(char *FileName);
        BOOLEAN                 GetNext_MMS(GSM_Backup_MMSEntry **En);
        BOOLEAN                 GetNext_SMS(GSM_Backup_SMSEntry **En);
        BOOLEAN                 GetNext_PBK(GSM_Backup_PBKEntry **En);
        BOOLEAN                 GetNext_Cal(GSM_Backup_CalEntry **En);
        void                    Add_PBK(GSM_PBKEntry *En);
        void                    Add_Cal(GSM_CalendarEntry *En);
        void                    Add_SMS(GSM_SMSList *En);
        void                    Add_MMS(GSM_MMSFile *En);
        void                    LinkSMS();
        void                    SortSMSByFolderDT();
        void                    Delete_PBK();
        void                    Delete_SMS();
        void                    Delete_Calendar();
        void                    Delete_MMS();
private:
        GSM_Backup_PBKEntry     *PBK;
        GSM_Backup_CalEntry     *Cal;
        GSM_Backup_SMSEntry     *SMS;
        GSM_Backup_MMSEntry     *MMS;

        GSM_Error               ReadFromTextFile(char *FileName);
	GSM_Error 		SaveToTextFile(char *FileName);
	void 			SaveTextFilePart(wchar_t *Text, FILE *file, BOOLEAN LineEnd);

        void                    Add_SMS0(GSM_Backup_SMSEntry **Start, GSM_SMSList *En);
};

#endif
