/* (C) 2003 - 2007 by Marcin Wiacek www.mwiacek.com */

#include "../../../cfg/config.h" //msvc2005
#include "../../misc/ini.h"
#include "../../misc/coding/coding.h"
#include "../gsmpbk.h"
#include "gsmback.h"

void GSM_Backup::SaveTextFilePart(wchar_t *Text, FILE *file, BOOLEAN LineEnd)
{
	int i = 0;
	unsignedstring Buffer;

	while(1) {
		if (Text[i] == 0x00) break;
		Buffer.push_back(Text[i]%256);
		Buffer.push_back(Text[i]/256);
		i++;
	}
	if (LineEnd) {
		Buffer.push_back(13);
		Buffer.push_back(0);
		Buffer.push_back(10);
		Buffer.push_back(0);
	}
	fwrite(Buffer.data(),1,Buffer.size(),file);
}

GSM_Error GSM_Backup::SaveToTextFile(char *FileName)
{
	GSM_CalendarSubEntry 	*CalSubEntry;
	GSM_Backup_PBKEntry	*PBKEntry;
	GSM_Backup_CalEntry	*CalEntry;
	FILE			*file;
	char			buff[100],buff2[100];
	int			Num,Num2;
	GSM_PBKSubEntry 	*PBKSubEntry;
	BOOLEAN			Found;
	GSM_DateTime		DT;

	if (FileName[0] == 0x00) return GSM_Return_Error(GSM_ERR_UNKNOWN);
	file = fopen(FileName,"wb");
	if (file == NULL) return GSM_Return_Error(GSM_ERR_UNKNOWN);

	buff[0] = 0xff;
	buff[1] = 0xfe;
	fwrite(buff,1,2,file);

	SaveTextFilePart(StringToUnicodeReturn("# This file format is compatible with Gammu, Gammu+\n# and some based on them programs. See www.gammu.org for more info\n"), file, TRUE);

	SaveTextFilePart(StringToUnicodeReturn("[Backup]"), file, TRUE);
	SaveTextFilePart(StringToUnicodeReturn("Format=1.04"), file, TRUE);

	sprintf(buff,"IMEI = \"%s\"",IMEI);
	SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);

	sprintf(buff,"Creator = \"Gammu+ %s",VERSION);
	if (strlen(GetOS()) != 0) sprintf(buff+strlen(buff),", %s",GetOS());
	if (strlen(GetCompiler()) != 0) sprintf(buff+strlen(buff),", %s",GetCompiler());
	sprintf(buff+strlen(buff),"\"");
	SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);

	sprintf(buff,"DateTime = ");
	GSM_GetCurrentDateTime(&DT);
	SaveVCalendarDateTime(&DT,buff);
	SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);

//	value = File.GetValue(x,StringToUnicodeReturn("Phone"));
//	if (value != NULL) sprintf(Model,"%s",UnicodeToStringReturn(value));

	Num = 1;
	PBKEntry = NULL;
	while (GetNext_PBK(&PBKEntry)) {
		if (PBKEntry->GetEntry()->Memory != MEM_PHONE) continue;

		Found = FALSE;
		Num2 = 1;
		PBKSubEntry = NULL;
		while (PBKEntry->GetEntry()->GetNext(&PBKSubEntry) == TRUE) {
			buff2[0] = 0;
			switch (PBKSubEntry->GetType()) {
			case PBK_Text_Phone_General: sprintf(buff2,"NumberGeneral"); 	break;
			case PBK_Text_Phone_Mobile: sprintf(buff2,"NumberMobile"); 	break;
			case PBK_Text_Phone_Home  : sprintf(buff2,"NumberHome"); 	break;
			case PBK_Text_Phone_Work  : sprintf(buff2,"NumberWork"); 	break;
			case PBK_Text_Phone_Fax   : sprintf(buff2,"NumberFax"); 		break;
			case PBK_Text_Email       : sprintf(buff2,"Email"); 		break;
//			case PBK_Text_URL:
			case PBK_Text_Postal	  : sprintf(buff2,"Postal"); 		break;
//			case PBK_Text_UserID:
			case PBK_Text_Note	  : sprintf(buff2,"Note"); 		break;
			case PBK_Text_Name	  : sprintf(buff2,"Name"); 		break;
			case PBK_Text_Name_Last	  : sprintf(buff2,"FirstName"); 		break;
			case PBK_Text_Name_First  : sprintf(buff2,"LastName"); 		break;
			default			  : break;
			}
			if (buff2[0] == 0) continue;
			if (!Found) {
				SaveTextFilePart(StringToUnicodeReturn(""), file, TRUE);
				sprintf(buff,"[PhonePBK%03i]",Num);
				SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
				sprintf(buff,"Location = %03i",PBKEntry->GetEntry()->Location);
				SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
				Num++;
				Found = TRUE;
			}
			sprintf(buff,"Entry%02iType = ",Num2);
			SaveTextFilePart(StringToUnicodeReturn(buff), file, FALSE);
			SaveTextFilePart(StringToUnicodeReturn(buff2), file, TRUE);
			sprintf(buff,"Entry%02iText = \"",Num2);
			SaveTextFilePart(StringToUnicodeReturn(buff), file, FALSE);
			SaveTextFilePart(PBKSubEntry->GetText(), file, FALSE);
			sprintf(buff,"\"");
			SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);

			Num2++;
		}
	}

	Num = 1;
	CalEntry = NULL;
	while (GetNext_Cal(&CalEntry)) {
		
		SaveTextFilePart(StringToUnicodeReturn(""), file, TRUE);
		sprintf(buff,"[Calendar%03i]",Num);
		SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
//		sprintf(buff,"Location = %03i",PBKEntry->GetEntry()->Location);
//		SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
		Num++;

		switch (CalEntry->GetEntry()->Type) {
		case Calendar_Type_Meeting :SaveTextFilePart(StringToUnicodeReturn("Type = Meeting"), file, TRUE);break;
		case Calendar_Type_Memo	   :SaveTextFilePart(StringToUnicodeReturn("Type = Memo"), file, TRUE);break;
		case Calendar_Type_Call	   :SaveTextFilePart(StringToUnicodeReturn("Type = Call"), file, TRUE);break;
		case Calendar_Type_Birthday:SaveTextFilePart(StringToUnicodeReturn("Type = Birthday"), file, TRUE);break;
		case Calendar_Type_Reminder:SaveTextFilePart(StringToUnicodeReturn("Type = Reminder"), file, TRUE);break;
		}

		CalSubEntry = NULL;
		while (CalEntry->GetEntry()->GetNext(&CalSubEntry) == TRUE) {
			switch (CalSubEntry->GetType()) {
			case Calendar_Text_Text:
				SaveTextFilePart(StringToUnicodeReturn("Text = \""), file, FALSE);
				SaveTextFilePart(CalSubEntry->GetText(), file, FALSE);
				SaveTextFilePart(StringToUnicodeReturn("\""), file, TRUE);
				break;
			case Calendar_Text_Phone:
				SaveTextFilePart(StringToUnicodeReturn("Phone = \""), file, FALSE);
				SaveTextFilePart(CalSubEntry->GetText(), file, FALSE);
				SaveTextFilePart(StringToUnicodeReturn("\""), file, TRUE);
				break;
			case Calendar_Text_Location:
				SaveTextFilePart(StringToUnicodeReturn("EventLocation = \""), file, FALSE);
				SaveTextFilePart(CalSubEntry->GetText(), file, FALSE);
				SaveTextFilePart(StringToUnicodeReturn("\""), file, TRUE);
				break;
			case Calendar_DateTime_Start:
				sprintf(buff,"StartTime = ",Num);
				SaveVCalendarDateTime(CalSubEntry->GetDateTime(),buff);
				SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
				break;
			case Calendar_DateTime_End:
				sprintf(buff,"StopTime = ",Num);
				SaveVCalendarDateTime(CalSubEntry->GetDateTime(),buff);
				SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
				break;
			case Calendar_DateTime_SilentAlarm:
			case Calendar_DateTime_ToneAlarm:
				sprintf(buff,"Alarm = ",Num);
				SaveVCalendarDateTime(CalSubEntry->GetDateTime(),buff);
				SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
				if (CalSubEntry->GetType() == Calendar_DateTime_SilentAlarm) {
					SaveTextFilePart(StringToUnicodeReturn("AlarmType = Silent"), file, TRUE);
				} else {
					SaveTextFilePart(StringToUnicodeReturn("AlarmType = Tone"), file, TRUE);
				}
				break;
			case Calendar_DateTime_End_Repeat:
				sprintf(buff,"RepeatStopDate = ",Num);
				SaveVCalendarDateTime(CalSubEntry->GetDateTime(),buff);
				SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
				break;
			case Calendar_Int_Repeat_Frequency:
				sprintf(buff,"RepeatFrequency = %i",CalSubEntry->GetInt());
				SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
				break;
			case Calendar_Int_Repeat_DayOfWeek:
				sprintf(buff,"DayOfWeek = %i",CalSubEntry->GetInt());
				SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
				break;			
			case Calendar_Int_Repeat_Day:
				sprintf(buff,"RepeatDay = %i",CalSubEntry->GetInt());
				SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
				break;
			case Calendar_Int_Repeat_Month:
				sprintf(buff,"RepeatMonth = %i",CalSubEntry->GetInt());
				SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
				break;
			}
		}
	}

	fclose(file);

	return GSM_Return_Error(GSM_ERR_UNKNOWN);
}

GSM_Error GSM_Backup::ReadFromTextFile(char *FileName)
{
	INI_File 		File;
	INI_File_Section 	*Section;
	wchar_t			*value, x[200];
	char			x2[100];
	GSM_PBKEntry		*PBKEntry;
	GSM_PBK_SubEntryType	PBKType;
	GSM_PBKSubEntry 	*SubEntry;
	GSM_CalendarEntry	*CalEntry;
	GSM_Calendar_Type	CalType;
	GSM_DateTime		DT;
	int			i;
	BOOLEAN			Found;

	if (!File.ReadFile(FileName)) return GSM_Return_Error(GSM_ERR_UNKNOWN);

	StringToUnicode("Backup",x);
	value = File.GetValue(x,StringToUnicodeReturn("Format"));
	if (value == NULL) return GSM_Return_Error(GSM_ERR_UNKNOWN);

	value = File.GetValue(x,StringToUnicodeReturn("IMEI"));
	if (value != NULL) sprintf(IMEI,"%s",UnicodeToStringReturn(value));

	value = File.GetValue(x,StringToUnicodeReturn("Creator"));
	if (value != NULL) sprintf(Creator,"%s",UnicodeToStringReturn(value));

	value = File.GetValue(x,StringToUnicodeReturn("Phone"));
	if (value != NULL) sprintf(Model,"%s",UnicodeToStringReturn(value));

	value = File.GetValue(x,StringToUnicodeReturn("DateTime"));
	if (value != NULL && ReadVCalendarDateTime(UnicodeToStringReturn(value), &DateTime)==TRUE) {
		DateTimeAvailable=TRUE;
	}

	StringToUnicode("PhonePBK",x);
	Section = NULL;
	while (File.GetNextSection(&Section)==TRUE) {
		if (wcsncmp(x,Section->GetName(),8) != 0) continue;

		value = File.GetValue(Section->GetName(),StringToUnicodeReturn("Location"));
		if (value == NULL) continue;

		PBKEntry 		= new GSM_PBKEntry;
		PBKEntry->Location 	= atoi(UnicodeToStringReturn(value));
		PBKEntry->Memory	= MEM_PHONE;
		for (i=0;i<20;i++) {
			sprintf(x2,"Entry%02iType",i);
			value = File.GetValue(Section->GetName(),StringToUnicodeReturn(x2));
			if (value == NULL) continue;

			PBKType = PBK_Not_Assigned;
			if (!wcscmp(value,StringToUnicodeReturn("LastName"))) 		PBKType = PBK_Text_Name_Last;
			if (!wcscmp(value,StringToUnicodeReturn("FirstName"))) 		PBKType = PBK_Text_Name_First;
			if (!wcscmp(value,StringToUnicodeReturn("NumberMobile"))) 	PBKType = PBK_Text_Phone_Mobile;
			if (!wcscmp(value,StringToUnicodeReturn("NumberHome"))) 	PBKType = PBK_Text_Phone_Home;
			if (!wcscmp(value,StringToUnicodeReturn("NumberWork"))) 	PBKType = PBK_Text_Phone_Work;
			if (!wcscmp(value,StringToUnicodeReturn("NumberFax"))) 		PBKType = PBK_Text_Phone_Fax;
			if (!wcscmp(value,StringToUnicodeReturn("NumberGeneral"))) 	PBKType = PBK_Text_Phone_General;
			if (!wcscmp(value,StringToUnicodeReturn("Postal"))) 		PBKType = PBK_Text_Postal;
			if (!wcscmp(value,StringToUnicodeReturn("Note"))) 		PBKType = PBK_Text_Note;
			if (!wcscmp(value,StringToUnicodeReturn("Email"))) 		PBKType = PBK_Text_Email;
			if (PBKType == PBK_Not_Assigned) continue;

			sprintf(x2,"Entry%02iText",i);
			value = File.GetValue(Section->GetName(),StringToUnicodeReturn(x2));
			if (value == NULL) continue;
			if (UnicodeLength(value)==0) continue;

			value[UnicodeLength(value)-1] = 0;
			PBKEntry->AddText(PBKType,value+1);
		}
		Found = FALSE;
		SubEntry = NULL;
		while (PBKEntry->GetNext(&SubEntry)) {
			switch (SubEntry->GetType()) {
			case PBK_Text_Name_First:
			case PBK_Text_Name_Last:
				Found = TRUE;
				break;
			default:
				break;
			}
		}
		if (!Found) {
			for (i=0;i<20;i++) {
				sprintf(x2,"Entry%02iType",i);
				value = File.GetValue(Section->GetName(),StringToUnicodeReturn(x2));
				if (value == NULL) continue;

				PBKType = PBK_Not_Assigned;
				if (!wcscmp(value,StringToUnicodeReturn("Name"))) PBKType = PBK_Text_Name;
				if (PBKType == PBK_Not_Assigned) continue;

				sprintf(x2,"Entry%02iText",i);
				value = File.GetValue(Section->GetName(),StringToUnicodeReturn(x2));
				if (value == NULL) continue;
				if (UnicodeLength(value)==0) continue;

				value[UnicodeLength(value)-1] = 0;
				PBKEntry->AddText(PBKType,value+1);
			}
		}
		Add_PBK(PBKEntry);
	}

	StringToUnicode("Calendar",x);
	Section = NULL;
	while (File.GetNextSection(&Section)==TRUE) {
		if (wcsncmp(x,Section->GetName(),8) != 0) continue;

		value = File.GetValue(Section->GetName(),StringToUnicodeReturn("Type"));
		if (value == NULL) continue;

		CalType = Calendar_Type_Not_Assigned;
		if (!wcscmp(value,StringToUnicodeReturn("Meeting"))) 	CalType = Calendar_Type_Meeting;
		if (!wcscmp(value,StringToUnicodeReturn("Memo"))) 	CalType = Calendar_Type_Memo;
		if (!wcscmp(value,StringToUnicodeReturn("Call"))) 	CalType = Calendar_Type_Call;
		if (!wcscmp(value,StringToUnicodeReturn("Birthday"))) 	CalType = Calendar_Type_Birthday;
		if (!wcscmp(value,StringToUnicodeReturn("Reminder"))) 	CalType = Calendar_Type_Reminder;
		if (CalType == Calendar_Type_Not_Assigned) continue;

		CalEntry = new GSM_CalendarEntry;
		CalEntry->Type = CalType;

		// ----------------------- times ------------------------------

		value = File.GetValue(Section->GetName(),StringToUnicodeReturn("StartTime"));
		if (value != NULL && ReadVCalendarDateTime(UnicodeToStringReturn(value), &DT)==TRUE) {
			CalEntry->AddDateTime(Calendar_DateTime_Start, DT);
		}

		value = File.GetValue(Section->GetName(),StringToUnicodeReturn("StopTime"));
		if (value != NULL && ReadVCalendarDateTime(UnicodeToStringReturn(value), &DT)==TRUE) {
			CalEntry->AddDateTime(Calendar_DateTime_End, DT);
		}

		value = File.GetValue(Section->GetName(),StringToUnicodeReturn("AlarmType"));
		if (value != NULL && !strcmp(UnicodeToStringReturn(value),"Silent")) {
			value = File.GetValue(Section->GetName(),StringToUnicodeReturn("Alarm"));
			if (value != NULL && ReadVCalendarDateTime(UnicodeToStringReturn(value), &DT)==TRUE) {
				CalEntry->AddDateTime(Calendar_DateTime_SilentAlarm, DT);
			}
		} else {
			value = File.GetValue(Section->GetName(),StringToUnicodeReturn("Alarm"));
			if (value != NULL && ReadVCalendarDateTime(UnicodeToStringReturn(value), &DT)==TRUE) {
				CalEntry->AddDateTime(Calendar_DateTime_ToneAlarm, DT);
			}
		}
		
		value = File.GetValue(Section->GetName(),StringToUnicodeReturn("RepeatStopDate"));
		if (value != NULL && ReadVCalendarDateTime(UnicodeToStringReturn(value), &DT)==TRUE) {
			CalEntry->AddDateTime(Calendar_DateTime_End_Repeat, DT);
		}

		// ----------------------- texts ------------------------------

		value = File.GetValue(Section->GetName(),StringToUnicodeReturn("EventLocation"));
		if (value != NULL && UnicodeLength(value)!=0) {
			value[UnicodeLength(value)-1] = 0;
			CalEntry->AddText(Calendar_Text_Location, value+1);
		}

		value = File.GetValue(Section->GetName(),StringToUnicodeReturn("Text"));
		if (value != NULL && UnicodeLength(value)!=0) {
			value[UnicodeLength(value)-1] = 0;
			CalEntry->AddText(Calendar_Text_Text, value+1);
		}

		value = File.GetValue(Section->GetName(),StringToUnicodeReturn("Phone"));
		if (value != NULL && UnicodeLength(value)!=0) {
			value[UnicodeLength(value)-1] = 0;
			CalEntry->AddText(Calendar_Text_Phone, value+1);
		}

		// ------------------------ int -------------------------------

		value = File.GetValue(Section->GetName(),StringToUnicodeReturn("RepeatDayOfWeek"));
		if (value != NULL) {
			CalEntry->AddInt(Calendar_Int_Repeat_DayOfWeek, atoi(UnicodeToStringReturn(value)));
		}

		value = File.GetValue(Section->GetName(),StringToUnicodeReturn("RepeatDay"));
		if (value != NULL) {
			CalEntry->AddInt(Calendar_Int_Repeat_Day, atoi(UnicodeToStringReturn(value)));
		}

		value = File.GetValue(Section->GetName(),StringToUnicodeReturn("RepeatMonth"));
		if (value != NULL) {
			CalEntry->AddInt(Calendar_Int_Repeat_Month, atoi(UnicodeToStringReturn(value)));
		}

		value = File.GetValue(Section->GetName(),StringToUnicodeReturn("RepeatFrequency"));
		if (value != NULL) {
			CalEntry->AddInt(Calendar_Int_Repeat_Frequency, atoi(UnicodeToStringReturn(value)));
		}

		Add_Cal(CalEntry);
	}

	return GSM_Return_Error(GSM_ERR_NONE);
}
