/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#ifdef WIN32
#  include <windows.h>
#endif
#include <stdio.h>

#include "misc.h"

#ifndef ini_h
#define ini_h

class INI_File_Entry {
public:
	INI_File_Entry();
	~INI_File_Entry();

	void SetValue		(wchar_t *Txt);
	wchar_t *GetValue	();

	void SetName		(wchar_t *Txt);
	wchar_t *GetName	();

	void SetNext		(INI_File_Entry *Nxt);
	INI_File_Entry 		*GetNext();
private:
	INI_File_Entry 		*Next;
	wchar_t			*Text;
	wchar_t			*Name;
};

class INI_File_Section {
public:
	INI_File_Section(wchar_t *Text);
	~INI_File_Section();

	wchar_t *GetName	();
	void SetName		(wchar_t *Text);

	void AddValue		(wchar_t *Name, wchar_t *Value);
	BOOLEAN GetNextValue	(INI_File_Entry **Entry);

	void SetNext		(INI_File_Section *Nxt);
	INI_File_Section 	*GetNext();
private:
	INI_File_Section 	*Next;
	INI_File_Entry 		*Entries;
	wchar_t			*Name;
};

class INI_File {
public:
	INI_File();
	~INI_File();

	BOOLEAN ReadFile	(char *FileName);

	void AddSection		(wchar_t *Name);
	BOOLEAN GetNextSection	(INI_File_Section **Section);
	INI_File_Section 	*GetLastSection();

	wchar_t *GetValue	(wchar_t *Sec, wchar_t *Nam);
private:
	INI_File_Section 	*Sections;

	BOOLEAN ReadFileLine	(FILE *f, unsigned char *Buffer, int *Pos, int *Size, wchar_t **Line, int Unicode);
};

#endif
