/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#include <stdio.h>
#include <wctype.h>

#include "../../cfg/config.h" //msvc2005
#include "ini.h"
#include "coding/coding.h"

INI_File_Entry::INI_File_Entry()
{
	Next = NULL;
	Text = NULL;
	Name = NULL;
}

INI_File_Entry::~INI_File_Entry()
{
	delete(Next);
	free(Text);
	free(Name);
}

void INI_File_Entry::SetValue(wchar_t *Txt)
{
	int len = (UnicodeLength(Txt)+1)*sizeof(wchar_t);

	Text = (wchar_t *)malloc(len);
	memcpy(Text,Txt,len);
}

wchar_t *INI_File_Entry::GetValue()
{
	if (Text==NULL) return 0x00;
	return Text;
}

void INI_File_Entry::SetName(wchar_t *Txt)
{
	int len = (UnicodeLength(Txt)+1)*sizeof(wchar_t);

	Name = (wchar_t *)malloc(len);
	memcpy(Name,Txt,len);	
}

wchar_t *INI_File_Entry::GetName()
{
	if (Name==NULL) return 0x00;
	return Name;
}

void INI_File_Entry::SetNext(INI_File_Entry *Nxt)
{
	Next = Nxt;
}

INI_File_Entry *INI_File_Entry::GetNext()
{
	return Next;
}

/* ------------------------------------------------------------------------- */

INI_File_Section::INI_File_Section(wchar_t *Text)
{
	Next 	= NULL;
	Entries = NULL;
	Name 	= NULL;
	SetName(Text);
}

INI_File_Section::~INI_File_Section()
{
	free(Name);
	delete(Entries);
	delete(Next);
}

void INI_File_Section::AddValue(wchar_t *Name, wchar_t *Value)
{
	INI_File_Entry *Entry,*Entry2;

	Entry = new INI_File_Entry;
	Entry->SetName(Name);
	Entry->SetValue(Value);

	if (Entries == NULL) {
		Entries = Entry;
	} else {
		Entry2 = Entries;
		while (Entry2->GetNext()!=NULL) Entry2 = Entry2->GetNext();
		Entry2->SetNext(Entry);
	}
}

wchar_t *INI_File_Section::GetName()
{
	return Name;
}

void INI_File_Section::SetName(wchar_t *Text)
{
	int len = (UnicodeLength(Text)+1)*sizeof(wchar_t);

	Name = (wchar_t *)malloc(len);
	memcpy(Name,Text,len);
}

BOOLEAN INI_File_Section::GetNextValue(INI_File_Entry **Entry)
{
	if ((*Entry) == NULL) {
		(*Entry) = Entries;
	} else {
		(*Entry) = (*Entry)->GetNext();
	}
	if ((*Entry) == NULL) return FALSE;
	return TRUE;
}

void INI_File_Section::SetNext(INI_File_Section *Nxt)
{
	Next = Nxt;
}

INI_File_Section *INI_File_Section::GetNext()
{
	return Next;
}

/* ------------------------------------------------------------------------- */

INI_File::INI_File()
{
	Sections = NULL;
}

INI_File::~INI_File()
{
	delete(Sections);
}

BOOLEAN INI_File::ReadFileLine(FILE *f, unsigned char *Buffer, int *Pos, int *Size, wchar_t **Line, int Unicode)
{
	int 		Level = 0, Len;
	wchar_t 	widechar;

	while (true) {
		if ((*Pos) == (*Size)) {
			(*Size) = fread(Buffer,1,2000,f);
			if ((*Size) == 0 && Level == 1) {
				while (iswspace((*Line)[UnicodeLength(*Line)-1])!=0) {
					(*Line)[UnicodeLength(*Line)-1] = 0x00;
					*Line = (wchar_t *)realloc(*Line,(UnicodeLength(*Line)+1)*sizeof(wchar_t));
				}
				return TRUE;
			}
			if ((*Size) == 0) return FALSE;
			(*Pos) = 0;
		}
		if (Unicode == 0) {
			mbtowc(&widechar, (char *)Buffer+(*Pos), MB_CUR_MAX);
		} else {
			if ((*Size)%2 != 0 && Level == 1) {
				while (iswspace((*Line)[UnicodeLength(*Line)-1])!=0) {
					(*Line)[UnicodeLength(*Line)-1] = 0x00;
					*Line = (wchar_t *)realloc(*Line,(UnicodeLength(*Line)+1)*sizeof(wchar_t));
				}
				return TRUE;
			}
			if ((*Size)%2 != 0) return FALSE;
			if (Unicode == 1) widechar = 256*Buffer[(*Pos)+1] + Buffer[*Pos];
			if (Unicode == 2) widechar = 256*Buffer[*Pos] + Buffer[(*Pos)+1];
		}
		switch (Level) {
		case 0:
			if (widechar != 13 && widechar != 10 && !iswspace(widechar)) {
				Level = 1;
			} else {
				(*Pos)++;
				if (Unicode > 0) (*Pos)++;
			}
			break;
		case 1:
			if (widechar == 13 || widechar == 10) {
				while (iswspace((*Line)[UnicodeLength(*Line)-1])!=0) {
					(*Line)[UnicodeLength(*Line)-1] = 0x00;
					*Line = (wchar_t *)realloc(*Line,(UnicodeLength(*Line)+1)*sizeof(wchar_t));
				}
				return TRUE;
			}
			if (*Line == NULL) {
				Len = 0;
			} else {
				Len = UnicodeLength(*Line);
			}
			*Line = (wchar_t *)realloc(*Line,(Len+2)*sizeof(wchar_t));
			(*Line)[Len] = widechar;
			(*Line)[Len+1] = 0x00;
			(*Pos)++;
			if (Unicode > 0) (*Pos)++;
		}
	}
}

BOOLEAN INI_File::ReadFile(char *FileName)
{                                          	
	FILE 		*f;
	unsigned char 	buffer[2000];
	int 		Pos = 0, Size = 0, pos, Unicode = 0;
	wchar_t		*Line = NULL, *Line2, Line3[1];
	fpos_t 		p;

	f = fopen(FileName,"rb");
	if (f == NULL) return FALSE;

	fgetpos(f,&p);
	pos = fread(Line3,2,1,f);
	if (pos == 1) {
		if (Line3[0] == 0xFE * 256 + 0xFF) Unicode = 1;
		if (Line3[0] == 0xFF * 256 + 0xFE) Unicode = 2;
	}
	if (Unicode == 0) fsetpos(f,&p);

	while (true) {
		while (Line == NULL) {
			if (ReadFileLine(f, buffer, &Pos, &Size, &Line, Unicode)==FALSE) {
				fclose(f);
				return TRUE;
			}
		}
		/* do we have line with [ and ] ? */
		if (Line[0] != '[' || strstr(UnicodeToStringReturn(Line),"]") == NULL) {
			free(Line);
			Line = NULL;
			continue;
		}
		/* we ignore line with comment */
		if (Line[0] == ';' || Line[0] == '#') {
			free(Line);
			Line = NULL;
			continue;
		}
		/* yes we have [ ] and it's section name */
		Line[UnicodeLength(Line)-1] = 0x00;			
		AddSection(Line+1);
		free(Line);
		Line = NULL;
		while (true) {
			if (ReadFileLine(f, buffer, &Pos, &Size, &Line, Unicode) == FALSE) {
				fclose(f);
				return TRUE;
			}
			if (Line == NULL) continue;
			/* Line with [ and ] means new section */
			if (Line[0] == '[' && strstr(UnicodeToStringReturn(Line),"]") != NULL) break;
			/* we ignore line with comment */
			if (Line[0] == ';' || Line[0] == '#') {
				free(Line);
				Line = NULL;
				continue;
			}
			/* do we have = ? If yes, it's section value */
			if (strstr(UnicodeToStringReturn(Line),"=") == NULL) {
				free(Line);
				Line = NULL;
				continue;
			}
			/* Find = and separate parts before and after */
			pos = 0;
			while(Line[pos] != '=') pos++;
			Line[pos] = 0x00;
			Line2 = Line + pos + 1;
			/* Remove white spaces */
			while(iswspace(Line2[0])) Line2 = Line2 + 1;
			while(iswspace(Line[UnicodeLength(Line)-1])) Line[UnicodeLength(Line)-1] = 0;
			/* Add as section value */
			GetLastSection()->AddValue(Line,Line2);
			free(Line);
			Line = NULL;
		}
	}
}

BOOLEAN INI_File::GetNextSection(INI_File_Section **Section)
{
	if ((*Section) == NULL) {
		(*Section) = Sections;
	} else {
		(*Section) = (*Section)->GetNext();
	}
	if ((*Section) == NULL) return FALSE;
	return TRUE;
}

void INI_File::AddSection(wchar_t *Name)
{
	INI_File_Section *Section,*Section2;

	Section = new INI_File_Section(Name);

	if (Sections == NULL) {
		Sections = Section;
	} else {
		Section2 = Sections;
		while (Section2->GetNext()!=NULL) Section2 = Section2->GetNext();
		Section2->SetNext(Section);
	}
}

INI_File_Section *INI_File::GetLastSection()
{
	INI_File_Section *Section;

	if (Sections == NULL) {
		return NULL;
	} else {
		Section = Sections;
		while (Section->GetNext()!=NULL) Section = Section->GetNext();
		return Section;
	}
}

wchar_t *INI_File::GetValue(wchar_t *Sec, wchar_t *Nam)
{
	INI_File_Section 	*Section;
	INI_File_Entry 		*Entry;

	Section = NULL;
	while (GetNextSection(&Section)==TRUE) {
		if (!UnicodeCaseCmp(Sec,Section->GetName(),-1)) continue;
		Entry = NULL;
		while (Section->GetNextValue(&Entry)==TRUE) {
			if (UnicodeCaseCmp(Nam,Entry->GetName(),-1)) return Entry->GetValue();
		}
	}
	return 0x00;
}
